package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.RelatorioManutencoesBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.HistoricoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.LogoRel;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.export.XlsxReportConfiguration;

/**
 * @author euler.ramos
 *
 */
public class RelatorioManutencoesBaseConhecimento extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		this.preencherComboPeriodo(document, request, response);
		this.preencherComboPasta(usuario, document, request, response);
		document.executeScript("$('#incluirFilhas').attr('disabled', 'disabled');");
		document.executeScript("$('#uniform-incluirFilhas').addClass('disabled');");
	}

	public void abreRelatorioPDF(JRDataSource dataSource, Map<String, Object> parametros, String diretorioTemp, String caminhoJasper,String jasperArqRel, String diretorioRelativo, String arquivoRelatorio, DocumentHTML document, HttpServletRequest request, HttpServletResponse response){
		try
		{
			final JasperDesign desenho = JRXmlLoader.load(caminhoJasper + jasperArqRel +".jrxml");
			desenho.setLanguage("java");
			final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
			final JRSwapFile arquivoSwap = new JRSwapFile(diretorioTemp, 4096, 25);
			final JRAbstractLRUVirtualizer virtualizer = new JRSwapFileVirtualizer(25, arquivoSwap, true);
			parametros.put(JRParameter.REPORT_VIRTUALIZER, virtualizer);
			final JasperPrint print = JasperFillManager.fillReport(relatorio, parametros, dataSource);
			JasperExportManager.exportReportToPdfFile(print, diretorioTemp + arquivoRelatorio + ".pdf");
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url="
					+ diretorioRelativo + arquivoRelatorio + ".pdf')");
		} catch(OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		} catch (JRException e) {
			e.printStackTrace();
		}
	}

	public void abreRelatorioXLS(JRDataSource dataSource, Map<String, Object> parametros, String diretorioTemp, String caminhoJasper, String jasperArqRel, String diretorioRelativo, String arquivoRelatorio, DocumentHTML document, HttpServletRequest request, HttpServletResponse response){
		try {
			final JasperDesign desenho = JRXmlLoader.load(caminhoJasper + jasperArqRel +".jrxml");
			desenho.setLanguage("java");
			final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
			final JasperPrint impressao = JasperFillManager.fillReport(relatorio, parametros, dataSource);
			final JRXlsxExporter exporter = new JRXlsxExporter();
			exporter.setExporterInput(new SimpleExporterInput(impressao));
			exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(diretorioTemp + arquivoRelatorio + ".xlsx"));
			final XlsxReportConfiguration xlsxReportConfiguration = new SimpleXlsxReportConfiguration();
            exporter.setConfiguration(xlsxReportConfiguration);
			exporter.exportReport();
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativo + arquivoRelatorio + ".xlsx')");
		} catch (final OutOfMemoryError | JRException e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		}
	}

	public void gerarRelatorio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response){
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		try {
			RelatorioManutencoesBaseConhecimentoDTO relatorioManutencoesBaseConhecimentoDTO = (RelatorioManutencoesBaseConhecimentoDTO) document.getBean();
			if (relatorioManutencoesBaseConhecimentoDTO.getIncluirFilhas()==null){
				relatorioManutencoesBaseConhecimentoDTO.setIncluirFilhas("N");
			}
			JRDataSource dataSource;
			// Obtendo informaes
			HistoricoBaseConhecimentoService historicoBaseConhecimentoService = (HistoricoBaseConhecimentoService) ServiceLocator.getInstance().getService(HistoricoBaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
			ArrayList<HistoricoBaseConhecimentoDTO> listaHistConhecimentos = historicoBaseConhecimentoService.listHistoricoBaseConhecimento(relatorioManutencoesBaseConhecimentoDTO.getDataInicial(), relatorioManutencoesBaseConhecimentoDTO.getDataFinal(), relatorioManutencoesBaseConhecimentoDTO.getIdPasta(), relatorioManutencoesBaseConhecimentoDTO.getIncluirFilhas(), relatorioManutencoesBaseConhecimentoDTO.getIdPeriodo(), usuario);
			if (listaHistConhecimentos.size() == 0) {
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio") );
				return;
			}

			dataSource = new JRBeanCollectionDataSource(listaHistConhecimentos);

			// Alimentando os parmetros de filtragem para serem mostrados no relatrio
			Map<String, Object> parametros = this.alimentaParametros(relatorioManutencoesBaseConhecimentoDTO, usuario, UtilI18N.internacionaliza(request, "relatorioManutencoesBaseConhecimento.titulo"), document, request, response);

			// Configurando dados para gerao do Relatrio
			StringBuilder jasperArqRel = new StringBuilder();
			jasperArqRel.append("relatorioManutencoesBaseConhecimento");
			Date dt = new Date();
			String strMiliSegundos = Long.toString(dt.getTime());
			String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS");
			String diretorioTemp = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
			String diretorioRelativo = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";
			String arquivoRelatorio = "/"+ jasperArqRel + strMiliSegundos + "_" + usuario.getIdUsuario();

			// Chamando o relatrio
			if (relatorioManutencoesBaseConhecimentoDTO.getFormato().equalsIgnoreCase("PDF")){
				abreRelatorioPDF(dataSource, parametros, diretorioTemp, caminhoJasper, jasperArqRel.toString(), diretorioRelativo, arquivoRelatorio, document, request, response);
			} else {
				abreRelatorioXLS(dataSource, parametros, diretorioTemp, caminhoJasper, jasperArqRel.toString(), diretorioRelativo, arquivoRelatorio, document, request, response);
			}
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private Map<String, Object> alimentaParametros(RelatorioManutencoesBaseConhecimentoDTO relatorioManutencoesBaseConhecimentoDTO, UsuarioDTO usuario, String titulo, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception{
		HttpSession session = request.getSession();
		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);
		parametros.put("TITULO_RELATORIO", titulo);
		parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual() );

		if (usuario!=null){
			parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		} else {
			parametros.put("NOME_USUARIO", "-");
		}

		// Tratamento para internacionalizao do intervalo de datas
		StringBuilder intervaloDasDatas = new StringBuilder();
		String pattern;
		if (usuario != null && StringUtils.isNotBlank(usuario.getLocale()) && (usuario.getLocale().toString().equals("en")||usuario.getLocale().toString().equals("en_US"))){
			pattern = "MM/dd/yyyy";
		} else {
			pattern = "dd/MM/yyyy";
		}
		intervaloDasDatas.append(UtilDatas.dateToSTRWithFormat(relatorioManutencoesBaseConhecimentoDTO.getDataInicial(), pattern)+" "+UtilI18N.internacionaliza(request,"citcorpore.comum.a")+" "+UtilDatas.dateToSTRWithFormat(relatorioManutencoesBaseConhecimentoDTO.getDataFinal(), pattern));
		parametros.put("Periodo", intervaloDasDatas.toString());

		parametros.put("Logo", LogoRel.getFile());

		if (relatorioManutencoesBaseConhecimentoDTO.getIdPasta()!=null&&relatorioManutencoesBaseConhecimentoDTO.getIdPasta().intValue()>0){
			PastaService pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
			PastaDTO pastaDTO = new PastaDTO();
			pastaDTO.setId(relatorioManutencoesBaseConhecimentoDTO.getIdPasta());
			pastaDTO = (PastaDTO) pastaService.restore(pastaDTO);
			parametros.put("pasta", pastaDTO.getNome());
			parametros.put("hierarquizar", relatorioManutencoesBaseConhecimentoDTO.getIncluirFilhas());
		} else {
			parametros.put("pasta", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));
			parametros.put("hierarquizar", "N");
		}

		parametros.put("SUBREPORT_DIR", CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS"));

		return parametros;
	}

	private void preencherComboPeriodo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response){
		HTMLSelect comboRelatorio;
		try {
			comboRelatorio = document.getSelectById("idPeriodo");
			if (comboRelatorio!=null){
				comboRelatorio.removeAllOptions();
				comboRelatorio.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
				comboRelatorio.addOption("1", UtilI18N.internacionaliza(request, "citcorpore.comum.dataCriacao"));
				comboRelatorio.addOption("2", UtilI18N.internacionaliza(request, "baseConhecimentoView.dataAlteracao"));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void preencherComboPasta(UsuarioDTO usuario, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		RelatorioManutencoesBaseConhecimentoDTO relatorioManutencoesBaseConhecimentoDTO = (RelatorioManutencoesBaseConhecimentoDTO) document.getBean();
		HTMLSelect comboPasta;
		try {
			comboPasta = document.getSelectById("idPasta");
			if (comboPasta!=null){
				comboPasta.removeAllOptions();
				PastaService pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
				List<PastaDTO> listaPastas =  (List<PastaDTO>) pastaService.listPastasESubpastas(usuario);
				if (listaPastas!=null){
					if (listaPastas.size()>0){
						if (listaPastas.size()>1){
							comboPasta.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));
						}
						comboPasta.addOptions(listaPastas, "id", "nome", null);
						if (listaPastas.size()<2){
							relatorioManutencoesBaseConhecimentoDTO.setIdPasta(listaPastas.get(0).getId());
							document.setBean(relatorioManutencoesBaseConhecimentoDTO);
						}
					} else {
						comboPasta.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));
					}
				} else {
					comboPasta.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public Class getBeanClass() {
		return RelatorioManutencoesBaseConhecimentoDTO.class;
	}

}