package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AprovacaoMudancaDTO;
import br.com.centralit.citcorpore.bean.AtividadePeriodicaDTO;
import br.com.centralit.citcorpore.bean.CategoriaOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.ContatoRequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoAtvPeriodicaDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.HistoricoMudancaDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.JustificativaRequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.LiberacaoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.LiberacaoMudancaDTO;
import br.com.centralit.citcorpore.bean.LiberacaoProblemaDTO;
import br.com.centralit.citcorpore.bean.LocalidadeDTO;
import br.com.centralit.citcorpore.bean.LocalidadeUnidadeDTO;
import br.com.centralit.citcorpore.bean.MidiaSoftwareDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaLiberacaoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.OrigemOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.ProblemaMudancaDTO;
import br.com.centralit.citcorpore.bean.ProgramacaoAtividadeDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoMidiaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoRequisicaoComprasDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoResponsavelDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaResponsavelDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaRiscoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoMudancaDTO;
import br.com.centralit.citcorpore.bean.TemplateSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.TipoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AprovacaoMudancaDao;
import br.com.centralit.citcorpore.integracao.HistoricoMudancaDao;
import br.com.centralit.citcorpore.integracao.LiberacaoMudancaDao;
import br.com.centralit.citcorpore.integracao.ProblemaMudancaDAO;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaItemConfiguracaoDao;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaResponsavelDao;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaRiscoDao;
import br.com.centralit.citcorpore.integracao.RequisicaoMudancaServicoDao;
import br.com.centralit.citcorpore.integracao.SolicitacaoServicoMudancaDao;
import br.com.centralit.citcorpore.negocio.AtividadePeriodicaService;
import br.com.centralit.citcorpore.negocio.CategoriaOcorrenciaService;
import br.com.centralit.citcorpore.negocio.CategoriaSolucaoService;
import br.com.centralit.citcorpore.negocio.ContatoRequisicaoLiberacaoServiceEjb;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoAtvPeriodicaService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.HistoricoLiberacaoService;
import br.com.centralit.citcorpore.negocio.HistoricoMudancaService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.JustificativaRequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.LiberacaoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.LiberacaoMudancaService;
import br.com.centralit.citcorpore.negocio.LiberacaoProblemaService;
import br.com.centralit.citcorpore.negocio.LocalidadeService;
import br.com.centralit.citcorpore.negocio.LocalidadeUnidadeService;
import br.com.centralit.citcorpore.negocio.MidiaSoftwareService;
import br.com.centralit.citcorpore.negocio.OcorrenciaLiberacaoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaSolicitacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoMidiaService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoRequisicaoComprasService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoResponsavelService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.TemplateSolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.TipoLiberacaoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.OccurrenceCategory;
import br.com.centralit.citcorpore.util.Enumerados.ReleaseRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.StatusIC;
import br.com.centralit.citcorpore.util.Enumerados.TipoAgendamento;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.integracao.ControleGEDDao;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.impressao.ImpressaoCadLiberacao;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;
import net.htmlparser.jericho.Source;

@SuppressWarnings({ "rawtypes", "unchecked", "unused" })
public class RequisicaoLiberacao extends AjaxFormAction {

	private RequisicaoLiberacaoDTO requisicaoLiberacaoDTO;

	private GrupoService grupoService;

	private CategoriaOcorrenciaService categoriaOcorrenciaService;

	private static HttpServletRequest requestGlobal;
	private static DocumentHTML documentGlobal;

	@Override
	public Class getBeanClass() {
		return RequisicaoLiberacaoDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		/**
		 * Adicionado para fazer limpeza do upload que est na sesso .
		 *
		 * @author maycon.fernandes
		 * @since 28/10/2013 08:21
		 */
		request.getSession(true).setAttribute("colUploadRequisicaoLiberacaoGED", null);

		if (this.listInfoRegExecucaoRequisicaoLiberacao(this.getRequisicaoLiberacaoDTO(), request) != null) {
			document.getElementById("tblOcorrencias").setInnerHTML(listInfoRegExecucaoRequisicaoLiberacao(requisicaoLiberacaoDTO, request));
		}
		this.preencherComboTipoLiberacao(document, request, response);
		this.preencherComboGrupoExecutor(document, request, response);
		this.preencherComboCategoriaSolucao(document, request, response);

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		Collection<GrupoDTO> lstGrupos = grupoService.getGruposByEmpregado(usuario.getIdEmpregado());

		if (lstGrupos != null) {
			for (GrupoDTO g : lstGrupos) {
				if (g.getAbertura() != null && g.getAbertura().trim().equals("S")) {
					document.getElementById("enviaEmailCriacao").setDisabled(true);
				}
				if (g.getEncerramento() != null && g.getEncerramento().trim().equals("S")) {
					document.getElementById("enviaEmailFinalizacao").setDisabled(true);
				}
				if (g.getAndamento() != null && g.getAndamento().trim().equals("S")) {
					document.getElementById("enviaEmailAcoes").setDisabled(true);
				}
			}
		}

		this.preencherComboSituacao(document, request, null);

		this.limpar(document, request, response);

		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		contratoService.carregarContratos("", usuario, document, request);

		if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {
			this.restore(document, request, response);
			document.executeScript("$('#tituloSolicitacao').removeClass('inativo')");
			document.executeScript("$('#liOcorrenciasReqLiberacao').removeClass('inativo');");
			if("N".equals(requisicaoLiberacaoDTO.getAlterarSituacao())){
				document.executeScript("$('#btAdicionarMudanca').hide();");
				document.executeScript("$('#modal-requisicao-liberacao-anexos-plano-reversao .btn').hide();");
				document.executeScript("$('#adicionaConhecimento').hide();");
			}
		} else {
			document.executeScript("$('#liOcorrenciasReqLiberacao').addClass('inativo');");
		}

		String tarefaAssociada = "N";
		if (requisicaoLiberacaoDTO.getIdTarefa() != null) {
			tarefaAssociada = "S";
		}
		request.setAttribute("tarefaAssociada", tarefaAssociada);

		if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null && requisicaoLiberacaoDTO.getIdGrupoAtvPeriodica() == null) {
			RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
			requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) liberacaoService.restore(requisicaoLiberacaoDTO);
		}

		// carregar o grupo de atividade peridica para agendamento
		HTMLForm form = document.getForm("form");

		if (requisicaoLiberacaoDTO.getIdGrupoAtvPeriodica() != null) {
			document.getSelectById("idGrupoAtvPeriodica").removeAllOptions();
			GrupoAtvPeriodicaService grupoService2 = (GrupoAtvPeriodicaService) ServiceLocator.getInstance().getService(GrupoAtvPeriodicaService.class, null);

			ArrayList<GrupoAtvPeriodicaDTO> grupos = (ArrayList) grupoService2.list();
			if (grupos != null) {
				for (GrupoAtvPeriodicaDTO grupo : grupos) {
					if (requisicaoLiberacaoDTO.getIdGrupoAtvPeriodica().equals(grupo.getIdGrupoAtvPeriodica())) {
						document.getSelectById("idGrupoAtvPeriodica").addOption(grupo.getIdGrupoAtvPeriodica().toString(), grupo.getNomeGrupoAtvPeriodica());
					}
				}
			}
		} else {

			AtividadePeriodicaDTO atividadePeriodicaDTO = new AtividadePeriodicaDTO();
			atividadePeriodicaDTO.setIdRequisicaoMudanca(requisicaoLiberacaoDTO.getIdLiberacao());
			HTMLSelect idGrupoAtvPeriodica = document.getSelectById("idGrupoAtvPeriodica");
			idGrupoAtvPeriodica.removeAllOptions();
			GrupoAtvPeriodicaService grupoAtvPeriodicaService = (GrupoAtvPeriodicaService) ServiceLocator.getInstance().getService(GrupoAtvPeriodicaService.class, null);
			Collection colGrupos = grupoAtvPeriodicaService.listGrupoAtividadePeriodicaAtiva();
			idGrupoAtvPeriodica.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			idGrupoAtvPeriodica.addOptions(colGrupos, "idGrupoAtvPeriodica", "nomeGrupoAtvPeriodica", null);

			form.setValues(atividadePeriodicaDTO);
		}

		if (requisicaoLiberacaoDTO != null && requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null && requisicaoLiberacaoDTO.getIdRequisicaoLiberacao().intValue() > 0) {
			document.getElementById("btnImprimir").setDisabled(false);
		} else {
			document.getElementById("btnImprimir").setDisabled(true);
		}
		
		requisicaoLiberacaoDTO = null;

		this.tabelaMudancaSituacaoLiberacao(document, request, response);
		document.getElementById("SGBD").setValue(CITCorporeUtil.SGBD_PRINCIPAL);
		document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");
		document.executeScript("JANELA_AGUARDE_MENU.hide();$('#loading_overlay').hide();");
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		/* document.executeScript("$('#requisicaLiberacaoStatus').show()"); */
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();
		RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));

		Integer idTarefa = requisicaoLiberacaoDTO.getIdTarefa();
		String acaoFluxo = requisicaoLiberacaoDTO.getAcaoFluxo();
		String alterarSituacao = requisicaoLiberacaoDTO.getAlterarSituacao();
		String editar = requisicaoLiberacaoDTO.getEditar();
		String escalar = requisicaoLiberacaoDTO.getEscalar();
		String[] arFuncoesExTblMudancas = new String[] { "gerarImgDel", "gerarImgpopup", "geraImgPlanoReversao" };
		String[] arFuncoesExTblIcs = new String[] { "gerarImgDelIc", "exibeIconesIC" };
		String[] arFuncoesExTblProblemas = new String[] { "gerarImgDelProblema" };
		String[] arFuncoesExTblConhecimentos = new String[] { "gerarImgDelConhecimento" };
		String[] arFuncoesExTblMidia = new String[] { "exibeIconesMidia" };
		String[] arFuncoesExTblResponsavel = new String[] { "gerarImgDelResponsavel" };
		String[] arFuncoesExTblRequisicaoCompra = new String[] { "gerarImgDelRequisicaoCompras" };

		requisicaoLiberacaoDTO = liberacaoService.restoreAll(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		if (requisicaoLiberacaoDTO == null) {
			return;
		}
		if (requisicaoLiberacaoDTO.getIdContrato() != null) {
			document.getElementById("pesqLockupLOOKUP_EMPREGADO_IDCONTRATO").setValue(requisicaoLiberacaoDTO.getIdContrato().toString());
		}

		requisicaoLiberacaoDTO.setIdTarefa(idTarefa);
		requisicaoLiberacaoDTO.setAcaoFluxo(acaoFluxo);
		requisicaoLiberacaoDTO.setAlterarSituacao(alterarSituacao);
		requisicaoLiberacaoDTO.setEscalar(escalar);

		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
		EmpregadoDTO empregadoDto = new EmpregadoDTO();
		empregadoDto = empregadoService.restoreByIdEmpregado(requisicaoLiberacaoDTO.getIdSolicitante());
		requisicaoLiberacaoDTO.setNomeSolicitante(empregadoDto.getNome());

		this.restaurarAnexos(request, requisicaoLiberacaoDTO);
		this.restaurarAnexosDocsLegais(request, requisicaoLiberacaoDTO);
		restaurarAnexosDocsGerais(request, requisicaoLiberacaoDTO);
		if (this.listInfoRegExecucaoRequisicaoLiberacao(this.getRequisicaoLiberacaoDTO(), request) != null) {
			document.getElementById("tblOcorrencias").setInnerHTML(listInfoRegExecucaoRequisicaoLiberacao(requisicaoLiberacaoDTO, request));
		}
		empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));

		this.preencherComboSituacao(document, request, requisicaoLiberacaoDTO);

		if (requisicaoLiberacaoDTO.getIdContatoRequisicaoLiberacao() != null) {
			ContatoRequisicaoLiberacaoDTO contatoRequisicaoLiberacaoDTO = new ContatoRequisicaoLiberacaoDTO();
			contatoRequisicaoLiberacaoDTO.setIdContatoRequisicaoLiberacao(requisicaoLiberacaoDTO.getIdContatoRequisicaoLiberacao());
			ContatoRequisicaoLiberacaoServiceEjb contatoRequisicaoLiberacaoServiceEjb = new ContatoRequisicaoLiberacaoServiceEjb();
			contatoRequisicaoLiberacaoDTO = contatoRequisicaoLiberacaoServiceEjb.restoreContatosById(contatoRequisicaoLiberacaoDTO.getIdContatoRequisicaoLiberacao());

			if (contatoRequisicaoLiberacaoDTO != null && contatoRequisicaoLiberacaoDTO.getIdContatoRequisicaoLiberacao() != null) {
				requisicaoLiberacaoDTO.setIdContatoRequisicaoLiberacao(contatoRequisicaoLiberacaoDTO.getIdContatoRequisicaoLiberacao());
			} else {
				return;
			}
			if (contatoRequisicaoLiberacaoDTO.getNomeContato() != null) {
				requisicaoLiberacaoDTO.setNomeContato2(Util.tratarAspasSimples(contatoRequisicaoLiberacaoDTO.getNomeContato()));
			}
			if (contatoRequisicaoLiberacaoDTO.getTelefoneContato() != null) {
				requisicaoLiberacaoDTO.setTelefoneContato(Util.tratarAspasSimples(contatoRequisicaoLiberacaoDTO.getTelefoneContato()));
			}
			if (contatoRequisicaoLiberacaoDTO.getRamal() != null) {
				requisicaoLiberacaoDTO.setRamal(Util.tratarAspasSimples(contatoRequisicaoLiberacaoDTO.getRamal()));
			}
			if (contatoRequisicaoLiberacaoDTO.getEmailContato() != null) {
				requisicaoLiberacaoDTO.setEmailContato(Util.tratarAspasSimples(contatoRequisicaoLiberacaoDTO.getEmailContato()));
			}
			if (contatoRequisicaoLiberacaoDTO.getIdUnidade() != null) {
				requisicaoLiberacaoDTO.setIdUnidade(contatoRequisicaoLiberacaoDTO.getIdUnidade());
			}
			if (contatoRequisicaoLiberacaoDTO.getIdLocalidade() != null) {
				requisicaoLiberacaoDTO.setIdLocalidade(contatoRequisicaoLiberacaoDTO.getIdLocalidade());
			}
			if (contatoRequisicaoLiberacaoDTO.getObservacao() != null) {
				requisicaoLiberacaoDTO.setObservacao(Util.tratarAspasSimples(contatoRequisicaoLiberacaoDTO.getObservacao()));
			}
		}
		HTMLForm form = document.getForm("form");
		form.clear();

		if (requisicaoLiberacaoDTO.getIdSolicitante() != null) {

			preencherComboGrupoAprovadorById(document, request, response, requisicaoLiberacaoDTO.getIdSolicitante());

		}

		carregaUnidadeAux(document, request, response, null, false);
		preencherComboLocalidadeComUnidade(document, request, response, requisicaoLiberacaoDTO.getIdUnidade());

		form.setValues(requisicaoLiberacaoDTO);
		document.getElementById("numeroLiberacao").setValue(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao().toString());

		if (requisicaoLiberacaoDTO.getIdContrato() != null) {
			document.getSelectById("idContrato").setDisabled(true);
		}
		if (requisicaoLiberacaoDTO.getDataInicial() != null) {
			document.getSelectById("dataInicial").setDisabled(true);
		}

		if (editar == null || "".equalsIgnoreCase(editar)) {
			requisicaoLiberacaoDTO.setEditar("S");
		} else if ("N".equalsIgnoreCase(editar)) {
			document.executeScript("$('#divBotoes').hide()");
			document.executeScript("$('#btnGravar').hide()");
			document.executeScript("$('#abas').hide()");
			document.executeScript("$('#divBotaoAddRegExecucao').hide()");
			document.getForm("form").lockForm();

		} else if ("RO".equalsIgnoreCase(editar)) { // verifca se  para mostrar
													// a barra de ferramentas,
													// mas com os anexos e
													// ocorrncias, apenas para
													// leitura(RO - Read Only).
													// Botes tambm so
													// desabilitados
			document.executeScript("$('#btnGravar').hide()");
			document.getForm("form").lockForm();
			document.executeScript("$('#fraUpload_uploadRequisicaoLiberacao').attr('src', '" + Configuracoes.getCaminhoComContexto("/pages/uploadRequisicaoLiberacao/uploadRequisicaoLiberacao.load?editar=RO") + "')");
			document.executeScript("$('#segundaAba').remove()");
			document.executeScript("$('#btAdicionarMudanca').remove()");
			arFuncoesExTblMudancas = new String[] { "geraImgPlanoReversao" };
			document.executeScript("$('#fraUpload_uploadPlanoDeReversaoLiberacao').attr('src', '" + Configuracoes.getCaminhoComContexto("/pages/refreshuploadPlanoDeReversaoLiberacao/refreshuploadPlanoDeReversaoLiberacao.load?editar=RO") + "')");

			document.executeScript("$(\"a[href='#tabCadastroOcorrencias']\").parent().hide();");
			document.executeScript("$('#tabCadastroOcorrencias').remove()");
			document.executeScript("$('#adicionaIC').remove()");
			document.executeScript("$('#consultaIC').remove()");
			document.executeScript("$('#adicionaProblema').remove()");
			document.executeScript("$('#adicionarMidia').remove()");
			document.executeScript("$('#adicionarResponsavel').remove()");
			document.executeScript("$('#adicionarRequisicaoCompras').remove()");
			arFuncoesExTblIcs = new String[] { "exibeIconesIC" };
			arFuncoesExTblProblemas = new String[] {};
			arFuncoesExTblConhecimentos = new String[] {};
			document.executeScript("$('#fraUpload_uploadAnexosdocsLegais').attr('src', '" + Configuracoes.getCaminhoComContexto("/pages/uploadDocsLegais/uploadDocsLegais.load?editar=RO") + "')");
			arFuncoesExTblMidia = new String[] {};
			document.executeScript("$('#fraUpload_uploadAnexosDocsGerais').attr('src', '" + Configuracoes.getCaminhoComContexto("/pages/uploadDocsGerais/uploadDocsGerais.load?editar=RO") + "')");
			arFuncoesExTblResponsavel = new String[] {};
			arFuncoesExTblRequisicaoCompra = new String[] {};
			document.executeScript("$('#btGravarPlanoReversao').remove()");
			document.executeScript("$('.disabledOnReadOnly').attr('disabled', 'disabled');");
		}

		if (ReleaseRequestStatus.SOLVED.getId().equals(requisicaoLiberacaoDTO.getIdStatus())) {
			document.executeScript("$('#dtLiberacao').addClass('campoObrigatorio')");
		}

		HTMLTable tblMudancas = document.getTableById("tblMudancas");
		tblMudancas.deleteAllRows();

		LiberacaoMudancaService liberacaoMudancaService = (LiberacaoMudancaService) ServiceLocator.getInstance().getService(LiberacaoMudancaService.class, WebUtil.getUsuarioSistema(request));
		Collection<LiberacaoMudancaDTO> listaLiberacaoMudancas = liberacaoMudancaService.findByIdRequisicaoMudanca(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao(), null);
		requisicaoLiberacaoDTO.setColMudancas(listaLiberacaoMudancas);

		if (listaLiberacaoMudancas != null) {
			RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, WebUtil.getUsuarioSistema(request));
			for (LiberacaoMudancaDTO liberacaoMudancaDto : listaLiberacaoMudancas) {
				RequisicaoMudancaDTO requisicaoMudancaDto = new RequisicaoMudancaDTO();
				requisicaoMudancaDto.setIdRequisicaoMudanca(liberacaoMudancaDto.getIdRequisicaoMudanca());
				requisicaoMudancaDto = (RequisicaoMudancaDTO) requisicaoMudancaService.restore(requisicaoMudancaDto);
				liberacaoMudancaDto.setIdLiberacao(requisicaoLiberacaoDTO.getIdLiberacao());
				liberacaoMudancaDto.setIdHistoricoLiberacao(liberacaoMudancaDto.getIdHistoricoLiberacao());
				liberacaoMudancaDto.setTitulo(requisicaoMudancaDto.getTitulo());
				liberacaoMudancaDto.setIdStatus(requisicaoMudancaDto.getIdStatus());
				liberacaoMudancaDto.setDescrStatus(UtilI18N.internacionaliza(request, liberacaoMudancaDto.getDescrStatus()));
				liberacaoMudancaDto.setDescrReleaseStatus(liberacaoMudancaDto.getDescrReleaseStatus()!= null ? UtilI18N.internacionaliza(request, liberacaoMudancaDto.getDescrReleaseStatus()):"");
			}

			tblMudancas.addRowsByCollection(listaLiberacaoMudancas, new String[] { "", "idRequisicaoMudanca", "titulo", "descrStatus", "descrReleaseStatus", "", "" }, null, "", arFuncoesExTblMudancas, "funcaoClickRowMudanca", null);
		}

		HTMLTable tblProblema = document.getTableById("tblProblema");
		tblProblema.deleteAllRows();

		LiberacaoProblemaService liberacaoProblemaService = (LiberacaoProblemaService) ServiceLocator.getInstance().getService(LiberacaoProblemaService.class, WebUtil.getUsuarioSistema(request));
		Collection<LiberacaoProblemaDTO> problemas = liberacaoProblemaService.findByIdLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		if (problemas != null) {
			for (LiberacaoProblemaDTO lp : problemas) {
				lp.setDescrStatus(UtilI18N.internacionaliza(request, lp.getDescrStatus()));
				tblProblema.addRow(lp, new String[] { "", "idProblema", "titulo", "descrStatus" }, null, "", arFuncoesExTblProblemas, null, null);
			}
		}

		HTMLTable tblConhecimento = document.getTableById("tblConhecimento");
		tblConhecimento.deleteAllRows();

		LiberacaoBaseConhecimentoService liberacaoBaseConhecimentoService = (LiberacaoBaseConhecimentoService) ServiceLocator.getInstance().getService(LiberacaoBaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		Collection<LiberacaoBaseConhecimentoDTO> conhecimentos = liberacaoBaseConhecimentoService.findByIdLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		if (conhecimentos != null) {
			tblConhecimento.addRowsByCollection(conhecimentos, new String[] { "", "idBaseConhecimento", "titulo" }, null, "", arFuncoesExTblConhecimentos, null, null);
		}

		HTMLTable tblMidia = document.getTableById("tblMidia");
		tblMidia.deleteAllRows();

		if (requisicaoLiberacaoDTO != null && requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {
			ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
			contratoService.restauraContrato(requisicaoLiberacaoDTO.getIdContrato(), usuario, document, request);

			RequisicaoLiberacaoMidiaService requisicaoLiberacaoMidiaService = (RequisicaoLiberacaoMidiaService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoMidiaService.class, WebUtil.getUsuarioSistema(request));
			Collection<RequisicaoLiberacaoMidiaDTO> listRequisicaoLiberacaoMidiaDTO = requisicaoLiberacaoMidiaService.findByIdLiberacaoEDataFim(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());

			if (listRequisicaoLiberacaoMidiaDTO != null) {
				tblMidia.addRowsByCollection(listRequisicaoLiberacaoMidiaDTO, new String[] { "", "idMidiaSoftware", "nomeMidia" }, new String[] { "idMidiaSoftware" }, "Liberao j cadastrado!", arFuncoesExTblMidia,
						null, null);
				document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblMidia', 'tblMidia');");
			}
		}

		// Responsvel
		HTMLTable tblResponsavel = document.getTableById("tblResponsavel");
		tblResponsavel.deleteAllRows();

		RequisicaoLiberacaoResponsavelService liberacaoResponsavelService = (RequisicaoLiberacaoResponsavelService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoResponsavelService.class, WebUtil.getUsuarioSistema(request));
		Collection<RequisicaoLiberacaoResponsavelDTO> responsavel = liberacaoResponsavelService.findByIdLiberacaoEDataFim(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		tblResponsavel.addRowsByCollection(responsavel, new String[] { "", "idResponsavel", "nomeResponsavel", "nomeCargo", "telResponsavel", "emailResponsavel", "papelResponsavel" }, null, "", arFuncoesExTblResponsavel, null, null);

		// Requisicao de Compras
		this.RestauraItensTabelaRequisicaoProdutoByIdLiberacao(document, request, requisicaoLiberacaoDTO, arFuncoesExTblRequisicaoCompra);

		this.restoreTableIcs(document, request, response, arFuncoesExTblIcs);
		document.executeScript("setInfoSolicitacao('" + requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() + "')");
		document.executeScript("$('.modal-header button.close').removeAttr('disabled');");
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		requestGlobal = request;
		documentGlobal = document;

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		if (ReleaseRequestStatus.SOLVED.getId().equals(requisicaoLiberacaoDTO.getIdStatus()) && requisicaoLiberacaoDTO.getDataLiberacao() == null) {
			document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");
			document.alert(UtilI18N.internacionaliza(request, "liberacao.dataLiberacao") + " " + UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			return;
		}

		GrupoDTO grupoAtual = new GrupoDTO();
		grupoAtual.setIdGrupo(requisicaoLiberacaoDTO.getIdGrupoAtual());
		grupoAtual = getGrupoService().restore(grupoAtual);

		requisicaoLiberacaoDTO.setNomeGrupoAtual(grupoAtual.getNome());

		try {
			RequisicaoLiberacaoDTO requisicaoLiberacaoAuxDto = null;

			if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {
				requisicaoLiberacaoAuxDto = (RequisicaoLiberacaoDTO) getRequisicaoLiberacaoService(request).restore(requisicaoLiberacaoDTO);

				if (requisicaoLiberacaoDTO.getDataInicial() == null) {
					requisicaoLiberacaoDTO.setDataInicial(requisicaoLiberacaoAuxDto.getDataInicial());
				}

				if (requisicaoLiberacaoDTO.getIdContrato() == null) {
					requisicaoLiberacaoDTO.setIdContrato(requisicaoLiberacaoAuxDto.getIdContrato());
				}
			}

			if (requisicaoLiberacaoDTO.getIdGrupoAtvPeriodica() == null && requisicaoLiberacaoAuxDto != null) {
				requisicaoLiberacaoDTO.setIdGrupoAtvPeriodica(requisicaoLiberacaoAuxDto.getIdGrupoAtvPeriodica());
			}

			RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));

			Collection<LiberacaoMudancaDTO> colMudancas = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(LiberacaoMudancaDTO.class, "mudancas_serialize", request);
			requisicaoLiberacaoDTO.setColMudancas(colMudancas);

			Collection<LiberacaoProblemaDTO> colProblemas = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(LiberacaoProblemaDTO.class, "problemas_serialize", request);
			requisicaoLiberacaoDTO.setColProblemas(colProblemas);

			Collection<LiberacaoBaseConhecimentoDTO> colConhecimentos = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(LiberacaoBaseConhecimentoDTO.class, "conhecimento_serialize", request);
			requisicaoLiberacaoDTO.setColConhecimentos(colConhecimentos);

			Collection<RequisicaoLiberacaoResponsavelDTO> colResponsavel = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoLiberacaoResponsavelDTO.class, "responsavel_serialize", request);
			requisicaoLiberacaoDTO.setColResponsaveis(colResponsavel);

			Collection<RequisicaoLiberacaoRequisicaoComprasDTO> colRequisicaoCompras = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoLiberacaoRequisicaoComprasDTO.class, "requisicaoCompras_serialize", request);
			requisicaoLiberacaoDTO.setColRequisicaoCompras(colRequisicaoCompras);

			requisicaoLiberacaoDTO.setUsuarioDto(usuario);

			ArrayList<RequisicaoLiberacaoItemConfiguracaoDTO> listRequisicaoLiberacaoItemConfiguracaoDTO = (ArrayList<RequisicaoLiberacaoItemConfiguracaoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoLiberacaoItemConfiguracaoDTO.class, "itensConfiguracaoRelacionadosSerializado", request);
			requisicaoLiberacaoDTO.setListRequisicaoLiberacaoItemConfiguracaoDTO(listRequisicaoLiberacaoItemConfiguracaoDTO);

			Collection<RequisicaoLiberacaoMidiaDTO> colMidia = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoLiberacaoMidiaDTO.class, "midias_serialize", request);
			requisicaoLiberacaoDTO.setColMidia(colMidia);

			if (requisicaoLiberacaoDTO != null && requisicaoLiberacaoDTO.getDataFinal() != null) {
				requisicaoLiberacaoDTO.setDataHoraTermino(UtilDatas.strToTimestamp(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, requisicaoLiberacaoDTO.getDataFinal(), WebUtil.getLanguage(request))));
			}

			requisicaoLiberacaoDTO.setUsuarioDto(usuario);
			requisicaoLiberacaoDTO.setEnviaEmailCriacao("S");
			requisicaoLiberacaoDTO.setEnviaEmailAcoes("S");
			requisicaoLiberacaoDTO.setEnviaEmailFinalizacao("S");

			requisicaoLiberacaoDTO.setColArquivosUpload((Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadRequisicaoLiberacaoGED"));
			requisicaoLiberacaoDTO.setColDocsGerais((Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadGeraisGED"));
			requisicaoLiberacaoDTO.setColArquivosUploadDocsLegais((Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadsGEDdocsLegais"));

			requisicaoLiberacaoDTO.setIdEmpresa(1);

			TipoLiberacaoService tipoLiberacaoService = (TipoLiberacaoService) ServiceLocator.getInstance().getService(TipoLiberacaoService.class, WebUtil.getUsuarioSistema(request));

			if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {
				RequisicaoLiberacaoService requisicaoLiberacaoServiceAux = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));

				if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {

					requisicaoLiberacaoAuxDto.setIdRequisicaoLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
					requisicaoLiberacaoAuxDto = (RequisicaoLiberacaoDTO) requisicaoLiberacaoServiceAux.restore(requisicaoLiberacaoAuxDto);

					if (requisicaoLiberacaoAuxDto.getIdContrato() != null) {

						requisicaoLiberacaoDTO.setIdContrato(requisicaoLiberacaoAuxDto.getIdContrato());

					}
					if (requisicaoLiberacaoAuxDto.getDataInicial() != null) {
						requisicaoLiberacaoDTO.setDataInicial(requisicaoLiberacaoAuxDto.getDataInicial());
					}
				}

				requisicaoLiberacaoServiceAux.update(requisicaoLiberacaoDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));

				this.limpar(document, request, response);
				document.executeScript("limpar();");
				document.executeScript("fechar();");
			} else {
				liberacaoService.create(requisicaoLiberacaoDTO);

				String tipoLiberacao = "";
				if (requisicaoLiberacaoDTO.getIdTipoLiberacao() != null) {
					TipoLiberacaoDTO tipoLiberacaoDTO = new TipoLiberacaoDTO();
					tipoLiberacaoDTO.setIdTipoLiberacao(requisicaoLiberacaoDTO.getIdTipoLiberacao());
					tipoLiberacaoDTO = (TipoLiberacaoDTO) tipoLiberacaoService.restore(tipoLiberacaoDTO);
					if (tipoLiberacaoDTO != null) {
						tipoLiberacao = tipoLiberacaoDTO.getNomeTipoLiberacao();
					}
				}

				String comando = "mostraMensagemInsercao('" + UtilI18N.internacionaliza(request, "MSG05") + ".<br>" + UtilI18N.internacionaliza(request, "requisicaoLiberacao.requisicaoLiberacao") + " <b><u>" + requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() + "</u></b> " + UtilI18N.internacionaliza(request, "citcorpore.comum.crida") + ".<br><br>" + UtilI18N.internacionaliza(request, "requisicaoLiberacao.tipo") + ": " + UtilStrings.nullToVazio(tipoLiberacao.toString()) + "<br>";
				comando = comando + "')";

				document.executeScript(comando);
			}
		} catch (Exception e) {
			/*
			 * No  a melhor soluo, mas o create e update de
			 * RequisicaoLiberacaoServiceEjb lana logicException durante as
			 * validaes. Para no precisar aumentar as validaes, s
			 * adicionei o alerta diretamente (antes esta classe nem capturava
			 * as excees).
			 */
			document.alert(e.getMessage() != null ? UtilI18N.internacionaliza(request, e.getMessage()) : UtilI18N.internacionaliza(request, "citcorpore.comum.erroGravacao"));
		} finally {
			document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");
		}
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		RequisicaoLiberacaoDTO liberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();
		RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));

		if (liberacaoDto.getIdRequisicaoLiberacao() != null) {
			liberacaoService.delete(liberacaoDto);
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			document.executeScript("limpar();");
		}
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void preencherComboTipoLiberacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		TipoLiberacaoService tipoLiberacaoService = (TipoLiberacaoService) ServiceLocator.getInstance().getService(TipoLiberacaoService.class, null);
		HTMLSelect comboTipoLiberacao = document.getSelectById("idTipoLiberacao");
		ArrayList<TipoLiberacaoDTO> listTipoLiberacao = (ArrayList) tipoLiberacaoService.getAtivos();

		comboTipoLiberacao.removeAllOptions();
		comboTipoLiberacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (listTipoLiberacao != null) {
			for (TipoLiberacaoDTO tipoLiberacaoDTO : listTipoLiberacao) {
				tipoLiberacaoDTO.setNomeTipoLiberacao(StringEscapeUtils.escapeJavaScript(tipoLiberacaoDTO.getNomeTipoLiberacao()));
				if (tipoLiberacaoDTO.getIdTipoLiberacao() != null || tipoLiberacaoDTO.getIdTipoLiberacao() > 0) {
					comboTipoLiberacao.addOption(tipoLiberacaoDTO.getIdTipoLiberacao().toString(), tipoLiberacaoDTO.getNomeTipoLiberacao());

				}
			}
		}

	}

	public void preencherComboGrupoAprovadorById(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, Integer idSolicitante) throws Exception {

		document.getSelectById("idGrupoAprovador").removeAllOptions();

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		Collection<GrupoDTO> listGrupo = grupoService.getGruposByIdEmpregado(idSolicitante);

		document.getSelectById("idGrupoAprovador").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		document.getSelectById("idGrupoAprovador").addOptions(listGrupo, "idGrupo", "nome", null);

	}

	public void preencherComboGrupoAprovador(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();

		document.getSelectById("idGrupoAprovador").removeAllOptions();

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		Collection<GrupoDTO> listGrupo = grupoService.getGruposByIdEmpregado(requisicaoLiberacaoDto.getIdSolicitante());

		document.getSelectById("idGrupoAprovador").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		document.getSelectById("idGrupoAprovador").addOptions(listGrupo, "idGrupo", "nome", null);

	}

	public void preencherComboGrupoExecutor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		document.getSelectById("idGrupoAtual").removeAllOptions();

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		Collection<GrupoDTO> listGrupo = grupoService.listGruposNaoComite();

		document.getSelectById("idGrupoAtual").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		document.getSelectById("idGrupoAtual").addOptions(listGrupo, "idGrupo", "nome", null);

	}

	public void carregaDadosContato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		EmpregadoDTO empregadoDTO = empregadoService.restoreByIdEmpregado(requisicaoLiberacaoDto.getIdSolicitante());

		if (empregadoDTO.getNome() != null) {
			HTMLSelect nomeContato = document.getSelectById("nomeContato2");
			nomeContato.setValue(empregadoDTO.getNome());
		}
		if (empregadoDTO.getEmail() != null) {
			HTMLSelect emailContato = document.getSelectById("emailContato");
			emailContato.setValue(empregadoDTO.getEmail());
		}
		if (empregadoDTO.getTelefone() != null) {
			HTMLSelect telefoneContato = document.getSelectById("telefoneContato");
			telefoneContato.setValue(empregadoDTO.getTelefone());
		}
		if (empregadoDTO.getRamal() != null) {
			HTMLSelect ramal = document.getSelectById("ramal");
			ramal.setValue(empregadoDTO.getRamal());
		}

		if (empregadoDTO.getIdUnidade() != null) {
			carregaUnidadeAux(document, request, response, empregadoDTO, true);
		} else {
			carregaUnidadeAux(document, request, response, empregadoDTO, false);
		}

		preencherComboLocalidadeComUnidade(document, request, response, empregadoDTO.getIdUnidade());

	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @param empregadoDTO
	 * @param setUnidade
	 * @throws Exception
	 */
	public void carregaUnidadeAux(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, EmpregadoDTO empregadoDTO, boolean setUnidade) throws Exception {

		String validarComboUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();

		if (requisicaoLiberacaoDto.getIdRequisicaoLiberacao() != null && requisicaoLiberacaoDto.getIdRequisicaoLiberacao().intValue() > 0) {
			RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
			requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) requisicaoLiberacaoService.restore(requisicaoLiberacaoDto);
		}

		if (requisicaoLiberacaoDto.getIdContrato() != null && requisicaoLiberacaoDto.getIdContrato().intValue() >= 0) {
			boolean verifica = false;
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			HTMLSelect comboUnidade = document.getSelectById("idUnidade");
			inicializarCombo(comboUnidade, request);
			if (validarComboUnidade.trim().equalsIgnoreCase("S")) {
				Integer idContrato = requisicaoLiberacaoDto.getIdContrato();
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquiaMultiContratos(idContrato);
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel().toString()));
							if (setUnidade) {
								if (unidade.getIdUnidade().equals(empregadoDTO.getIdUnidade())) {
									verifica = true;
								}
							}
						}
					}
					if (verifica) {
						comboUnidade.setValue(empregadoDTO.getIdUnidade().toString());
					}
				}
			} else {
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquia();
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel().toString()));
						}
					}
				}
				if (setUnidade) {
					comboUnidade.setValue(empregadoDTO.getIdUnidade().toString());
				}
			}
		}
	}

	private void inicializarCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	public void preencherComboLocalidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		preencherComboLocalidadeComUnidade(document, request, response, null);

	}

	public void preencherComboLocalidadeComUnidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, Integer idUnidade) throws Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();

		if (idUnidade == null) {
			idUnidade = requisicaoLiberacaoDto.getIdUnidade();
		}

		LocalidadeUnidadeService localidadeUnidadeService = (LocalidadeUnidadeService) ServiceLocator.getInstance().getService(LocalidadeUnidadeService.class, null);

		LocalidadeService localidadeService = (LocalidadeService) ServiceLocator.getInstance().getService(LocalidadeService.class, null);

		LocalidadeDTO localidadeDto = new LocalidadeDTO();

		Collection<LocalidadeUnidadeDTO> listaIdlocalidadePorUnidade = null;

		Collection<LocalidadeDTO> listaIdlocalidade = null;

		String TIRAR_VINCULO_LOCALIDADE_UNIDADE = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.TIRAR_VINCULO_LOCALIDADE_UNIDADE, "N");

		HTMLSelect comboLocalidade = document.getSelectById("idLocalidade");
		comboLocalidade.removeAllOptions();
		if (TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("N") || TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("")) {
			if (idUnidade != null) {
				listaIdlocalidadePorUnidade = localidadeUnidadeService.listaIdLocalidades(idUnidade);
			}
			if (listaIdlocalidadePorUnidade != null) {
				inicializarComboLocalidade(comboLocalidade, request);
				for (LocalidadeUnidadeDTO localidadeUnidadeDto : listaIdlocalidadePorUnidade) {
					localidadeDto.setIdLocalidade(localidadeUnidadeDto.getIdLocalidade());
					localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
					comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
				}

			}
		} else {
			listaIdlocalidade = localidadeService.listLocalidade();
			if (listaIdlocalidade != null) {
				inicializarComboLocalidade(comboLocalidade, request);
				for (LocalidadeDTO localidadeDTO : listaIdlocalidade) {
					localidadeDto.setIdLocalidade(localidadeDTO.getIdLocalidade());
					localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
					comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
				}
			}

		}

	}

	private void inicializarComboLocalidade(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	public RequisicaoLiberacaoDTO getRequisicaoLiberacaoDTO() {
		return requisicaoLiberacaoDTO;
	}

	/**
	 * Retorna uma lista de informaes da entidade ocorrencia
	 *
	 * @param requisicaoMudancaDto
	 * @param request
	 * @return
	 * @throws ServiceException
	 * @throws Exception
	 * @author murilo.pacheco
	 */
	public String listInfoRegExecucaoRequisicaoLiberacao(RequisicaoLiberacaoDTO requisicaoLiberacaoDTO, HttpServletRequest request) throws ServiceException, Exception {
		JustificativaRequisicaoLiberacaoService justificativaRequisicaoLiberacaoService = (JustificativaRequisicaoLiberacaoService) ServiceLocator.getInstance().getService(JustificativaRequisicaoLiberacaoService.class, null);

		OcorrenciaLiberacaoService ocorrenciaLiberacaoService = (OcorrenciaLiberacaoService) ServiceLocator.getInstance().getService(OcorrenciaLiberacaoService.class, null);
		Collection<OcorrenciaLiberacaoDTO> col = null;
		if (requisicaoLiberacaoDTO != null) {
			if (requisicaoLiberacaoDTO.getIdRequisicaoLiberacao() != null) {
				col = ocorrenciaLiberacaoService.findByIdRequisicaoLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
			}
		}

		CategoriaOcorrenciaDTO categoriaOcorrenciaDTO = new CategoriaOcorrenciaDTO();
		OrigemOcorrenciaDTO origemOcorrenciaDTO = new OrigemOcorrenciaDTO();

		StringBuffer sb = new StringBuffer();
		sb.append("<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' style='table-layout: fixed;'>");
		sb.append("<thead>");
		sb.append("<tr>");
		sb.append("<th style='width:20%'>");
		sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.datahora"));
		sb.append("</th>");
		sb.append("<th >");
		sb.append(UtilI18N.internacionaliza(request, "solicitacaoServico.informacaoexecucao"));
		sb.append("</th>");
		sb.append("</tr>");
		sb.append("</thead>");

		if (col != null) {

			for (OcorrenciaLiberacaoDTO ocorrenciaLiberacaoDTO : col) {

				if (ocorrenciaLiberacaoDTO.getOcorrencia() != null) {
					Source source = new Source(ocorrenciaLiberacaoDTO.getOcorrencia());
					ocorrenciaLiberacaoDTO.setOcorrencia(source.getTextExtractor().toString());
				}

				String ocorrencia = UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getOcorrencia());
				String informacoesContato = UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getInformacoesContato());
				ocorrencia = ocorrencia.replaceAll("\"", "");
				informacoesContato = informacoesContato.replaceAll("\"", "");
				ocorrencia = ocorrencia.replaceAll("\n", "<br>");
				informacoesContato = informacoesContato.replaceAll("\n", "<br>");
				ocorrencia = UtilHTML.encodeHTML(ocorrencia.replaceAll("\'", ""));
				informacoesContato = UtilHTML.encodeHTML(informacoesContato.replaceAll("\'", ""));
				sb.append("<tr>");
				sb.append("<td>");
				sb.append("<b>");
				sb.append(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaLiberacaoDTO.getDataregistro(), WebUtil.getLanguage(request)));
				sb.append(" - ");
				sb.append(ocorrenciaLiberacaoDTO.getHoraregistro());
				sb.append(" - </b>");
				sb.append(UtilI18N.internacionaliza(request, "ocorrenciaSolicitacao.registradopor"));
				sb.append(": <b>");
				sb.append(ocorrenciaLiberacaoDTO.getRegistradopor());
				sb.append("</b>");
				sb.append("</td>");
				sb.append("<td style='word-wrap: break-word;overflow:hidden;'>");
				sb.append("<b>");

				if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(ocorrenciaLiberacaoDTO.getIdCategoriaOcorrencia())) {
					categoriaOcorrenciaDTO.setIdCategoriaOcorrencia(ocorrenciaLiberacaoDTO.getIdCategoriaOcorrencia());
					categoriaOcorrenciaDTO = getCategoriaOcorrenciaService().restore(categoriaOcorrenciaDTO);
					sb.append(categoriaOcorrenciaDTO.getNome());
				} else {
					sb.append(UtilI18N.internacionaliza(request, OccurrenceCategory.chaveFromId(ocorrenciaLiberacaoDTO.getIdOccurrenceCategory())));
				}

				sb.append("<br><br></b>");

				sb.append("<b>");

				String execucaoDaTarefa = "Execu&ccedil;&atilde;o&nbsp;da&nbsp;tarefa&nbsp;";
				String chaveExecucaoDaTarefa = "citcorpore.comum.execucaoTarefa&nbsp;";
				if (ocorrencia.indexOf(execucaoDaTarefa) > -1) {
					ocorrencia = ocorrencia.substring(execucaoDaTarefa.length());
					sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.execucaoTarefa"));
					sb.append(" ");
				} else if (ocorrencia.indexOf(chaveExecucaoDaTarefa) > -1) {
					ocorrencia = ocorrencia.substring(chaveExecucaoDaTarefa.length());
					sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.execucaoTarefa"));
					sb.append(" ");
				}

				sb.append(ocorrencia);
				sb.append("<br><br></b>");

				if (OccurrenceCategory.REQUEST_SUSPENSION.getId().equals(ocorrenciaLiberacaoDTO.getIdOccurrenceCategory()) || OccurrenceCategory.SLA_CHANGE.getId().equals(ocorrenciaLiberacaoDTO.getIdOccurrenceCategory())) {
					JustificativaRequisicaoLiberacaoDTO justificativaRequisicaoLiberacaoDTO = new JustificativaRequisicaoLiberacaoDTO();
					if (ocorrenciaLiberacaoDTO.getIdJustificativa() != null) {
						justificativaRequisicaoLiberacaoDTO.setIdJustificativaLiberacao(ocorrenciaLiberacaoDTO.getIdJustificativa());
						justificativaRequisicaoLiberacaoDTO = (JustificativaRequisicaoLiberacaoDTO) justificativaRequisicaoLiberacaoService.restore(justificativaRequisicaoLiberacaoDTO);
						if (justificativaRequisicaoLiberacaoDTO != null) {
							sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.justificativa"));
							sb.append(": <b>");
							sb.append(justificativaRequisicaoLiberacaoDTO.getDescricaoJustificativa());
							sb.append("<br><br></b>");
						}
					}
					if (!UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getComplementoJustificativa()).trim().equalsIgnoreCase("")) {
						sb.append("<b>");
						sb.append(UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getComplementoJustificativa()));
						sb.append("<br><br></b>");
					}
				}

				if (ocorrenciaLiberacaoDTO.getOcorrencia() != null) {
					if (categoriaOcorrenciaDTO.getNome() != null && !categoriaOcorrenciaDTO.getNome().equals("")) {
						if (categoriaOcorrenciaDTO.getNome().equalsIgnoreCase(Enumerados.OccurrenceCategory.REQUEST_SUSPENSION.toString()) || categoriaOcorrenciaDTO.getNome().equalsIgnoreCase(Enumerados.OccurrenceCategory.SLA_CHANGE.toString())) {
							JustificativaRequisicaoLiberacaoDTO justificativaRequisicaoLiberacaoDTO = new JustificativaRequisicaoLiberacaoDTO();
							if (ocorrenciaLiberacaoDTO.getIdJustificativa() != null) {
								justificativaRequisicaoLiberacaoDTO.setIdJustificativaLiberacao(ocorrenciaLiberacaoDTO.getIdJustificativa());
								justificativaRequisicaoLiberacaoDTO = (JustificativaRequisicaoLiberacaoDTO) justificativaRequisicaoLiberacaoService.restore(justificativaRequisicaoLiberacaoDTO);
								if (justificativaRequisicaoLiberacaoDTO != null) {
									sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.justificativa"));
									sb.append(": <b>");
									sb.append(justificativaRequisicaoLiberacaoDTO.getDescricaoJustificativa());
									sb.append("<br><br></b>");
								}
							}
							if (!UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getComplementoJustificativa()).trim().equalsIgnoreCase("")) {
								sb.append("<b>");
								sb.append(UtilStrings.nullToVazio(ocorrenciaLiberacaoDTO.getComplementoJustificativa()));
								sb.append("<br><br></b>");
							}
						}
					}
				}

				sb.append("</td>");
				sb.append("</tr>");
			}

		}

		sb.append("</table>");

		categoriaOcorrenciaDTO = null;
		origemOcorrenciaDTO = null;

		return sb.toString();
	}

	protected void restaurarAnexos(HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws ServiceException, Exception {
		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		Collection colAnexos = controleGedService.listByIdTabelaAndIdLiberacaoAndLigacao(ControleGEDDTO.TABELA_REQUISICAOLIBERACAO, requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		Collection<UploadDTO> colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);

		/**
		 * ================================= Restaura anexo(s) principal. =================================
		 * **/
		if (colAnexosUploadDTO != null) {
			for (UploadDTO uploadDTO : colAnexosUploadDTO) {
				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				}
			}
		}

		request.getSession(true).setAttribute("colUploadRequisicaoLiberacaoGED", colAnexosUploadDTO); // Anexo principal

	}

	protected void restaurarAnexosDocsGerais(HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws ServiceException, Exception {
		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);

		Collection colDocsGeraisAnexos = controleGedService.listByIdTabelaAndIdLiberacaoAndLigacao(ControleGEDDTO.TABELA_DOCSGERAIS_REQUISICAOLIBERACAO, requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		Collection<UploadDTO> colAnexosDocsGeraisUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colDocsGeraisAnexos);

		/**
		 * ================================= Restaura anexo(s) Documentos gerais. =================================
		 * **/
		if (colAnexosDocsGeraisUploadDTO != null) {
			for (UploadDTO uploadDTO : colAnexosDocsGeraisUploadDTO) {
				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				}
			}
		}

		request.getSession(true).setAttribute("colUploadGeraisGED", colAnexosDocsGeraisUploadDTO);

	}

	protected void restaurarAnexosDocsLegais(HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws ServiceException, Exception {
		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);

		Collection colDocsLegaisAnexos = controleGedService.listByIdTabelaAndIdLiberacaoAndLigacao(ControleGEDDTO.TABELA_DOCSLEGAIS_REQUISICAOLIBERACAO, requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		Collection<UploadDTO> colAnexosDocsLegaisUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colDocsLegaisAnexos);

		/**
		 * ================================= Restaura anexo(s) Documentos legais. =================================
		 * **/
		if (colAnexosDocsLegaisUploadDTO != null) {
			for (UploadDTO uploadDTO : colAnexosDocsLegaisUploadDTO) {
				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				}
			}
		}

		request.getSession(true).setAttribute("colUploadsGEDdocsLegais", colAnexosDocsLegaisUploadDTO); // Anexo documentos legais

	}

	public void mostraHistoricoLiberacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws Exception {
		HistoricoLiberacaoService liberacaoService = (HistoricoLiberacaoService) ServiceLocator.getInstance().getService(HistoricoLiberacaoService.class, null);
		HistoricoMudancaService mudancaService = (HistoricoMudancaService) ServiceLocator.getInstance().getService(HistoricoMudancaService.class, null);
		Collection<String> colbaselines = new ArrayList();

		HTMLElement divPrincipal = document.getElementById("contentBaseline");
		StringBuilder subDiv = new StringBuilder();
		subDiv.append("" + "<div class='formBody'> " + "	<table id='tblBaselines' class='table table-bordered table-striped'> 	" + "		<thead>" + "			<tr>" + "				<th>" + UtilI18N.internacionaliza(request, "liberacao.baseline") + "</th>	" + "				<th>" + UtilI18N.internacionaliza(request, "liberacao.versaoHistorico") + "</th>	" + "				<th>" + UtilI18N.internacionaliza(request, "liberacao.executorModificacao") + "</th>	" + "				<th>" + UtilI18N.internacionaliza(request, "colaborador.colaborador") + "</th>	" + "				<th>" + UtilI18N.internacionaliza(request, "liberacao.idRequisicaoMudancaVinculada") + "</th>	" + "				<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.historicoRestaurar") + "</th>	" + "			</tr>" + "		</thead>");
		List<HistoricoMudancaDTO> listHistoricoMudancas = new ArrayList<HistoricoMudancaDTO>();
		List<HistoricoMudancaDTO> listHistoricoMudancasAux = new ArrayList<HistoricoMudancaDTO>();

		if (requisicaoLiberacaoDTO != null && requisicaoLiberacaoDTO.getColMudancas() != null) {
			for (LiberacaoMudancaDTO requisicaoMudancaDTO : requisicaoLiberacaoDTO.getColMudancas()) {
				listHistoricoMudancasAux = mudancaService.listHistoricoMudancaByIdRequisicaoMudanca(requisicaoMudancaDTO.getIdRequisicaoMudanca());
				listHistoricoMudancas.addAll(listHistoricoMudancasAux);
				listHistoricoMudancasAux = null;
			}
		}

		if (listHistoricoMudancas != null) {
			int count = 0;
			boolean flag = false;
			document.executeScript("document.form.idHistoricoLiberacao.value = " + requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
			document.executeScript("countHistorico = 0");
			for (HistoricoMudancaDTO historicoMudancaDTO : listHistoricoMudancas) {
				flag = historicoMudancaDTO.getBaseLine() != null && historicoMudancaDTO.getBaseLine().equals("SIM") ? true : false;
				String disabled = "";
				count++;
				DecimalFormat df = new DecimalFormat("0.##");
				String versao = df.format(historicoMudancaDTO.getHistoricoVersao());
				versao = versao.replace(",", ".");
				document.executeScript("seqBaseline = " + count);
				if (flag) {
					disabled = "disabled='disabled'";
					colbaselines.add("idHistoricoMudanca" + count);
				}
				subDiv.append("<tbody>" + "	<tr>" + "		<td width='5%'>" + "<input type='checkbox' " + disabled + " id='idHistoricoMudanca" + count + "'" + " name='idHistoricoMudanca" + count + "' value='0" + historicoMudancaDTO.getIdHistoricoMudanca().toString() + "'/></td>" + "		<td>" + versao + " - " + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, historicoMudancaDTO.getDataHoraModificacao(), WebUtil.getLanguage(request)) + "</td>" + "		<td width='15%'>" + (historicoMudancaDTO.getNomeExecutorModificacao() == null ? "" : historicoMudancaDTO.getNomeExecutorModificacao()) + "</td>" + "		<td>" + (historicoMudancaDTO.getNomeProprietario() == null ? "" : historicoMudancaDTO.getNomeProprietario()) + "</td>" + "		<td>" + (historicoMudancaDTO.getIdRequisicaoMudanca() == null ? "" : historicoMudancaDTO.getIdRequisicaoMudanca()) + "</td>" + "		<td>" + "			<a href='javascript:;' class='even' id='even-" + historicoMudancaDTO.getIdHistoricoMudanca() + "'>" + "		<img src='../../template_new/images/icons/small/grey/documents.png' alt='" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.historico") + "' " + "title='" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.historico") + "' /></a>");
				if (flag) {
					subDiv.append("		<a href='javascript:;' onclick='restaurarHistorico(\"" + historicoMudancaDTO.getIdHistoricoMudanca() + "\")'>" + "			<img src='../../template_new/images/icons/small/grey/refresh_3.png' alt='" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.restaurar") + "' " + "title='" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.restaurar") + "' /></a>");
				}

				subDiv.append("		</td>" + "	</tr>" + "	<tr class='sel' id='sel-" + historicoMudancaDTO.getIdHistoricoMudanca() + "'>" + "	</tr>" + "</tbody>");
			}
		}
		subDiv.append("	</table>" + "</div>");
		divPrincipal.setInnerHTML(subDiv.toString());
		document.executeScript("marcarCheckbox(" + colbaselines + ")");
		for (String str : colbaselines) {
			document.getCheckboxById(str).setChecked(true);
		}
	}

	public void saveBaseline(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usrDto = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);
		if (usrDto == null) {
			return;
		}
		HistoricoMudancaService historicoMudancaService = (HistoricoMudancaService) ServiceLocator.getInstance().getService(HistoricoMudancaService.class, null);
		HistoricoMudancaDao historicoMudancaDao = new HistoricoMudancaDao();
		List<HistoricoMudancaDTO> set = (ArrayList<HistoricoMudancaDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(HistoricoMudancaDTO.class, "baselinesSerializadas", request);
		if (set != null) {
			for (HistoricoMudancaDTO historicoMudancaDTO : set) {
				HistoricoMudancaDTO novo = new HistoricoMudancaDTO();
				novo.setBaseLine("SIM");
				if (historicoMudancaDTO.getIdHistoricoMudanca() != null) {
					novo.setIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
					novo = (HistoricoMudancaDTO) historicoMudancaDao.restore(novo);
					novo.setBaseLine("SIM");
					historicoMudancaDao.update(novo);
				}
			}
			document.alert(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.baselineGravadasSucesso"));
			load(document, request, response);
		}
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void carregaUnidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String validarComboUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();

		if (requisicaoLiberacaoDto.getIdRequisicaoLiberacao() != null && requisicaoLiberacaoDto.getIdRequisicaoLiberacao().intValue() > 0) {

			RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);

			ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);

			requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) requisicaoLiberacaoService.restore(requisicaoLiberacaoDto);

			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();
			servicoContratoDTO.setIdServicoContrato(requisicaoLiberacaoDto.getIdContrato());
			if (requisicaoLiberacaoDto.getIdContrato() != null) {
				servicoContratoDTO = (ServicoContratoDTO) servicoContratoService.restore(servicoContratoDTO);
			} else {
				servicoContratoDTO = null;
			}
			if (servicoContratoDTO != null) {
				requisicaoLiberacaoDto.setIdRequisicaoLiberacao(servicoContratoDTO.getIdServico());
				requisicaoLiberacaoDto.setIdContrato(servicoContratoDTO.getIdContrato());
			}

		}

		if (requisicaoLiberacaoDto.getIdContrato() != null) {
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			HTMLSelect comboUnidade = document.getSelectById("idUnidade");
			inicializarCombo(comboUnidade, request);
			if (validarComboUnidade.trim().equalsIgnoreCase("S")) {
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquiaMultiContratos(requisicaoLiberacaoDto.getIdContrato());
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), unidade.getNomeNivel());
						}

					}
				}
			} else {
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquia();
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), unidade.getNomeNivel());
						}
					}
				}
			}
		}
	}

	public void verificaGrupoExecutor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();
		if (requisicaoLiberacaoDto.getIdContrato() != null || requisicaoLiberacaoDto.getIdContrato().intValue() >= 0) {
			String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");
			if (COLABORADORES_VINC_CONTRATOS == null) {
				COLABORADORES_VINC_CONTRATOS = "N";
			}
			if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
				HTMLSelect idGrupoAtual = document.getSelectById("idGrupoAtual");
				idGrupoAtual.removeAllOptions();
				idGrupoAtual.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
				GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
				Collection colGrupos = grupoSegurancaService.listGruposServiceDeskByIdContrato(requisicaoLiberacaoDto.getIdContrato());
				if (colGrupos != null) {
					idGrupoAtual.addOptions(colGrupos, "idGrupo", "nome", null);
				}
			}
		}
	}

	private RequisicaoLiberacaoDTO restauraRequisicaoLiberacaoDTOAux(HttpServletRequest request) {
		RequisicaoLiberacaoDTO requisicaoLiberacaoAuxDto = new RequisicaoLiberacaoDTO();
		return requisicaoLiberacaoAuxDto;
	}

	private RequisicaoLiberacaoService getRequisicaoLiberacaoService(HttpServletRequest request) throws ServiceException, Exception {
		RequisicaoLiberacaoService requisicaoLiberacaoServiceAux = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));
		return requisicaoLiberacaoServiceAux;
	}

	public void verificarParametroAnexos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String DISKFILEUPLOAD_REPOSITORYPATH = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.DISKFILEUPLOAD_REPOSITORYPATH, "");
		if (DISKFILEUPLOAD_REPOSITORYPATH == null) {
			DISKFILEUPLOAD_REPOSITORYPATH = "";
		}
		if (DISKFILEUPLOAD_REPOSITORYPATH.equals("")) {
			throw new LogicException(UtilI18N.internacionaliza(request, "citcorpore.comum.anexosUploadSemParametro"));
		}
		File pasta = new File(DISKFILEUPLOAD_REPOSITORYPATH);
		if (!pasta.exists()) {
			throw new LogicException(UtilI18N.internacionaliza(request, "citcorpore.comum.pastaIndicadaNaoExiste"));
		}
	}

	public void restaurarBaseline(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usrDto = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);
		HistoricoMudancaDao historicoMudancaDao = new HistoricoMudancaDao();
		if (usrDto == null) {
			return;
		}
		RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
		RequisicaoMudancaDTO requisicaoMudancaDTOAux = new RequisicaoMudancaDTO();
		HistoricoMudancaDTO historicoMudancaDTO = new HistoricoMudancaDTO();
		historicoMudancaDTO.setIdHistoricoMudanca(Integer.parseInt(request.getParameter("idHistoricoMudanca")));

		HistoricoMudancaService historicoMudancaService = (HistoricoMudancaService) ServiceLocator.getInstance().getService(HistoricoMudancaService.class, null);
		RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		historicoMudancaDTO = (HistoricoMudancaDTO) historicoMudancaDao.restore(historicoMudancaDTO);

		// Realizando a Reflexo de Item de Configurao
		Reflexao.copyPropertyValues(historicoMudancaDTO, requisicaoMudancaDTOAux);

		List<RequisicaoMudancaItemConfiguracaoDTO> colItemconfiguracao = new ArrayList<RequisicaoMudancaItemConfiguracaoDTO>();
		RequisicaoMudancaItemConfiguracaoDao itemConfiguracaoDao = new RequisicaoMudancaItemConfiguracaoDao();
		colItemconfiguracao = (List<RequisicaoMudancaItemConfiguracaoDTO>) itemConfiguracaoDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListRequisicaoMudancaItemConfiguracaoDTO(colItemconfiguracao);

		List<ProblemaMudancaDTO> colProblemas = new ArrayList<ProblemaMudancaDTO>();
		ProblemaMudancaDAO problemaMudancaDAO = new ProblemaMudancaDAO();
		colProblemas = (List<ProblemaMudancaDTO>) problemaMudancaDAO.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListProblemaMudancaDTO(colProblemas);

		List<RequisicaoMudancaRiscoDTO> colMudancaRiscoDTOs = new ArrayList<RequisicaoMudancaRiscoDTO>();
		RequisicaoMudancaRiscoDao requisicaoMudancaRiscoDao = new RequisicaoMudancaRiscoDao();
		colMudancaRiscoDTOs = (List<RequisicaoMudancaRiscoDTO>) requisicaoMudancaRiscoDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListRequisicaoMudancaRiscoDTO(colMudancaRiscoDTOs);

		List<AprovacaoMudancaDTO> aprovacaoMudancaDTOs = new ArrayList<AprovacaoMudancaDTO>();
		AprovacaoMudancaDao aprovacaoMudancaDao = new AprovacaoMudancaDao();
		aprovacaoMudancaDTOs = (List<AprovacaoMudancaDTO>) aprovacaoMudancaDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListAprovacaoMudancaDTO(aprovacaoMudancaDTOs);

		List<LiberacaoMudancaDTO> liberacaoMudancaDTOs = new ArrayList<LiberacaoMudancaDTO>();
		LiberacaoMudancaDao liberacaoMudancaDao = new LiberacaoMudancaDao();
		liberacaoMudancaDTOs = (List<LiberacaoMudancaDTO>) liberacaoMudancaDao.listByIdHistoricoMudanca2(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListLiberacaoMudancaDTO(liberacaoMudancaDTOs);

		List<RequisicaoMudancaServicoDTO> requisicaoMudancaServicoDTOs = new ArrayList<RequisicaoMudancaServicoDTO>();
		RequisicaoMudancaServicoDao requisicaoMudancaServicoDao = new RequisicaoMudancaServicoDao();
		requisicaoMudancaServicoDTOs = (List<RequisicaoMudancaServicoDTO>) requisicaoMudancaServicoDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setListRequisicaoMudancaServicoDTO(requisicaoMudancaServicoDTOs);

		List<SolicitacaoServicoMudancaDTO> solicitacaoServicoMudancaDTOs = new ArrayList<SolicitacaoServicoMudancaDTO>();
		List<SolicitacaoServicoDTO> solicitacaoServicos = new ArrayList<SolicitacaoServicoDTO>();
		SolicitacaoServicoDTO solicitacaoServicoDTO = new SolicitacaoServicoDTO();
		SolicitacaoServicoMudancaDao solicitacaoServicoMudancaDao = new SolicitacaoServicoMudancaDao();
		solicitacaoServicoMudancaDTOs = (List<SolicitacaoServicoMudancaDTO>) solicitacaoServicoMudancaDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		for (SolicitacaoServicoMudancaDTO solicitacaoServicoMudancaDTO : solicitacaoServicoMudancaDTOs) {
			solicitacaoServicoDTO.setIdRequisicaoMudanca(solicitacaoServicoMudancaDTO.getIdRequisicaoMudanca());
			solicitacaoServicoDTO.setIdSolicitacaoServico(solicitacaoServicoMudancaDTO.getIdSolicitacaoServico());
			solicitacaoServicos.add(solicitacaoServicoDTO);
			solicitacaoServicoDTO = new SolicitacaoServicoDTO();
		}
		requisicaoMudancaDTOAux.setListIdSolicitacaoServico(solicitacaoServicos);

		List<RequisicaoMudancaResponsavelDTO> respMudancaDTOs = new ArrayList<RequisicaoMudancaResponsavelDTO>();
		RequisicaoMudancaResponsavelDao respMudancaDao = new RequisicaoMudancaResponsavelDao();
		respMudancaDTOs = (List<RequisicaoMudancaResponsavelDTO>) respMudancaDao.listByIdHistoricoMudanca(historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setColResponsaveis(respMudancaDTOs);

		// esse bloco preenche os anexos do historico
		Collection<UploadDTO> listuploadDTO = new ArrayList<UploadDTO>();
		ControleGEDDao controleGEDDao = new ControleGEDDao();
		listuploadDTO = controleGEDDao.listByIdTabelaAndIdHistorico(ControleGEDDTO.TABELA_REQUISICAOLIBERACAO, historicoMudancaDTO.getIdHistoricoMudanca());
		requisicaoMudancaDTOAux.setColArquivosUpload(listuploadDTO);

		UsuarioDTO usr = new UsuarioDTO();
		usr.setIdUsuario(historicoMudancaDTO.getIdProprietario());
		requisicaoMudancaDTOAux.setUsuarioDto(usr);
		requisicaoMudancaService.update(requisicaoMudancaDTOAux, document, request);

		document.setBean(requisicaoMudancaDTOAux);

		document.executeScript("uploadAnexos.refresh()");

		String comando = "mostraMensagemRestaurarBaseline('" + UtilI18N.internacionaliza(request, "MSG15") + ".<br>" + UtilI18N.internacionaliza(request, "requisicaoLiberacao.requisicaoLiberacao") + " <b><u>"
				+ requisicaoMudancaDTO.getIdRequisicaoMudanca() + "</u></b> " + UtilI18N.internacionaliza(request, "citcorpore.comum.restaurada") + ".<br><br>" + "Verso: "
				+ UtilStrings.nullToVazio(requisicaoMudancaDTOAux.getIdRequisicaoMudanca().toString()) + "<br>";
		comando = comando + "')";

		document.executeScript(comando);

	}

	public void limpar(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		request.getSession(true).setAttribute("colUploadRequisicaoLiberacaoGED", null);
		request.getSession(true).setAttribute("colUploadsGEDdocsLegais", null);
		request.getSession(true).setAttribute("colUploadGeraisGED", null);

	}

	public void restaurarMidiaSoftware(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		String idMidia = request.getParameter("midia#idMidiaSoftware");
		MidiaSoftwareDTO midiaSoftwareDTO = new MidiaSoftwareDTO();
		HTMLTable tblMidia = document.getTableById("tblMidia");

		if (idMidia != null && idMidia.length() > 0) {
			midiaSoftwareDTO.setIdMidiaSoftware(new Integer(idMidia));

			MidiaSoftwareService midiaService = (MidiaSoftwareService) ServiceLocator.getInstance().getService(MidiaSoftwareService.class, WebUtil.getUsuarioSistema(request));
			midiaSoftwareDTO = (MidiaSoftwareDTO) midiaService.restore(midiaSoftwareDTO);
			if (midiaSoftwareDTO.getSequenciaLiberacao() == null) {
				tblMidia.addRow(midiaSoftwareDTO, new String[] { "", "idMidiaSoftware", "nome", "" }, new String[] { "idMidiaSoftware" }, "Liberao j cadastrado!", new String[] { "exibeIconesMidia" }, null, null);
			} else {
				tblMidia.updateRow(midiaSoftwareDTO, new String[] { "", "idMidiaSoftware", "nome", "" }, new String[] { "idMidiaSoftware" }, "Liberao j cadastrado!", new String[] { "exibeIconesMidia" }, null, null,
						midiaSoftwareDTO.getSequenciaLiberacao());
			}
			document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblMidia', 'tblMidia');");
			document.executeScript("fecharMidia();");
		}
		requisicaoLiberacaoDTO = null;
	}

	/**
	 * Restaura o EmpregadoDTO com o Nome cargo a partir do ID Empregado
	 * informado.
	 *
	 * @param idEmpregado
	 * @return Adiciona Responsvel a tabela de tblResponsavel
	 * @author maycon.fernandes 31/10/2013 18:47
	 */
	public void restaurarResponsavel(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		String idResponsavel = request.getParameter("responsavel#idResponsavel");
		String papelResponsavel = request.getParameter("responsavel#papelResponsavel");

		EmpregadoDTO empregadoDTO = new EmpregadoDTO();
		HTMLTable tblResponsavel = document.getTableById("tblResponsavel");

		RequisicaoLiberacaoResponsavelDTO requisicaoLiberacaoResponsavelDTO = new RequisicaoLiberacaoResponsavelDTO();

		if (idResponsavel != null && idResponsavel.length() > 0) {
			empregadoDTO.setIdEmpregado(new Integer(idResponsavel));
			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
			try {
				empregadoDTO = empregadoService.restoreEmpregadoAndNomeCargoByIdEmpegado(empregadoDTO.getIdEmpregado());
				requisicaoLiberacaoResponsavelDTO.setNomeResponsavel(empregadoDTO.getNome());

				requisicaoLiberacaoResponsavelDTO.setIdResponsavel(empregadoDTO.getIdEmpregado());

				if (papelResponsavel != null && papelResponsavel.length() > 0) {
					requisicaoLiberacaoResponsavelDTO.setPapelResponsavel(papelResponsavel);
				} else {
					requisicaoLiberacaoResponsavelDTO.setPapelResponsavel("");
				}

				requisicaoLiberacaoResponsavelDTO.setTelResponsavel(empregadoDTO.getTelefone());
				requisicaoLiberacaoResponsavelDTO.setEmailResponsavel(empregadoDTO.getEmail());
				requisicaoLiberacaoResponsavelDTO.setNomeCargo(empregadoDTO.getNomeCargo());

				if (requisicaoLiberacaoResponsavelDTO.getSequenciaEmpregado() == null) {
					tblResponsavel.addRow(requisicaoLiberacaoResponsavelDTO, new String[] { "", "idResponsavel", "nomeResponsavel", "nomeCargo", "telResponsavel", "emailResponsavel", "papelResponsavel" }, new String[] { "idResponsavel" },
							"Responsavel j cadastrado!", new String[] { "exibeIconesResponsavel" }, null, null);
				} else {
					tblResponsavel.updateRow(requisicaoLiberacaoResponsavelDTO, new String[] { "", "idResponsavel", "nomeResponsavel", "nomeCargo", "telResponsavel", "emailResponsavel", "papelResponsavel" },
							new String[] { "idResponsavel" }, "Responsavel j cadastrado!", new String[] { "exibeIconesResponsavel" }, null, null,
							requisicaoLiberacaoResponsavelDTO.getSequenciaEmpregado());
				}
				document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblResponsavel', 'tblResponsavel');");
				document.executeScript("fecharResponsavel();");
			} catch (IndexOutOfBoundsException e) {
				/*
				 * @autor edu.braz 07/04/2014 tratamento relacionado a
				 * colaboradores importados pelo ldap que no possui cargo e
				 * deve ser atribuido um cargo a eles
				 */
				document.executeScript("alert(i18n_message('requisicaoLiberacao.cargo'));");
			}
		}
		requisicaoLiberacaoDTO = null;
	}

	private void carregaInformacoesComplementares(DocumentHTML document, HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws Exception {
		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		TemplateSolicitacaoServicoService templateService = (TemplateSolicitacaoServicoService) ServiceLocator.getInstance().getService(TemplateSolicitacaoServicoService.class, br.com.centralit.citcorpore.util.WebUtil.getUsuarioSistema(request));
		document.executeScript("exibirInformacoesComplementares('" + requisicaoLiberacaoService.getUrlInformacoesComplementares(requisicaoLiberacaoDTO) + "');");
		TemplateSolicitacaoServicoDTO templateDto = templateService.recuperaTemplateRequisicaoLiberacao(requisicaoLiberacaoDTO);

		if (templateDto != null) {
			if (templateDto.getAlturaDiv() != null) {
				document.executeScript("document.getElementById('divInformacoesComplementares').style.height = '" + templateDto.getAlturaDiv().intValue() + "px';");
			}
		}
		document.executeScript("escondeJanelaAguarde()");
	}

	public void carregaQuestionario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		TemplateSolicitacaoServicoService templateService = (TemplateSolicitacaoServicoService) ServiceLocator.getInstance().getService(TemplateSolicitacaoServicoService.class, br.com.centralit.citcorpore.util.WebUtil.getUsuarioSistema(request));
		document.executeScript("exibirInformacoesComplementares('" + requisicaoLiberacaoService.getUrlInformacoesQuestionario(requisicaoLiberacaoDTO) + "');");
		TemplateSolicitacaoServicoDTO templateDto = templateService.recuperaTemplateRequisicaoLiberacao(requisicaoLiberacaoDTO);

		if (templateDto != null) {
			if (templateDto.getAlturaDiv() != null) {
				document.executeScript("document.getElementById('divInformacoesComplementares').style.height = '" + templateDto.getAlturaDiv().intValue() + "px';");
			}

		}
		document.executeScript("escondeJanelaAguarde()");
		document.executeScript("Modal.open('modal-requisicao-liberacao-checklist', removeModalOverflowClass);");
	}

	// Inicio Compras

	public void addDadosItemProdutos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String idItemProduto = request.getParameter("idItemRequisicaProduto");
		RequisicaoLiberacaoRequisicaoComprasDTO requisicaoLiberacaoRequisicaoComprasDTO = this.carregaItemrRequisicaoProdutoByidItemrRequisicaoProduto(document, request, new Integer(idItemProduto));
		this.addItensTabelaRequisicaoProduto(document, request, requisicaoLiberacaoRequisicaoComprasDTO);
	}

	public RequisicaoLiberacaoRequisicaoComprasDTO carregaItemrRequisicaoProdutoByidItemrRequisicaoProduto(DocumentHTML document, HttpServletRequest request, Integer idItemrRequisicaoProduto) {
		RequisicaoLiberacaoRequisicaoComprasDTO requisicaoLiberacaoRequisicaoComprasDTO = null;
		try {
			RequisicaoLiberacaoRequisicaoComprasService requisicaoLiberacaoRequisicaoComprasService = (RequisicaoLiberacaoRequisicaoComprasService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoRequisicaoComprasService.class, WebUtil.getUsuarioSistema(request));
			requisicaoLiberacaoRequisicaoComprasDTO = requisicaoLiberacaoRequisicaoComprasService.carregaItemRequisicaoComprasByidItemRequisicaProduto(idItemrRequisicaoProduto);
		} catch (br.com.citframework.excecao.ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return requisicaoLiberacaoRequisicaoComprasDTO;
	}

	public void addItensTabelaRequisicaoProduto(DocumentHTML document, HttpServletRequest request, RequisicaoLiberacaoRequisicaoComprasDTO requisicaoLiberacaoRequisicaoComprasDTO) throws Exception {
		HTMLTable tblRequisicaoCompra = document.getTableById("tblRequisicaoCompra");
		tblRequisicaoCompra.addRow(requisicaoLiberacaoRequisicaoComprasDTO, new String[] { "", "idSolicitacaoServico", "descricaoItem", "nomeProjeto", "codigoCentroResultado", "nomeCentroResultado", "situacaoItemRequisicao", }, new String[] { "idItemRequisicaoProduto" }, UtilI18N.internacionaliza(request, "citcorpore.comum.itemSelecionado"), new String[] { "gerarImgDelRequisicaoCompras" }, null, null);
		document.executeScript("$('#POPUP_REQUISICAOCOMPRAS').dialog('close')");
	}

	public void RestauraItensTabelaRequisicaoProdutoByIdLiberacao(DocumentHTML document, HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO,
			String[] arFuncoesExTblRequisicaoCompra) throws Exception {
		HTMLTable tblRequisicaoCompra = document.getTableById("tblRequisicaoCompra");
		tblRequisicaoCompra.deleteAllRows();
		RequisicaoLiberacaoRequisicaoComprasService liberacaoPedidoComprasService = (RequisicaoLiberacaoRequisicaoComprasService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoRequisicaoComprasService.class, WebUtil.getUsuarioSistema(request));
		Collection<RequisicaoLiberacaoRequisicaoComprasDTO> requisicaoCompras = liberacaoPedidoComprasService.findByIdLiberacaoAndDataFim(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		tblRequisicaoCompra.addRowsByCollection(requisicaoCompras, new String[] { "", "idSolicitacaoServico", "descricaoItem", "nomeProjeto", "codigoCentroResultado", "nomeCentroResultado", "situacaoItemRequisicao" }, null, "", arFuncoesExTblRequisicaoCompra, null, null);
	}

	/**
	 * Adiciona automaticamente o(s) Item(s) de configurao relacionados h uma
	 * mudana que esta sendo relacionado a esta liberao
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws br.com.citframework.excecao.ServiceException
	 * @throws Exception
	 */
	public void relacionaICMudanca(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws br.com.citframework.excecao.ServiceException, Exception {

		RequisicaoLiberacaoDTO liberacaoDto = (RequisicaoLiberacaoDTO) document.getBean();
		RequisicaoMudancaItemConfiguracaoService mudancaICService = (RequisicaoMudancaItemConfiguracaoService) ServiceLocator.getInstance().getService(RequisicaoMudancaItemConfiguracaoService.class, null);
		ItemConfiguracaoDTO icDto = new ItemConfiguracaoDTO();
		ItemConfiguracaoService icService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

		Collection<RequisicaoMudancaItemConfiguracaoDTO> mudancaICs = mudancaICService.listByIdRequisicaoMudanca(liberacaoDto.getIdICMudanca());

		if (mudancaICs != null) {
			for (RequisicaoMudancaItemConfiguracaoDTO m : mudancaICs) {

				RequisicaoLiberacaoItemConfiguracaoDTO requisicaoLiberacaoICDTO = new RequisicaoLiberacaoItemConfiguracaoDTO();

				icDto.setIdItemConfiguracao(m.getIdItemConfiguracao());
				icDto = (ItemConfiguracaoDTO) icService.restore(icDto);
				if (icDto != null) {
					StatusIC status = StatusIC.getStatus(icDto.getStatus() == null ? 1 : icDto.getStatus());
					String nomeStatus = status.getDescricao();
					requisicaoLiberacaoICDTO.setIdItemConfiguracao(icDto.getIdItemConfiguracao());
					requisicaoLiberacaoICDTO.setNomeStatusIc(nomeStatus);
					requisicaoLiberacaoICDTO.setNomeItemConfiguracao(icDto.getIdentificacao());
					HTMLTable tblic = document.getTableById("tblICs");

					tblic.addRow(requisicaoLiberacaoICDTO, new String[] { "", "idItemConfiguracao", "nomeItemConfiguracao", "nomeStatusIc" }, new String[] { "idItemConfiguracao" }, UtilI18N.internacionaliza(request, "requisicaoLiberacao.icMudancaJaAdicionado"), new String[] { "gerarImgDelIc" }, null, null);
				}
			}
			document.alert(UtilI18N.internacionaliza(request, "requisicaoLiberacao.icMudancaAdicionado"));
		}
	}

	/**
	 * Verifica se um requisio de compra foi adicionado na tabela. se sim, nao
	 * deixa avanar o fluxo apenas gravar a tarefa atual.
	 *
	 * @param colRequisicaoCompras
	 * @param idRequisicao
	 * @return
	 * @throws br.com.citframework.excecao.ServiceException
	 * @throws Exception
	 */
	public boolean verificaTabelaCompra(Collection<RequisicaoLiberacaoRequisicaoComprasDTO> colRequisicaoCompras, Integer idRequisicao) throws br.com.citframework.excecao.ServiceException, Exception {
		Collection<RequisicaoLiberacaoRequisicaoComprasDTO> listAux = new ArrayList<RequisicaoLiberacaoRequisicaoComprasDTO>();
		boolean isOk = false;

		RequisicaoLiberacaoRequisicaoComprasService service = (RequisicaoLiberacaoRequisicaoComprasService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoRequisicaoComprasService.class, null);
		listAux = service.findByIdLiberacaoAndDataFim(idRequisicao);
		if (listAux != null) {
			if (colRequisicaoCompras.size() > listAux.size()) {
				isOk = true;
			}

		}
		return isOk;
	}

	public void tabelaMudancaSituacaoLiberacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect comboSituacaoLiberacao = document.getSelectById("idFechamentoCategoria");
		comboSituacaoLiberacao.removeAllOptions();
		comboSituacaoLiberacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (ReleaseRequestStatus sit : ReleaseRequestStatus.values()) {
			comboSituacaoLiberacao.addOption(sit.getId().toString(), UtilI18N.internacionaliza(request, sit.getI18NKey()));
		}
	}

	public void addICs(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		ItemConfiguracaoDTO icDto = new ItemConfiguracaoDTO();
		ItemConfiguracaoService icService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

		RequisicaoLiberacaoItemConfiguracaoService requisicaoLiberacaoItemConfiguracaoService = (RequisicaoLiberacaoItemConfiguracaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoItemConfiguracaoService.class, null);
		RequisicaoLiberacaoItemConfiguracaoDTO requisicaoLiberacaoICDTO = new RequisicaoLiberacaoItemConfiguracaoDTO();
		if (requisicaoLiberacaoDTO != null) {

			icDto.setIdItemConfiguracao(requisicaoLiberacaoDTO.getIdItemConfig());
			if (icDto.getIdItemConfiguracao() != null) {
				icDto = (ItemConfiguracaoDTO) icService.restore(icDto);

				StatusIC status = StatusIC.getStatus(icDto.getStatus());
				if (status != null) {
					String nomeStatus = status.getDescricao();
					requisicaoLiberacaoICDTO.setNomeStatusIc(nomeStatus);
				}
				requisicaoLiberacaoICDTO.setIdItemConfiguracao(requisicaoLiberacaoDTO.getIdItemConfig());
				requisicaoLiberacaoICDTO.setNomeItemConfiguracao(icDto.getIdentificacao());
			}
			HTMLTable tblic = document.getTableById("tblICs");

			tblic.addRow(requisicaoLiberacaoICDTO, new String[] { "", "idItemConfiguracao", "nomeItemConfiguracao", "nomeStatusIc", "" }, new String[] { "idItemConfiguracao" }, UtilI18N.internacionaliza(request, "citcorpore.comum.itemSelecionado"), new String[] { "gerarImgDelIc", "exibeIconesIC" }, null, null);

			document.executeScript("Modal.close('modal-requisicao-liberacao-add-ic');");

		}

	}

	public void restoreTableIcs(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, String[] arFuncoesExTblIcs) throws Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();

		ItemConfiguracaoDTO icDto = new ItemConfiguracaoDTO();
		ItemConfiguracaoService icService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

		RequisicaoLiberacaoItemConfiguracaoService requisicaoLiberacaoItemConfiguracaoService = (RequisicaoLiberacaoItemConfiguracaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoItemConfiguracaoService.class, null);
		RequisicaoLiberacaoItemConfiguracaoDTO requisicaoLiberacaoICDTO = new RequisicaoLiberacaoItemConfiguracaoDTO();
		if (requisicaoLiberacaoDTO != null) {
			requisicaoLiberacaoICDTO.setIdRequisicaoLiberacao(requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
			Collection<RequisicaoLiberacaoItemConfiguracaoDTO> col = requisicaoLiberacaoItemConfiguracaoService.findByIdRequisicaoLiberacao(requisicaoLiberacaoICDTO.getIdRequisicaoLiberacao());
			if (col != null) {
				for (RequisicaoLiberacaoItemConfiguracaoDTO obj : col) {

					icDto.setIdItemConfiguracao(obj.getIdItemConfiguracao());
					icDto = (ItemConfiguracaoDTO) icService.restore(icDto);

					if (icDto.getStatus() != null) {
						StatusIC status = StatusIC.getStatus(icDto.getStatus());
						String nomeStatus = status.getDescricao();
						obj.setNomeStatusIc(nomeStatus);
					}
					obj.setNomeItemConfiguracao(icDto.getIdentificacao());
					HTMLTable tblic = document.getTableById("tblICs");
					tblic.deleteAllRows();

					tblic.addRowsByCollection(col, new String[] { "", "idItemConfiguracao", "nomeItemConfiguracao", "nomeStatusIc", "" }, null, "", arFuncoesExTblIcs, null, null);

				}
			}
		}
	}

	private void preencherComboSituacao(DocumentHTML document, HttpServletRequest request, RequisicaoLiberacaoDTO requisicaoLiberacaoDTO) throws Exception {

		UsuarioDTO usuarioDto = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

		HTMLSelect comboStatus = document.getSelectById("idStatus");
		comboStatus.removeAllOptions();
		comboStatus.addOption(ReleaseRequestStatus.IN_EXECUTION.getId().toString(), UtilI18N.internacionaliza(request, ReleaseRequestStatus.IN_EXECUTION.getI18NKey()));
		comboStatus.addOption(ReleaseRequestStatus.SOLVED.getId().toString(), UtilI18N.internacionaliza(request, ReleaseRequestStatus.SOLVED.getI18NKey()));
		comboStatus.addOption(ReleaseRequestStatus.UNSOLVED.getId().toString(), UtilI18N.internacionaliza(request, ReleaseRequestStatus.UNSOLVED.getI18NKey()));

		if (requisicaoLiberacaoDTO != null) {
			GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
			Collection<GrupoDTO> lstGrupos = grupoService.getGruposByEmpregado(usuarioDto.getIdEmpregado());

			if (lstGrupos != null) {
				for (GrupoDTO g : lstGrupos) {
					if (this.getRequisicaoLiberacaoService(request).verificaPermissaoGrupoCancelar(requisicaoLiberacaoDTO.getIdTipoLiberacao(), g.getIdGrupo())) {
						comboStatus.addOption(ReleaseRequestStatus.CANCELED.getId().toString(), UtilI18N.internacionaliza(request, ReleaseRequestStatus.CANCELED.getI18NKey()));
						break;
					}
				}
			}
		}
	}

	public void preencherComboCategoriaSolucao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		CategoriaSolucaoService categoriaSolucaoService = (CategoriaSolucaoService) ServiceLocator.getInstance().getService(CategoriaSolucaoService.class, null);
		Collection colCategSolucao = categoriaSolucaoService.listHierarquia();
		HTMLSelect idCategoriaSolucao = document.getSelectById("idCategoriaSolucao");
		idCategoriaSolucao.removeAllOptions();
		idCategoriaSolucao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (colCategSolucao != null) {
			idCategoriaSolucao.addOptions(colCategSolucao, "idCategoriaSolucao", "descricaoCategoriaNivel", null);
		}
	}

	public static Boolean salvaGrupoAtvPeriodicaEAgenda(RequisicaoLiberacaoDTO requisicaoLiberacaoDto) throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(requestGlobal);
		if (usuario == null) {
			documentGlobal.alert(UtilI18N.internacionaliza(requestGlobal, "citcorpore.comum.sessaoExpirada"));
			documentGlobal.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + requestGlobal.getContextPath() + "'");
			return false;
		}

		AtividadePeriodicaDTO atividadePeriodicaDTO = new AtividadePeriodicaDTO();
		atividadePeriodicaDTO.setIdRequisicaoLiberacao(requisicaoLiberacaoDto.getIdRequisicaoLiberacao());

		atividadePeriodicaDTO.setDuracaoEstimada((int) calculaDuracaoEstimada(requisicaoLiberacaoDto));
		atividadePeriodicaDTO.setIdGrupoAtvPeriodica(requisicaoLiberacaoDto.getIdGrupoAtvPeriodica());
		atividadePeriodicaDTO.setDataInicio(transformaDataStringEmDate(requisicaoLiberacaoDto.getDataInicioStr()));
		atividadePeriodicaDTO.setHoraInicio(requisicaoLiberacaoDto.getHoraAgendamentoInicial());

		if (atividadePeriodicaDTO.getDuracaoEstimada() == null || atividadePeriodicaDTO.getDuracaoEstimada().intValue() == 0) {
			return false;
		} else if (requisicaoLiberacaoDto.getIdGrupoAtvPeriodica() == null) {
			return false;
		}
		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(requestGlobal));
		GrupoAtvPeriodicaService grupoAtvPeriodicaService = (GrupoAtvPeriodicaService) ServiceLocator.getInstance().getService(GrupoAtvPeriodicaService.class, null);

		String orient = "";
		String ocorr = "";
		if (!ocorr.equalsIgnoreCase("")) {
			ocorr += "\n";
		}
		ocorr += UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.dataagendamento") + " " + UtilDatas.dateToSTR(atividadePeriodicaDTO.getDataInicio());
		if (!ocorr.equalsIgnoreCase("")) {
			ocorr += "\n";
		}
		ocorr += UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.horaagendamento") + " " + atividadePeriodicaDTO.getHoraInicio();
		if (!ocorr.equalsIgnoreCase("")) {
			ocorr += "\n";
		}
		ocorr += UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.duracaoestimada") + " " + atividadePeriodicaDTO.getDuracaoEstimada();
		GrupoAtvPeriodicaDTO grupoAtvPeriodicaDTO = new GrupoAtvPeriodicaDTO();
		grupoAtvPeriodicaDTO.setIdGrupoAtvPeriodica(atividadePeriodicaDTO.getIdGrupoAtvPeriodica());
		grupoAtvPeriodicaDTO = (GrupoAtvPeriodicaDTO) grupoAtvPeriodicaService.restore(grupoAtvPeriodicaDTO);
		if (grupoAtvPeriodicaDTO != null) {
			ocorr += "\n" + UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.grupo") + ": " + grupoAtvPeriodicaDTO.getNomeGrupoAtvPeriodica();
		}
		if (atividadePeriodicaDTO.getOrientacaoTecnica() != null) {
			orient = atividadePeriodicaDTO.getOrientacaoTecnica();
			ocorr += "\n" + UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.orientacaotecnica") + ": \n" + atividadePeriodicaDTO.getOrientacaoTecnica();
		}
		orient += "\n\n" + UtilI18N.internacionaliza(requestGlobal, "requisicaoLiberacao.requisicaoLiberacao") + ": \n" + requisicaoLiberacaoDto.getDescricao();

		atividadePeriodicaDTO.setTituloAtividade(UtilI18N.internacionaliza(requestGlobal, "gerenciaservico.agendaratividade.solicitacaoliberacao") + " " + atividadePeriodicaDTO.getIdRequisicaoLiberacao());
		atividadePeriodicaDTO.setDescricao(requisicaoLiberacaoDto.getDescricao());
		atividadePeriodicaDTO.setDataCriacao(UtilDatas.getDataAtual());
		atividadePeriodicaDTO.setCriadoPor(usuario.getNomeUsuario());
		atividadePeriodicaDTO.setIdContrato(requisicaoLiberacaoDto.getIdContrato());
		atividadePeriodicaDTO.setOrientacaoTecnica(orient);

		Collection colItens = new ArrayList();
		ProgramacaoAtividadeDTO programacaoAtividadeDTO = new ProgramacaoAtividadeDTO();
		programacaoAtividadeDTO.setTipoAgendamento(TipoAgendamento.U.getIdentificador().toString());
		programacaoAtividadeDTO.setDataInicio(atividadePeriodicaDTO.getDataInicio());
		programacaoAtividadeDTO.setHoraInicio(atividadePeriodicaDTO.getHoraInicio());
		programacaoAtividadeDTO.setHoraFim("00:00");
		programacaoAtividadeDTO.setDuracaoEstimada(atividadePeriodicaDTO.getDuracaoEstimada());
		programacaoAtividadeDTO.setRepeticao("N");
		colItens.add(programacaoAtividadeDTO);

		AtividadePeriodicaService atividadePeriodicaService = (AtividadePeriodicaService) ServiceLocator.getInstance().getService(AtividadePeriodicaService.class, null);
		atividadePeriodicaDTO.setColItens(colItens);

		// verifica se j no houve agendamento para essa requisio
		Collection<AtividadePeriodicaDTO> listAtividade = atividadePeriodicaService.findByIdRequisicaoLiberacao(requisicaoLiberacaoDto.getIdRequisicaoLiberacao());
		if (listAtividade != null) {
			atividadePeriodicaDTO.setIdAtividadePeriodica(listAtividade.iterator().next().getIdAtividadePeriodica());
			atividadePeriodicaService.update(atividadePeriodicaDTO);
		} else {
			atividadePeriodicaService.create(atividadePeriodicaDTO);
		}

		OcorrenciaSolicitacaoService ocorrenciaSolicitacaoService = (OcorrenciaSolicitacaoService) ServiceLocator.getInstance().getService(OcorrenciaSolicitacaoService.class, null);
		OcorrenciaSolicitacaoDTO ocorrenciaSolicitacaoDTO = new OcorrenciaSolicitacaoDTO();
		ocorrenciaSolicitacaoDTO.setIdSolicitacaoServico(atividadePeriodicaDTO.getIdSolicitacaoServico());
		ocorrenciaSolicitacaoDTO.setDataregistro(UtilDatas.getDataAtual());
		ocorrenciaSolicitacaoDTO.setHoraregistro(UtilDatas.formatHoraFormatadaStr(UtilDatas.getHoraAtual()));
		ocorrenciaSolicitacaoDTO.setTempoGasto(0);
		ocorrenciaSolicitacaoDTO.setDataInicio(UtilDatas.getDataAtual());
		ocorrenciaSolicitacaoDTO.setDataFim(UtilDatas.getDataAtual());
		ocorrenciaSolicitacaoDTO.setInformacoesContato(UtilI18N.internacionaliza(requestGlobal, "MSG13"));
		ocorrenciaSolicitacaoDTO.setRegistradopor(usuario.getNomeUsuario());
		ocorrenciaSolicitacaoDTO.setOcorrencia(ocorr);
		ocorrenciaSolicitacaoDTO.setOrigem(Enumerados.OrigemOcorrencia.OUTROS.getSigla().toString());
		ocorrenciaSolicitacaoDTO.setIdOccurrenceCategory(Enumerados.OccurrenceCategory.ACTIVITY_SCHEDULE.getId());
		ocorrenciaSolicitacaoDTO.setIdItemTrabalho(requisicaoLiberacaoDto.getIdTarefa());
		ocorrenciaSolicitacaoService.create(ocorrenciaSolicitacaoDTO);

		return true;
	}

	public static long calculaDuracaoEstimada(RequisicaoLiberacaoDTO requisicaoLiberacaoDto) {
		long duracao = requisicaoLiberacaoDto.getDataHoraTerminoAgendada().getTime() - requisicaoLiberacaoDto.getDataHoraInicioAgendada().getTime();
		long minutos = duracao / (1000 * 60);
		return minutos;
	}

	public static java.sql.Date transformaDataStringEmDate(String dataSemFormatacao) throws ParseException {
		DateFormat fmt = new SimpleDateFormat("dd/MM/yyyy");
		java.sql.Date data = new java.sql.Date(fmt.parse(dataSemFormatacao).getTime());
		return data;

	}

	public void listarPlanos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		Integer idmudanca = Integer.parseInt(request.getParameter("idMudanca"));
		this.restaurarAnexosPlanoDeReversao(document, request, idmudanca);
	}

	public void gravarAnexosPlanosReversao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {

		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) document.getBean();
		RequisicaoMudancaDTO requisicaoMudancaDto = new RequisicaoMudancaDTO();
		requisicaoMudancaDto.setIdRequisicaoMudanca(requisicaoLiberacaoDTO.getIdMudanca());
		HistoricoMudancaDTO historicoMudancaDTO = new HistoricoMudancaDTO();
		Integer idEmpresa = null;
		RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, WebUtil.getUsuarioSistema(request));
		Collection<UploadDTO> arquivosReversaoUpados = (Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadPlanoDeReversaoLiberacaoGED");
		requisicaoMudancaDto.setColUploadPlanoDeReversaoGED(arquivosReversaoUpados);
		// Rotina para gravar no banco
		if (requisicaoMudancaDto.getColUploadPlanoDeReversaoGED() != null && requisicaoMudancaDto.getColUploadPlanoDeReversaoGED().size() > 0) {
			idEmpresa = WebUtil.getIdEmpresa(request);
			if (idEmpresa == null) {
				idEmpresa = 1;
			}
			/* requisicaoMudancaService.gravaInformacoesGED(requisicaoMudancaDto.getColArquivosUpload(), idEmpresa, requisicaoMudancaDto, null); */
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			// document.executeScript("('#POPUP_menuAnexos').dialog('close');");
		}
		requisicaoMudancaDto.setIdEmpresa(idEmpresa);
		requisicaoMudancaService.gravaPlanoDeReversaoGED(requisicaoMudancaDto, null, historicoMudancaDTO);

	}

	protected void restaurarAnexosPlanoDeReversao(DocumentHTML document, HttpServletRequest request, Integer idRequisicaoMudanca) throws ServiceException, Exception {
		Collection<UploadDTO> colAnexosUploadDTO = null;
		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		Collection colAnexos = controleGedService.listByIdTabelaAndIdLiberacaoAndLigacao(ControleGEDDTO.TABELA_PLANO_REVERSAO_MUDANCA, idRequisicaoMudanca);
		colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);
		request.getSession(true).setAttribute("colUploadPlanoDeReversaoLiberacaoGED", colAnexosUploadDTO);
		document.executeScript("Modal.open('modal-requisicao-liberacao-anexos-plano-reversao');");
	}

	public void imprimirCadastroPdf(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		ImpressaoCadLiberacao impressaoCadLiberacao;
		try {
			impressaoCadLiberacao = new ImpressaoCadLiberacao(document, request);
			impressaoCadLiberacao.gerarRelatorio();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			impressaoCadLiberacao = null;
			try {
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}

	private CategoriaOcorrenciaService getCategoriaOcorrenciaService() throws ServiceException {
		if (categoriaOcorrenciaService == null) {
			categoriaOcorrenciaService = (CategoriaOcorrenciaService) ServiceLocator.getInstance().getService(CategoriaOcorrenciaService.class, null);
		}
		return categoriaOcorrenciaService;
	}

}