package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.reflexao.CitAjaxReflexao;
import br.com.centralit.citcertdigital.CITAssinadorDigital;
import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.ValidacaoCertificadoDigitalDTO;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.bean.ControleGEDExternoDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.citquestionario.ajaxForms.QuestionarioResponser;
import br.com.centralit.citquestionario.bean.ArquivoMultimidiaDTO;
import br.com.centralit.citquestionario.bean.RespostaItemAuxiliarDTO;
import br.com.centralit.citquestionario.bean.RespostaItemQuestionarioAnexosDTO;
import br.com.centralit.citquestionario.util.WebValuesQuestionario;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.UtilTratamentoArquivos;


public class ServicoQuestionario extends QuestionarioResponser {

	@Override
	public Class<ServicoQuestionarioDTO> getBeanClass() {
		return ServicoQuestionarioDTO.class;
	}

	@Override
	@SuppressWarnings("unchecked")
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		request.getSession().setAttribute("HASH_CONTEUDO", null);
		request.getSession().setAttribute("TABELA_ASS_DIGITAL", null);
		request.getSession().setAttribute("KEY_ASS_DIGITAL", null);

		String idServico = request.getParameter("idServico");
		String attrSessao = "dados_servico_questionario_".concat(idServico);
		request.getSession(true).setAttribute(attrSessao, null);

		Integer idEmpresa = 1;

		ServicoQuestionarioDTO servicoQuestionarioDto = (ServicoQuestionarioDTO) document.getBean();

		Collection<RespostaItemAuxiliarDTO> colValoresRequisicao = WebValuesQuestionario.getFormValues(request);

		servicoQuestionarioDto.setColValores(colValoresRequisicao);

		Collection<RespostaItemQuestionarioAnexosDTO> colAnexos = new ArrayList<RespostaItemQuestionarioAnexosDTO>();

		List<ArquivoMultimidiaDTO> listArquivoMultimidia = (List<ArquivoMultimidiaDTO>) request.getSession(true).getAttribute("TEMP_LISTA_ARQ_MULTIMIDIA");
		if (listArquivoMultimidia == null) {
			listArquivoMultimidia = new ArrayList<ArquivoMultimidiaDTO>();
		}

		Collection<ValidacaoCertificadoDigitalDTO> listCertificadoDigital = (Collection<ValidacaoCertificadoDigitalDTO>) request.getSession().getAttribute("TEMP_LISTA_CERTIFICADO_DIGITAL");
		servicoQuestionarioDto.setColCertificados(listCertificadoDigital);

		ControleGEDService controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		for (Iterator<ArquivoMultimidiaDTO> it = listArquivoMultimidia.iterator(); it.hasNext();) {
			ArquivoMultimidiaDTO arquivoMultimidia = it.next();
			ControleGEDDTO controleGEDDTO = new ControleGEDDTO();

			String GED_INTERNO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInterno, "S");
			if (GED_INTERNO == null){
				GED_INTERNO = "S";
			}
			String prontuarioGedInternoBancoDados = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedInternoBD, "N");
		    if(!UtilStrings.isNotVazio(prontuarioGedInternoBancoDados)) {
				prontuarioGedInternoBancoDados = "N";
			}

			String GED_DIRETORIO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedDiretorio,"");
			if (GED_DIRETORIO == null || GED_DIRETORIO.trim().equalsIgnoreCase("")) {
			    GED_DIRETORIO = "";
			}
			if (GED_DIRETORIO.equalsIgnoreCase("")) {
			    GED_DIRETORIO = Constantes.getValue("DIRETORIO_GED");
			}
			if (GED_DIRETORIO == null || GED_DIRETORIO.equalsIgnoreCase("")) {
			    GED_DIRETORIO = "/ged";
			}

			String pasta = "";
			if (GED_INTERNO.equalsIgnoreCase("S")){
				pasta = controleGEDService.getProximaPastaArmazenar();

				File fileDir = new File(GED_DIRETORIO);
				if (!fileDir.exists()){
				    fileDir.mkdirs();
				}
				fileDir = new File(GED_DIRETORIO + "/" + idEmpresa);
				if (!fileDir.exists()){
				    fileDir.mkdirs();
				}
				fileDir = new File(GED_DIRETORIO + "/" + idEmpresa + "/" + pasta);
				if (!fileDir.exists()){
				    fileDir.mkdirs();
				}
			}

			controleGEDDTO.setIdTabela(ControleGEDDTO.TABELA_RESPOSTAITEMQUESTIONARIOANEXOS);
			controleGEDDTO.setId(new Integer(0));
			controleGEDDTO.setDataHora(UtilDatas.getDataAtual());
			controleGEDDTO.setDescricaoArquivo(arquivoMultimidia.getNomeArquivo());
			controleGEDDTO.setExtensaoArquivo(br.com.centralit.citcorpore.util.Util.getFileExtension(arquivoMultimidia.getNomeArquivo()));
			controleGEDDTO.setPasta(pasta);
			controleGEDDTO.setNomeArquivo(arquivoMultimidia.getNomeArquivo());

			if (!arquivoMultimidia.getCaminhoArquivo().startsWith("IDCITGED=")){
				if(GED_INTERNO.equalsIgnoreCase("S") && "S".equalsIgnoreCase(prontuarioGedInternoBancoDados)){
					java.util.Date now = new java.util.Date();
					CriptoUtils.encryptFile(arquivoMultimidia.getCaminhoArquivo(),
							GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/TMP_" + now.getTime() + ".ged",
							this.getClass().getResourceAsStream(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));

					controleGEDDTO.setPathArquivo(GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/TMP_" + now.getTime() + ".ged");
				}
				controleGEDDTO = controleGEDService.create(controleGEDDTO);
				if (GED_INTERNO.equalsIgnoreCase("S") && !"S".equalsIgnoreCase(prontuarioGedInternoBancoDados)){ //Se utiliza GED interno
					if (controleGEDDTO != null){
						CriptoUtils.encryptFile(arquivoMultimidia.getCaminhoArquivo(),
								GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".ged",
								this.getClass().getResourceAsStream(Constantes.getValue("CAMINHO_CHAVE_PUBLICA")));

						if (servicoQuestionarioDto.getColCertificados() != null && servicoQuestionarioDto.getColCertificados().size() > 0) {
							int ordem = 1;
							CITAssinadorDigital d = new CITAssinadorDigital();
							d.inicializar();
							for (Iterator<ValidacaoCertificadoDigitalDTO> itCert = servicoQuestionarioDto.getColCertificados().iterator(); itCert.hasNext();) {
								ValidacaoCertificadoDigitalDTO validacaoCertificadoDigitalDTO = itCert.next();

								InputStream inStream = new FileInputStream(validacaoCertificadoDigitalDTO.getCaminhoCompleto());
								CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
								X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
								d.assinar(validacaoCertificadoDigitalDTO.getInfoCertificadoDigital().getCpf(), arquivoMultimidia.getCaminhoArquivo(), GED_DIRETORIO + "/" + idEmpresa + "/" + pasta + "/" + controleGEDDTO.getIdControleGED() + ".signed" + ordem, cert, false);

								ordem++;
							}
						}
					}
				}else if(!GED_INTERNO.equalsIgnoreCase("S")){ //Se utiliza GED externo
					String CLASSE_GED_EXTERNO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.GedExternoClasse, "");
					Class<?> classe = Class.forName(CLASSE_GED_EXTERNO);
					Object objeto = classe.newInstance();
					Method mtd = CitAjaxReflexao.findMethod("create", objeto);

					ControleGEDExternoDTO controleGedExternoDto = new ControleGEDExternoDTO();
					Reflexao.copyPropertyValues(controleGEDDTO, controleGedExternoDto);

					File file = new File(arquivoMultimidia.getCaminhoArquivo());
					controleGedExternoDto.setConteudoDocumento(UtilTratamentoArquivos.getBytesFromFile(file));

					byte[] conteudoAssinaturaDigital = null;
					if (servicoQuestionarioDto.getColCertificados() != null && servicoQuestionarioDto.getColCertificados().size() > 0) {
						CITAssinadorDigital d = new CITAssinadorDigital();
						d.inicializar();
						for (Iterator<ValidacaoCertificadoDigitalDTO> itCert = servicoQuestionarioDto.getColCertificados().iterator(); itCert.hasNext();) {
							ValidacaoCertificadoDigitalDTO validacaoCertificadoDigitalDTO = itCert.next();

							InputStream inStream = new FileInputStream(validacaoCertificadoDigitalDTO.getCaminhoCompleto());
							CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
							X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
							conteudoAssinaturaDigital = d.assinar(validacaoCertificadoDigitalDTO.getInfoCertificadoDigital().getCpf(), arquivoMultimidia.getCaminhoArquivo(), cert, false);

							break; //Faz so a primeira.
						}
					}

					controleGedExternoDto.setConteudoAssinaturaDigital(conteudoAssinaturaDigital);
					mtd.invoke(objeto, new Object[] { controleGedExternoDto, new HashMap<Object, Object>() });
				}
			}else{
				controleGEDDTO.setIdControleGED(new Integer(UtilStrings.apenasNumeros(arquivoMultimidia.getCaminhoArquivo())));
			}

			RespostaItemQuestionarioAnexosDTO respItemQuestAnexoDto = new RespostaItemQuestionarioAnexosDTO();
			if(controleGEDDTO != null){
				respItemQuestAnexoDto.setCaminhoAnexo(controleGEDDTO.getIdControleGED().toString());
			}
			respItemQuestAnexoDto.setObservacao(arquivoMultimidia.getObservacao());
			respItemQuestAnexoDto.setIdQuestaoQuestionario(arquivoMultimidia.getIdQuestaoQuest());

			colAnexos.add(respItemQuestAnexoDto);
		}

		servicoQuestionarioDto.setColAnexos(colAnexos);

		request.getSession(true).setAttribute(attrSessao, servicoQuestionarioDto);
	}
}
