package br.com.centralit.citcorpore.ajaxForms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.MenuDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsWidgetsDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsWidgetsGroupsDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.MenuService;
import br.com.centralit.citcorpore.negocio.SmartDecisionsService;
import br.com.centralit.citcorpore.negocio.SmartDecisionsWidgetsGroupsService;
import br.com.centralit.citcorpore.negocio.SmartDecisionsWidgetsService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ReportTypes;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.SmartDecisionsPanels;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citgerencial.bean.SmartReportParameterDTO;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilSmartReport;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.Widget;

public class SmartDecisions extends AjaxFormAction {

	private SmartDecisionsService smartDecisionsService;
	private SmartDecisionsWidgetsService smartDecisionsWidgetsService;
	private SmartReportService smartReportService;
	private MenuService menuService;
	private EvmConexaoService evmConexaoService;
	private SmartDecisionsWidgetsGroupsService smartDecisionsWidgetsGroupsService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private ContratoService contratoService;

	@Override
	public Class<SmartDecisionsDTO> getBeanClass() {
		return SmartDecisionsDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		loadUserConfig(document, request);
	}

	private void loadUserConfig(DocumentHTML document, HttpServletRequest request) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		if (Constantes.SERVER_ADDRESS == null || Constantes.SERVER_ADDRESS.equalsIgnoreCase("")) {
			String url = request.getRequestURL().toString();
			int index = url.indexOf(CITCorporeUtil.CONTEXTO_APLICACAO);
			if (index > -1) {
				url = url.substring(0, index);
				Constantes.SERVER_ADDRESS = url;
			}
		}

		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		JSONObject joWidget = new JSONObject();

		for (SmartDecisionsPanels smartDecisionsPanel : SmartDecisionsPanels.values()) {
			Collection<SmartDecisionsWidgetsDTO> colSmartDecisionsWidgetsDTO = this.getSmartDecisionsWidgetsService().findByIdUsuarioAndIdPanel(usuarioDTO.getIdUsuario(), smartDecisionsPanel.getId());
			if (colSmartDecisionsWidgetsDTO != null && !colSmartDecisionsWidgetsDTO.isEmpty()) {
				for (SmartDecisionsWidgetsDTO smartDecisionsWidgetsDTO : colSmartDecisionsWidgetsDTO) {
					joWidget.put(smartDecisionsPanel.getName(), smartDecisionsWidgetsDTO.getModel());
				}
			} else {
				if (smartDecisionsPanel.equals(SmartDecisionsPanels.FAST_ACCESS)) {
					Map<String, StringBuilder> map = new HashMap<String, StringBuilder>();

					ArrayList<MenuDTO> listaMenusPai = (ArrayList<MenuDTO>) getMenuService().listarMenusPorPerfil(usuarioDTO, null, false);

					if (listaMenusPai != null && !listaMenusPai.isEmpty()) {
						for (MenuDTO menu : listaMenusPai) {
							ArrayList<MenuDTO> listaSubMenus = (ArrayList<MenuDTO>) getMenuService().listarMenusPorPerfil(usuarioDTO, menu.getIdMenu(), true);
							if (listaSubMenus != null && !listaSubMenus.isEmpty()) {
								StringBuilder sub = new StringBuilder();

								for (MenuDTO submenu : listaSubMenus) {
									buildLink(request, sub, usuarioDTO, submenu);
								}

								if (sub.length() > 0) {
									map.put(menu.getNome(), sub);
								}
							}
						}
					}

					if (map != null && !map.isEmpty()) {
						StringBuilder sb = new StringBuilder();

						sb.append("{");
						sb.append("	\"title\": \"" + UtilI18N.internacionaliza(request, "citcorpore.comum.acessoRapido") + "\",");
						sb.append("	\"structure\": \"6-6\",");
						sb.append("	\"rows\": [{");
						sb.append("		\"columns\": [");

						for (String key : map.keySet()) {
							if (sb.toString().endsWith("}")) {
								sb.append(",");
							}
							sb.append("{");
							sb.append("	\"styleClass\": \"col-md-6\",");
							sb.append("	\"widgets\": [{");
							sb.append("		\"type\": \"linklist\",");
							sb.append("		\"config\": {");
							sb.append("			\"links\": [");

							sb.append(map.get(key));

							sb.append("			]");
							sb.append("		},");
							sb.append("		\"title\": \"" + UtilI18N.internacionaliza(request, key) + "\"");
							sb.append("	}]");
							sb.append("}");
						}

						sb.append("		]");
						sb.append("	}]");
						sb.append("}");

						joWidget.put(smartDecisionsPanel.getName(), sb.toString());
					}
				}
			}
		}

		document.executeScript("Dashboard.loadConfig(".concat(joWidget.toString()).concat(");"));
	}

	private void buildLink(HttpServletRequest request, StringBuilder sub, UsuarioDTO usuarioDTO, MenuDTO menuDTO) throws Exception {
		if (menuDTO.getLink() != null && !menuDTO.getLink().equals("")) {
			if (sub.toString().endsWith("}")) {
				sub.append(",");
			}

			sub.append("{");
			sub.append("	\"title\": \"" + UtilI18N.internacionaliza(request, menuDTO.getNome()) + "\",");
			sub.append("	\"href\": \"" + (menuDTO.getLink() == null || menuDTO.getLink().isEmpty() ? "javascript:;" : Constantes.SERVER_ADDRESS + Configuracoes.getCaminhoComContexto("/pages" + menuDTO.getLink())) + "\"");
			sub.append("}");
		}

		ArrayList<MenuDTO> listaSubMenus = (ArrayList<MenuDTO>) getMenuService().listarMenusPorPerfil(usuarioDTO, menuDTO.getIdMenu(), true);
		if (listaSubMenus != null && !listaSubMenus.isEmpty()) {
			for (MenuDTO menuDTO2 : listaSubMenus) {
				buildLink(request, sub, usuarioDTO, menuDTO2);
			}
		}
	}

	public void saveUserConfigByPanel(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();

		Collection<SmartDecisionsWidgetsDTO> colSmartDecisionsWidgetsDTO = this.getSmartDecisionsWidgetsService().findByIdUsuarioAndIdPanel(usuario.getIdUsuario(), SmartDecisionsPanels.fromName(smartDecisionsDTO.getPanel()).getId());

		if (colSmartDecisionsWidgetsDTO != null && !colSmartDecisionsWidgetsDTO.isEmpty()) {
			for (SmartDecisionsWidgetsDTO smartDecisionsWidgetsDTO : colSmartDecisionsWidgetsDTO) {
				smartDecisionsWidgetsDTO.setModel(smartDecisionsDTO.getModel());
				getSmartDecisionsWidgetsService().updateNotNull(smartDecisionsWidgetsDTO);
			}
		} else {
			SmartDecisionsWidgetsDTO smartDecisionsWidgetsDTO = new SmartDecisionsWidgetsDTO();
			smartDecisionsWidgetsDTO.setModel(smartDecisionsDTO.getModel());
			smartDecisionsWidgetsDTO.setIdPanel(SmartDecisionsPanels.fromName(smartDecisionsDTO.getPanel()).getId());
			smartDecisionsWidgetsDTO.setIdUsuario(usuario.getIdUsuario());
			smartDecisionsWidgetsDTO.setDataInicio(UtilDatas.getDataAtual());

			getSmartDecisionsWidgetsService().create(smartDecisionsWidgetsDTO);
		}
	}

	public void loadWidgets(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		List<SmartReportDTO> smartReports = getSmartReportService().findAvailablesByUsuario(usuarioDTO);

		JSONArray jaWidgets = new JSONArray();
		for (SmartReportDTO smartReportDTO : smartReports) {
			Widget widget = new Widget();

			widget.setIdSmartReport(smartReportDTO.getIdSmartReport());
			widget.setTitle(smartReportDTO.getIdentificacao());
			widget.setDescription(smartReportDTO.getDescricao());
			widget.setHasFilter(UtilStrings.isNotVazio(smartReportDTO.getParametros()));

			if (smartReportDTO.getTipoRelatorio() != null) {
				widget.setImage(ReportTypes.imageFromId(smartReportDTO.getTipoRelatorio()));
			} else {
				widget.setImage(CITCorporeUtil.CONTEXTO_APLICACAO + "/imagens/smart-decisions/Braces-01-128.png");
			}

			jaWidgets.put(new JSONObject(widget));
		}
		document.executeScript("$('#formController #widgetsSmartReport').attr('value', '".concat(jaWidgets.toString()).concat("');"));

		List<SmartDecisionsWidgetsGroupsDTO> listSmartDecisionsWidgetsGroupsDTO = getSmartDecisionsWidgetsGroupsService().findAvailablesByUsuario(usuarioDTO);

		JSONArray widgetsSmartDecisions = new JSONArray();
		if (listSmartDecisionsWidgetsGroupsDTO != null && !listSmartDecisionsWidgetsGroupsDTO.isEmpty()) {
			for (SmartDecisionsWidgetsGroupsDTO smartDecisionsWidgetsGroupsDTO : listSmartDecisionsWidgetsGroupsDTO) {
				widgetsSmartDecisions.put(smartDecisionsWidgetsGroupsDTO.getIdWidget());
			}
		}

		document.executeScript("$('#formController #widgetsSmartDecisions').attr('value', '".concat(widgetsSmartDecisions.toString()).concat("');"));
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void loadReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();

		SmartReportDTO smartReportDTO = new SmartReportDTO();
		smartReportDTO.setIdSmartReport(smartDecisionsDTO.getIdSmartReport());
		smartReportDTO = getSmartReportService().restore(smartReportDTO);

		if (smartReportDTO != null) {
			Boolean isExibirParametroIdEspecifico = false;

			try {
				isExibirParametroIdEspecifico = SimNao.SIM.name().equalsIgnoreCase(request.getParameter("exibirParametroIdEspecifico"));
			} catch (Exception e) {
			}

			if (!UtilStrings.isNullOrEmpty(smartReportDTO.getParametros()) || isExibirParametroIdEspecifico && TipoExibicaoRelatorio.ESPECIFICO.getIdentificador().equalsIgnoreCase(smartReportDTO.getTipoExibicao())) {
				loadReportParameters(document, request, smartReportDTO);
			} else if (smartReportDTO != null && smartReportDTO.getTipoConsulta() != null) {
				processReport(document, request, smartReportDTO);
			}
		}

	}

	/**
	 * @param document
	 * @param request
	 * @param smartReportDTO
	 * @throws Exception
	 * @author renato.jesus
	 */
	private void loadReportParameters(DocumentHTML document, HttpServletRequest request, SmartReportDTO smartReportDTO) throws Exception {
		List<SmartReportParameterDTO> smartReportParametroDTOs = UtilSmartReport.getReportParameters(smartReportDTO.getParametros());

		if (TipoExibicaoRelatorio.ESPECIFICO.getIdentificador().equalsIgnoreCase(smartReportDTO.getTipoExibicao())) {
			SmartReportParameterDTO specificParameter = new SmartReportParameterDTO();
			specificParameter.setDefaultValue("0");
			specificParameter.setDescription("smartReportGenerators.idEspecifico");
			specificParameter.setType("java.lang.Integer");
			specificParameter.setTypeHTML("text");
			specificParameter.setMandatory(Boolean.TRUE);
			specificParameter.setName("specificID");

			smartReportParametroDTOs.add(0, specificParameter);
		}

		String reportParameterModalHtml = "";
		reportParameterModalHtml += "<div class='row body-params-fields clearfix'>" + UtilSmartReport.getHtmlReportParametersSmartDecisions(request, smartReportParametroDTOs) + "</div>";
		reportParameterModalHtml += "<button type='button' onclick='UtilSmartReport.process(" + smartReportDTO.getIdSmartReport() + ", true)' class='btn btn-citsmart btn-params btn-sm pull-right'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.gerarRelatorio") + "</button>";
		reportParameterModalHtml += "<button type='button' onclick='UtilSmartReport.cleanFilters(" + smartReportDTO.getIdSmartReport() + ")' class='btn btn-default btn-params btn-sm pull-right mr5'>" + UtilI18N.internacionaliza(request, "citcorpore.ui.botao.rotulo.Limpar") + "</button>";

		document.executeScript("Modal.open('modal-smart-report');");
		document.executeScript("$('#formSmartReport" + smartReportDTO.getIdSmartReport() + " .div-smart-report-params').removeClass('hidden')");
		document.executeScript("$('#formSmartReport" + smartReportDTO.getIdSmartReport() + " .div-smart-report-params .body-params').empty().append('" + StringEscapeUtils.escapeJavaScript(reportParameterModalHtml) + "')");
		document.executeScript("DEFINEALLPAGES_generateConfiguracaoCampos()");

		document.executeScript("angular.element('#smart-report" + smartReportDTO.getIdSmartReport() + "').scope().$compile(angular.element('#smart-report" + smartReportDTO.getIdSmartReport() + " .filter'))(angular.element('#smart-report" + smartReportDTO.getIdSmartReport() + "').scope())");

		document.executeScript("UtilSmartReport.afterLoadReport(" + smartReportDTO.getIdSmartReport() + ");");
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 *
	 * @author douglas.japiassu
	 * @since 20.09.2016
	 */
	public void processReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();

		SmartReportDTO smartReportDTO = new SmartReportDTO();
		smartReportDTO.setIdSmartReport(smartDecisionsDTO.getIdSmartReport());
		smartReportDTO = getSmartReportService().restore(smartReportDTO);

		processReport(document, request, smartReportDTO);
	}

	/**
	 * @param document
	 * @param request
	 * @param smartReportDTO
	 * @throws IOException
	 * @throws Exception
	 * @throws JSONException
	 * @author renato.jesus
	 */
	private void processReport(DocumentHTML document, HttpServletRequest request, SmartReportDTO smartReportDTO) throws IOException, Exception, JSONException {
		document.setBean(smartReportDTO);
		UtilSmartReport.processReport(document, request);
	}

	public void solicitacoesPorServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();

		JSONArray datasets = new JSONArray();
		JSONArray labels = new JSONArray();
		JSONArray ids = new JSONArray();

		List<Object[]> list = this.getSmartDecisionsService().solicitacoesPorServico(smartDecisionsDTO.getDataInicioSolicitacoesPorServico(), smartDecisionsDTO.getDataFimSolicitacoesPorServico(), smartDecisionsDTO.getIdServicoNegocioSolicitacoesPorServico());

		if (list != null && !list.isEmpty()) {
			JSONArray datasetData = new JSONArray();

			for (Object[] object : list) {
				if (object[0] != null) {
					ids.put(((Long) object[0]).intValue());
				} else {
					ids.put(0);
				}

				labels.put(UtilStrings.ellipsis((String) object[1], 50, "..."));
				datasetData.put(((Long) object[2]).intValue());
			}

			datasets.put(new JSONObject().put("data", datasetData)); // .put("label", "Situaes")
		}


		JSONObject data = new JSONObject();

		data.put("ids", ids).put("labels", labels).put("datasets", datasets);

		JSONObject options = new JSONObject();
		options.put("responsive", true);
		options.put("legend", new JSONObject().put("display", true));

		document.executeScript("$('#solicitacoes-por-servico').scope().build('doughnut', '" + StringEscapeUtils.escapeJavaScript(data.toString()) + "', '" + StringEscapeUtils.escapeJavaScript(options.toString()) + "');");
	}

	public void dashboardProcessos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();
		String[] periodoDashboardProcessos = smartDecisionsDTO.getPeriodoDashboardProcessos().split("/");

		JSONArray labels = new JSONArray();
		JSONArray datasets = new JSONArray();

		Calendar calendarBase = Calendar.getInstance();
		calendarBase.set(Integer.parseInt(periodoDashboardProcessos[1]), Integer.parseInt(periodoDashboardProcessos[0]) - 1, 1);

		for (int i = calendarBase.getActualMinimum(Calendar.DAY_OF_MONTH); i <= calendarBase.getActualMaximum(Calendar.DAY_OF_MONTH); i++) {
			labels.put(i);
		}

		Map<String, HashMap<Integer, Integer>> map = this.getSmartDecisionsService().dashboardProcessos(periodoDashboardProcessos[0], periodoDashboardProcessos[1]);

		for (String processo : map.keySet()) {
			JSONObject dataset = new JSONObject();
			dataset.put("label", UtilI18N.internacionaliza(request, processo)).put("fill", false);

			JSONArray data = new JSONArray();

			for (int i = calendarBase.getActualMinimum(Calendar.DAY_OF_MONTH); i <= calendarBase.getActualMaximum(Calendar.DAY_OF_MONTH); i++) {
				if (map.get(processo).get(i) != null) {
					data.put(map.get(processo).get(i));
				} else {
					data.put(0);
				}
			}

			dataset.put("data", data);

			datasets.put(dataset);
		}

		JSONObject data = new JSONObject();

		data.put("labels", labels).put("datasets", datasets);

		JSONObject options = new JSONObject();
		options.put("responsive", true);
		options.put("maintainAspectRatio", false);
		options.put("legend", new JSONObject().put("display", true));

		document.executeScript("$('#dashboard-processos').scope().build('line', '" + StringEscapeUtils.escapeJavaScript(data.toString()) + "', '" + StringEscapeUtils.escapeJavaScript(options.toString()) + "');");
	}

	public void itensConfiguracaoSoftwares(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsDTO smartDecisionsDTO = (SmartDecisionsDTO) document.getBean();

		List<Object[]> list = this.getSmartDecisionsService().itensConfiguracaoSoftwares(smartDecisionsDTO.getPeriodoItensConfiguracaoSoftwares(), smartDecisionsDTO.getPalavraChaveItensConfiguracaoSoftwares());

		JSONArray data = new JSONArray();
		if (list != null && !list.isEmpty()) {
			for (Object[] object : list) {
				JSONObject ic = new JSONObject();

				if (object[0] != null) {
					ic.put("quantidade", ((Long) object[0]).intValue());
				} else {
					ic.put("quantidade", 0);
				}

				ic.put("identificacao", object[1]);

				data.put(ic);
			}
		}

		document.executeScript("$('#itens-configuracao-softwares').scope().build('" + StringEscapeUtils.escapeJavaScript(data.toString()) + "');");
	}

	public void dashboardSolicitacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		JSONArray data = new JSONArray();

		GerenciamentoServicosDTO gerenciamentoServicosDTO = new GerenciamentoServicosDTO();
		gerenciamentoServicosDTO.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());

		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratoDTO> listContratoUsuarioLogado = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoUsuarioLogado = this.getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());
		} else {
			listContratoUsuarioLogado = this.getContratoService().listAtivos();
		}

		List<SolicitacaoServicoDTO> listSolicitacaoServicoDTO = this.getSolicitacaoServicoService(request).recuperaSolicitacoesPorUsuarioComFiltro(usuarioDTO, listContratoUsuarioLogado, gerenciamentoServicosDTO);
		Map<String, Integer> mapTipoSolicitacaoServico = this.getSolicitacaoServicoService(request).resumoTipoDemandaServico(listSolicitacaoServicoDTO);

		for (Map.Entry<String, Integer> tipoSolicitacaoServico : mapTipoSolicitacaoServico.entrySet()) {
			JSONObject tipo = new JSONObject();
			tipo.put("tipo", UtilI18N.internacionaliza(request, tipoSolicitacaoServico.getKey()));
			tipo.put("quantidade", tipoSolicitacaoServico.getValue());

			data.put(tipo);
		}

		document.executeScript("$('#dashboard-solicitacoes').scope().build('" + StringEscapeUtils.escapeJavaScript(data.toString()) + "');");
	}

	private SmartDecisionsService getSmartDecisionsService() throws Exception {
		if (smartDecisionsService == null) {
			smartDecisionsService = (SmartDecisionsService) ServiceLocator.getInstance().getService(SmartDecisionsService.class, null);
		}

		return smartDecisionsService;
	}

	private SmartDecisionsWidgetsService getSmartDecisionsWidgetsService() throws Exception {
		if (smartDecisionsWidgetsService == null) {
			smartDecisionsWidgetsService = (SmartDecisionsWidgetsService) ServiceLocator.getInstance().getService(SmartDecisionsWidgetsService.class, null);
		}

		return smartDecisionsWidgetsService;
	}

	private SmartReportService getSmartReportService() throws Exception {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}

		return smartReportService;
	}

	private MenuService getMenuService() throws Exception {
		if (menuService == null) {
			menuService = (MenuService) ServiceLocator.getInstance().getService(MenuService.class, null);
		}

		return menuService;
	}

	private EvmConexaoService getEvmConexaoService() throws ServiceException {
		if (evmConexaoService == null) {
			evmConexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		}
		return evmConexaoService;
	}

	private SmartDecisionsWidgetsGroupsService getSmartDecisionsWidgetsGroupsService() throws ServiceException {
		if (smartDecisionsWidgetsGroupsService == null) {
			smartDecisionsWidgetsGroupsService = (SmartDecisionsWidgetsGroupsService) ServiceLocator.getInstance().getService(SmartDecisionsWidgetsGroupsService.class, null);
		}
		return smartDecisionsWidgetsGroupsService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService(HttpServletRequest request) throws Exception {
		if (solicitacaoServicoService == null) {
			if (request == null) {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
			} else {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));
			}
		}
		return solicitacaoServicoService;
	}

	private ContratoService getContratoService() throws Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

}
