package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsConfigurationsDTO;
import br.com.centralit.citcorpore.bean.SmartDecisionsWidgetsGroupsDTO;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.SmartDecisionsWidgetsGroupsService;
import br.com.centralit.citcorpore.util.Enumerados.SmartDecisionsWidgets;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class SmartDecisionsConfigurations extends AjaxFormAction {

	private SmartDecisionsWidgetsGroupsService smartDecisionsWidgetsGroupsService;
	private GrupoService grupoService;

	@Override
	public Class<SmartDecisionsConfigurationsDTO> getBeanClass() {
		return SmartDecisionsConfigurationsDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	public void loadConfigurations(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		JSONArray widgets = new JSONArray();

		for (SmartDecisionsWidgets smartDecisionsWidgets : SmartDecisionsWidgets.values()) {
			JSONObject widget = new JSONObject();
			widget.put("id", smartDecisionsWidgets.getId());
			widget.put("name", UtilI18N.internacionaliza(request, smartDecisionsWidgets.getKeyTitle()));
			widget.put("description", UtilI18N.internacionaliza(request, smartDecisionsWidgets.getKeyDescription()));

			widgets.put(widget);
		}

		document.executeScript("$('#smart-decisions-configurations').scope().setWidgets('" + StringEscapeUtils.escapeJavaScript(widgets.toString()) + "');");
	}

	public void editWidget(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SmartDecisionsConfigurationsDTO smartDecisionsConfigurationsDTO = (SmartDecisionsConfigurationsDTO) document.getBean();

		if (smartDecisionsConfigurationsDTO != null && smartDecisionsConfigurationsDTO.getIdWidget() != null) {
			SmartDecisionsWidgets smartDecisionsWidgets = SmartDecisionsWidgets.fromId(smartDecisionsConfigurationsDTO.getIdWidget());

			JSONObject widget = new JSONObject();

			widget.put("id", smartDecisionsWidgets.getId());
			widget.put("name", UtilI18N.internacionaliza(request, smartDecisionsWidgets.getKeyTitle()));
			widget.put("description", UtilI18N.internacionaliza(request, smartDecisionsWidgets.getKeyDescription()));

			Collection<SmartDecisionsWidgetsGroupsDTO> colSmartDecisionsWidgetsGroups = this.getSmartDecisionsWidgetsGroupsService().findByIdWidget(smartDecisionsWidgets.getId());

			JSONArray groups = new JSONArray();
			if (colSmartDecisionsWidgetsGroups != null && !colSmartDecisionsWidgetsGroups.isEmpty()) {
				for (SmartDecisionsWidgetsGroupsDTO smartDecisionsWidgetsGroupsDTO : colSmartDecisionsWidgetsGroups) {
					JSONObject group = new JSONObject();

					GrupoDTO grupoDTO = new GrupoDTO();
					grupoDTO.setIdGrupo(smartDecisionsWidgetsGroupsDTO.getIdGrupo());
					grupoDTO = getGrupoService().restore(grupoDTO);

					if (grupoDTO != null) {
						group.put("id", grupoDTO.getIdGrupo());
						group.put("name", grupoDTO.getNome());

						groups.put(group);
					}
				}
			}

			widget.put("groups", groups);

			document.executeScript("$('#smart-decisions-widgets-edit').scope().setWidget('" + StringEscapeUtils.escapeJavaScript(widget.toString()) + "');");
		}
	}

	public void saveWidget(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SmartDecisionsConfigurationsDTO smartDecisionsConfigurationsDTO = (SmartDecisionsConfigurationsDTO) document.getBean();

		if (smartDecisionsConfigurationsDTO != null && smartDecisionsConfigurationsDTO.getJson() != null) {
			JSONObject widget = new JSONObject(smartDecisionsConfigurationsDTO.getJson());

			JSONArray groups = widget.getJSONArray("groups");

			this.getSmartDecisionsWidgetsGroupsService().deleteByIdWidget(widget.getInt("id"));

			if (groups != null) {
				for (int i = 0; i < groups.length(); i++) {
					JSONObject group = groups.getJSONObject(i);

					SmartDecisionsWidgetsGroupsDTO smartDecisionsWidgetsGroupsDTO = new SmartDecisionsWidgetsGroupsDTO();

					smartDecisionsWidgetsGroupsDTO.setIdWidget(widget.getInt("id"));
					smartDecisionsWidgetsGroupsDTO.setIdGrupo(group.getInt("id"));

					this.getSmartDecisionsWidgetsGroupsService().create(smartDecisionsWidgetsGroupsDTO);
				}
			}
		}

		document.executeScript("Notification.success('" + UtilI18N.internacionaliza(request, "MSG06") + "');");
	}

	public void adicionaTabelaLOOKUP_GRUPO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartDecisionsConfigurationsDTO smartDecisionsConfigurationsDTO = (SmartDecisionsConfigurationsDTO) document.getBean();

		if (smartDecisionsConfigurationsDTO != null) {
			String listGrupos = smartDecisionsConfigurationsDTO.getColAllLOOKUP_GRUPO();

			if (listGrupos != null && !listGrupos.isEmpty()) {
				String[] gs = listGrupos.split(";");

				if (gs != null && gs.length > 0) {
					for (String g : gs) {
						JSONObject group = new JSONObject();

						GrupoDTO grupoDTO = new GrupoDTO();
						grupoDTO.setIdGrupo(Integer.parseInt(g));
						grupoDTO = getGrupoService().restore(grupoDTO);

						if (grupoDTO != null) {
							group.put("id", grupoDTO.getIdGrupo());
							group.put("name", grupoDTO.getNome());

							document.executeScript("$('#smart-decisions-widgets-edit').scope().setGroup('" + StringEscapeUtils.escapeJavaScript(group.toString()) + "');");
						}

					}
				}
			}
		}
	}

	private SmartDecisionsWidgetsGroupsService getSmartDecisionsWidgetsGroupsService() throws Exception {
		if (smartDecisionsWidgetsGroupsService == null) {
			smartDecisionsWidgetsGroupsService = (SmartDecisionsWidgetsGroupsService) ServiceLocator.getInstance().getService(SmartDecisionsWidgetsGroupsService.class, null);
		}

		return smartDecisionsWidgetsGroupsService;
	}

	private GrupoService getGrupoService() throws Exception {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}

}
