package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.AvaliacaoServicoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.CategoriaOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ContatoSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.DadosEmailRegOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.GrupoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.OpiniaoDTO;
import br.com.centralit.citcorpore.bean.OrigemOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.ParamRecuperacaoTarefasDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.PesquisaSatisfacaoDTO;
import br.com.centralit.citcorpore.bean.PortfolioServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SmartPortalDTO;
import br.com.centralit.citcorpore.bean.SmartPortalSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoDao;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.AcordoServicoContratoService;
import br.com.centralit.citcorpore.negocio.AvaliacaoServicoService;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.CategoriaOcorrenciaService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ComentariosService;
import br.com.centralit.citcorpore.negocio.ContatoSolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.ExecucaoSolicitacaoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoEmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaService;
import br.com.centralit.citcorpore.negocio.OcorrenciaSolicitacaoService;
import br.com.centralit.citcorpore.negocio.OpiniaoService;
import br.com.centralit.citcorpore.negocio.OrigemOcorrenciaService;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoPastaService;
import br.com.centralit.citcorpore.negocio.PesquisaSatisfacaoService;
import br.com.centralit.citcorpore.negocio.PortfolioServicoService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.CategoriaPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.DescricaoPrioridade;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.PermissaoAcessoPasta;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.citquestionario.negocio.QuestionarioService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilFormatacao;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class SmartPortal extends AjaxFormAction {

	private BaseConhecimentoService baseConhecimentoService;
	private ComentariosService comentariosService;
	private PastaService pastaService;
	private PerfilAcessoPastaService perfilAcessoPastaService;
	private PortfolioServicoService portfolioServicoService;
	private ServicoService servicoService;
	private ContratoService contratoService;
	private ServicoContratoService servicoContratoService;
	private QuestionarioService questionarioService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private EmpregadoService empregadoService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private AcordoServicoContratoService acordoServicoContratoService;
	private ExecucaoSolicitacaoService execucaoSolicitacaoService;
	private ControleGEDService controleGedService;
	private ClienteService clienteService;
	private FornecedorService fornecedorService;
	private OcorrenciaSolicitacaoService ocorrenciaSolicitacaoService;
	private OrigemOcorrenciaService origemOcorrenciaService;
	private CategoriaOcorrenciaService categoriaOcorrenciaService;
	private OcorrenciaService ocorrenciaService;
	private GrupoService grupoService;
	private OpiniaoService opiniaoService;
	private PesquisaSatisfacaoService pesquisaSatisfacaoService;
	private ContatoSolicitacaoServicoService contatoSolicitacaoServicoService;
	private GrupoEmpregadoService grupoEmpregadoService;
	private AvaliacaoServicoService avaliacaoServicoService;
	private UsuarioService usuarioService;

	@SuppressWarnings("unchecked")
	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		loadCatalogosServico(document, request, response);

		List<SmartPortalSolicitacaoDTO> solicitacoes = (List<SmartPortalSolicitacaoDTO>) request.getSession(true).getAttribute("solicitacoesPortal");

		if (solicitacoes != null && !solicitacoes.isEmpty()) {
			document.executeScript("MeusPedidos.badge.update(" + solicitacoes.size() + ");");
		}
	}

	public void loadCatalogosServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final StringBuilder sb = new StringBuilder();

		sb.append("<div class='row'>");
		sb.append("	<div class='col-md-12'>");
		sb.append("		<div class='input-group gerenciamento-servicos-busca'>");
		sb.append("			<input type='text' id='pesquisaCatalogoServico' name='pesquisaCatalogoServico' class='form-control' placeholder='" + UtilI18N.internacionaliza(request, "portal.pesquiseAqui") + "' value='" + (siteDTO.getPesquisaCatalogoServico() != null && !siteDTO.getPesquisaCatalogoServico().isEmpty() ? siteDTO.getPesquisaCatalogoServico() : "") + "'>");
		sb.append("			<span class='input-group-btn'>");
		sb.append("				<button class='btn btn-default' type='button' onclick='GerenciamentoServicos.catalogos.search();'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.pesquisar") + "</button>");
		sb.append("			</span>");
		sb.append("		</div>");
		sb.append("	</div>");
		sb.append("</div>");

		sb.append("<div class='separator bottom'></div>");

		List<PortfolioServicoDTO> listPortfolioServico = new ArrayList<>();
		final UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);
		Collection<ContratoDTO> contratosDTO = getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());

		if (contratosDTO != null && !contratosDTO.isEmpty()) {
			listPortfolioServico = getPortfolioServicoService().findDisponiveisPortalByContratos(siteDTO.getPesquisaCatalogoServico(), contratosDTO);
		}


		sb.append("<div class='row'>");

		if (listPortfolioServico != null && !listPortfolioServico.isEmpty() && listPortfolioServico.size() > 0) {
			for (PortfolioServicoDTO portfolioServicoDTO : listPortfolioServico) {
				sb.append("	<div class='col-md-6'>");
				sb.append("		<div class='card' onclick='GerenciamentoServicos.catalogos.open(" + portfolioServicoDTO.getIdPortfolioServico() + ");'>");
				sb.append("			<img src='" + (UtilStrings.isNotVazio(portfolioServicoDTO.getImagemPortal()) ? Configuracoes.getCaminhoComContexto(portfolioServicoDTO.getImagemPortal()) : "")
						+ "' class='avatar img-responsive' />");
				sb.append("			<h4 class='card-title'>" + portfolioServicoDTO.getNomePortal() + "</h4>");
				sb.append("			<p class='card-text'>" + UtilStrings.ellipsis(portfolioServicoDTO.getDescricaoPortal(), 80, "...") + "</p>");
				sb.append("		</div>");
				sb.append("	</div>");
			}
		} else {
			sb.append("	<div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
		}

		sb.append("</div>");

		final HTMLElement gerenciamentoServicosContent = document.getElementById("gerenciamento-servicos-content");
		gerenciamentoServicosContent.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void openCatalogosServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final StringBuilder sb = new StringBuilder();

		PortfolioServicoDTO portfolioServicoDTO = new PortfolioServicoDTO();
		portfolioServicoDTO.setIdPortfolioServico(siteDTO.getIdCatalogoServico());
		portfolioServicoDTO = getPortfolioServicoService().restore(portfolioServicoDTO);

		sb.append("<div class='card-main'>");
		sb.append("		<div class='card-img'>");
		sb.append("			<img src='" + (UtilStrings.isNotVazio(portfolioServicoDTO.getImagemPortal()) ? Configuracoes.getCaminhoComContexto(portfolioServicoDTO.getImagemPortal()) : "") + "' class='avatar img-responsive' />");
		sb.append("			<div id='stars-catalogo-servico-content' class='stars'>");
		sb.append("				<i class='material-icons'>star_border</i>");
		sb.append("				<i class='material-icons'>star_border</i>");
		sb.append("				<i class='material-icons'>star_border</i>");
		sb.append("				<i class='material-icons'>star_border</i>");
		sb.append("				<i class='material-icons'>star_border</i>");
		sb.append("				<div class='clearfix'></div>");
		sb.append("			</div>");
		sb.append("		</div>");
		sb.append("		<div class='card-content'>");
		sb.append("			<h2 class='card-title'>" + portfolioServicoDTO.getNomePortal() + "</h2>");
		sb.append("			<p class='card-text'>" + portfolioServicoDTO.getDescricaoPortal() + "</p>");
		sb.append("		</div>");
		sb.append("		<div class='clearfix'></div>");
		sb.append("</div>");

		sb.append("<ul class='gerenciamento-servicos-nav nav nav-tabs'>");
		sb.append("	<li role='presentation' class='active'><a href='javascript:void(0);' data-ref='catalogo'>" + UtilI18N.internacionaliza(request, "portal.servicos") + "</a></li>");
		//sb.append("	<li role='presentation'><a href='javascript:void(0);' data-ref='avaliacoes'>" + UtilI18N.internacionaliza(request, "portal.avaliacoes") + "</a></li>");
		//sb.append("	<li role='presentation'><a href='javascript:void(0);' data-ref='informacoes'>" + UtilI18N.internacionaliza(request, "portal.informacoes") + "</a></li>");
		sb.append("</ul>");

		sb.append("<div class='separator bottom'></div>");

		sb.append("<div class='gerenciamento-servicos-nav-content'>");
		sb.append("	<div data-ref='catalogo'>");

		sb.append("		<div class='row'>");
		sb.append("			<div class='col-md-12'>");
		sb.append("				<div class='input-group gerenciamento-servicos-busca'>");
		sb.append("					<input type='text' id='pesquisaServicoNegocio' name='pesquisaServicoNegocio' class='form-control' placeholder='" + UtilI18N.internacionaliza(request, "portal.pesquiseAqui") + "' value='" + (siteDTO.getPesquisaServicoNegocio() != null && !siteDTO.getPesquisaServicoNegocio().isEmpty() ? siteDTO.getPesquisaServicoNegocio() : "") + "'>");
		sb.append("					<span class='input-group-btn'>");
		sb.append("						<button class='btn btn-default' type='button' onclick='GerenciamentoServicos.catalogo.servicos.search();'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.pesquisar") + "</button>");
		sb.append("					</span>");
		sb.append("				</div>");
		sb.append("			</div>");
		sb.append("		</div>");

		sb.append("		<div class='separator bottom'></div>");

		sb.append("		<div id='servicos-negocio-content' class='row'></div>");

		sb.append("	</div>");
		//sb.append("	<div class='dn' data-ref='avaliacoes'></div>");
		//sb.append("	<div class='dn' data-ref='informacoes'></div>");
		sb.append("</div>");

		final HTMLElement gerenciamentoServicosContent = document.getElementById("gerenciamento-servicos-content");
		gerenciamentoServicosContent.setInnerHTML(sb.toString());

		this.searchServicoNegocio(document, request, response);

		document.getElementById("nomeCatalogoServico").setValue(portfolioServicoDTO.getNomePortal());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void searchServicoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final StringBuilder sb = new StringBuilder();

		final UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);
		List<ServicoDTO> listServicoNegocio = new ArrayList<>();
		Collection<ContratoDTO> contratosDTO = getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());

		if (contratosDTO != null && !contratosDTO.isEmpty()) {
			listServicoNegocio = getServicoService().listServicosDeNegocioPortal(siteDTO.getIdCatalogoServico(), contratosDTO, CategoriaPortfolio.CATALOGO_SERVICOS.getIdentificador(), siteDTO.getPesquisaServicoNegocio(), null, null);
		}

		if (listServicoNegocio != null && !listServicoNegocio.isEmpty()) {
			Double notas = 0.0;
			Integer numeroAvaliacoes = 0;

			Double mediaNotas = 0.0;
			Double resto = 0.0;

			for (ServicoDTO servicoDTO : listServicoNegocio) {
				sb.append("			<div class='col-md-6'>");
				sb.append("				<div class='card' onclick='GerenciamentoServicos.catalogo.servicos.open(" + servicoDTO.getIdServico() + ");'>");
				sb.append("					<img src='" + (UtilStrings.isNotVazio(servicoDTO.getImagemPortal()) ? Configuracoes.getCaminhoComContexto(servicoDTO.getImagemPortal()) : "") + "' class='avatar img-responsive' />");
				sb.append("					<h4 class='card-title'>" + servicoDTO.getNomePortal() + "</h4>");
				sb.append("					<p class='card-text'>" + UtilStrings.ellipsis(servicoDTO.getDescricaoPortal(), 80, "...") + "</p>");
				sb.append("				</div>");
				sb.append("			</div>");

				List<AvaliacaoServicoDTO> listAvaliacaoServicoDTO = (List<AvaliacaoServicoDTO>) getAvaliacaoServicoService().findByIdServico(servicoDTO.getIdServico());

				if (listAvaliacaoServicoDTO != null && !listAvaliacaoServicoDTO.isEmpty()) {
					for (AvaliacaoServicoDTO avaliacaoServicoDTO : listAvaliacaoServicoDTO) {
						notas += avaliacaoServicoDTO.getNota();
					}

					numeroAvaliacoes += listAvaliacaoServicoDTO.size();
				}
			}

			if (numeroAvaliacoes > 0) {
				mediaNotas = new Double(notas / numeroAvaliacoes);
				resto = mediaNotas % 1;

				final StringBuilder sbAvaliacoes = new StringBuilder();

				sbAvaliacoes.append("				<i class='material-icons'>" + (mediaNotas >= 1 ? "star" : "star_border") + "</i>");
				sbAvaliacoes.append("				<i class='material-icons'>" + (mediaNotas >= 2 ? "star" : mediaNotas >= 1 && mediaNotas <= 2 && resto > 0 ? "star_half" : "star_border") + "</i>");
				sbAvaliacoes.append("				<i class='material-icons'>" + (mediaNotas >= 3 ? "star" : mediaNotas >= 2 && mediaNotas <= 3 && resto > 0 ? "star_half" : "star_border") + "</i>");
				sbAvaliacoes.append("				<i class='material-icons'>" + (mediaNotas >= 4 ? "star" : mediaNotas >= 3 && mediaNotas <= 4 && resto > 0 ? "star_half" : "star_border") + "</i>");
				sbAvaliacoes.append("				<i class='material-icons'>" + (mediaNotas >= 5 ? "star" : mediaNotas >= 4 && mediaNotas <= 5 && resto > 0 ? "star_half" : "star_border") + "</i>");

				final HTMLElement starsCatalogoServicoContent = document.getElementById("stars-catalogo-servico-content");
				starsCatalogoServicoContent.setInnerHTML(sbAvaliacoes.toString());
			}
		} else {
			sb.append("	<div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
		}

		document.getElementById("servicos-negocio-content").setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void openServicoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		if (siteDTO != null && siteDTO.getIdServicoNegocio() != null) {
			final StringBuilder sb = new StringBuilder();
			final StringBuilder sbAvaliacoes = new StringBuilder();

			ServicoDTO servicoNegocioDTO = getServicoService().findByIdServico(siteDTO.getIdServicoNegocio());

			List<AvaliacaoServicoDTO> listAvaliacaoServicoDTO = (List<AvaliacaoServicoDTO>) getAvaliacaoServicoService().findByIdServico(servicoNegocioDTO.getIdServico());

			Double mediaNotas = 0.0;
			Double resto = 0.0;

			if (listAvaliacaoServicoDTO != null && !listAvaliacaoServicoDTO.isEmpty()) {
				Double notas = 0.0;

				for (AvaliacaoServicoDTO avaliacaoServicoDTO : listAvaliacaoServicoDTO) {
					UsuarioDTO usuario = getUsuarioService().restoreByID(avaliacaoServicoDTO.getIdUsuario());

					sbAvaliacoes.append("		<div class='row avaliacao'>");
					sbAvaliacoes.append("			<div class='col-md-12'>");
					sbAvaliacoes.append("				<div class='card-list'>");
					sbAvaliacoes.append("					<h4 class='card-title'>" + usuario.getNomeUsuario() + "</h4>");
					sbAvaliacoes.append("					<div class='stars'>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 1 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 2 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 3 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 4 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() == 5 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<div class='clearfix'></div>");
					sbAvaliacoes.append("					</div>");
					sbAvaliacoes.append("					<div class='separator bottom'></div>");
					sbAvaliacoes.append("					<p class='card-text'>" + avaliacaoServicoDTO.getComentario() + "</p>");
					sbAvaliacoes.append("				</div>");
					sbAvaliacoes.append("			</div>");
					sbAvaliacoes.append("		</div>");

					notas += avaliacaoServicoDTO.getNota();
				}

				mediaNotas = new Double(notas / listAvaliacaoServicoDTO.size());
				resto = mediaNotas % 1;
			} else {
				sbAvaliacoes.append("	<div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
				sbAvaliacoes.append("	<div class='separator bottom'></div>");
			}

			sb.append("<div class='card-main'>");
			sb.append("		<div class='card-img'>");
			sb.append("			<img src='" + (UtilStrings.isNotVazio(servicoNegocioDTO.getImagemPortal()) ? Configuracoes.getCaminhoComContexto(servicoNegocioDTO.getImagemPortal()) : "") + "' class='avatar img-responsive' />");
			sb.append("			<div id='stars-servico-negocio-content' class='stars'>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 1 ? "star" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 2 ? "star" : mediaNotas >= 1 && mediaNotas <= 2 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 3 ? "star" : mediaNotas >= 2 && mediaNotas <= 3 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 4 ? "star" : mediaNotas >= 3 && mediaNotas <= 4 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 5 ? "star" : mediaNotas >= 4 && mediaNotas <= 5 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<div class='clearfix'></div>");
			sb.append("			</div>");
			sb.append("			<a onclick='GerenciamentoServicos.servico.avaliacao.open(" + servicoNegocioDTO.getIdServico() + ");'>" + UtilI18N.internacionaliza(request, "portal.avaliarServico") + "</a>");
			sb.append("		</div>");
			sb.append("		<div class='card-content'>");
			sb.append("			<h2 class='card-title'>" + servicoNegocioDTO.getNomePortal() + "</h2>");
			sb.append("			<p class='card-text'>" + servicoNegocioDTO.getDescricaoPortal() + "</p>");
			sb.append("		</div>");
			sb.append("		<div class='clearfix'></div>");
			sb.append("</div>");

			sb.append("<ul class='gerenciamento-servicos-nav nav nav-tabs'>");
			sb.append("	<li role='presentation' class='active'><a href='javascript:void(0);' data-ref='catalogo'>" + UtilI18N.internacionaliza(request, "portal.solicitacoes") + "</a></li>");
			sb.append("	<li role='presentation'><a href='javascript:void(0);' data-ref='avaliacoes'>" + UtilI18N.internacionaliza(request, "portal.avaliacoes") + "</a></li>");
			//sb.append("	<li role='presentation'><a href='javascript:void(0);' data-ref='informacoes'>" + UtilI18N.internacionaliza(request, "portal.informacoes") + "</a></li>");
			sb.append("</ul>");

			sb.append("<div class='separator bottom'></div>");

			sb.append("<div class='gerenciamento-servicos-nav-content'>");
			sb.append("	<div data-ref='catalogo'>");

			sb.append("		<div class='row'>");
			sb.append("			<div class='col-md-12'>");
			sb.append("				<div class='input-group gerenciamento-servicos-busca'>");
			sb.append("					<input type='text' id='pesquisaAtividade' name='pesquisaAtividade' class='form-control' placeholder='" + UtilI18N.internacionaliza(request, "portal.pesquiseAqui") + "' value='" + (siteDTO.getPesquisaAtividade() != null && !siteDTO.getPesquisaAtividade().isEmpty() ? siteDTO.getPesquisaAtividade() : "") + "'>");
			sb.append("					<span class='input-group-btn'>");
			sb.append("						<button class='btn btn-default' type='button' onclick='GerenciamentoServicos.servico.atividades.search();'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.pesquisar") + "</button>");
			sb.append("					</span>");
			sb.append("				</div>");
			sb.append("			</div>");
			sb.append("		</div>");

			sb.append("		<div class='separator bottom'></div>");

			sb.append("		<div id='atividades-content' class='row'></div>");

			sb.append("	</div>");
			sb.append("	<div id='avaliacoes-content' class='dn' data-ref='avaliacoes'>");

			sb.append(sbAvaliacoes);

			sb.append("	</div>");
			//sb.append("	<div class='dn' data-ref='informacoes'></div>");
			sb.append("</div>");

			final HTMLElement gerenciamentoServicosContent = document.getElementById("gerenciamento-servicos-content");
			gerenciamentoServicosContent.setInnerHTML(sb.toString());

			this.searchAtividades(document, request, response);

			document.getElementById("nomeServicoNegocio").setValue(servicoNegocioDTO.getNomePortal());
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void carregaAvaliacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		if (siteDTO != null && siteDTO.getIdServicoNegocio() != null) {
			final StringBuilder sb = new StringBuilder();
			final StringBuilder sbAvaliacoes = new StringBuilder();

			ServicoDTO servicoNegocioDTO = getServicoService().findByIdServico(siteDTO.getIdServicoNegocio());

			List<AvaliacaoServicoDTO> listAvaliacaoServicoDTO = (List<AvaliacaoServicoDTO>) getAvaliacaoServicoService().findByIdServico(servicoNegocioDTO.getIdServico());

			Double mediaNotas = 0.0;
			Double resto = 0.0;

			if (listAvaliacaoServicoDTO != null && !listAvaliacaoServicoDTO.isEmpty()) {
				Double notas = 0.0;

				for (AvaliacaoServicoDTO avaliacaoServicoDTO : listAvaliacaoServicoDTO) {
					UsuarioDTO usuario = getUsuarioService().restoreByID(avaliacaoServicoDTO.getIdUsuario());

					sbAvaliacoes.append("		<div class='row avaliacao'>");
					sbAvaliacoes.append("			<div class='col-md-12'>");
					sbAvaliacoes.append("				<div class='card-list'>");
					sbAvaliacoes.append("					<h4 class='card-title'>" + usuario.getNomeUsuario() + "</h4>");
					sbAvaliacoes.append("					<div class='stars'>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 1 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 2 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 3 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() >= 4 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<i class='material-icons'>" + (avaliacaoServicoDTO.getNota() != null && avaliacaoServicoDTO.getNota() == 5 ? "star" : "star_border") + "</i>");
					sbAvaliacoes.append("						<div class='clearfix'></div>");
					sbAvaliacoes.append("					</div>");
					sbAvaliacoes.append("					<div class='separator bottom'></div>");
					sbAvaliacoes.append("					<p class='card-text'>" + avaliacaoServicoDTO.getComentario() + "</p>");
					sbAvaliacoes.append("				</div>");
					sbAvaliacoes.append("			</div>");
					sbAvaliacoes.append("		</div>");

					notas += avaliacaoServicoDTO.getNota();
				}

				mediaNotas = new Double(notas / listAvaliacaoServicoDTO.size());
				resto = mediaNotas % 1;
			} else {
				sbAvaliacoes.append("	<div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
				sbAvaliacoes.append("	<div class='separator bottom'></div>");
			}

			sb.append("				<i class='material-icons'>" + (mediaNotas >= 1 ? "star" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 2 ? "star" : mediaNotas >= 1 && mediaNotas <= 2 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 3 ? "star" : mediaNotas >= 2 && mediaNotas <= 3 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 4 ? "star" : mediaNotas >= 3 && mediaNotas <= 4 && resto > 0 ? "star_half" : "star_border") + "</i>");
			sb.append("				<i class='material-icons'>" + (mediaNotas >= 5 ? "star" : mediaNotas >= 4 && mediaNotas <= 5 && resto > 0 ? "star_half" : "star_border") + "</i>");

			final HTMLElement avaliacoesContent = document.getElementById("avaliacoes-content");
			avaliacoesContent.setInnerHTML(sbAvaliacoes.toString());

			final HTMLElement starsServicoNegocioContent = document.getElementById("stars-servico-negocio-content");
			starsServicoNegocioContent.setInnerHTML(sb.toString());
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void searchAtividades(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final StringBuilder sb = new StringBuilder();

		final UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);
		List<ServicoDTO> listAtividades = new ArrayList<>();
		Collection<ContratoDTO> contratosDTO = getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());

		if (contratosDTO != null && !contratosDTO.isEmpty()) {
			List<TipoServico> tiposServico = new ArrayList<>();
			tiposServico.add(TipoServico.SERVICO_REQUISICAO);
			tiposServico.add(TipoServico.SERVICO_INCIDENTE);

			listAtividades = getServicoService().listServicosVinculadosAoContratoPortal(tiposServico, siteDTO.getIdCatalogoServico(), siteDTO.getIdServicoNegocio(), contratosDTO, siteDTO.getPesquisaAtividade());
		}

		if (listAtividades != null && !listAtividades.isEmpty()) {
			for (ServicoDTO servicoDTO : listAtividades) {
				Integer idQuestionario = getServicoService().obterIdQuestionarioServico(servicoDTO.getIdServico());

				boolean questionarioObrigatorio = false;
				if (idQuestionario != null) {
					questionarioObrigatorio = getQuestionarioService().existeQuestaoObrigatoria(idQuestionario);
				}

				sb.append("			<div class='col-md-6'>");
				sb.append("				<div class='card' data-toggle='modal' data-target='#modal-add-service' onclick='GerenciamentoServicos.servico.atividades.open(" + servicoDTO.getIdServico() + ", " + (idQuestionario != null ? idQuestionario : "undefined") + ", \"" + questionarioObrigatorio + "\");'>");
				sb.append("					<img src='" + (UtilStrings.isNotVazio(servicoDTO.getImagemPortal()) ? Configuracoes.getCaminhoComContexto(servicoDTO.getImagemPortal()) : "") + "' class='avatar img-responsive' />");
				sb.append("					<h4 class='card-title'>" + servicoDTO.getNomePortal() + "</h4>");
				sb.append("					<p class='card-text'>" + UtilStrings.ellipsis(servicoDTO.getDescricaoPortal(), 80, "...") + "</p>");
				sb.append("				</div>");
				sb.append("			</div>");
			}
		} else {
			sb.append("	<div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
		}

		document.getElementById("atividades-content").setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void loadBaseConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		int quantidadePorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));
		Integer paginaAtual = siteDTO.getPaginaAtualBaseConhecimento() == null ? 1 : siteDTO.getPaginaAtualBaseConhecimento();

		Pageable pageable = new PageRequest(paginaAtual - 1, quantidadePorPagina);

		int quantidadePaginasBaseConhecimento = 0;
		List<BaseConhecimentoDTO> listBase = new ArrayList<>();

		if (siteDTO.getPesquisaBaseConhecimento() != null && !siteDTO.getPesquisaBaseConhecimento().isEmpty()) {
			quantidadePaginasBaseConhecimento = getBaseConhecimentoService().pesquisaBaseConhecimentoPortal(pageable, true, siteDTO.getPesquisaBaseConhecimento()).getTotalPages();
			listBase = getBaseConhecimentoService().pesquisaBaseConhecimentoPortal(pageable, false, siteDTO.getPesquisaBaseConhecimento()).getContent();
		} else {
			quantidadePaginasBaseConhecimento = getBaseConhecimentoService().listarBaseConhecimentoPortal(pageable, true).getTotalPages();
			listBase = getBaseConhecimentoService().listarBaseConhecimentoPortal(pageable, false).getContent();
		}

		StringBuilder sb = new StringBuilder();

		sb.append("<table class='table'>");
		sb.append("		<thead>");
		sb.append("			<tr>");
		sb.append("				<th>" + UtilI18N.internacionaliza(request, "baseConhecimento.titulo") + "</th>");
		sb.append("				<th>" + UtilI18N.internacionaliza(request, "baseConhecimento.nota") + "</th>");
		sb.append("			</tr>");
		sb.append("		</thead>");
		sb.append("		<tbody>");

		if (listBase != null) {
			PastaDTO pastaDto;
			boolean permissao = false;

			for (final BaseConhecimentoDTO baseDTO : listBase) {
				if (baseDTO.getFaq().equalsIgnoreCase("S")) {
					continue;
				}

				pastaDto = new PastaDTO();
				pastaDto.setId(baseDTO.getIdPasta());
				pastaDto = (PastaDTO) getPastaService().restore(pastaDto);

				permissao = this.getBaseConhecimentoService().verificaPermissaoDeAcessoDoUsuarioParaBaseConhecimento(pastaDto, baseDTO, usuarioDto);

				if (permissao) {
					if (baseDTO.getDataFim() == null) {
						final Double nota = getComentariosService().calcularNota(baseDTO.getIdBaseConhecimento());

						sb.append("			<tr>");
						sb.append("				<td><a href='javascript:void(0);' onclick='BaseConhecimento.open(" + baseDTO.getIdBaseConhecimento() + ");'>" + UtilStrings.unescapeJavaString(baseDTO.getTitulo()) + "</a></td>");
						sb.append("				<td>" + (nota == null ? "S/N" : String.valueOf(nota)) + "</td>");
						sb.append("			</tr>");
					}
				}
			}
		}

		sb.append("		</tbody>");
		sb.append("</table>");

		sb.append(geraPaginacao(quantidadePaginasBaseConhecimento, paginaAtual, request, "BaseConhecimento.load(this);"));

		final HTMLElement baseConhecimentoContent = document.getElementById("base-conhecimento-content");
		baseConhecimentoContent.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void loadFAQ(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final int quantidadePorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));
		Integer paginaAtual = siteDTO.getPaginaAtualFAQ() == null ? 1 : siteDTO.getPaginaAtualFAQ();

		Pageable pageable = new PageRequest(paginaAtual - 1, quantidadePorPagina);

		int quantidadePaginasFaq = 0;
		Collection<BaseConhecimentoDTO> listBaseFaq = new ArrayList<>();

		if (siteDTO.getPesquisaFAQ() != null && !siteDTO.getPesquisaFAQ().isEmpty()) {
			quantidadePaginasFaq = getBaseConhecimentoService().pesquisaBaseConhecimentoFAQPortal(pageable, true, siteDTO.getPesquisaFAQ()).getTotalPages();
			listBaseFaq = getBaseConhecimentoService().pesquisaBaseConhecimentoFAQPortal(pageable, false, siteDTO.getPesquisaFAQ()).getContent();
		} else {
			quantidadePaginasFaq = getBaseConhecimentoService().listarBaseConhecimentoFAQPortal(pageable, true).getTotalPages();
			listBaseFaq = getBaseConhecimentoService().listarBaseConhecimentoFAQPortal(pageable, false).getContent();
		}

		final UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		final StringBuilder sb = new StringBuilder();

		if (listBaseFaq != null) {
			sb.append("<div class='panel-group' id='accordion-faq' role='tablist' aria-multiselectable='true'>");

			for (final BaseConhecimentoDTO baseDTO : listBaseFaq) {
				if (baseDTO.getDataFim() == null) {

					PastaDTO pastaDto = new PastaDTO();
					if (baseDTO.getIdPasta() != null) {
						pastaDto.setId(baseDTO.getIdPasta());
						pastaDto = (PastaDTO) getPastaService().restore(pastaDto);
					}

					final PermissaoAcessoPasta permissao = getPerfilAcessoPastaService().verificarPermissaoDeAcessoPasta(usuarioDto, pastaDto);

					sb.append("<div class='panel panel-default'>");
					sb.append("	<div class='panel-heading' role='tab' id='heading-" + baseDTO.getIdBaseConhecimento() + "'>");
					sb.append("		<h4 class='panel-title'>");
					sb.append("			<a class='collapsed' role='button' data-toggle='collapse' data-parent='#accordion-faq' href='#collapse-" + baseDTO.getIdBaseConhecimento() + "' aria-expanded='false' aria-controls='collapse-" + baseDTO.getIdBaseConhecimento() + "'>" + UtilStrings.unescapeJavaString(baseDTO.getTitulo()) + "</a>");
					sb.append("		</h4>");
					sb.append("	</div>");
					sb.append("	<div id='collapse-" + baseDTO.getIdBaseConhecimento() + "' class='panel-collapse collapse' role='tabpanel' aria-labelledby='heading-" + baseDTO.getIdBaseConhecimento() + "'>");
					sb.append("		<div class='panel-body'>");

					if (permissao != null) {
						if (PermissaoAcessoPasta.SEMPERMISSAO.equals(permissao)) {
							sb.append(UtilI18N.internacionaliza(request, "baseconhecimento.validacao.usuariosemacesso"));
						} else {
							sb.append(baseDTO.getConteudo());
						}
					} else {
						sb.append(UtilI18N.internacionaliza(request, "baseconhecimento.validacao.usuariosemacesso"));
					}

					sb.append("		</div>");
					sb.append("	</div>");
					sb.append("</div>");
				}
			}

			sb.append("</div>");
		}

		sb.append(geraPaginacao(quantidadePaginasFaq, paginaAtual, request, "FAQ.load(this);"));

		HTMLElement faqContent = document.getElementById("faq-content");
		faqContent.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public String geraPaginacao(Integer totalPaginas, Integer paginaSelecionada, HttpServletRequest request, String functionName) throws Exception {
		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		StringBuilder sb = new StringBuilder();

		sb.append("<nav aria-label='" + UtilI18N.internacionaliza(request, "citcorpore.comum.paginas") + "'>");
		sb.append("	<ul class='pagination pull-right'>");
		sb.append("		<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada == 1 ? " class='disabled' " : "") + ">");
		sb.append("			<a href='javascript:void(0);' " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada == 1 ? "" : " onclick='" + functionName + "' data-page='1' ") + " aria-label='" + UtilI18N.internacionaliza(request, "citcorpore.comum.anterior") + "'>");
		sb.append("				<span aria-hidden=\"true\">&laquo;</span>");
		sb.append("			</a>");
		sb.append("		</li>");
		sb.append("		<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada == 1 ? " class='disabled' " : "") + ">");
		sb.append("			<a href='javascript:void(0);' " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada == 1 ? "" : " onclick='" + functionName + "' data-page='" + (paginaSelecionada - 1) + "' ") + " aria-label='" + UtilI18N.internacionaliza(request, "citcorpore.comum.anterior") + "'>");
		sb.append("				<span aria-hidden=\"true\">&lsaquo;</span>");
		sb.append("			</a>");
		sb.append("		</li>");

		if (totalPaginas <= 5) {
			for (int i = 1; i <= totalPaginas; i++) {
				if (i == paginaSelecionada) {
					sb.append("		<li class='active'><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
				} else {
					sb.append("		<li><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
				}
			}
		} else {
			if (paginaSelecionada < 5) {
				for (int i = 1; i <= 5; i++) {
					if (i == paginaSelecionada) {
						sb.append("		<li class='active'><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					} else {
						sb.append("		<li><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					}
				}
			} else if (paginaSelecionada > 4 && paginaSelecionada < totalPaginas - 3) {
				for (int i = paginaSelecionada - 2; i <= paginaSelecionada + 2; i++) {
					if (i == paginaSelecionada) {
						sb.append("		<li class='active'><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					} else {
						sb.append("		<li><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					}
				}
			} else {
				for (int i = totalPaginas - 4; i <= totalPaginas; i++) {
					if (i == paginaSelecionada) {
						sb.append("		<li class='active'><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					} else {
						sb.append("		<li><a href='javascript:void(0);' onclick='" + functionName + "' data-page='" + i + "'>" + i + "</a></li>");
					}
				}
			}
		}

		sb.append("		<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada.equals(totalPaginas) ? " class='disabled' " : "") + ">");
		sb.append("			<a href='javascript:void(0);' " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada.equals(totalPaginas) ? "" : " onclick='" + functionName + "' data-page='" + (paginaSelecionada + 1) + "' ") + " aria-label='" + UtilI18N.internacionaliza(request, "citcorpore.comum.proximo") + "'>");
		sb.append("				<span aria-hidden='true'>&rsaquo;</span>");
		sb.append("			</a>");
		sb.append("		</li>");
		sb.append("		<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada.equals(totalPaginas) ? " class='disabled' " : "") + ">");
		sb.append("			<a href='javascript:void(0);' " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada.equals(totalPaginas) ? "" : " onclick='" + functionName + "' data-page='" + totalPaginas + "' ") + " aria-label='" + UtilI18N.internacionaliza(request, "citcorpore.comum.proximo") + "'>");
		sb.append("				<span aria-hidden='true'>&raquo;</span>");
		sb.append("			</a>");
		sb.append("		</li>");
		sb.append("	</ul>");
		sb.append("	<div class='clearfix'></div>");
		sb.append("</nav>");

		return sb.toString();
	}

	@SuppressWarnings("unchecked")
	public void loadMeusPedidos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();

		String habilitaPreco = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.HABILITA_PRECO_CARRINHO_PORTAL, "N");

		List<SmartPortalSolicitacaoDTO> solicitacoes = (List<SmartPortalSolicitacaoDTO>) request.getSession(true).getAttribute("solicitacoesPortal");

		if (solicitacoes != null && !solicitacoes.isEmpty()) {
			Double valorTotal = new Double(0.0);

			for (SmartPortalSolicitacaoDTO siteSolicitacaoDTO : solicitacoes) {
				ServicoDTO servicoDTO = new ServicoDTO();
				servicoDTO.setIdServico(siteSolicitacaoDTO.getIdServico());
				servicoDTO = getServicoService().restore(servicoDTO);

				ServicoContratoDTO servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(siteSolicitacaoDTO.getIdServico(), siteSolicitacaoDTO.getIdContrato());

				sb.append("<div class='row pedido' data-uuid='" + siteSolicitacaoDTO.getUuid() + "'>");
				sb.append("	<div class='col-md-12'>");

				sb.append("		<div class='card-list'>");
				sb.append("			<div class='row'>");
				sb.append("				<div class='" + (habilitaPreco.equalsIgnoreCase(SimNao.NAO.getValorStr()) ? "col-md-12" : "col-md-10 col-sm-10 col-xs-8") + "'>");
				sb.append("					<h4 class='card-title'>" + servicoDTO.getNomePortal() + "</h4>");

				if (servicoDTO.getDescricaoPortal() != null && !servicoDTO.getDescricaoPortal().isEmpty()) {
					sb.append("				<p class='card-text'>" + servicoDTO.getDescricaoPortal() + "</p>");
				}

				sb.append("					<div class='separator bottom'></div>");

				sb.append("					<label>" + UtilI18N.internacionaliza(request, "portal.carrinho.observacao") + "</label>");
				sb.append("					<p class='card-text'>" + siteSolicitacaoDTO.getSolicitacaoObservacao() + "</p>");

				Collection<UploadDTO> uploads = (Collection<UploadDTO>) request.getSession(true).getAttribute("uploadsPortal-" + siteSolicitacaoDTO.getUuid());

				if (uploads != null && !uploads.isEmpty()) {
					sb.append("				<div class='separator bottom'></div>");
					sb.append("				<label>" + UtilI18N.internacionaliza(request, "citcorpore.comum.anexos") + "</label>");
					sb.append("				<div class='card-anexos'>");
					for (UploadDTO uploadDTO : uploads) {
						sb.append("				<span class='label label-primary'>" + uploadDTO.getNameFile() + "</span>");
					}
					sb.append("				</div>");
				}

				sb.append("					<div class='separator bottom'></div>");

				sb.append("					<div class='card-acoes'>");
				sb.append("						<a onclick='MeusPedidos.remove(this);' href='javascript:void(0);'>" + UtilI18N.internacionaliza(request, "carrinho.excluir") + "</a>");
				sb.append("					</div>");
				sb.append("				</div>");

				if (habilitaPreco.equalsIgnoreCase(SimNao.SIM.getValorStr()) || habilitaPreco.equalsIgnoreCase(SimNao.SIM.getValorStrEn())) {
					sb.append("				<div class='col-md-2 col-sm-2 col-xs-4'>");
					sb.append("					<p class='text-right'>" + UtilFormatacao.formatDouble(servicoContratoDTO != null && servicoContratoDTO.getValorServico() != null ? servicoContratoDTO.getValorServico() : 0.0, 2) + "</p>");
					sb.append("				</div>");

					valorTotal += servicoContratoDTO != null && servicoContratoDTO.getValorServico() != null ? servicoContratoDTO.getValorServico() : 0.0;
				}

				sb.append("			</div>");
				sb.append("		</div>");

				sb.append("	</div>");
				sb.append("</div>");
			}

			sb.append("<div class='separator bottom'></div>");

			if (habilitaPreco.equalsIgnoreCase(SimNao.SIM.getValorStr()) || habilitaPreco.equalsIgnoreCase(SimNao.SIM.getValorStrEn())) {
				sb.append("<div class='row'>");
				sb.append("	<div class='col-md-12 text-right'>");
				sb.append("		<label>" + UtilI18N.internacionaliza(request, "itemPedidoCompra.valorTotal") + "</label>");
				sb.append("		<h3 class='m0'>" + UtilFormatacao.formatDouble(valorTotal, 2) + "</h3>");
				sb.append("	</div>");
				sb.append("</div>");
				sb.append("<div class='separator'></div>");
			}

			sb.append("<div class='row'>");
			sb.append("	<div class='col-md-12'>");
			sb.append("		<button type='button' class='btn btn-citsmart pull-right' onclick='MeusPedidos.save();'>" + (solicitacoes.size() > 1 ? UtilI18N.internacionaliza(request, "portal.concluirSolicitacoes") : UtilI18N.internacionaliza(request, "portal.concluirSolicitacao")) + "</button>");
			sb.append("	</div>");
			sb.append("</div>");
		} else {
			sb.append("<div class='row'><div class='col-md-12 text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div></div>");
		}

		document.executeScript("MeusPedidos.badge.update(" + (solicitacoes != null ? solicitacoes.size() : "0") + ");");

		HTMLElement minhasSolicitacoesContent = document.getElementById("meus-pedidos-content");
		minhasSolicitacoesContent.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@SuppressWarnings("unchecked")
	public void adicionaSolicitacaoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		try {
			SmartPortalSolicitacaoDTO siteSolicitacaoDTO = new SmartPortalSolicitacaoDTO();

			Reflexao.copyPropertyValues(siteDTO, siteSolicitacaoDTO);

			List<SmartPortalSolicitacaoDTO> solicitacoes = (List<SmartPortalSolicitacaoDTO>) request.getSession(true).getAttribute("solicitacoesPortal");

			if (solicitacoes == null) {
				solicitacoes = new ArrayList<>();
			}

			solicitacoes.add(siteSolicitacaoDTO);

			request.getSession(true).setAttribute("solicitacoesPortal", solicitacoes);

			document.executeScript("MeusPedidos.badge.update(" + solicitacoes.size() + ");");

			document.executeScript("$('#formAddServico #requestStatus').attr('value', true);");
		} catch (Exception e) {
			document.executeScript("$('#formAddServico #requestStatus').attr('value', false);");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@SuppressWarnings("unchecked")
	public void saveMeusPedidos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		StringBuilder sb = new StringBuilder();

		try {
			Collection<SolicitacaoServicoDTO> listSolicitacaoServicoDTO = new ArrayList<>();
			List<String> uuidSolicitacoesCriadas = new ArrayList<>();
			List<SmartPortalSolicitacaoDTO> solicitacoes = (List<SmartPortalSolicitacaoDTO>) request.getSession(true).getAttribute("solicitacoesPortal");

			if (solicitacoes != null && !solicitacoes.isEmpty()) {
				for (SmartPortalSolicitacaoDTO siteSolicitacaoDTO : solicitacoes) {
					ServicoDTO servicoDTO = new ServicoDTO();
					servicoDTO.setIdServico(siteSolicitacaoDTO.getIdServico());
					servicoDTO = getServicoService().restore(servicoDTO);

					ServicoContratoDTO servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(siteSolicitacaoDTO.getIdServico(), siteSolicitacaoDTO.getIdContrato());

					servicoContratoDTO.setIdServicoContrato(servicoContratoDTO.getIdServicoContrato());
					servicoContratoDTO = getServicoContratoService().restore(servicoContratoDTO);

					SolicitacaoServicoDTO solicitacaoServicoDTO = new SolicitacaoServicoDTO();

					solicitacaoServicoDTO.setDescricao(UtilStrings.getParameter((servicoContratoDTO.getDescricao() != null ? servicoContratoDTO.getDescricao() + "<br>" : "") + (siteSolicitacaoDTO.getSolicitacaoObservacao() != null ? siteSolicitacaoDTO.getSolicitacaoObservacao() : "")));
					solicitacaoServicoDTO.setIdContrato(servicoContratoDTO.getIdContrato());
					solicitacaoServicoDTO.setIdServico(servicoContratoDTO.getIdServico());

					solicitacaoServicoDTO.setEnviaEmailCriacao("S");

					Collection<UploadDTO> uploads = (Collection<UploadDTO>) request.getSession(true).getAttribute("uploadsPortal-" + siteSolicitacaoDTO.getUuid());
					solicitacaoServicoDTO.setColArquivosUpload(uploads);

					solicitacaoServicoDTO.setIdTipoDemandaServico(servicoDTO.getIdTipoDemandaServico());

					if (servicoContratoDTO.getIdGrupoExecutor() != null) {
						solicitacaoServicoDTO.setIdGrupoAtual(servicoContratoDTO.getIdGrupoExecutor());
					}

					try {
						solicitacaoServicoDTO.setIdOrigem(Integer.valueOf(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_PADRAO_SOLICITACAO, "0").trim()));
					} catch (Exception e) {
						solicitacaoServicoDTO.setIdOrigem(0);
					}

					solicitacaoServicoDTO.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());
					solicitacaoServicoDTO.setRegistroexecucao("");
					solicitacaoServicoDTO.setIdSolicitante(usuarioDTO.getIdEmpregado());
					solicitacaoServicoDTO.setUsuarioDto(usuarioDTO);
					solicitacaoServicoDTO.setRegistradoPor(usuarioDTO.getNomeUsuario());

					EmpregadoDTO empregadoDTO = getEmpregadoService().restoreByIdEmpregado(usuarioDTO.getIdEmpregado());
					solicitacaoServicoDTO.setIdUnidade(empregadoDTO.getIdUnidade());
					solicitacaoServicoDTO.setNomecontato(empregadoDTO.getNome());
					solicitacaoServicoDTO.setEmailcontato(empregadoDTO.getEmail());
					solicitacaoServicoDTO.setTelefonecontato(empregadoDTO.getTelefone());

					solicitacaoServicoDTO.setImpacto("B");
					solicitacaoServicoDTO.setUrgencia("B");

					if (servicoContratoDTO != null) {
						AcordoNivelServicoDTO acordoNivelServicoDTO = getAcordoNivelServicoService().findAtivoByIdServicoContrato(servicoContratoDTO.getIdServicoContrato(), "T");

						if (acordoNivelServicoDTO == null) {
							// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato, entao busca um acordo geral que esteja vinculado ao servicocontrato.
							AcordoServicoContratoDTO acordoServicoContratoDTO = getAcordoServicoContratoService().findAtivoByIdServicoContrato(servicoContratoDTO.getIdServicoContrato(), "T");

							if (acordoServicoContratoDTO != null) {
								// Apos achar a vinculacao do acordo com o servicocontrato, entao faz um restore do acordo de nivel de servico.
								acordoNivelServicoDTO = new AcordoNivelServicoDTO();
								acordoNivelServicoDTO.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
								acordoNivelServicoDTO = (AcordoNivelServicoDTO) new AcordoNivelServicoDao().restore(acordoNivelServicoDTO);

								if (acordoNivelServicoDTO != null) {
									if (acordoNivelServicoDTO.getImpacto() != null) {
										solicitacaoServicoDTO.setImpacto(acordoNivelServicoDTO.getImpacto());
									} else {
										solicitacaoServicoDTO.setImpacto("B");
									}

									if (acordoNivelServicoDTO.getUrgencia() != null) {
										solicitacaoServicoDTO.setUrgencia(acordoNivelServicoDTO.getUrgencia());
									} else {
										solicitacaoServicoDTO.setUrgencia("B");
									}
								}
							}
						}
					}

					SolicitacaoServicoQuestionarioDTO questionario = (SolicitacaoServicoQuestionarioDTO) request.getSession(true).getAttribute("dados_questionario_portal_" + siteSolicitacaoDTO.getUuid());
					solicitacaoServicoDTO.setSolicitacaoServicoQuestionarioDTO(questionario);

					listSolicitacaoServicoDTO.add(solicitacaoServicoDTO);
					uuidSolicitacoesCriadas.add(siteSolicitacaoDTO.getUuid());
				}
			}

			listSolicitacaoServicoDTO = getSolicitacaoServicoService(request).createList(listSolicitacaoServicoDTO);

			if (listSolicitacaoServicoDTO != null && !listSolicitacaoServicoDTO.isEmpty()) {
				sb.append("<div class='row'>");
				for (SolicitacaoServicoDTO solicitacaoServicoDTO : listSolicitacaoServicoDTO) {
					if (solicitacaoServicoDTO != null && solicitacaoServicoDTO.getIdSolicitacaoServico() != null) {
						sb.append("<div class='col-md-12'>");
						sb.append("	<div class='panel panel-default solicitacao-criada'>");
						sb.append("		<div class='panel-body'>");
						sb.append("			<div class='row'>");

						if (solicitacaoServicoDTO.getPrazoHH() > 0 || solicitacaoServicoDTO.getPrazoMM() > 0) {
							sb.append("				<div class='col-md-4 text-center'>");
							sb.append("					<span class='label-numero'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.numero") + "</span>");
							sb.append("					<h2 class='text-citsmart'>" + solicitacaoServicoDTO.getIdSolicitacaoServico() + "</h3>");
							sb.append("				</div>");
							sb.append("				<div class='col-md-4 text-center'>");
							sb.append("					<span class='label-numero'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.prioridade") + "</span>");
							sb.append("					<h2>" + UtilI18N.internacionaliza(request, DescricaoPrioridade.fromId(solicitacaoServicoDTO.getIdPrioridade()).getChave()) + "</h3>");
							sb.append("				</div>");
							sb.append("				<div class='col-md-4 text-center'>");
							sb.append("					<span class='label-numero'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.prazo") + "</span>");
							sb.append("					<h2>" + solicitacaoServicoDTO.getSLAStr() + "</h3>");
							sb.append("				</div>");
						} else {
							sb.append("				<div class='col-md-6 text-center'>");
							sb.append("					<span class='label-numero'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.numero") + "</span>");
							sb.append("					<h2 class='text-primary'>" + solicitacaoServicoDTO.getIdSolicitacaoServico() + "</h3>");
							sb.append("				</div>");
							sb.append("				<div class='col-md-6 text-center'>");
							sb.append("					<span class='label-numero'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.prioridade") + "</span>");
							sb.append("					<h2>" + UtilI18N.internacionaliza(request, DescricaoPrioridade.fromId(solicitacaoServicoDTO.getIdPrioridade()).getChave()) + "</h3>");
							sb.append("				</div>");
						}

						sb.append("			</div>");
						sb.append("		</div>");
						sb.append("	</div>");
						sb.append("</div>");
					}
				}
				sb.append("</div>");
			}

			try {
				if (uuidSolicitacoesCriadas != null && !uuidSolicitacoesCriadas.isEmpty()) {
					Iterator<SmartPortalSolicitacaoDTO> iterator = solicitacoes.iterator();
					while (iterator.hasNext()) {
						SmartPortalSolicitacaoDTO siteSolicitacaoSessaoDTO = iterator.next();

						if (uuidSolicitacoesCriadas.contains(siteSolicitacaoSessaoDTO.getUuid())) {
							iterator.remove();

							request.getSession(true).removeAttribute("uploadsPortal-" + siteSolicitacaoSessaoDTO.getUuid());
							request.getSession(true).removeAttribute("dados_questionario_portal_" + siteSolicitacaoSessaoDTO.getUuid());
						}
					}
				}

				request.getSession(true).setAttribute("solicitacoesPortal", solicitacoes);

				uuidSolicitacoesCriadas.clear();
			} catch (Exception e) {
			}

			HTMLElement solicitacoesCriadasContent = document.getElementById("solicitacoes-criadas-content");
			solicitacoesCriadasContent.setInnerHTML(sb.toString());

			document.executeScript("$('#formMeusPedidos #requestStatus').attr('value', true);");
		} catch (Exception e) {
			document.executeScript("$('#formMeusPedidos #requestStatus').attr('value', false);");

			if (e != null) {
				if (e.getCause() != null) {
					document.executeScript("$('#formMeusPedidos #requestMessage').attr('value', '" + (e.getCause().getMessage() != null ? e.getCause().getMessage() : "") + "');");
				} else {
					document.executeScript("$('#formMeusPedidos #requestMessage').attr('value', '" + (e.getMessage() != null ? e.getMessage() : "") + "');");
				}
			}
		}

		this.loadMeusPedidos(document, request, response);

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@SuppressWarnings("unchecked")
	public void removePedido(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		if (siteDTO.getUuid() != null && !siteDTO.getUuid().isEmpty()) {
			try {
				List<SmartPortalSolicitacaoDTO> solicitacoes = (List<SmartPortalSolicitacaoDTO>) request.getSession(true).getAttribute("solicitacoesPortal");

				if (solicitacoes != null && !solicitacoes.isEmpty()) {
					Iterator<SmartPortalSolicitacaoDTO> iterator = solicitacoes.iterator();
					while (iterator.hasNext()) {
						SmartPortalSolicitacaoDTO siteSolicitacaoDTO = iterator.next();
						if (siteSolicitacaoDTO.getUuid() != null && siteSolicitacaoDTO.getUuid().equalsIgnoreCase(siteDTO.getUuid())) {
							iterator.remove();
						}
					}
				}

				request.getSession(true).removeAttribute("uploadsPortal-" + siteDTO.getUuid());
				request.getSession(true).removeAttribute("dados_questionario_portal_" + siteDTO.getUuid());

				request.getSession(true).setAttribute("solicitacoesPortal", solicitacoes);

				document.executeScript("MeusPedidos.badge.update(" + solicitacoes.size() + ");");

				this.loadMeusPedidos(document, request, response);

				document.executeScript("$('#formMeusPedidos #requestStatus').attr('value', true);");
			} catch (Exception e) {
				document.executeScript("$('#formMeusPedidos #requestStatus').attr('value', false);");
			}
		} else {
			document.executeScript("$('#formMeusPedidos #requestStatus').attr('value', false);");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@SuppressWarnings("unchecked")
	public void carregaContratosPedido(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		List<ServicoContratoDTO> colServicoContratoDTO = (List<ServicoContratoDTO>) getServicoContratoService().findByIdServico(siteDTO.getIdServico());

		if (colServicoContratoDTO != null && !colServicoContratoDTO.isEmpty()) {
			HTMLSelect idContrato = document.getSelectById("idContrato");

			idContrato.removeAllOptions();

			for (ServicoContratoDTO servicoContratoDTO : colServicoContratoDTO) {
				servicoContratoDTO.setIdServicoContrato(servicoContratoDTO.getIdServicoContrato());
				servicoContratoDTO = getServicoContratoService().restore(servicoContratoDTO);

				ContratoDTO contratoDTO = new ContratoDTO();
				contratoDTO.setIdContrato(servicoContratoDTO.getIdContrato());
				contratoDTO = getContratoService().restore(contratoDTO);
				contratoDTO.setNome(this.tratarNomeContrato(contratoDTO, document.getLanguage()));

				idContrato.addOption(String.valueOf(servicoContratoDTO.getIdContrato()), contratoDTO.getNome());
			}

			idContrato.setSelectedIndex(0);

			if (colServicoContratoDTO.size() == 1) {
				document.executeScript("$('#formAddServico .contrato-select').addClass('dn';)");
			} else {
				document.executeScript("$('#formAddServico .contrato-select').removeClass('dn');");
			}
		}
	}

	public void loadMinhasSolicitacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		final int quantidadePorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));
		Integer paginaAtual = siteDTO.getPaginaAtualSolicitacoes() == null ? 1 : siteDTO.getPaginaAtualSolicitacoes();

		Pageable pageable = new PageRequest(paginaAtual - 1, quantidadePorPagina);

		int quantidadePaginasSolicitacoes = 0;

		final UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		GerenciamentoServicosDTO gerenciamentoServicosDTO = new GerenciamentoServicosDTO();
		gerenciamentoServicosDTO.setIdSolicitante(usuarioDTO.getIdEmpregado());
		gerenciamentoServicosDTO.setOrdenarPor("NSolicitacao");
		gerenciamentoServicosDTO.setDirecaoOrdenacao("desc");
		gerenciamentoServicosDTO.setPalavraChave(siteDTO.getPesquisaSolicitacoes());
		gerenciamentoServicosDTO.setPaginaSelecionada(paginaAtual);
		gerenciamentoServicosDTO.setItensPorPagina(quantidadePorPagina);

		if (ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.FILTRAR_SOLICITACAO_ANDAMENTO, "N").equals("S")) {
			gerenciamentoServicosDTO.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());
		}

		String locale = (String) request.getSession().getAttribute("locale");
		if (locale == null) {
			locale = "pt";
		}

		final StringBuilder sb = new StringBuilder();

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");
		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Page<SolicitacaoServicoDTO> solicitacoesPage = getSolicitacaoServicoService(request).paginacaoPortal(gerenciamentoServicosDTO, pageable, COLABORADORES_VINC_CONTRATOS);

		Collection<SolicitacaoServicoDTO> solicitacoes = solicitacoesPage.getContent();
		quantidadePaginasSolicitacoes = solicitacoesPage.getTotalPages();

		if (solicitacoes != null && !solicitacoes.isEmpty()) {
			for (SolicitacaoServicoDTO solicitacaoServicoDTO : solicitacoes) {
				// Faz o clculo da SLA
				String hh = "";
				String mm = "";
				if (solicitacaoServicoDTO.getIdContrato() != null || solicitacaoServicoDTO.getIdServico() != null) {

					hh = solicitacaoServicoDTO.getPrazoHH().toString();
					mm = solicitacaoServicoDTO.getPrazoMM().toString();
					/**
					 * Se os minutos forem 60, corrige o tempo
					 *
					 * @author thyen.chang
					 * @since 03/03/2015
					 */
					if (mm.equals("60")) {
						mm = "00";
						hh = new Integer(Integer.parseInt(hh) + 1).toString();
					}

					if (hh.length() == 1) {
						hh = "0" + hh;
					}
					if (mm.length() == 1) {
						mm = "0" + mm;
					}

				}

				String cssPrioridade = setarCssPrioridade(solicitacaoServicoDTO.getPrioridade());
				String cssPrazo = setarCssPrazo(solicitacaoServicoDTO);
				String situacaoSLA = "";

				if (solicitacaoServicoDTO.getSituacaoSLA().equalsIgnoreCase("N")) {
					situacaoSLA = UtilI18N.internacionaliza(request, "citcorpore.comum.naoIniciado");
				} else if (solicitacaoServicoDTO.getSituacaoSLA().equalsIgnoreCase("S")) {
					situacaoSLA = UtilI18N.internacionaliza(request, "citcorpore.comum.suspenso");
				}

				sb.append("<div class=\"box-generic\">");
				sb.append("<div class=\"content-row\">");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "citcorpore.comum.numero") + "</h5>");
				sb.append("		<span>" + solicitacaoServicoDTO.getIdSolicitacaoServico() + "</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipo") + "</h5>");
				sb.append("		<span class=\"" + (ServiceDemandType.INCIDENT.equals(ServiceDemandType.fromId(solicitacaoServicoDTO.getIdTipoDemandaServico())) ? "incidente" : "verde-negrito") + "\">");
				sb.append("		").append(UtilI18N.internacionaliza(request, ServiceDemandType.chaveFromId(solicitacaoServicoDTO.getIdTipoDemandaServico())));
				sb.append("		</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "citcorpore.comum.solicitacao") + "</h5>");
				sb.append("		<span class=\"servico\" title=\"" + solicitacaoServicoDTO.getServico() + "\">" + solicitacaoServicoDTO.getServico() + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "tempoAtendimento.descTempoAtendimento") + "</h5>");
				if ((solicitacaoServicoDTO.getPrazoHH().equals(0) || solicitacaoServicoDTO.getPrazoHH() == null) && (solicitacaoServicoDTO.getPrazoMM().equals(0) || solicitacaoServicoDTO.getPrazoMM() == null) && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					sb.append("		<span class=\"\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.aCombinar") + "</span>");
				} else if (!hh.equals("") && !mm.equals("") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					sb.append("		<span class= \"" + cssPrazo + "\"> " + hh + ":" + mm + " " + situacaoSLA + "</span>");
				} else {
					sb.append("		<span class= \"" + cssPrazo + "\"></span>");
				}
				sb.append("	</div>");

				if (!ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					if (!solicitacaoServicoDTO.getSituacaoSLA().equalsIgnoreCase("S") || solicitacaoServicoDTO.getAtrasoSLA() > 0) {
						sb.append("	<div class=\"content-item\">");
						sb.append("		<h5>" + UtilI18N.internacionaliza(request, "solicitacaoServico.prazoLimite") + "</h5>");
						sb.append("		<span class=\"" + cssPrazo + "\">" + UtilStrings.nullToVazio(solicitacaoServicoDTO.obterDataHoraLimiteStrWithLanguage(locale)) + "</span>");
						sb.append("	</div>");
					}
				}

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "solicitacaoServico.prioridade") + "</h5>");
				sb.append("		<span class=\"" + cssPrioridade + "\">" + solicitacaoServicoDTO.getPrioridade() + "</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "solicitacaoServico.situacao") + "</h5>");
				sb.append("		<span>" + UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServicoDTO.getIdStatus())) + "</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "requisitosla.contrato") + "</h5>");
				sb.append("		<span title=\"" + solicitacaoServicoDTO.getContrato() + "\">" + solicitacaoServicoDTO.getContrato() + "</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(request, "solicitacaoServico.dataHoraCriacao") + "</h5>");
				sb.append("		<span class=\"verde-negrito\">" + solicitacaoServicoDTO.obterDataHoraSolicitacaoStrWithLanguage(locale) + "</span>");
				sb.append("	</div>");

				if (solicitacaoServicoDTO.getAtrasoSLA() > 0 && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(request, "tarefa.atraso") + "</h5>");
					sb.append("		<span class=\"" + cssPrazo + "\">" + solicitacaoServicoDTO.getAtrasoSLAStr() + "</span>");
					sb.append("	</div>");
				}

				sb.append("	<div class=\"clearfix\"></div>");
				sb.append("</div>");
				sb.append("<div class=\"separator bottom\"></div>");

				sb.append("<div class=\"row\">");
				sb.append("	<div class=\"col-md-3 col-sm-3 col-xs-3\">");
				sb.append("		<button type=\"button\" class=\"btn btn-default solicitacao-mostrar-mais-detalhes\"><i class=\"material-icons md-16\">expand_more</i></button>");
				sb.append("	</div>");
				sb.append("	<div class=\"col-md-9 col-sm-9 col-xs-9 text-right\">");

				String paramRegistrarOcorrenciaPortal =  ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.REGISTRAR_OCORRENCIA_PELO_PORTAL, "N");

				if ((ServiceRequestStatus.IN_PROGRESS.getId().equals(solicitacaoServicoDTO.getIdStatus()) || ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) && paramRegistrarOcorrenciaPortal.equalsIgnoreCase("S")) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "portal.gerenciaservico.registrarOcorrencia") + "\" data-toggle='modal' data-target='#modal-registro-ocorrencia' onclick='MinhasSolicitacoes.ocorrencia.open(" + solicitacaoServicoDTO.getIdSolicitacaoServico() + ");'><i class=\"material-icons md-16\">playlist_add</i></button>");
				}

				if (ServiceRequestStatus.CLOSED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
					OpiniaoDTO opiniaoDTO = getOpiniaoService().findByIdSolicitacao(solicitacaoServicoDTO.getIdSolicitacaoServico());
					if (opiniaoDTO == null) {
						sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "portal.gerenciaservico.registraropiniao") + "\" data-toggle='modal' data-target='#modal-registro-opiniao' onclick='MinhasSolicitacoes.opiniao.open(" + solicitacaoServicoDTO.getIdSolicitacaoServico() + ");'><i class=\"material-icons md-16\">feedback</i></button>");
					}

					ArrayList<PesquisaSatisfacaoDTO> listPesquisaSatisfacaoDTO = (ArrayList<PesquisaSatisfacaoDTO>) getPesquisaSatisfacaoService().getPesquisaByIdSolicitacao(solicitacaoServicoDTO.getIdSolicitacaoServico());
					if (listPesquisaSatisfacaoDTO == null || listPesquisaSatisfacaoDTO.isEmpty()) {
						sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "portal.gerenciaservico.pesquisasatisfacao") + "\" data-toggle='modal' data-target='#modal-pesquisa-satisfacao' onclick='MinhasSolicitacoes.pesquisaSatisfacao.open(" + solicitacaoServicoDTO.getIdSolicitacaoServico() + ");'><i class=\"material-icons md-16\">thumbs_up_down</i></button>");
					}
				}

				sb.append("	</div>");
				sb.append("</div>");

				sb.append("</div>");
				sb.append("<div class=\"separator bottom\"></div>");
			}
		}

		sb.append(geraPaginacao(quantidadePaginasSolicitacoes, paginaAtual, request, "MinhasSolicitacoes.load(this);"));

		HTMLElement solicitacaoContent = document.getElementById("content-solicitacao");
		solicitacaoContent.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public Collection<TarefaFluxoDTO> listarTarefas(Integer itensPorPagina, Integer paginaSelecionada, UsuarioDTO usuario, HttpServletRequest request, boolean grafico, GerenciamentoServicosDTO gerenciamento) throws Exception {

		List<TarefaFluxoDTO> colTarefas = null;
		List<SolicitacaoServicoDTO> listSolicitacaoServico = new ArrayList<>();

		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratoDTO> listContratoUsuarioLogado = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoUsuarioLogado = this.getContratoService().findAtivosByIdEmpregado(usuario.getIdEmpregado());
		} else {
			listContratoUsuarioLogado = this.getContratoService().listAtivos();
		}

		if (!grafico) {
			/** Chamada do mtodo recuperaTarefas otimizado. Operao Usain Bolt - 27.01.2015 - carlos.santos */
			final ParamRecuperacaoTarefasDTO param = new ParamRecuperacaoTarefasDTO(usuario.getLogin(), gerenciamento, listContratoUsuarioLogado);
			final Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);
			final Page<TarefaFluxoDTO> resultPage = this.getExecucaoSolicitacaoService().recuperaTarefas(param, pageable);
			colTarefas = resultPage.getContent();
		} else {
			colTarefas = this.getExecucaoSolicitacaoService().recuperaTarefas(usuario.getLogin(), gerenciamento, listContratoUsuarioLogado);
		}

		List<TarefaFluxoDTO> colTarefasFiltradasFinal = new ArrayList<>();

		if (colTarefas != null && !colTarefas.isEmpty()) {
			boolean asc = true;
			for (TarefaFluxoDTO tarefaDto : colTarefas) {
				SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) tarefaDto.getSolicitacaoDto();
				listSolicitacaoServico.add(solicitacaoServicoDto);
				solicitacaoServicoDto.setDataHoraLimiteToString(""); // Apenas forca atualizacao
				solicitacaoServicoDto.setDataHoraSolicitacaoToString(""); // Apenas forca atualizacao
				solicitacaoServicoDto.setDescricaoSemFormatacao(Util.tratarAspasSimples(UtilStrings.nullToNaoDisponivel(solicitacaoServicoDto.getDescricaoSemFormatacao())));
				solicitacaoServicoDto.setDescricaoForTitle(Util.tratarAspasSimples(solicitacaoServicoDto.getDescricao()));
				solicitacaoServicoDto.setDescricao(Util.tratarAspasSimples(solicitacaoServicoDto.getDescricao()));// tratamento para Aspas Simples
				solicitacaoServicoDto.setDescricao(Util.converterHtmlQuadro(solicitacaoServicoDto.getDescricao())); // tratamento para codigo html
				solicitacaoServicoDto.setDescricao(Util.converterCaracteresInadequadosParaTexto(solicitacaoServicoDto.getDescricao())); // tratamento de caracteres inadequados para texto
				solicitacaoServicoDto.setResposta("");
				solicitacaoServicoDto.setDetalhamentoCausa("");
				if (solicitacaoServicoDto.getSlaACombinar() == null) {
					solicitacaoServicoDto.setSlaACombinar("N");
				}
				int prazoHH = 0;
				int prazoMM = 0;

				if (solicitacaoServicoDto.getPrazoHH() != null) {
					prazoHH = solicitacaoServicoDto.getPrazoHH();
				}
				if (solicitacaoServicoDto.getPrazoMM() != null) {
					prazoMM = solicitacaoServicoDto.getPrazoMM();
				}
				if (prazoHH == 0 && prazoMM == 0) {
					solicitacaoServicoDto.setSlaACombinar("S");
					solicitacaoServicoDto.setAtrasoSLA(0);
					solicitacaoServicoDto.setAtrasoSLAStr("");
					solicitacaoServicoDto.setDataHoraLimiteStr("");
				}
				if (solicitacaoServicoDto.getSlaACombinar().equalsIgnoreCase("S")) {
					solicitacaoServicoDto.setDataHoraLimite(null);
					solicitacaoServicoDto.setAtrasoSLA(0);
					solicitacaoServicoDto.setAtrasoSLAStr("");
					if (asc) {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), 10, Calendar.YEAR).getTime()));
					} else {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), -10, Calendar.YEAR).getTime()));
					}
				}
				if (ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					solicitacaoServicoDto.setDataHoraLimite(null);
					solicitacaoServicoDto.setAtrasoSLA(0);
					solicitacaoServicoDto.setAtrasoSLAStr("");
					if (asc) {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), 10, Calendar.YEAR).getTime()));
					} else {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), -10, Calendar.YEAR).getTime()));
					}
				}

				if (solicitacaoServicoDto.getSolicitanteUnidade() != null && StringUtils.isNotBlank(solicitacaoServicoDto.getSolicitanteUnidade())) {
					solicitacaoServicoDto.setSolicitante(""); // pra nao enviar no JSON
				} else {
					if (solicitacaoServicoDto.getSolicitante() != null && StringUtils.isNotBlank(solicitacaoServicoDto.getSolicitante())) {
						solicitacaoServicoDto.setSolicitanteUnidade(Util.tratarAspasSimples(solicitacaoServicoDto.getSolicitante()));
					} else {
						solicitacaoServicoDto.setSolicitanteUnidade(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
					}
				}
				colTarefasFiltradasFinal.add(tarefaDto);
			}
		}

		return colTarefasFiltradasFinal;
	}

	/**
	 * @param solicitacaoServicoDTO
	 * @throws Exception
	 *             Seta o css (cor) em "prioridade" alterando a cor de acordo com a mesma
	 * **/
	private String setarCssPrioridade(String prioridade) throws Exception {
		String cssPrioridade = "";
		if (prioridade.equalsIgnoreCase("1") || prioridade.equalsIgnoreCase("2")) {
			cssPrioridade = "prioridade Alta";
		}
		if (prioridade.equalsIgnoreCase("3")) {
			cssPrioridade = "prioridade Media";
		}
		if (prioridade.equalsIgnoreCase("4") || prioridade.equalsIgnoreCase("5")) {
			cssPrioridade = "prioridade Baixa";
		}
		return cssPrioridade;
	}

	/**
	 * @param solicitacaoServicoDTO
	 * @throws Exception
	 *             Seta o css (cor) em "prazo limite" do box mostrando se est norma, suspensa, vencido ou menos de 1 hora p/ vencer
	 **/
	private String setarCssPrazo(SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
		String cssPrioridade = "";
		if (solicitacaoServicoDTO.getAtrasoSLA() > 0 && !ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
			if (solicitacaoServicoDTO.getDataHoraLimite() != null) {
				Timestamp dataHoraLimite = solicitacaoServicoDTO.getDataHoraLimite();
				Timestamp dataHoraComparacao = UtilDatas.getDataHoraAtual();
				if (solicitacaoServicoDTO.encerrada()) {
					dataHoraComparacao = solicitacaoServicoDTO.getDataHoraFim();
				}
				if (dataHoraComparacao != null) {
					if (dataHoraComparacao.compareTo(dataHoraLimite) > 0) {
						cssPrioridade = "prazoVencido";

					}
				}
			}
		} else {
			if (solicitacaoServicoDTO.getFalta1Hora() == true) {
				cssPrioridade = "prazoAVencer";
			} else {
				cssPrioridade = "prazoNormal";
			}
		}
		return cssPrioridade;
	}

	/**
	 * Verificar se o servico da solicitacao e critico
	 *
	 * @param solicitacaoServicoDTO
	 * @param request
	 * @return
	 */
	private boolean verificarIncidenteCritico(SolicitacaoServicoDTO solicitacaoServicoDTO, HttpServletRequest request) {
		if (solicitacaoServicoDTO.getIdSolicitacaoServico() == null || solicitacaoServicoDTO.getIdServico() == null) {
			return false;
		}

		ServicoDTO servicoCritico;
		try {
			servicoCritico = getServicoService().findById(solicitacaoServicoDTO.getIdServico());

			if (servicoCritico != null && servicoCritico.getIncidenteCritico() != null && servicoCritico.getIncidenteCritico().equalsIgnoreCase("S")) {
				return true;
			}

		} catch (Exception e) {
			return false;
		}

		return false;
	}

	private String tratarNomeContrato(final ContratoDTO contratoDto, final String language) throws Exception {
		String nomeCliente = "";
		String nomeFornecedor = "";

		ClienteDTO clienteDto = new ClienteDTO();

		clienteDto.setIdCliente(contratoDto.getIdCliente());

		clienteDto = (ClienteDTO) this.getClienteService().restore(clienteDto);

		if (clienteDto != null) {
			nomeCliente = clienteDto.getNomeRazaoSocial();
		}

		FornecedorDTO fornecedorDto = new FornecedorDTO();

		fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

		fornecedorDto = (FornecedorDTO) this.getFornecedorService().restore(fornecedorDto);

		if (fornecedorDto != null) {
			nomeFornecedor = fornecedorDto.getRazaoSocial();
		}

		final String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), language) + " (" + nomeCliente + " - " + nomeFornecedor + ")";

		return nomeContrato;
	}

	public void carregaRegistroOcorrencia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		String idCategoriaRegistroOcorrencia = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_CATEGORIA_REGISTRA_OCORRENCIA_PORTAL, "");
		String idOrigemRegistroOcorrencia = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_ORIGEM_REGISTRA_OCORRENCIA_PORTAL, "");

		if (idCategoriaRegistroOcorrencia != null && !idCategoriaRegistroOcorrencia.isEmpty()) {
			document.getElementById("idCategoriaOcorrencia").setValue(idCategoriaRegistroOcorrencia);

			CategoriaOcorrenciaDTO categoriaOcorrenciaDTO = new CategoriaOcorrenciaDTO();
			categoriaOcorrenciaDTO.setIdCategoriaOcorrencia(Integer.parseInt(idCategoriaRegistroOcorrencia));
			categoriaOcorrenciaDTO = getCategoriaOcorrenciaService().restore(categoriaOcorrenciaDTO);

			if (categoriaOcorrenciaDTO != null) {
				document.getElementById("nomeCategoriaOcorrencia").setValue(categoriaOcorrenciaDTO.getNome());
			}
		}

		if (idOrigemRegistroOcorrencia != null && !idOrigemRegistroOcorrencia.isEmpty()) {
			document.getElementById("idOrigemOcorrencia").setValue(idOrigemRegistroOcorrencia);

			OrigemOcorrenciaDTO origemOcorrenciaDTO = new OrigemOcorrenciaDTO();
			origemOcorrenciaDTO.setIdOrigemOcorrencia(Integer.parseInt(idOrigemRegistroOcorrencia));
			origemOcorrenciaDTO = getOrigemOcorrenciaService().restore(origemOcorrenciaDTO);

			if (origemOcorrenciaDTO != null) {
				document.getElementById("nomeOrigemOcorrencia").setValue(origemOcorrenciaDTO.getNome());
			}
		}

		SolicitacaoServicoDTO solicitacaoServicoDTO = getSolicitacaoServicoService(request).restoreAll(siteDTO.getIdSolicitacaoOcorrencia());

		if (solicitacaoServicoDTO != null) {
			StringBuilder informacoesContato = new StringBuilder();

			if (solicitacaoServicoDTO.getSolicitante() != null && !solicitacaoServicoDTO.getSolicitante().trim().isEmpty()) {
				informacoesContato.append(UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + ": " + solicitacaoServicoDTO.getSolicitante() + "\\n");
			}

			if (solicitacaoServicoDTO.getTelefonecontato() != null && !solicitacaoServicoDTO.getTelefonecontato().trim().isEmpty()) {
				informacoesContato.append(UtilI18N.internacionaliza(request, "citcorpore.comum.telefone") + ": " + solicitacaoServicoDTO.getTelefonecontato() + "\\n");
			}

			if (solicitacaoServicoDTO.getEmailResponsavel() != null && !solicitacaoServicoDTO.getEmailResponsavel().trim().isEmpty()) {
				informacoesContato.append(UtilI18N.internacionaliza(request, "citcorpore.comum.email") + ": " + solicitacaoServicoDTO.getEmailResponsavel() + "\\n");
			}

			document.executeScript("$('#formRegistroOcorrencia #informacoesContatoOcorrencia').val('" + informacoesContato.toString() + "');");
		}
	}

	public void saveRegistroOcorrencia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		OcorrenciaSolicitacaoDTO ocorrenciaSolicitacaoDTO = new OcorrenciaSolicitacaoDTO();
		ocorrenciaSolicitacaoDTO.setDataInicio(UtilDatas.getDataAtual());
		ocorrenciaSolicitacaoDTO.setRegistradopor(usuarioDTO.getNomeUsuario());
		ocorrenciaSolicitacaoDTO.setDataregistro(UtilDatas.getDataAtual());
		ocorrenciaSolicitacaoDTO.setHoraregistro(UtilDatas.formatHoraFormatadaStr(UtilDatas.getHoraAtual()));
		ocorrenciaSolicitacaoDTO.setIdSolicitacaoServico(siteDTO.getIdSolicitacaoOcorrencia());
		ocorrenciaSolicitacaoDTO.setIdCategoriaOcorrencia(siteDTO.getIdCategoriaOcorrencia());
		ocorrenciaSolicitacaoDTO.setIdOrigemOcorrencia(siteDTO.getIdOrigemOcorrencia());
		ocorrenciaSolicitacaoDTO.setDescricao("citcorpore.comum.registroDaSolicitacao");
		ocorrenciaSolicitacaoDTO.setOcorrencia(siteDTO.getOcorrencia());
		ocorrenciaSolicitacaoDTO.setInformacoesContato(siteDTO.getInformacoesContatoOcorrencia());
		ocorrenciaSolicitacaoDTO.setNotificarResponsavel(siteDTO.getNotificarResponsavelOcorrencia());
		ocorrenciaSolicitacaoDTO.setTempoGasto(0);

		ocorrenciaSolicitacaoDTO = getOcorrenciaSolicitacaoService().create(ocorrenciaSolicitacaoDTO);

		OrigemOcorrenciaDTO origemOcorrenciaDTO = new OrigemOcorrenciaDTO();
		origemOcorrenciaDTO.setIdOrigemOcorrencia(ocorrenciaSolicitacaoDTO.getIdOrigemOcorrencia());
		origemOcorrenciaDTO = (OrigemOcorrenciaDTO) getOrigemOcorrenciaService().restore(origemOcorrenciaDTO);

		ocorrenciaSolicitacaoDTO.setOrigem(origemOcorrenciaDTO.getNome());

		try {
			Integer idModeloEmailNotificacaoResponsavel = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_EMAIL_REGISTRO_OCORRENCIA_PELO_PORTAL, "0"));

			if (idModeloEmailNotificacaoResponsavel != null && idModeloEmailNotificacaoResponsavel > 0) {
				if (ocorrenciaSolicitacaoDTO.getNotificarResponsavel() != null && ocorrenciaSolicitacaoDTO.getNotificarResponsavel().equalsIgnoreCase("S")) {
					enviaEmailResponsavel(idModeloEmailNotificacaoResponsavel, ocorrenciaSolicitacaoDTO, request);
				}
			}
		} catch (NumberFormatException e) {
		}

		document.executeScript("$('#formRegistroOcorrencia #requestStatus').attr('value', true);");
	}

	public void saveRegistroOpiniao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		OpiniaoDTO opiniao = new OpiniaoDTO();

		opiniao.setTipo(siteDTO.getTipoOpiniao());
		opiniao.setObservacoes(siteDTO.getObservacoesOpiniao());
		opiniao.setIdSolicitacao(siteDTO.getIdSolicitacaoOpiniao());
		opiniao.setIdUsuario(usuarioDTO.getIdUsuario());
		opiniao.setData(UtilDatas.getDataAtual());
		opiniao.setHora(UtilDatas.getDataHoraAtual());

		opiniao = getOpiniaoService().create(opiniao);

		document.executeScript("$('#formRegistroOpiniao #requestStatus').attr('value', true);");

		this.loadMinhasSolicitacoes(document, request, response);
	}

	public void carregaPesquisaSatisfacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		SolicitacaoServicoDTO solicitacaoServicoDTO = new SolicitacaoServicoDTO();

		solicitacaoServicoDTO.setIdSolicitacaoServico(siteDTO.getIdSolicitacaoPesquisaSatisfacao());

		solicitacaoServicoDTO = (SolicitacaoServicoDTO) this.getSolicitacaoServicoService(request).restore(solicitacaoServicoDTO);

		if (solicitacaoServicoDTO != null) {
			document.getElementById("codigoDataAberturaPesquisaSatisfacao").setInnerHTML("" + solicitacaoServicoDTO.getIdSolicitacaoServico() + " - " + formataDataHora(solicitacaoServicoDTO.getDataHoraSolicitacao()));
			document.getElementById("descricaoPesquisaSatisfacao").setInnerHTML(solicitacaoServicoDTO.getDescricao());
			document.getElementById("respostaPesquisaSatisfacao").setInnerHTML(UtilStrings.unescapeJavaString(solicitacaoServicoDTO.getResposta()));

			HTMLSelect notaPesquisaSatisfacao = document.getSelectById("notaPesquisaSatisfacao");
			notaPesquisaSatisfacao.removeAllOptions();

			notaPesquisaSatisfacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			for (Enumerados.Nota nota : Enumerados.Nota.values()) {
				notaPesquisaSatisfacao.addOption(nota.getNota().toString(), UtilI18N.internacionaliza(request, nota.getChaveInternacionalizacao()));
			}
		}
	}

	public void savePesquisaSatisfacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		boolean avaliacaoRuimOuRegular = siteDTO.getNotaPesquisaSatisfacao() == Enumerados.Nota.RUIM.getNota().intValue() || siteDTO.getNotaPesquisaSatisfacao() == Enumerados.Nota.REGULAR.getNota().intValue();

		PesquisaSatisfacaoDTO pesquisaSatisfacaoDTO = new PesquisaSatisfacaoDTO();

		pesquisaSatisfacaoDTO.setIdSolicitacaoServico(siteDTO.getIdSolicitacaoPesquisaSatisfacao());
		pesquisaSatisfacaoDTO.setNota(siteDTO.getNotaPesquisaSatisfacao());
		pesquisaSatisfacaoDTO.setComentario(siteDTO.getComentarioPesquisaSatisfacao());

		pesquisaSatisfacaoDTO = this.getPesquisaSatisfacaoService().create(pesquisaSatisfacaoDTO);

		if (avaliacaoRuimOuRegular) {
			String idModeloEmailAvisarPesquisaSatisfacaoRuimOuRegular = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR, "54");

			Map<String, String> map = new HashMap<>();

			if (pesquisaSatisfacaoDTO.getNota() == Enumerados.Nota.RUIM.getNota().intValue()) {
				map.put("NOTA", Enumerados.Nota.RUIM.getDescricao());
			} else {
				map.put("NOTA", Enumerados.Nota.REGULAR.getDescricao());
			}

			SolicitacaoServicoDTO solicitacaoServico = getSolicitacaoServicoService(request).restoreAll(pesquisaSatisfacaoDTO.getIdSolicitacaoServico());
			ContatoSolicitacaoServicoDTO contatoSolicitacaoServicoDTO = new ContatoSolicitacaoServicoDTO();
			contatoSolicitacaoServicoDTO.setIdcontatosolicitacaoservico(solicitacaoServico.getIdContatoSolicitacaoServico());
			contatoSolicitacaoServicoDTO = (ContatoSolicitacaoServicoDTO) getContatoSolicitacaoServicoService().restore(contatoSolicitacaoServicoDTO);

			map.put("USUARIO", contatoSolicitacaoServicoDTO.getNomecontato());
			map.put("IDSOLICITACAOSERVICO", pesquisaSatisfacaoDTO.getIdSolicitacaoServico().toString());
			map.put("COMENTARIO", pesquisaSatisfacaoDTO.getComentario());

			try {
				String idGrupoAvisarPesquisaSatisfacaoRuimOuRegular = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR, "");

				if (idGrupoAvisarPesquisaSatisfacaoRuimOuRegular != null && !idGrupoAvisarPesquisaSatisfacaoRuimOuRegular.isEmpty()) {
					Collection<GrupoEmpregadoDTO> grupoEmpregados = getGrupoEmpregadoService().findByIdGrupo(Integer.parseInt(idGrupoAvisarPesquisaSatisfacaoRuimOuRegular));

					MensagemEmail mensagem;
					EmpregadoDTO empregado;

					for (GrupoEmpregadoDTO grupoEmpregado : grupoEmpregados) {
						mensagem = new MensagemEmail(Integer.parseInt(idModeloEmailAvisarPesquisaSatisfacaoRuimOuRegular), map);

						empregado = new EmpregadoDTO();
						empregado.setIdEmpregado(grupoEmpregado.getIdEmpregado());
						empregado = getEmpregadoService().restoreEmpregadoSeAtivo(empregado);

						if (empregado != null && empregado.getEmail() != null && !empregado.getEmail().trim().equalsIgnoreCase("")) {
							mensagem.envia(empregado.getEmail(), "", ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, "10"));
						}
					}
				}
			} catch (Exception e) {
				System.out.println(UtilStrings.fixEncoding("Erro na verificao da Nota Ruim/Regular para envio de e-mail para o grupo parametrizado:\n" + e.getMessage()));
			}
		}

		document.executeScript("$('#formPesquisaSatisfacao #requestStatus').attr('value', true);");

		this.loadMinhasSolicitacoes(document, request, response);
	}

	public void saveAvaliacaoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (usuarioDTO == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		SmartPortalDTO siteDTO = (SmartPortalDTO) document.getBean();

		AvaliacaoServicoDTO avaliacaoServicoDTO = new AvaliacaoServicoDTO();
		avaliacaoServicoDTO.setIdUsuario(usuarioDTO.getIdUsuario());
		avaliacaoServicoDTO.setIdServico(siteDTO.getIdServicoAvaliacao());
		avaliacaoServicoDTO.setNota(siteDTO.getNotaAvaliacao());
		avaliacaoServicoDTO.setComentario(siteDTO.getComentarioAvaliacao());
		avaliacaoServicoDTO.setDataInicio(UtilDatas.getDataAtual());

		avaliacaoServicoDTO = getAvaliacaoServicoService().create(avaliacaoServicoDTO);

		if (avaliacaoServicoDTO != null && avaliacaoServicoDTO.getIdAvaliacaoServico() != null) {
			document.executeScript("$('#formAvaliacaoServico #requestStatus').attr('value', true);");
		} else {
			document.executeScript("$('#formAvaliacaoServico #requestStatus').attr('value', false);");
		}
	}

	private String formataDataHora(Timestamp dateDate) {
		SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
		return df.format(dateDate);
	}

	private void enviaEmailResponsavel(Integer idModeloEmail, OcorrenciaSolicitacaoDTO ocorrenciaSolicitacaoDTO, HttpServletRequest request) throws Exception {
		MensagemEmail mensagem = null;

		if (idModeloEmail == null || idModeloEmail.intValue() == 0) {
			System.out.println("ID Modelo de Email no configurado");
			return;
		}

		SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		SolicitacaoServicoDTO solicitacaoServicoDTO = solicitacaoServicoService.restoreAll(ocorrenciaSolicitacaoDTO.getIdSolicitacaoServico());

		if (solicitacaoServicoDTO == null) {
			System.out.println("Solicitao no existe");
			return;
		}

		Collection<String> emails = obteDestinatariosOcorrencia(ocorrenciaSolicitacaoDTO);
		Map<String, String> mapParametros = new HashMap<>();

		mapParametros.put("IDSOLICITACAOSERVICO", String.valueOf(ocorrenciaSolicitacaoDTO.getIdSolicitacaoServico()));
		mapParametros.put("DATAHORA", new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date()));
		mapParametros.put("REGISTRADOPOR", ocorrenciaSolicitacaoDTO.getRegistradopor());

		CategoriaOcorrenciaDTO categoriaOcorrenciaDTO = new CategoriaOcorrenciaDTO();
		categoriaOcorrenciaDTO.setIdCategoriaOcorrencia(ocorrenciaSolicitacaoDTO.getIdCategoriaOcorrencia());
		categoriaOcorrenciaDTO = (CategoriaOcorrenciaDTO) getCategoriaOcorrenciaService().restore(categoriaOcorrenciaDTO);

		mapParametros.put("CATEGORIA", categoriaOcorrenciaDTO.getNome());
		mapParametros.put("ORIGEM", ocorrenciaSolicitacaoDTO.getOrigem());
		mapParametros.put("OCORRENCIAS", ocorrenciaSolicitacaoDTO.getOcorrencia());

		ocorrenciaSolicitacaoDTO.setInformacoesContato(ocorrenciaSolicitacaoDTO.getInformacoesContato().replace("\n", "<br>"));
		ocorrenciaSolicitacaoDTO.setInformacoesContato("<br>" + ocorrenciaSolicitacaoDTO.getInformacoesContato());
		mapParametros.put("INFORMACOESCONTATO", ocorrenciaSolicitacaoDTO.getInformacoesContato());
		mapParametros.put("DESCRICAO", ocorrenciaSolicitacaoDTO.getDescricao());

		try {
			for (String email : emails) {
				String remetente = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, null);

				if (remetente == null) {
					System.out.println("Remetente no definido.");
					return;
				}

				mensagem = new MensagemEmail(idModeloEmail, mapParametros);
				mensagem.envia(email, null, remetente);
			}

		} catch (Exception e) {
			System.out.println("Erro ao envia o email: ");
			e.printStackTrace();
		}
	}

	private Collection<String> obteDestinatariosOcorrencia(final OcorrenciaSolicitacaoDTO ocorrencia) throws ServiceException, Exception {
		DadosEmailRegOcorrenciaDTO dadosEmail = getOcorrenciaService().obterDadosResponsavelEmailRegOcorrencia(ocorrencia.getIdSolicitacaoServico());

		Collection<String> destinatarios = new ArrayList<>();

		if (dadosEmail != null) {
			if (dadosEmail.getIdResponsavelAtual() != null) {
				destinatarios.add(dadosEmail.getEmail());
			}

			if (dadosEmail.getIdGrupoAtual() != null) {
				Collection<String> emailsGrupo = getGrupoService().listarEmailsPorGrupo(dadosEmail.getIdGrupoAtual());
				destinatarios.addAll(emailsGrupo);
			}
		}

		if (destinatarios == null || destinatarios.isEmpty()) {
			ServicoContratoDTO servicoContratoDTO = servicoContratoService.findByIdSolicitacaoServico(ocorrencia.getIdSolicitacaoServico());

			if (servicoContratoDTO.getIdGrupoNivel1() != null) {
				Collection<String> emailNivel1 = getGrupoService().listarEmailsPorGrupo(servicoContratoDTO.getIdGrupoNivel1());
				destinatarios.clear();
				destinatarios.addAll(emailNivel1);
			}

			if (servicoContratoDTO.getIdGrupoNivel1() == null && servicoContratoDTO.getIdGrupoExecutor() != null) {
				Collection<String> emailGrupoExecutor = getGrupoService().listarEmailsPorGrupo(servicoContratoDTO.getIdGrupoExecutor());
				destinatarios.clear();
				destinatarios.addAll(emailGrupoExecutor);
			}

			if (servicoContratoDTO.getIdGrupoNivel1() == null && servicoContratoDTO.getIdGrupoExecutor() == null) {
				Integer idGrupoPadraoNivel1 = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, "0"));
				Collection<String> emailPadraoNivel1 = getGrupoService().listarEmailsPorGrupo(idGrupoPadraoNivel1);
				destinatarios.clear();
				destinatarios.addAll(emailPadraoNivel1);
			}
		}

		return destinatarios;
	}

	@Override
	public Class<SmartPortalDTO> getBeanClass() {
		return SmartPortalDTO.class;
	}

	private BaseConhecimentoService getBaseConhecimentoService() throws ServiceException {
		if (baseConhecimentoService == null) {
			baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
		}
		return baseConhecimentoService;
	}

	private ComentariosService getComentariosService() throws ServiceException {
		if (comentariosService == null) {
			comentariosService = (ComentariosService) ServiceLocator.getInstance().getService(ComentariosService.class, null);
		}
		return comentariosService;
	}

	private PastaService getPastaService() throws ServiceException {
		if (pastaService == null) {
			pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
		}
		return pastaService;
	}

	private PerfilAcessoPastaService getPerfilAcessoPastaService() throws ServiceException {
		if (perfilAcessoPastaService == null) {
			perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);
		}
		return perfilAcessoPastaService;
	}

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private PortfolioServicoService getPortfolioServicoService() throws ServiceException {
		if (portfolioServicoService == null) {
			portfolioServicoService = (PortfolioServicoService) ServiceLocator.getInstance().getService(PortfolioServicoService.class, null);
		}
		return portfolioServicoService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private ServicoContratoService getServicoContratoService() throws ServiceException {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	private QuestionarioService getQuestionarioService() throws ServiceException {
		if (questionarioService == null) {
			questionarioService = (QuestionarioService) ServiceLocator.getInstance().getService(QuestionarioService.class, null);
		}
		return questionarioService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService(HttpServletRequest request) throws Exception {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));
		}
		return solicitacaoServicoService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws ServiceException {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	private AcordoServicoContratoService getAcordoServicoContratoService() throws ServiceException {
		if (acordoServicoContratoService == null) {
			acordoServicoContratoService = (AcordoServicoContratoService) ServiceLocator.getInstance().getService(AcordoServicoContratoService.class, null);
		}
		return acordoServicoContratoService;
	}

	private ExecucaoSolicitacaoService getExecucaoSolicitacaoService() throws Exception {
		if (execucaoSolicitacaoService == null) {
			execucaoSolicitacaoService = (ExecucaoSolicitacaoService) ServiceLocator.getInstance().getService(ExecucaoSolicitacaoService.class, null);
		}
		return execucaoSolicitacaoService;
	}

	public ControleGEDService getControleGedService() throws ServiceException {
		if (controleGedService == null) {
			controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}
		return controleGedService;
	}

	public ClienteService getClienteService() throws ServiceException {
		if (clienteService == null) {
			clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		}
		return clienteService;
	}

	public FornecedorService getFornecedorService() throws ServiceException {
		if (fornecedorService == null) {
			fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		}
		return fornecedorService;
	}

	public OcorrenciaSolicitacaoService getOcorrenciaSolicitacaoService() throws ServiceException {
		if (ocorrenciaSolicitacaoService == null) {
			ocorrenciaSolicitacaoService = (OcorrenciaSolicitacaoService) ServiceLocator.getInstance().getService(OcorrenciaSolicitacaoService.class, null);
		}
		return ocorrenciaSolicitacaoService;
	}

	public OrigemOcorrenciaService getOrigemOcorrenciaService() throws ServiceException {
		if (origemOcorrenciaService == null) {
			origemOcorrenciaService = (OrigemOcorrenciaService) ServiceLocator.getInstance().getService(OrigemOcorrenciaService.class, null);
		}
		return origemOcorrenciaService;
	}

	private CategoriaOcorrenciaService getCategoriaOcorrenciaService() throws ServiceException {
		if (categoriaOcorrenciaService == null) {
			categoriaOcorrenciaService = (CategoriaOcorrenciaService) ServiceLocator.getInstance().getService(CategoriaOcorrenciaService.class, null);
		}
		return categoriaOcorrenciaService;
	}

	private OcorrenciaService getOcorrenciaService() throws ServiceException {
		if (ocorrenciaService == null) {
			ocorrenciaService = (OcorrenciaService) ServiceLocator.getInstance().getService(OcorrenciaService.class, null);
		}
		return ocorrenciaService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	private OpiniaoService getOpiniaoService() throws ServiceException {
		if (opiniaoService == null) {
			opiniaoService = (OpiniaoService) ServiceLocator.getInstance().getService(OpiniaoService.class, null);
		}
		return opiniaoService;
	}

	public PesquisaSatisfacaoService getPesquisaSatisfacaoService() throws ServiceException, Exception {
		if (pesquisaSatisfacaoService == null) {
			pesquisaSatisfacaoService = (PesquisaSatisfacaoService) ServiceLocator.getInstance().getService(PesquisaSatisfacaoService.class, null);
		}
		return pesquisaSatisfacaoService;
	}

	public ContatoSolicitacaoServicoService getContatoSolicitacaoServicoService() throws ServiceException, Exception {
		if (contatoSolicitacaoServicoService == null) {
			contatoSolicitacaoServicoService = (ContatoSolicitacaoServicoService) ServiceLocator.getInstance().getService(ContatoSolicitacaoServicoService.class, null);
		}
		return contatoSolicitacaoServicoService;
	}

	public GrupoEmpregadoService getGrupoEmpregadoService() throws ServiceException, Exception {
		if (grupoEmpregadoService == null) {
			grupoEmpregadoService = (GrupoEmpregadoService) ServiceLocator.getInstance().getService(GrupoEmpregadoService.class, null);
		}
		return grupoEmpregadoService;
	}

	public AvaliacaoServicoService getAvaliacaoServicoService() throws ServiceException, Exception {
		if (avaliacaoServicoService == null) {
			avaliacaoServicoService = (AvaliacaoServicoService) ServiceLocator.getInstance().getService(AvaliacaoServicoService.class, null);
		}
		return avaliacaoServicoService;
	}

	public UsuarioService getUsuarioService() throws ServiceException, Exception {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}
}
