package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONException;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.SmartReportGrupoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.SmartReportGrupoService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.QueryTypes;
import br.com.centralit.citcorpore.util.Enumerados.ReportCategories;
import br.com.centralit.citcorpore.util.Enumerados.ReportTypes;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citgerencial.bean.SmartReportParameterDTO;
import br.com.centralit.citquestionario.util.Upload;
import br.com.citframework.dto.IDto;
import br.com.citframework.dto.ReflexaoCopyProperty;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilSmartReport;
import br.com.citframework.util.UtilStrings;

public class SmartReportGenerator extends AjaxFormAction {

	private SmartReportService smartReportService;
	private SmartReportGrupoService smartReportGrupoService;
	private GrupoService grupoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String action = request.getParameter("action");
		if("EXPORT".equalsIgnoreCase(action)) {
			exportReport(document, request, response);
		} else {
			if ("IMPORT".equalsIgnoreCase(action)) {
				importReport(document, request, response);
				document.executeScript("$('.pesquisaRelatorios').hide(); $('.cadastroRelatorios').show();");
				document.executeScript("CM.initComponents();");
				document.executeScript("window.history.pushState({}, '', 'smartReport.load');");
			}
			init(document, request);
		}
	}

	private void init(DocumentHTML document, HttpServletRequest request) throws Exception {
		carregaComboTipoConsulta(document, request);
		carregaComboTipoRelatorio(document, request);
		carregaComboIdCategoria(document, request);
		carregaComboModuloExibicao(document, request);

		carregaTabelaRelatorios(document, request, null);
	}

	public void carregaTabelaRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		// Pagina selecionada
		Integer paginaSelecionada = smartReportDTO.getPaginaSelecionada();
		if (paginaSelecionada == null || paginaSelecionada == 0) {
			paginaSelecionada = 1;
		}

		// Itens por pagina
		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		// Configure pageable
		Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);

		Collection<SmartReportDTO> colSmartReport = getSmartReportService().findPaged(smartReportDTO.getFilterTabela(), pageable, false).getContent();
		HTMLElement divTabelaRelatorios = document.getElementById("divDinamicoTabelaRelatorios");
		StringBuilder sb = new StringBuilder();

		if (colSmartReport != null && !colSmartReport.isEmpty() && colSmartReport.size() > 0) {
			sb.append(geraHtmlCabecalhoTabelaRelatorios(request));

			for (SmartReportDTO smartReport : colSmartReport) {
				sb.append(geraHtmlLinhaTabelaRelatorios(request, smartReport));
			}

			sb.append(geraHTMLFinalTabela());

			Integer totalPaginas = getSmartReportService().findPaged(smartReportDTO.getFilterTabela(), pageable, true).getTotalPages();

			HTMLElement paginacaoServicosNegocio = document.getElementById("divPaginacaoRelatorios");
			String changePageFuction = "changePage";
			paginacaoServicosNegocio.setInnerHTML(UtilHTML.paginacaoHtml(request, changePageFuction, totalPaginas, paginaSelecionada));
			document.executeScript("$('#divDinamicoTabelaRelatorios').show('blind', 'fast', function(){});");
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "MSG04") + "</h4>");
		}

		divTabelaRelatorios.setInnerHTML(sb.toString());

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	/**
	 * @author douglas.japiassu
	 * @since 22.09.2016
	 */
	private String geraHtmlCabecalhoTabelaRelatorios(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
		sb.append("					<th style=\"width: 40%;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th style=\"width: 20%;\">" + UtilI18N.internacionaliza(request, "construtorconsultas.categoria") + "</th> ");
		sb.append("					<th style=\"width: 15%;\">" + UtilI18N.internacionaliza(request, "construtorconsultas.tipoConsulta") + "</th> ");
		sb.append("					<th style=\"width: 15%;\">" + UtilI18N.internacionaliza(request, "construtorconsultas.tipoRelatorio") + "</th> ");
		sb.append("					<th style=\"width: 9%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * @author douglas.japiassu
	 * @since 22.09.2016
	 */
	private String geraHtmlLinhaTabelaRelatorios(HttpServletRequest request, SmartReportDTO smartReport) {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "citcorpore.comum.editar") + "')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id=\"" + smartReport.getIdSmartReport() + "\">");
		sb.append("			<td class=\"center\">" + smartReport.getIdSmartReport() + "</td> ");
		sb.append("			<td>" + smartReport.getIdentificacao() + "</td> ");
		sb.append("			<td>" + UtilI18N.internacionaliza(request, ReportCategories.keyFromId(smartReport.getIdCategoria())) + "</td> ");
		sb.append("			<td>" + UtilI18N.internacionaliza(request, QueryTypes.keyFromId(smartReport.getTipoConsulta())) + "</td> ");
		sb.append("			<td>" + UtilI18N.internacionaliza(request, ReportTypes.keyFromId(smartReport.getTipoRelatorio())) + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 50px;\">");
		sb.append("				<a onclick=\"CONSTRUTOR.restore('" + smartReport.getIdSmartReport() + "');\" " + onMouseOver + " class=\"btn-action glyphicons pencil btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private void carregaComboIdCategoria(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect tipoConsulta = document.getSelectById("idCategoria");
		tipoConsulta.removeAllOptions();

		for (ReportCategories reportCategory : ReportCategories.values()) {
			tipoConsulta.addOption(String.valueOf(reportCategory.getId()), UtilI18N.internacionaliza(request, reportCategory.getKey()));
		}

		tipoConsulta.setSelectedIndex(0);
	}

	private void carregaComboTipoConsulta(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect tipoConsulta = document.getSelectById("tipoConsulta");
		tipoConsulta.removeAllOptions();

		for (QueryTypes queryType : QueryTypes.values()) {
			tipoConsulta.addOption(String.valueOf(queryType.getId()), UtilI18N.internacionaliza(request, queryType.getKey()));
		}

		tipoConsulta.setSelectedIndex(0);
	}

	private void carregaComboTipoRelatorio(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect tipoRelatorio = document.getSelectById("tipoRelatorio");
		tipoRelatorio.removeAllOptions();

		carregaOpcoesTipoRelatorio(request, tipoRelatorio, QueryTypes.SQL.getId());

		tipoRelatorio.setDisabled(false);
	}

	private void carregaOpcoesTipoRelatorio(HttpServletRequest request, HTMLSelect comboTipoRelatorio, Integer tipoConsulta) {
		for (ReportTypes reportType : ReportTypes.values()) {
			if (reportType.equals(ReportTypes.HTML_RETURN) && QueryTypes.SQL.getId().equals(tipoConsulta)) {
				continue;
			}
			comboTipoRelatorio.addOption(String.valueOf(reportType.getId()), UtilI18N.internacionaliza(request, reportType.getKey()));
		}
	}

	@Override
	public Class<SmartReportDTO> getBeanClass() {
		return SmartReportDTO.class;
	}

	public void carregaTipoRelatorio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		Integer tipoRelatorioSelected = smartReportDTO.getTipoRelatorio();
		HTMLSelect comboTipoRelatorio = document.getSelectById("tipoRelatorio");
		comboTipoRelatorio.removeAllOptions();

		if (smartReportDTO != null) {
			if (QueryTypes.JSP.getId().equals(smartReportDTO.getTipoConsulta())) {
				comboTipoRelatorio.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
				comboTipoRelatorio.setDisabled(true);
			} else {
				carregaOpcoesTipoRelatorio(request, comboTipoRelatorio, smartReportDTO.getTipoConsulta());
				comboTipoRelatorio.setDisabled(false);
			}
			comboTipoRelatorio.setValue(tipoRelatorioSelected + "");
		}
	}

	private void carregaComboModuloExibicao(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("slModuloExibicao");
		combo.removeAllOptions();

		for (ModuloExibicaoRelatorio moduloExibicao : ModuloExibicaoRelatorio.values()) {
			combo.addOption(moduloExibicao.getIdentificador(), UtilI18N.internacionaliza(request, moduloExibicao.getChave()));
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		smartReportDTO = (SmartReportDTO) getSmartReportService().restore(smartReportDTO);

		carregaTipoRelatorio(document, request, response);

		HTMLForm form = document.getForm("form");
		form.clear();
		form.setValues(smartReportDTO);

		document.executeScript("try{CM.transformToTextArea();}catch(err){}");
		document.executeScript("CM.initComponents();");
		document.executeScript("CM.clearComponents();");
		document.executeScript("CM.configureSizeComponents();");
		document.executeScript("CM.update(parametros, \"" + StringEscapeUtils.escapeJavaScript(smartReportDTO.getParametros()) + "\");");
		document.executeScript("CM.update(sql, \"" + StringEscapeUtils.escapeJavaScript(smartReportDTO.getSql()) + "\");");
		document.executeScript("CM.update(script, \"" + StringEscapeUtils.escapeJavaScript(smartReportDTO.getScript()) + "\");");
		document.executeScript("CM.update(jsp, \"" + StringEscapeUtils.escapeJavaScript(smartReportDTO.getJsp()) + "\");");
		document.executeScript("CM.update(template, \"" + StringEscapeUtils.escapeJavaScript(smartReportDTO.getTemplate()) + "\");");

		defineValueElementos(document, smartReportDTO);

		List<GrupoDTO> listaGrupos = (List<GrupoDTO>) getSmartReportGrupoService().findGruposByIdSmartReport(smartReportDTO.getIdSmartReport());
		String listaGruposLookup = "";
		geraHtmlTabelaGrupo(document, request, listaGrupos);
		for (GrupoDTO unidadeDTO : listaGrupos) {
			listaGruposLookup += unidadeDTO.getIdGrupo() + ";";
		}
		form.setValue("listaIdsGruposVinculados", listaGruposLookup);
		document.executeScript("Grupo.serializarListaIdsGruposVinculados();");
	}

	private void defineValueElementos(DocumentHTML document, SmartReportDTO smartReportDTO) throws Exception {
		document.executeScript("CONSTRUTOR.defineComportamentoRadioTipoExibicao('".concat(smartReportDTO.getTipoExibicao()).concat("')"));
		document.executeScript("CONSTRUTOR.defineComportamentoSelectModuloExibicao('".concat(UtilStrings.nullToVazio(smartReportDTO.getModuloExibicao())).concat("')"));
	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();
		smartReportDTO.setListaGrupos(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SmartReportGrupoDTO.class, "listaSmartReportGrupo_Serialize", request));

		if (smartReportDTO.getIdSmartReport() == null || smartReportDTO.getIdSmartReport().intValue() == 0) {
			getSmartReportService().create(smartReportDTO);
			document.getForm("form").setValue("idSmartReport", smartReportDTO.getIdSmartReport());
			document.executeScript("notificacaoI18N('MSG05','')");
		} else {
			getSmartReportService().update(smartReportDTO);
			document.executeScript("notificacaoI18N('MSG06','')");
		}

		document.getForm("form").setValue("identificacao", smartReportDTO.getIdentificacao());
		document.executeScript("setTimeout(function() { CM.initComponents(); CM.configureSizeComponents(); CM.setValues(); }, 100);");

		carregaTabelaRelatorios(document, request, response);
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		if (smartReportDTO != null && smartReportDTO.getIdSmartReport() != null) {
			getSmartReportService().delete(smartReportDTO);
			document.executeScript("notificacaoI18N('MSG07','')");
			document.executeScript("CONSTRUTOR.limpar();");

			carregaTabelaRelatorios(document, request, response);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelExcluir','')");
		}
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void loadReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();
		smartReportDTO = getSmartReportService().restore(smartReportDTO);

		Boolean isExibirParametroIdEspecifico = false;

		try {
			isExibirParametroIdEspecifico = SimNao.SIM.name().equalsIgnoreCase(request.getParameter("exibirParametroIdEspecifico"));
		} catch (Exception e) {

		}

		if (!UtilStrings.isNullOrEmpty(smartReportDTO.getParametros())
				|| isExibirParametroIdEspecifico && TipoExibicaoRelatorio.ESPECIFICO.getIdentificador().equalsIgnoreCase(smartReportDTO.getTipoExibicao())) {
			loadReportParameters(document, request, smartReportDTO);
		} else if (smartReportDTO != null && smartReportDTO.getTipoConsulta() != null) {
			processReport(document, request, smartReportDTO);
		}
	}

	/**
	 * @param document
	 * @param request
	 * @param smartReportDTO
	 * @throws Exception
	 * @author renato.jesus
	 */
	private void loadReportParameters(DocumentHTML document, HttpServletRequest request,
			SmartReportDTO smartReportDTO) throws Exception {
		List<SmartReportParameterDTO> smartReportParametroDTOs = UtilSmartReport.getReportParameters(smartReportDTO.getParametros());

		if (TipoExibicaoRelatorio.ESPECIFICO.getIdentificador().equalsIgnoreCase(smartReportDTO.getTipoExibicao())) {
			SmartReportParameterDTO specificParameter = new SmartReportParameterDTO();
			specificParameter.setDefaultValue("0");
			specificParameter.setDescription("smartReportGenerators.idEspecifico");
			specificParameter.setType("java.lang.Integer");
			specificParameter.setTypeHTML("text");
			specificParameter.setMandatory(Boolean.TRUE);
			specificParameter.setName("specificID");

			smartReportParametroDTOs.add(0, specificParameter);
		}

		String reportParameterModalHtml = "";
		reportParameterModalHtml += "<div class='clearfix body-params-fields'>" + UtilSmartReport.getHtmlReportParameters(request, smartReportParametroDTOs) + "</div>";
		reportParameterModalHtml += "<button type='button' onclick='UtilSmartReport.process(" + smartReportDTO.getIdSmartReport() + ")' class='btn btn-params btn-default btn-mini pull-right'>"
				+ UtilI18N.internacionaliza(request, "citcorpore.comum.gerarRelatorio") + "</button>";
		reportParameterModalHtml += "<button type='button' onclick='UtilSmartReport.cleanFilters(" + smartReportDTO.getIdSmartReport() + ")' class='btn btn-params btn-default btn-mini pull-right mr-5'>"
				+ UtilI18N.internacionaliza(request, "citcorpore.comum.limpar") + "</button>";

		document.executeScript("Modal.open('modal-smart-report');");
		document.executeScript("$('#formSmartReport" + smartReportDTO.getIdSmartReport() + " .div-smart-report-params').removeClass('hidden')");
		document.executeScript("$('#formSmartReport" + smartReportDTO.getIdSmartReport() + " .div-smart-report-params .body-params').empty().append('" + StringEscapeUtils.escapeJavaScript(reportParameterModalHtml) + "')");
		document.executeScript("DEFINEALLPAGES_generateConfiguracaoCampos()");
		document.executeScript("$('.datepicker').datepicker();");
		document.executeScript("UtilSmartReport.afterLoadReport(" + smartReportDTO.getIdSmartReport() + ");");
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 *
	 * @author douglas.japiassu
	 * @since 20.09.2016
	 */
	public void processReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();
		smartReportDTO = getSmartReportService().restore(smartReportDTO);

		processReport(document, request, smartReportDTO);
	}

	/**
	 * @param document
	 * @param request
	 * @param smartReportDTO
	 * @throws IOException
	 * @throws Exception
	 * @throws JSONException
	 * @author renato.jesus
	 */
	private void processReport(DocumentHTML document, HttpServletRequest request, SmartReportDTO smartReportDTO) throws IOException, Exception, JSONException {
		document.setBean(smartReportDTO);
		UtilSmartReport.processReport(document, request);
	}

	public void gerarTemplate(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		if (smartReportDTO != null && smartReportDTO.getTipoConsulta() != null && smartReportDTO.getTipoRelatorio() != null) {
			String errorMsg = "MSG04";
			List<String> listAlias = new ArrayList<String>();

			if (QueryTypes.SQL.getId().equals(smartReportDTO.getTipoConsulta()) && UtilStrings.isNotVazio(smartReportDTO.getSql())) {
				try {
					listAlias = UtilSmartReport.getResultColumns(request, smartReportDTO);
				} catch (Exception e) {
					document.executeScript("notificacaoErro('construtorconsultas.naoFoiPossivelConstruirTemplate', 'construtorconsultas.erroNaConsulta');");
				}
				errorMsg = "construtorconsultas.erroNaConsulta";
			} else if (QueryTypes.RHINOSCRIPT.getId().equals(smartReportDTO.getTipoConsulta()) && UtilStrings.isNotVazio(smartReportDTO.getScript())) {
				UtilSmartReport.executeRhinoScript(request, usuario, smartReportDTO, new ArrayList<Object[]>(), listAlias, null);
				errorMsg = "construtorconsultas.objetoReturnColumnsNaoInformado";
			}

			if (listAlias != null && !listAlias.isEmpty()) {
				StringBuilder dados = new StringBuilder();

				dados.append("<!DOCTYPE html>\r\n");
				dados.append("<html>\r\n");
				dados.append("<head>\r\n");
				dados.append("</head>\r\n");
				dados.append("<body>\r\n");
				dados.append("	<div class=\"row-fluid\">\r\n");
				dados.append("		<div class=\"span12 center\">\r\n");
				dados.append("			<b>" + smartReportDTO.getIdentificacao() + "</b>\r\n");
				dados.append("		</div>\r\n");
				dados.append("	</div>\r\n");
				dados.append("	<table width=\"100%\" border=\"1\">\r\n");
				dados.append("		<tr>\r\n");

				for (String alias : listAlias) {
					dados.append("			<th>" + UtilI18N.internacionaliza(request, UtilStrings.isNullOrEmpty(alias) ? "construtorconsultas.nomeColuna" : alias) + "</th>\r\n");
				}

				dados.append("		</tr>\r\n");
				dados.append("		<#list QUERY_RESULT as item>\r\n");
				dados.append("			<tr>\r\n");

				for (int i = 0; i < listAlias.size(); i++) {
					dados.append("				<td>${item[" + i + "]!''}</td>\r\n");
				}

				dados.append("			</tr>\r\n");
				dados.append("		</#list>\r\n");
				dados.append("	</table>\r\n");
				dados.append("</body>\r\n");
				dados.append("</html>");

				document.executeScript("CONSTRUTOR.buildTemplate('" + StringEscapeUtils.escapeJavaScript(dados.toString()) + "');");
			} else {
				document.executeScript("notificacaoErro('construtorconsultas.naoFoiPossivelConstruirTemplate', '" + errorMsg + "');");
			}
		}
	}

	private void exportReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			return;
		}

		String idSmartReportStr = request.getParameter("idSmartReport");
		Integer idSmartReport = Integer.valueOf(idSmartReportStr);

		SmartReportDTO smartReportDTO = new SmartReportDTO();
		smartReportDTO.setIdSmartReport(idSmartReport);
		smartReportDTO = this.getSmartReportService().restore(smartReportDTO);

		List<SmartReportGrupoDTO> smartReportGrupoDTO = (List<SmartReportGrupoDTO>)
		br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SmartReportGrupoDTO.class, "listaSmartReportGrupo_Serialize", request);
		smartReportDTO.setListaGrupos(smartReportGrupoDTO);

		String exportPath = request.getSession().getServletContext().getRealPath("/") + "exportXML";

		File f = new File(exportPath);
		if (!f.exists()){
			f.mkdirs();
		}

		String fileName = UtilStrings.generateNomeBusca(smartReportDTO.getIdentificacao());
		fileName += ".citreport";

		String exportFilePath = exportPath + "/" + fileName;
		OutputStream out = new FileOutputStream(exportFilePath);

		XStream x = new XStream(new StaxDriver());
		smartReportDTO.setIdSmartReport(null);
		x.toXML(smartReportDTO, out);
		out.close();

		File fileDownload = new File(exportFilePath);

		response.setContentType("text/xml");
		response.setContentLength((int) fileDownload.length());
		response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", fileDownload.getName()));

		InputStream inputStream = new FileInputStream(fileDownload);
		OutputStream outputStream = response.getOutputStream();

		byte[] buffer = new byte[4096];
		int bytesRead = -1;

		while ((bytesRead = inputStream.read(buffer)) != -1) {
			outputStream.write(buffer, 0, bytesRead);
		}

		inputStream.close();
		outputStream.close();
		if(fileDownload.exists()) {
			fileDownload.delete();
		}
	}

	private void importReport(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Upload upload = new Upload();
		HashMap hshRetorno[] = null;

		try{
			hshRetorno = upload.doUploadAll(request);
		}catch (Exception e) {
		}
		if (hshRetorno != null){
			Collection fileItems = hshRetorno[1].values();
			HashMap formItems = hshRetorno[0];

			IDto obj = null;
			SmartReportDTO smartReportDTO = new SmartReportDTO();
			FileItem fi = null;

			if (!fileItems.isEmpty()){
				Iterator it = fileItems.iterator();
				while(it.hasNext()){
					fi = (FileItem)it.next();

					XStream x = new XStream(new StaxDriver());

					String str = new String(fi.get(), "UTF-8");

					obj = (IDto) x.fromXML(str);
				}
			}

			if (SmartReportDTO.class.isInstance(obj)) {
				smartReportDTO = (SmartReportDTO) obj;
				SmartReportDTO smartReportDTOBase = getSmartReportService().getByIdentificacao(smartReportDTO.getIdentificacao());

				if (smartReportDTOBase != null) {
					smartReportDTO.setIdSmartReport(smartReportDTOBase.getIdSmartReport());
					getSmartReportService().update(smartReportDTO);
				} else {
					smartReportDTO = getSmartReportService().create(smartReportDTO);
				}
			} else if (BIConsultaDTO.class.isInstance(obj)) {
				BIConsultaDTO biConsultaDTO = (BIConsultaDTO) obj;

				String[] tipoConsultaSQL = {"C", "D", "1", "2"};
				String[] tipoConsultaRHINO = { "T", "S" };
				String tipoConsultaJSP = "J";

				ReflexaoCopyProperty[] reflexaoCopyProperties = new ReflexaoCopyProperty[]{
						new ReflexaoCopyProperty("identificacao","identificacao"),
						new ReflexaoCopyProperty("idCategoria","idCategoria"),
						new ReflexaoCopyProperty("tipoExibicao","tipoExibicao"),
						new ReflexaoCopyProperty("moduloExibicao","moduloExibicao"),
						new ReflexaoCopyProperty("parametros","parametros"),
						new ReflexaoCopyProperty("template","template"),
						new ReflexaoCopyProperty("textoSQL","sql"),
						new ReflexaoCopyProperty("nomeConsulta", "descricao"),
						new ReflexaoCopyProperty("scriptExec","script")
				};

				Reflexao.copyPropertyValues(biConsultaDTO, smartReportDTO, reflexaoCopyProperties);

				if (Arrays.asList(tipoConsultaSQL).contains(biConsultaDTO.getTipoConsulta())) {
					smartReportDTO.setTipoConsulta(QueryTypes.SQL.getId());
				} else if (Arrays.asList(tipoConsultaRHINO).contains(biConsultaDTO.getTipoConsulta())) {
					smartReportDTO.setTipoConsulta(QueryTypes.RHINOSCRIPT.getId());

					//TODO: Tratar objetos utilizados no Rhino. Verificar classes GeraTemplateReport e GeraScript.
					String aux = smartReportDTO.getScript();
					aux.replaceAll("", "");
					smartReportDTO.setScript(aux);
				} else if (tipoConsultaJSP.equalsIgnoreCase(biConsultaDTO.getTipoConsulta())){
					smartReportDTO.setTipoConsulta(QueryTypes.JSP.getId());
					smartReportDTO.setJsp(UtilStrings.nullToVazio(biConsultaDTO.getScriptExec()));
				}

				smartReportDTO = getSmartReportService().create(smartReportDTO);
			} else {
				return;
			}



			HTMLForm form = document.getForm("form");

			form.clear();
			form.setValues(obj);
		}
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	public void adicionaTabelaLOOKUP_GRUPO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		SmartReportDTO smartReportDTO = (SmartReportDTO) document.getBean();

		if (smartReportDTO != null) {
			document.executeScript("Grupo.montarTabelaGrupos();");
			document.executeScript("Grupo.fecharModal();");
		}
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	@SuppressWarnings("unchecked")
	public void montarTabelaGrupos(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		try {
			List<SmartReportGrupoDTO> listSmartReportGrupo = new ArrayList<SmartReportGrupoDTO>();
			listSmartReportGrupo = (ArrayList<SmartReportGrupoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SmartReportGrupoDTO.class, "listaSmartReportGrupo_Serialize", request);
			List<GrupoDTO> listaGrupos = new ArrayList<GrupoDTO>();

			if (listSmartReportGrupo != null && listSmartReportGrupo.size() > 0) {
				for (SmartReportGrupoDTO processoNegocioUnidades : listSmartReportGrupo) {
					listaGrupos.add(getGrupoService().listGrupoById(processoNegocioUnidades.getIdGrupo()));
				}
				document.executeScript("notificacaoI18N('construtorconsultas.grupoVinculadoComSucesso');");
			}

			Collections.sort(listaGrupos);
			geraHtmlTabelaGrupo(document, request, listaGrupos);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	private void geraHtmlTabelaGrupo(DocumentHTML document, HttpServletRequest request, List<GrupoDTO> listaGrupos) throws Exception {
		StringBuilder sb = new StringBuilder();

		if (listaGrupos != null && listaGrupos.size() > 0) {
			sb.append(geraHtmlCabecalhoTabelaGrupo(request));

			for (GrupoDTO grupo : listaGrupos) {
				sb.append(geraHtmlLinhaTabelaGrupos(request, grupo));
			}

			sb.append(geraHTMLFinalTabela());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "construtorconsultas.nenhumGrupoVinculado") + "</h4>");
		}
		HTMLElement tabelaUnidade = document.getElementById("divTabelaGrupos");
		tabelaUnidade.setInnerHTML(sb.toString());
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	private String geraHtmlCabecalhoTabelaGrupo(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	private String geraHtmlLinhaTabelaGrupos(HttpServletRequest request, GrupoDTO grupo) {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "construtorconsultas.desvincularGrupo") + "')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id=\"" + grupo.getIdGrupo() + "\">");
		sb.append("			<td class=\"center\">" + grupo.getIdGrupo() + "</td> ");
		sb.append("			<td>" + grupo.getDescricao() + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 50px;\">");
		sb.append("				<a onclick=\"Grupo.removerGrupoFromTable(this);\" " + onMouseOver + " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * @author douglas.japiassu
	 * @since 12.09.2016
	 */
	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

	private SmartReportGrupoService getSmartReportGrupoService() throws ServiceException, Exception {
		if (smartReportGrupoService == null) {
			smartReportGrupoService = (SmartReportGrupoService) ServiceLocator.getInstance().getService(SmartReportGrupoService.class, null);
		}

		return smartReportGrupoService;
	}

	private SmartReportService getSmartReportService() throws ServiceException, Exception {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}

		return smartReportService;
	}

	private GrupoService getGrupoService() throws Exception {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}

}