package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.TemplateServicoDTO;
import br.com.centralit.citcorpore.negocio.TemplateServicoService;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citquestionario.bean.QuestionarioDTO;
import br.com.centralit.citquestionario.negocio.QuestionarioService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 *
 * @author douglas.japiassu
 * @since 27.01.2016
 */
public class TemplateServico extends AjaxFormAction {

	private TemplateServicoService templateServicoService;
	private QuestionarioService questionarioService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		carregarComboQuestionario(document, request, response);
	}

	private void carregarComboQuestionario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect idQuestionario = document.getSelectById("idQuestionario");
		idQuestionario.removeAllOptions();
		idQuestionario.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		Collection<QuestionarioDTO> colQuestionarios = getQuestionarioService().list();

		if (colQuestionarios != null && !colQuestionarios.isEmpty()) {
			idQuestionario.addOptions(colQuestionarios, "idQuestionarioOrigem", "nomeQuestionario", null);
		}
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TemplateServicoDTO templateServicoDTO = (TemplateServicoDTO) document.getBean();

		if (templateServicoDTO.getIdTemplateServico() == null || templateServicoDTO.getIdTemplateServico().intValue() == 0) {
			getTemplateServicoService().create(templateServicoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
		} else {
			getTemplateServicoService().update(templateServicoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}
		HTMLForm form = document.getForm("form");
		form.clear();
		document.setBean(new TemplateServicoDTO());
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TemplateServicoDTO templateServicoDTO = (TemplateServicoDTO) document.getBean();

		templateServicoDTO = (TemplateServicoDTO) getTemplateServicoService().restore(templateServicoDTO);

		HTMLForm form = document.getForm("form");
		form.clear();
		form.setValues(templateServicoDTO);
	}

	@Override
	public Class<TemplateServicoDTO> getBeanClass() {
		return TemplateServicoDTO.class;
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TemplateServicoDTO templateServicoDTO = (TemplateServicoDTO) document.getBean();

		if (verificaDependenciaTemplate(templateServicoDTO)) {
			document.executeScript("notificacaoI18N('deParaCatalogoServicos.naoFoiPossivelExcluir', 'deParaCatalogoServicos.naoFoiPossivelExcluirRelacionado');");
			return;
		}

		if (templateServicoDTO.getIdTemplateServico().intValue() > 0) {
			getTemplateServicoService().delete(templateServicoDTO);
		}

		document.alert(UtilI18N.internacionaliza(request, "MSG07"));

		HTMLForm form = document.getForm("form");
		form.clear();
	}

	private Boolean verificaDependenciaTemplate(TemplateServicoDTO templateServico) {
		return false;
	}

	private TemplateServicoService getTemplateServicoService() throws ServiceException {
		if (templateServicoService == null) {
			templateServicoService = (TemplateServicoService) ServiceLocator.getInstance().getService(TemplateServicoService.class, null);
		}

		return templateServicoService;
	}

	private QuestionarioService getQuestionarioService() throws ServiceException {
		if (questionarioService == null) {
			questionarioService = (QuestionarioService) ServiceLocator.getInstance().getService(QuestionarioService.class, null);
		}

		return questionarioService;
	}

}
