package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONObject;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoHistoricoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.TempoAtendimentoUnidadeDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.metainfo.complementos.ComplementoSLA_Grupos;
import br.com.centralit.citcorpore.metainfo.complementos.ComplementoSLA_Prioridade;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.ModeloEmailService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.TempoAcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoAnsMultinivel;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHashMaps;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class TempoAtendimento extends AjaxFormAction {

	private ComplementoSLA_Prioridade complementoSLA_Prioridade;
	private ComplementoSLA_Grupos complementoSLA_Grupos;
	private ModeloEmailService modeloEmailService;
	private TempoAcordoNivelServicoService tempoAcordoNivelServicoService;
	private ServicoService servicoService;
	private ServicoContratoService servicoContratoService;
	private UnidadeService unidadeService;
	private UsuarioService usuarioService;
	private EmpregadoService empregadoService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private ContratoService contratoService;
	private Permissoes permissao;
	private boolean isRestoreTree;

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		this.permissao = new Permissoes(document, request);
		isRestoreTree = false;

		carregaComboPrioridadeAuto(document, request, response);
		carregaComboGrupos(document, request, response);
		carregaComboEmails(document, request, response);

		selecionaTipoAcordoPadrao(document, request, response);
	}

	/**
	 * Inicia a combo passado por parmetro com a opo 'selecione'
	 *
	 * @author rodrigo.dorighello
	 * @since 29.10.2015
	 */
	private void iniciaCombo(DocumentHTML document, HttpServletRequest request, HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	/**
	 * Preenche a combo de prioridade de ao
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private void carregaComboPrioridadeAuto(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String resp = this.getComplementoSLA_Prioridade().execute(null, request, response);

		HTMLSelect combo = document.getSelectById("idPrioridadeAuto1");
		iniciaCombo(document, request, combo);

		if (resp != null) {
			combo.setInnerHTML(resp);
		}
	}

	/**
	 * Preenche a combo de grupos
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private void carregaComboGrupos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String resp = this.getComplementoSLA_Grupos().execute(null, request, response);

		HTMLSelect combo = document.getSelectById("idGrupo1");
		iniciaCombo(document, request, combo);

		if (resp != null) {
			combo.setInnerHTML(resp);
		}
	}

	/**
	 * Preenche a combo de e-mails
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	@SuppressWarnings("unchecked")
	private void carregaComboEmails(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HTMLSelect combo = document.getSelectById("idEmail");
		iniciaCombo(document, request, combo);

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	/**
	 * Inicia o tipo do acordo como sendo o global
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 24.11.2015
	 */
	public void selecionaTipoAcordoPadrao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

			if (tempoAtendimentoDto != null) {
				tempoAtendimentoDto.setTipoAcordo(TipoAnsMultinivel.GLOBAL.getChave());
				generateTree(document, request, tempoAtendimentoDto, true);

				document.executeScript("TipoTempoAtendimento.changeTipoAtendimento(_tipoGlobal, false, false);");
			}
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}

	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

		if (tempoAtendimentoDto != null) {

			try {
				Set<Integer> listIdServicoContrato = new HashSet<>();
				Set<Integer> listIdServicosRelacionadosServicoContrato = new HashSet<>();
				Set<Integer> listIdContratosRelacionadosServicoContrato = new HashSet<>();

				if (!UtilStrings.isNullOrEmpty(tempoAtendimentoDto.getListaIdsServicosContratosStr())) {
					String[] listaIdsStr = new String[] {};

					listaIdsStr = tempoAtendimentoDto.getListaIdsServicosContratosStr().split(",");

					if (listaIdsStr != null && listaIdsStr.length > 0) {
						for (String idServicoContrato : listaIdsStr) {
							listIdServicoContrato.add(Integer.parseInt(idServicoContrato));
						}
					}
				}

				if (!UtilStrings.isNullOrEmpty(tempoAtendimentoDto.getListaIdsContratosRelacionadosServicoContratoStr())) {
					String[] listaIdsContratosRelacionadosStr = new String[] {};

					listaIdsContratosRelacionadosStr = tempoAtendimentoDto.getListaIdsContratosRelacionadosServicoContratoStr().split(",");

					if (listaIdsContratosRelacionadosStr != null && listaIdsContratosRelacionadosStr.length > 0) {
						for (String idContrato : listaIdsContratosRelacionadosStr) {
							listIdContratosRelacionadosServicoContrato.add(Integer.parseInt(idContrato));
						}
					}

					listIdServicosRelacionadosServicoContrato
							.addAll(this.getServicoContratoService().getIdsServicosRelacionadosServicoContratoByIdsContrato(tempoAtendimentoDto.getListaIdsContratosRelacionadosServicoContratoStr()));
				}

				if (!UtilStrings.isNullOrEmpty(tempoAtendimentoDto.getListaIdsServicosRelacionadosServicoContratoStr())) {
					String[] listaIdsServicosRelacionadosStr = new String[] {};

					listaIdsServicosRelacionadosStr = tempoAtendimentoDto.getListaIdsServicosRelacionadosServicoContratoStr().split(",");

					if (listaIdsServicosRelacionadosStr != null && listaIdsServicosRelacionadosStr.length > 0) {
						for (String keyStr : listaIdsServicosRelacionadosStr) {
							String[] key = keyStr.split("-");

							listIdContratosRelacionadosServicoContrato.add(Integer.parseInt(key[0]));
							listIdServicosRelacionadosServicoContrato.add(Integer.parseInt(key[1]));
						}
					}
				}

				listIdServicoContrato.addAll(this.getServicoContratoService().getIdsServicoContratoByIdsContratoAndIdsServicosRelacionados(Util.listIntegerToListStr(listIdContratosRelacionadosServicoContrato),
						Util.listIntegerToListStr(listIdServicosRelacionadosServicoContrato)));

				List<TempoAtendimentoUnidadeDTO> listaTempoAtendimentoUnidade = new ArrayList<>();
				if (tempoAtendimentoDto.getPrioridadeUnidadeSerializados() != null && !tempoAtendimentoDto.getPrioridadeUnidadeSerializados().isEmpty()) {
					listaTempoAtendimentoUnidade = (ArrayList<TempoAtendimentoUnidadeDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(TempoAtendimentoUnidadeDTO.class, "prioridadeUnidadeSerializados", request);
				}

				List<TempoAtendimentoEmpregadoDTO> listaTempoAtendimentoEmpregado = new ArrayList<>();
				if (tempoAtendimentoDto.getPrioridadeEmpregadoSerializados() != null && !tempoAtendimentoDto.getPrioridadeEmpregadoSerializados().isEmpty()) {
					listaTempoAtendimentoEmpregado = (ArrayList<TempoAtendimentoEmpregadoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(TempoAtendimentoEmpregadoDTO.class, "prioridadeEmpregadoSerializados", request);
				}

				AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
				Reflexao.copyPropertyValues(tempoAtendimentoDto, acordoNivelServicoDTO);

				acordoNivelServicoDTO.setModificadoEm(UtilDatas.getDataHoraAtual());
				acordoNivelServicoDTO.setTipo("T");

				// Adicao historico
				AcordoNivelServicoHistoricoDTO acordoNivelServicoHistoricoDTO = new AcordoNivelServicoHistoricoDTO();

				UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

				Reflexao.copyPropertyValues(acordoNivelServicoDTO, acordoNivelServicoHistoricoDTO);

				acordoNivelServicoHistoricoDTO.setCriadoEm(UtilDatas.getDataHoraAtual());
				acordoNivelServicoHistoricoDTO.setModificadoEm(UtilDatas.getDataHoraAtual());
				acordoNivelServicoHistoricoDTO.setCriadoPor(usuarioDto.getNomeUsuario());
				acordoNivelServicoHistoricoDTO.setModificadoPor(usuarioDto.getNomeUsuario());
				acordoNivelServicoHistoricoDTO.setConteudodados(UtilHashMaps.generateString(document.getValuesForm()));

				getAcordoNivelServicoService().addAcordoNivelServicoMultiNivel(acordoNivelServicoDTO, listIdServicoContrato, listaTempoAtendimentoUnidade, listaTempoAtendimentoEmpregado, acordoNivelServicoHistoricoDTO);

				if (tempoAtendimentoDto.getIdAcordoNivelServico() != null) {
					document.alert(UtilI18N.internacionaliza(request, "MSG06"));
				} else {
					document.alert(UtilI18N.internacionaliza(request, "MSG05"));
				}

				document.executeScript("ANS.limpar()");
			} catch (Exception e) {
				throw new Exception(e);
			}
		}

	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

		if (tempoAtendimentoDto != null) {
			document.executeScript("ANS.limparTabelas();");
			tempoAtendimentoDto = (TempoAtendimentoDTO) getAcordoNivelServicoService().restoreTempoAtendimento(tempoAtendimentoDto.getIdAcordoNivelServico());
			document.getForm("formTempoAtendimento").clear();
			document.getForm("formTempoAtendimento").setValues(tempoAtendimentoDto);

			restoreTree(document, request, tempoAtendimentoDto, false);

			if(tempoAtendimentoDto.getListaPrioridadeUnidade() != null && !tempoAtendimentoDto.getListaPrioridadeUnidade().isEmpty()){
				for (TempoAtendimentoUnidadeDTO tempoAtendimentoUnidade : tempoAtendimentoDto.getListaPrioridadeUnidade()) {
					StringBuilder script = new StringBuilder();
					script.append("insereRowUnidade(").append(tempoAtendimentoUnidade.getIdUnidade()).append(",'").append(tempoAtendimentoUnidade.getNomeUnidade());
					script.append("',").append(tempoAtendimentoUnidade.getPrioridade()).append(");");
					document.executeScript(script.toString());
				}
			}
			if(tempoAtendimentoDto.getListaPrioridadeEmpregado() != null && !tempoAtendimentoDto.getListaPrioridadeEmpregado().isEmpty()){
				for (TempoAtendimentoEmpregadoDTO tempoAtendimentoEmpregado : tempoAtendimentoDto.getListaPrioridadeEmpregado()) {
					StringBuilder script = new StringBuilder();
					script.append("insereRowEmpregado(").append(tempoAtendimentoEmpregado.getIdEmpregado()).append(",'").append(tempoAtendimentoEmpregado.getNomeEmpregado());
					script.append("',").append(tempoAtendimentoEmpregado.getPrioridade()).append(");");
					document.executeScript(script.toString());
				}
			}

			restoreTempoAtendimento(document, tempoAtendimentoDto);
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

		if (tempoAtendimentoDto != null) {
			UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

			try {
				AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
				Reflexao.copyPropertyValues(tempoAtendimentoDto, acordoNivelServicoDTO);

				acordoNivelServicoDTO.setModificadoEm(UtilDatas.getDataHoraAtual());
				acordoNivelServicoDTO.setModificadoPor(usuarioDto.getNomeUsuario());

				getAcordoNivelServicoService().excluiAnsMulti(acordoNivelServicoDTO);

				document.alert(UtilI18N.internacionaliza(request, "MSG07"));

				document.executeScript("ANS.limpar()");

			} catch (Exception e) {
				throw new Exception(e);
			} finally {
				document.executeScript("JANELA_AGUARDE_MENU.hide()");
			}
		}

	}

	public void defineLookupUnidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

		try{
			if(tempoAtendimentoDto != null && tempoAtendimentoDto.getTipoAcordo() != null){
	            String UNIDADE_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");

	            if (UNIDADE_VINC_CONTRATOS!=null && UNIDADE_VINC_CONTRATOS.equalsIgnoreCase("S")) {

	            	if(tempoAtendimentoDto.getTipoAcordo().equals(Enumerados.TipoAnsMultinivel.CLIENTE.getChave()) && tempoAtendimentoDto.getIdContrato() != null){
	            		carregaComboUnidadesHierarquia(document, request, tempoAtendimentoDto.getIdContrato());
	            	}else{

	                	if(tempoAtendimentoDto.getTipoAcordo().equals(Enumerados.TipoAnsMultinivel.REQUISICAO.getChave()) && tempoAtendimentoDto.getIdServicoContrato() != null){
	                		ServicoContratoDTO servicoContratoDto = new ServicoContratoDTO();
	                		servicoContratoDto.setIdServicoContrato(tempoAtendimentoDto.getIdServicoContrato());
	                		servicoContratoDto = this.getServicoContratoService().restore(servicoContratoDto);

	                		if(servicoContratoDto != null && servicoContratoDto.getIdServicoContrato() != null && servicoContratoDto.getIdContrato() != null){
	                    		carregaComboUnidadesHierarquia(document, request, servicoContratoDto.getIdContrato());
	                		}else{
	                        	document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "tempoAtendimento.impossivelContinuar")+"', '');");
	                		}

	                	}else{
	                    	document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "tempoAtendimento.impossivelContinuar")+"', '');");
	                	}
	            	}

	            }else{
	            	document.executeScript("Unidade.openModalUnidade();");
	            }
			}
		} catch (Exception e) {
			throw new Exception(e);
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	private void carregaComboUnidadesHierarquia(DocumentHTML document, HttpServletRequest request, Integer idContrato) throws Exception {
		if(idContrato!=null){
			HTMLSelect comboUnidadesHierarquia = document.getSelectById("comboUnidadesHierarquia");

			iniciaCombo(document, request, comboUnidadesHierarquia);

			final ArrayList<UnidadeDTO> unidades = (ArrayList) this.getUnidadeService().listHierarquiaMultiContratos(idContrato);

			if (unidades != null && !unidades.isEmpty()) {
				for (final UnidadeDTO unidade : unidades) {
					if (unidade.getDataFim() == null) {
						comboUnidadesHierarquia.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
					}

				}
			}
			document.executeScript("Unidade.openModalUnidadeContrato("+idContrato+");");
		}else{
			document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "tempoAtendimento.impossivelContinuar")+"', '');");
		}

	}

	public ComplementoSLA_Prioridade getComplementoSLA_Prioridade() {
		if (complementoSLA_Prioridade == null) {
			complementoSLA_Prioridade = new ComplementoSLA_Prioridade();
		}

		return complementoSLA_Prioridade;
	}

	public ComplementoSLA_Grupos getComplementoSLA_Grupos() {
		if (complementoSLA_Grupos == null) {
			complementoSLA_Grupos = new ComplementoSLA_Grupos();
		}

		return complementoSLA_Grupos;
	}

	private ModeloEmailService getModeloEmailService() throws ServiceException {
		if (modeloEmailService == null) {
			modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		}
		return modeloEmailService;
	}

	/**
	 * Recupera a instncia do tempoAcordoNivelServicoService
	 *
	 * @author rodrigo.guilherme
	 * @since 26.10.2015
	 */
	public TempoAcordoNivelServicoService getTempoAcordoNivelServicoService() throws ServiceException, Exception {
		if (tempoAcordoNivelServicoService == null) {
			tempoAcordoNivelServicoService = (TempoAcordoNivelServicoService) ServiceLocator.getInstance().getService(TempoAcordoNivelServicoService.class, null);
		}
		return tempoAcordoNivelServicoService;
	}

	/**
	 * Recupera a instncia do ServicoService
	 *
	 * @author rodrigo.guilherme
	 * @since 05.11.2015
	 */
	public ServicoService getServicoService() throws ServiceException, Exception {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	/**
	 * Recupera a instncia do ServicoContratoService
	 *
	 * @author rodrigo.guilherme
	 * @since 05.11.2015
	 */
	public ServicoContratoService getServicoContratoService() throws ServiceException, Exception {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	/**
	 * Recupera a instncia do UnidadeService
	 *
	 * @author rodrigo.guilherme
	 * @since 05.11.2015
	 */
	public UnidadeService getUnidadeService() throws ServiceException, Exception {
		if (unidadeService == null) {
			unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
		}
		return unidadeService;
	}

	/**
	 * Recupera a instncia do UsuarioService
	 *
	 * @author rodrigo.guilherme
	 * @since 05.11.2015
	 */
	public UsuarioService getUsuarioService() throws ServiceException, Exception {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}

	/**
	 * Recupera a instncia do EmpregadoService
	 *
	 * @author rodrigo.guilherme
	 * @since 05.11.2015
	 */
	public EmpregadoService getEmpregadoService() throws ServiceException, Exception {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	public ContratoService getContratoService() throws ServiceException, Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	@Override
	public Class<?> getBeanClass() {
		return TempoAtendimentoDTO.class;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws Exception {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	private void restoreTempoAtendimento(DocumentHTML document, TempoAtendimentoDTO tempoAtendimentoDTO) throws Exception{
		document.getElementById("taHoraP1F1").setValue(tempoAtendimentoDTO.getHhCaptura()[0].toString());
		document.getElementById("taMinutoP1F1").setValue(tempoAtendimentoDTO.getMmCaptura()[0].toString());
		document.getElementById("taHoraP1F2").setValue(tempoAtendimentoDTO.getHhResolucao()[0].toString());
		document.getElementById("taMinutoP1F2").setValue(tempoAtendimentoDTO.getMmResolucao()[0].toString());

		document.getElementById("taHoraP2F1").setValue(tempoAtendimentoDTO.getHhCaptura()[1].toString());
		document.getElementById("taMinutoP2F1").setValue(tempoAtendimentoDTO.getMmCaptura()[1].toString());
		document.getElementById("taHoraP2F2").setValue(tempoAtendimentoDTO.getHhResolucao()[1].toString());
		document.getElementById("taMinutoP2F2").setValue(tempoAtendimentoDTO.getMmResolucao()[1].toString());

		document.getElementById("taHoraP3F1").setValue(tempoAtendimentoDTO.getHhCaptura()[2].toString());
		document.getElementById("taMinutoP3F1").setValue(tempoAtendimentoDTO.getMmCaptura()[2].toString());
		document.getElementById("taHoraP3F2").setValue(tempoAtendimentoDTO.getHhResolucao()[2].toString());
		document.getElementById("taMinutoP3F2").setValue(tempoAtendimentoDTO.getMmResolucao()[2].toString());

		document.getElementById("taHoraP4F1").setValue(tempoAtendimentoDTO.getHhCaptura()[3].toString());
		document.getElementById("taMinutoP4F1").setValue(tempoAtendimentoDTO.getMmCaptura()[3].toString());
		document.getElementById("taHoraP4F2").setValue(tempoAtendimentoDTO.getHhResolucao()[3].toString());
		document.getElementById("taMinutoP4F2").setValue(tempoAtendimentoDTO.getMmResolucao()[3].toString());

		document.getElementById("taHoraP5F1").setValue(tempoAtendimentoDTO.getHhCaptura()[4].toString());
		document.getElementById("taMinutoP5F1").setValue(tempoAtendimentoDTO.getMmCaptura()[4].toString());
		document.getElementById("taHoraP5F2").setValue(tempoAtendimentoDTO.getHhResolucao()[4].toString());
		document.getElementById("taMinutoP5F2").setValue(tempoAtendimentoDTO.getMmResolucao()[4].toString());

	}

	public void onChangeGenerateTree(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();

			generateTree(document, request, tempoAtendimentoDto, true);
		} catch (Exception e) {
			throw new Exception(e);
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	private void restoreTree(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, boolean ifRefresh) throws Exception {
		try {
			isRestoreTree = true;
			tempoAtendimentoDto.setListaIdsServicosContratosStr(Util.listIntegerToListStr(tempoAtendimentoDto.getListaIdsServicosContrato()));
			document.getForm("formTempoAtendimento").setValues(tempoAtendimentoDto);

			generateTree(document, request, tempoAtendimentoDto, true);

			isRestoreTree = false;
		} catch (Exception e) {
			throw new Exception(e);
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	private void generateTree(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, boolean ifRefresh) throws Exception {
		StringBuilder tree = new StringBuilder();

		geraSubmenuPorTipoAcordoContrato(document, request, tempoAtendimentoDto, tree);

		document.getElementById("requisicoes-incidentes-list").setInnerHTML(tree.toString());

		if (ifRefresh) {
			document.executeScript("Tree.refresh();");
		}
	}

	private void geraSubmenuPorTipoAcordoContrato(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, StringBuilder tree) throws Exception, ServiceException {
		for (TipoAcordoContrato tipoAcordoContrato : TipoAcordoContrato.values()) {
			tree.append("<li class=\"hasSubmenu\">");
			tree.append("	<a data-hidden=\"true\" class=\"glyphicons folder_open\" title=\"\" onclick=\"TipoTempoAtendimento.geraContentTipoContrato(this, '"
					+ tipoAcordoContrato.getIdentificador() + "')\">");
			tree.append("		<i></i>");
			tree.append("		<span class=\"ellipsis\">" + UtilI18N.internacionaliza(request, tipoAcordoContrato.getChavePlural()) + "</span>");
			tree.append("	</a>");

			tree.append("	<div id=\"divContentsContratos" + tipoAcordoContrato.getIdentificador() + "\">");

			if (isRestoreTree) {
				tree.append(this.getBuilderContratosTree(document, request, tempoAtendimentoDto, tipoAcordoContrato.getIdentificador()));
			}

			tree.append("	</div>");
			tree.append("</li>");
		}
	}

	public void generateContratosTree(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();
		JSONObject json = new JSONObject(tempoAtendimentoDto.getJsonTempoAtendimento());
		String identificadorTipoAcordoContrato = json.getString("tipoAcordoContrato");

		String contentContratosTree = this.getBuilderContratosTree(document, request, tempoAtendimentoDto, identificadorTipoAcordoContrato);

		if (!UtilStrings.isNullOrEmpty(contentContratosTree)) {
			HTMLElement divContentsContratos = document.getElementById("divContentsContratos" + identificadorTipoAcordoContrato);
			divContentsContratos.setInnerHTML(contentContratosTree);
			document.executeScript("TipoTempoAtendimento.showHide('" + "tableOfContentsContratos" + identificadorTipoAcordoContrato + "')");
		}
	}

	private String getBuilderContratosTree(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, String identificadorTipoAcordoContrato) throws Exception {
		StringBuilder tree = new StringBuilder();
		boolean isContratoCheckedOnRestore = false;
		String dataLoad = "";

		if (!UtilStrings.isNullOrEmpty(identificadorTipoAcordoContrato)) {
			Collection<ContratoDTO> colContratoDTO = getContratoService().listaContratosAtivosPorTipo(identificadorTipoAcordoContrato);

			if (colContratoDTO != null && !colContratoDTO.isEmpty()) {
				tree.append("	<ul class=\"list\" id=\"tableOfContentsContratos" + identificadorTipoAcordoContrato + "\" style='display: none;' >");

				for (ContratoDTO contratoDTO : colContratoDTO) {
					isContratoCheckedOnRestore = false;
					if (isRestoreTree) {
						isContratoCheckedOnRestore = tempoAtendimentoDto.getListaIdsContratosRelacionadosServicoContrato() != null
								&& tempoAtendimentoDto.getListaIdsContratosRelacionadosServicoContrato().contains(contratoDTO.getIdContrato());
						dataLoad = isContratoCheckedOnRestore ? "data-load=\"true\"" : "";
					}

					tree.append("<li class=\"hasSubmenu\">");
					tree.append("	<a data-hidden=\"true\" " + dataLoad + " class=\"glyphicons folder_open\" title=\"\" onclick=\"TipoTempoAtendimento.geraContentContrato(this, '"
							+ identificadorTipoAcordoContrato + "', " + contratoDTO.getIdContrato() + ")\">");
					tree.append("		<i></i>");
					tree.append("		<span class=\"ellipsis\">" + contratoDTO.getNumero() + "</span>");
					tree.append("	</a>");

					if (tempoAtendimentoDto.getTipoAcordo() != null) {
						if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global")) {
							tree.append("	<div class=\"option-check\"><input type=\"checkbox\" id=\"\" name=\"checkboxContrato\" value=" + contratoDTO.getIdContrato() + "  data-ref=\"tableOfContentsContrato"
									+ contratoDTO.getIdContrato() + "\" data-owner=\"tableOfContentsContratos" + contratoDTO.getTipo() + "\" /></div>");
						} else if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
							tree.append("	<div class=\"option-radio\">");
							tree.append("		<label class=\"radio\">");
							tree.append("			<input type=\"radio\" class=\"radio\" id=\"radioContratos" + contratoDTO.getIdContrato() + "\" name=\"radioContratos" + "\" data-ref=\"tableOfContentsContrato"
									+ contratoDTO.getIdContrato() + "\" value=\"" + contratoDTO.getIdContrato() + "\" ");
							if (tempoAtendimentoDto.getIdContrato() != null && tempoAtendimentoDto.getIdContrato().intValue() == contratoDTO.getIdContrato().intValue()) {
								tree.append("			checked=\"checked\"");
							}
							tree.append("			/>");
							tree.append("		</label>");
							tree.append("	</div>");
						}
					}

					tree.append("	<div id=\"divContentsContrato" + contratoDTO.getIdContrato() + "\">");

					if (isContratoCheckedOnRestore) {
						JSONObject json = new JSONObject();
						json.put("tipoAcordoContrato", identificadorTipoAcordoContrato);
						json.put("idContrato", contratoDTO.getIdContrato());
						json.put("isChecked", false);
						tree.append(this.getBuilderServicosTree(document, request, tempoAtendimentoDto, json));
					}

					tree.append("	</div>");
				}

				tree.append("	</ul>");
			}
		}

		return tree.toString();
	}

	public void generateServicosTree(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();
		JSONObject json = new JSONObject(tempoAtendimentoDto.getJsonTempoAtendimento());
		Integer idContrato = Integer.parseInt(json.getString("idContrato"));

		String contentServicosTree = this.getBuilderServicosTree(document, request, tempoAtendimentoDto, json);
		if (!Util.isNullOrEmpty(contentServicosTree)) {
			HTMLElement divContentsContratos = document.getElementById("divContentsContrato" + idContrato);
			divContentsContratos.setInnerHTML(contentServicosTree);
			document.executeScript("TipoTempoAtendimento.showHide('" + "tableOfContentsContrato" + idContrato + "')");
		}
	}

	private String getBuilderServicosTree(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, JSONObject json) throws Exception {
		StringBuilder tree = new StringBuilder();
		String identificadorTipoAcordoContrato = json.getString("tipoAcordoContrato");
		Integer idContrato = Integer.parseInt(json.getString("idContrato"));
		boolean isCheckedOnOpen = json.getBoolean("isChecked");
		boolean isServicoCheckedOnRestore = false;
		String dataLoad = "";
		String tipoServico;
		Collection<ServicoContratoDTO> colServicosNegocio;

		if (TipoAcordoContrato.CONTRATO_APOIO.getIdentificador().equals(identificadorTipoAcordoContrato)
				|| TipoAcordoContrato.ACORDO_NIVEL_OPERACIONAL.getIdentificador().equalsIgnoreCase(identificadorTipoAcordoContrato)) {
			tipoServico = Enumerados.TipoServico.SERVICO_APOIO.getIdentificador();
		} else {
			tipoServico = Enumerados.TipoServico.SERVICO_NEGOCIO.getIdentificador();
		}

		colServicosNegocio = this.getServicoContratoService().listServicosContratoByIdContratoAndTipoServico(idContrato, tipoServico);

		if (colServicosNegocio != null && !colServicosNegocio.isEmpty()) {
			tree.append("<ul class=\"list\" id=\"tableOfContentsContrato" + idContrato + "\" style='display: none;' >");

			for (ServicoContratoDTO servicoNegocio : colServicosNegocio) {
				if (isRestoreTree) {
					isServicoCheckedOnRestore = tempoAtendimentoDto.getListaIdsServicosRelacionadosServicoContrato() != null
							&& tempoAtendimentoDto.getListaIdsServicosRelacionadosServicoContrato().contains(servicoNegocio.getIdServico());
					dataLoad = isServicoCheckedOnRestore ? "data-load=\"true\"" : "";
				}

				tree.append("<li class=\"hasSubmenu\">");
				tree.append("	<a data-hidden=\"true\" " + dataLoad + " class=\"glyphicons folder_open\" title=\"\" onclick=\"TipoTempoAtendimento.geraContentServico(this, '"
						+ identificadorTipoAcordoContrato + "', " + idContrato + ", " + servicoNegocio.getIdServicoContrato() + ", " + servicoNegocio.getIdServico() + ", " + servicoNegocio.getIdPortfolioServico()
						+ ")\">");
				tree.append("		<i></i>");
				tree.append("		<span class=\"ellipsis\">" + servicoNegocio.getNomeServico() + "</span>");
				tree.append("	</a>");

				if (tempoAtendimentoDto.getTipoAcordo() != null) {
					if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
						String checked = isCheckedOnOpen ? "checked=\"checked\"" : "";
						tree.append("	<div class=\"option-check\"><input type=\"checkbox\" id=\"\" name=\"checkboxServico\"  value=" + servicoNegocio.getIdServico() + " data-idcontrato=" + idContrato
								+ " data-ref=\"tableOfContentsServico" + servicoNegocio.getIdServico() + "Contrato" + idContrato + "\" data-owner=\"tableOfContentsContrato" + idContrato + "\" " + checked + "/></div>");
					}
				}

				tree.append("<div id=\"divContentsServico" + servicoNegocio.getIdServico() + "Contrato" + idContrato + "\">");

				if (isServicoCheckedOnRestore) {
					JSONObject jsonContentServico = new JSONObject();
					jsonContentServico.put("idContrato", idContrato);
					jsonContentServico.put("idServico", servicoNegocio.getIdServico());
					jsonContentServico.put("idServicoContrato", servicoNegocio.getIdServicoContrato());
					jsonContentServico.put("idPortfolio", servicoNegocio.getIdPortfolioServico());
					jsonContentServico.put("isChecked", false);

					tree.append(this.getBuilderServicosContentTree(document, request, tempoAtendimentoDto, jsonContentServico));
				}

				tree.append("</div>");
			}

			tree.append("</ul>");
		}

		return tree.toString();
	}

	public void generateServicosContentTree(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TempoAtendimentoDTO tempoAtendimentoDto = (TempoAtendimentoDTO) document.getBean();
		JSONObject json = new JSONObject(tempoAtendimentoDto.getJsonTempoAtendimento());
		Integer idContrato = Integer.parseInt(json.getString("idContrato"));
		Integer idServico = Integer.parseInt(json.getString("idServico"));

		String contentBuilderServicosContentTree = this.getBuilderServicosContentTree(document, request, tempoAtendimentoDto, json);
		if (!UtilStrings.isNullOrEmpty(contentBuilderServicosContentTree)) {
			HTMLElement divContentsContratos = document.getElementById("divContentsServico" + idServico + "Contrato" + idContrato);
			divContentsContratos.setInnerHTML(contentBuilderServicosContentTree);
			document.executeScript("TipoTempoAtendimento.showHide('" + "tableOfContentsServico" + idServico + "Contrato" + idContrato + "')");
		}
	}

	private String getBuilderServicosContentTree(DocumentHTML document, HttpServletRequest request, TempoAtendimentoDTO tempoAtendimentoDto, JSONObject json) throws Exception {
		StringBuilder tree = new StringBuilder();
		Integer idContrato = Integer.parseInt(json.getString("idContrato"));
		Integer idServico = Integer.parseInt(json.getString("idServico"));
		Integer idServicoContrato = Integer.parseInt(json.getString("idServicoContrato"));
		Integer idPortfolio = Integer.parseInt(json.getString("idPortfolio"));
		boolean isCheckedOnOpen = json.getBoolean("isChecked");

		Collection<ServicoContratoDTO> requisicoes = this.getServicoContratoService().listRequisicoesIncidentesProcedimentosByIdServicoIdContrato(Enumerados.TipoServico.SERVICO_REQUISICAO.getIdentificador(), idPortfolio,
				idServico, idContrato);

		Collection<ServicoContratoDTO> incidentes = this.getServicoContratoService().listRequisicoesIncidentesProcedimentosByIdServicoIdContrato(Enumerados.TipoServico.SERVICO_INCIDENTE.getIdentificador(), idPortfolio,
				idServico, idContrato);

		Collection<ServicoContratoDTO> procedimentos = this.getServicoContratoService().listRequisicoesIncidentesProcedimentosByIdServicoIdContrato(Enumerados.TipoServico.SERVICO_PROCEDIMENTO.getIdentificador(),
				idPortfolio, idServico, idContrato);

		if ((requisicoes != null && !requisicoes.isEmpty()) || (incidentes != null && !incidentes.isEmpty()) || (procedimentos != null && !procedimentos.isEmpty())) {
			tree.append("<ul class=\"list\" id=\"tableOfContentsServico" + idServico + "Contrato" + idContrato + "\" style='display: none;' >");

			if (requisicoes != null && !requisicoes.isEmpty()) {
				tree.append(generateRequisicoesTree(requisicoes, tempoAtendimentoDto, idContrato, idServicoContrato, idServico, isCheckedOnOpen, request));
			}

			if (incidentes != null && !incidentes.isEmpty()) {
				tree.append(generateIncidentesTree(incidentes, tempoAtendimentoDto, idContrato, idServicoContrato, idServico, isCheckedOnOpen, request));
			}

			if (procedimentos != null && !procedimentos.isEmpty()) {
				tree.append(generateProcedimentosTree(procedimentos, tempoAtendimentoDto, idContrato, idServicoContrato, idServico, isCheckedOnOpen, request));
			}

			tree.append("</ul>");
		}

		return tree.toString();
	}

	private String generateRequisicoesTree(Collection<ServicoContratoDTO> requisicoes, TempoAtendimentoDTO tempoAtendimentoDto, Integer idContrato, Integer idServicoContrato, Integer idServico, boolean isCheckedOnOpen,
			HttpServletRequest request)
			throws Exception {
		StringBuilder tree = new StringBuilder();

		if (requisicoes != null && !requisicoes.isEmpty()) {
			List<Integer> listaIdsServicosContrato = Util.listStrToListInteger(tempoAtendimentoDto.getListaIdsServicosContratosStr());

			tree.append("<li class=\"hasSubmenu\">");
			tree.append("	<a class=\"glyphicons folder_open\" href=\"#tableOfContentsRequisicoes" + idServicoContrato + "\" title=\"\" onclick=\"TipoTempoAtendimento.showHide('" + "tableOfContentsRequisicoes"
					+ idServicoContrato + "');\">");
			tree.append("		<i></i>");
			tree.append("		<span class=\"ellipsis\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.requisicoes")).append("</span>");
			tree.append("	</a>");

			if (tempoAtendimentoDto.getTipoAcordo() != null) {
				if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
					String checked = isCheckedOnOpen ? "checked=\"checked\"" : "";
					tree.append("	<div class=\"option-check\"><input type=\"checkbox\" id=\"\" name=\"\" data-ref=\"tableOfContentsRequisicoes" + idServicoContrato + "\" data-owner=\"tableOfContentsServico" + idServico
							+ "Contrato" + idContrato + "\" " + checked + " /></div>");
				}
			}

			tree.append("<ul class=\"list\" id=\"tableOfContentsRequisicoes" + idServicoContrato + "\" style='display: none;' >");

			for(ServicoContratoDTO requisicao : requisicoes){

				tree.append("<li class=\"hasSubmenu\">");
				tree.append("	<a class=\"glyphicons chevron-right\" href=\"#tableOfContentsRequisicao" + requisicao.getIdServicoContrato()
						+ "\" title=\"\" onclick=\"Tree.toggleClick(this); return false;\">");
				tree.append("		<i></i>");
				tree.append("		<span class=\"ellipsis\">"+requisicao.getNomeServico()+"</span>");
				tree.append("	</a>");

				if (tempoAtendimentoDto.getTipoAcordo() != null) {
					if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {

						tree.append("	<div class=\"option-check\"><input type=\"checkbox\" class=\"checkbox\" id=\"checkboxServicoContrato_" + requisicao.getIdServicoContrato()
								+ "\" name=\"checkboxServicoContrato\" value=" + requisicao.getIdServicoContrato() + " data-owner=\"tableOfContentsRequisicoes" + idServicoContrato + "\" ");

						if ((listaIdsServicosContrato != null && listaIdsServicosContrato.contains(requisicao.getIdServicoContrato().intValue())) || isCheckedOnOpen) {
							tree.append(" checked=\"checked\" ");
						}

						tree.append("	/></div> ");

					} else {
						tree.append("	<div class=\"option-radio\">");
						tree.append("		<label class=\"radio\">");
						tree.append("			<input type=\"radio\" class=\"radio\" id=\"radioServicoContrato_" + requisicao.getIdServicoContrato() + "\" name=\"radioServicoContrato\" value="
								+ requisicao.getIdServicoContrato() + " data-owner=\"tableOfContentsRequisicoes" + idServicoContrato + "\" ");
						if (tempoAtendimentoDto.getIdServicoContrato() != null && tempoAtendimentoDto.getIdServicoContrato().equals(requisicao.getIdServicoContrato().intValue())) {
							tree.append("			checked=\"checked\"");
						}
						tree.append("			/>");
						tree.append("		</label>");
						tree.append("	</div>");
					}
				}

				tree.append("</li>");
			}

			tree.append("</ul>");
		}

		return tree.toString();
	}

	private String generateIncidentesTree(Collection<ServicoContratoDTO> incidentes, TempoAtendimentoDTO tempoAtendimentoDto, Integer idContrato, Integer idServicoContrato, Integer idServico, boolean isCheckedOnOpen,
			HttpServletRequest request)
			throws Exception {
		StringBuilder tree = new StringBuilder();

		if (incidentes != null && !incidentes.isEmpty()) {
			List<Integer> listaIdsServicosContrato = Util.listStrToListInteger(tempoAtendimentoDto.getListaIdsServicosContratosStr());

			tree.append("<li class=\"hasSubmenu\">");
			tree.append("	<a class=\"glyphicons folder_open\" href=\"#tableOfContentsIncidentes" + idServicoContrato + "\" title=\"\" onclick=\"TipoTempoAtendimento.showHide('" + "tableOfContentsIncidentes"
					+ idServicoContrato + "');\">");
			tree.append("		<i></i>");
			tree.append("		<span class=\"ellipsis\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.incidentes")).append("</span>");
			tree.append("	</a>");

			if (tempoAtendimentoDto.getTipoAcordo() != null) {
				if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
					String checked = isCheckedOnOpen ? "checked=\"checked\"" : "";
					tree.append("	<div class=\"option-check\"><input type=\"checkbox\" id=\"\" name=\"\" data-ref=\"tableOfContentsIncidentes" + idServicoContrato
							+ "\" data-owner=\"tableOfContentsServico" + idServico + "Contrato" + idContrato + "\" " + checked + " /></div>");
				}
			}

			tree.append("<ul class=\"list\" id=\"tableOfContentsIncidentes" + idServicoContrato + "\" style='display: none;' >");

			for (ServicoContratoDTO incidente : incidentes) {
				tree.append("<li class=\"hasSubmenu\">");
				tree.append("	<a class=\"glyphicons chevron-right\" href=\"#tableOfContentsIncidente" + incidente.getIdServicoContrato()
						+ "\" title=\"\" onclick=\"Tree.toggleClick(this); return false;\">");
				tree.append("		<i></i>");
				tree.append("		<span class=\"ellipsis\">" + incidente.getNomeServico() + "</span>");
				tree.append("	</a>");

				if (tempoAtendimentoDto.getTipoAcordo() != null) {
					if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
						tree.append("	<div class=\"option-check\"><input type=\"checkbox\" class=\"checkbox\" id=\"checkboxServicoContrato_" + incidente.getIdServicoContrato()
								+ "\" name=\"checkboxServicoContrato\" value=" + incidente.getIdServicoContrato() + " data-owner=\"tableOfContentsIncidentes" + idServicoContrato + "\" ");

						if ((listaIdsServicosContrato != null && listaIdsServicosContrato.contains(incidente.getIdServicoContrato().intValue())) || isCheckedOnOpen) {
							tree.append(" checked=\"checked\" ");
						}

						tree.append("	/></div> ");
					} else {
						tree.append("	<div class=\"option-radio\">");
						tree.append("		<label class=\"radio\">");
						tree.append("			<input type=\"radio\" class=\"radio\" id=\"radioServicoContrato_" + incidente.getIdServicoContrato() + "\" name=\"radioServicoContrato\" value="
								+ incidente.getIdServicoContrato() + " data-owner=\"tableOfContentsIncidentes" + idServicoContrato + "\" ");
						if (tempoAtendimentoDto.getIdServicoContrato() != null && tempoAtendimentoDto.getIdServicoContrato().equals(incidente.getIdServicoContrato().intValue())) {
							tree.append("			checked=\"checked\"");
						}
						tree.append("			/> ");
						tree.append("		</label>");
						tree.append("	</div>");
					}
				}

				tree.append("</li>");
			}

			tree.append("</ul>");
		}

		return tree.toString();
	}

	private String generateProcedimentosTree(Collection<ServicoContratoDTO> procedimentos, TempoAtendimentoDTO tempoAtendimentoDto, Integer idContrato, Integer idServicoContrato, Integer idServico,
			boolean isCheckedOnOpen,
			HttpServletRequest request)
			throws Exception {
		StringBuilder tree = new StringBuilder();

		if (procedimentos != null && !procedimentos.isEmpty()) {
			List<Integer> listaIdsServicosContrato = Util.listStrToListInteger(tempoAtendimentoDto.getListaIdsServicosContratosStr());

			tree.append("<li class=\"hasSubmenu\">");
			tree.append("	<a class=\"glyphicons folder_open\" href=\"#tableOfContentsProcedimentos" + idServicoContrato + "\" title=\"\" onclick=\"TipoTempoAtendimento.showHide('" + "tableOfContentsProcedimentos"
					+ idServicoContrato + "');\">");
			tree.append("		<i></i>");
			tree.append("		<span class=\"ellipsis\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.procedimentos")).append("</span>");
			tree.append("	</a>");

			if (tempoAtendimentoDto.getTipoAcordo() != null) {
				if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
					String checked = isCheckedOnOpen ? "checked=\"checked\"" : "";
					tree.append("	<div class=\"option-check\"><input type=\"checkbox\" id=\"\" name=\"\" data-ref=\"tableOfContentsProcedimentos" + idServicoContrato + "\" data-owner=\"tableOfContentsServico"
							+ idServico + "Contrato" + idContrato + "\" " + checked + " /></div>");
				}
			}

			tree.append("<ul class=\"list\" id=\"tableOfContentsProcedimentos" + idServicoContrato + "\" style='display: none;' >");

			for (ServicoContratoDTO procedimento : procedimentos) {
				tree.append("<li class=\"hasSubmenu\">");
				tree.append("	<a class=\"glyphicons chevron-right\" href=\"#tableOfContentsProcedimentos" + procedimento.getIdServicoContrato()
						+ "\" title=\"\" onclick=\"Tree.toggleClick(this); return false;\">");
				tree.append("		<i></i>");
				tree.append("		<span class=\"ellipsis\">" + procedimento.getNomeServico() + "</span>");
				tree.append("	</a>");

				if (tempoAtendimentoDto.getTipoAcordo() != null) {
					if (tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("global") || tempoAtendimentoDto.getTipoAcordo().equalsIgnoreCase("cliente")) {
						tree.append("	<div class=\"option-check\"><input type=\"checkbox\" class=\"checkbox\" id=\"checkboxServicoContrato_" + procedimento.getIdServicoContrato()
								+ "\" name=\"checkboxServicoContrato\" value=" + procedimento.getIdServicoContrato() + " data-owner=\"tableOfContentsIncidentes"
								+ idServicoContrato + "\" ");

						if ((listaIdsServicosContrato != null && listaIdsServicosContrato.contains(procedimento.getIdServicoContrato().intValue())) || isCheckedOnOpen) {
							tree.append(" checked=\"checked\" ");
						}

						tree.append("	/></div> ");
					} else {
						tree.append("	<div class=\"option-radio\">");
						tree.append("		<label class=\"radio\">");
						tree.append("			<input type=\"radio\" class=\"radio\" id=\"radioServicoContrato_" + procedimento.getIdServicoContrato() + "\" name=\"radioServicoContrato\" value="
								+ procedimento.getIdServicoContrato() + " data-owner=\"tableOfContentsProcedimentos" + idServicoContrato + "\" ");
						if (tempoAtendimentoDto.getIdServicoContrato() != null && tempoAtendimentoDto.getIdServicoContrato().equals(procedimento.getIdServicoContrato().intValue())) {
							tree.append("			checked=\"checked\"");
						}
						tree.append("			/> ");
						tree.append("		</label>");
						tree.append("	</div>");
					}
				}

				tree.append("</li>");
			}

			tree.append("</ul>");
		}

		return tree.toString();
	}
}