/**
 * CentralIT - CITSmart.
 */
package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.TipoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.negocio.CaracteristicaService;
import br.com.centralit.citcorpore.negocio.CaracteristicaTipoItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.TipoItemConfiguracaoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.WebUtil;

/**
 * Action de TipoItemConfiguracao.
 * 
 * @author valdoilo.damasceno
 * @author flavio.santana
 * @since 15/05/2013
 * 
 */
public class TipoItemConfiguracao extends AjaxFormAction {

    /** Bean de TipoItemConfiguracao. */
    private TipoItemConfiguracaoDTO tipoItemConfiguracaoBean;

    @Override
    public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
    	/*Combo de status*/
		HTMLSelect comboCategoria = document.getSelectById("categoria");
		comboCategoria.removeAllOptions();
		for (Enumerados.CategoriaTipoItemConfiguracao st : Enumerados.CategoriaTipoItemConfiguracao.values()) {
			comboCategoria.addOption(st.getItem().toString(), st.getDescricao());
		}

		List<String> listaImagens = new ArrayList<String>();
		listaImagens.add("desktop_windows");
		listaImagens.add("desktop_mac");
		listaImagens.add("computer");
		listaImagens.add("cast");
		listaImagens.add("developer_board");
		listaImagens.add("device_hub");
		listaImagens.add("dock");
		listaImagens.add("headset");
		listaImagens.add("keyboard");
		listaImagens.add("memory");
		listaImagens.add("mouse");
		listaImagens.add("smartphone");
		listaImagens.add("router");
		listaImagens.add("scanner");
		listaImagens.add("security");
		listaImagens.add("speaker");
		listaImagens.add("cloud");
		listaImagens.add("settings");
		listaImagens.add("settings_input_component");
		listaImagens.add("settings_input_hdmi");
		listaImagens.add("usb");
		listaImagens.add("folder");
		listaImagens.add("local_printshop");
		listaImagens.add("local_dining");
		listaImagens.add("local_phone");
		listaImagens.add("camera_alt");
		listaImagens.add("camera_roll");
		listaImagens.add("mic");
		listaImagens.add("local_cafe");
		listaImagens.add("local_library");
		listaImagens.add("local_atm");
		listaImagens.add("leak_add");
		listaImagens.add("image");
		listaImagens.add("radio");
		listaImagens.add("filter_list");
		listaImagens.add("devices");
		listaImagens.add("extension");
		listaImagens.add("album");
		listaImagens.add("web");
		listaImagens.add("question_answer");
		listaImagens.add("visibility");
		listaImagens.add("videocam");
		listaImagens.add("music_note");
		listaImagens.add("person");
		listaImagens.add("people");
		listaImagens.add("domain");
		listaImagens.add("live_tv");
		listaImagens.add("adb");
		listaImagens.add("accessibility");
		listaImagens.add("alarm");
		listaImagens.add("event_seat");
		listaImagens.add("store");
		listaImagens.add("theaters");
		listaImagens.add("surround_sound");
		listaImagens.add("email");
		listaImagens.add("vpn_key");
		listaImagens.add("dvr");
		listaImagens.add("storage");
		listaImagens.add("wallpaper");
		listaImagens.add("watch");
		listaImagens.add("tune");
		listaImagens.add("event_note");
		listaImagens.add("power");

		StringBuilder sb = new StringBuilder();
		for (String imagem : listaImagens) {
			sb.append("<label style=\"text-align: center;margin-left:10px;\">");
			sb.append("	<i class=\"material-icons md-36\">" + imagem + "</i>");
			sb.append("	<input class='' type='radio' name='imagem' value='" + imagem + "' />");
			sb.append("</label>");
		}
		document.getElementById("imagens").setInnerHTML(sb.toString());

    }

    /**
	 * Inclui Novo Item de Configurao.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    @SuppressWarnings("rawtypes")
    public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setTipoItemConfiguracaoBean((TipoItemConfiguracaoDTO) document.getBean());
		this.getTipoItemConfiguracaoBean().setNome(this.getTipoItemConfiguracaoBean().getNome().trim());
	
		this.getTipoItemConfiguracaoBean().setCaracteristicas(
			(List) WebUtil.deserializeCollectionFromRequest(CaracteristicaDTO.class, "caracteristicasSerializadas", request));
	
		if (this.getTipoItemConfiguracaoBean().getId() == null || this.getTipoItemConfiguracaoBean().getId().intValue() == 0) {
			if(getTipoItemConfiguracaoService().verificarSeTipoItemConfiguracaoExiste(getTipoItemConfiguracaoBean())){				
				document.alert(UtilI18N.internacionaliza(request, "MSE01") );				
				return;
			}
		    this.getTipoItemConfiguracaoService().create(this.getTipoItemConfiguracaoBean(), request);		    
		    document.alert(UtilI18N.internacionaliza(request, "MSG05") );
		} else {
			if(getTipoItemConfiguracaoService().verificarSeTipoItemConfiguracaoExiste(getTipoItemConfiguracaoBean())){
				document.alert(UtilI18N.internacionaliza(request, "MSE01") );				
				return;
			}
		    this.getTipoItemConfiguracaoService().update(this.getTipoItemConfiguracaoBean());
		    document.alert(UtilI18N.internacionaliza(request, "MSG06") );
		}
	
		CITCorporeUtil.limparFormulario(document);
		document.executeScript("ocultaGrid()");
		HTMLTable tabelaCaracteristica = document.getTableById("tabelaCaracteristica");
		tabelaCaracteristica.deleteAllRows();
    }

    /**
	 * Restaura Tela de Tipo Item Configurao.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setTipoItemConfiguracaoBean((TipoItemConfiguracaoDTO) document.getBean());
		this.setTipoItemConfiguracaoBean(this.getTipoItemConfiguracaoService().restore(this.getTipoItemConfiguracaoBean()));
		document.executeScript("deleteAllRows()");
		HTMLForm form = CITCorporeUtil.limparFormulario(document);
		form.setValues(this.getTipoItemConfiguracaoBean());
		this.bloquearDesbloquearTag(document);
		if (this.getTipoItemConfiguracaoBean() != null) {
		    this.getTipoItemConfiguracaoService().restaurarGridCaracteristicas(document,
			    this.getCaracteristicaService().consultarCaracteristicasAtivas(this.getTipoItemConfiguracaoBean().getId()));
		}
		
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
		
    }
    
    /**
     * Bloquea ou desbloqueia TAG.
     * 
     * @param document
     * @author valdoilo.damasceno
     */
    private void bloquearDesbloquearTag(DocumentHTML document) {
		if (this.getTipoItemConfiguracaoBean().getSistema() != "N") {
		    document.executeScript("bloquearTag(+" + true + ")");
		} else {
		    document.executeScript("bloquearTag(+" + false + ")");
		}
    }

    /**
	 * Exclui Tipo Item Configurao e suas caractersticas.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    public void excluirTipoItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setTipoItemConfiguracaoBean((TipoItemConfiguracaoDTO) document.getBean());
	
		if (!this.verificaAssociacaoItemConfiguracao()){
			if (this.getTipoItemConfiguracaoBean().getId() != null && this.getTipoItemConfiguracaoBean().getId() != 0) {
			    this.getTipoItemConfiguracaoBean().setDataFim(UtilDatas.getDataAtual());
			    this.getTipoItemConfiguracaoService().update(this.getTipoItemConfiguracaoBean());
		
			    this.getCaracteristicaTipoItemConfiguracaoService().excluirAssociacaoCaracteristicaTipoItemConfiguracao(
				    this.getTipoItemConfiguracaoBean().getId(), null);
		
			    CITCorporeUtil.limparFormulario(document);
			    document.executeScript("ocultaGrid()");
			    document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "grupo.deletar.tipoItemConfiguracao"));
		}
    }

    /**
	 * Exclui caracterstica do Tipo Item Configurao.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    public void excluirAssociacaoCaracteristicaTipoItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response)
	    throws Exception {
		Integer idCaracteristica = !request.getParameter("caracteristicaSerializada").isEmpty() ? Integer.parseInt(request
			.getParameter("caracteristicaSerializada")) : null;
		
		CaracteristicaDTO caracteristica = new CaracteristicaDTO();
		if(idCaracteristica != null) {
			caracteristica.setIdCaracteristica(idCaracteristica);
			caracteristica = (CaracteristicaDTO) this.getCaracteristicaService().restore(caracteristica);	
			
			/*
			 * Retirado da rotina para validao da pink elephant &&
			 * caracteristica.getSistema() == "N";
			 */
			if (caracteristica != null ){
				this.setTipoItemConfiguracaoBean((TipoItemConfiguracaoDTO) document.getBean());
				this.getCaracteristicaTipoItemConfiguracaoService().excluirAssociacaoCaracteristicaTipoItemConfiguracao(this.getTipoItemConfiguracaoBean().getId(), idCaracteristica);
				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			}
		}
		
		
    }

    /**
     * Retorna Service de TipoItemConfiguracao.
     * 
     * @return TipoItemConfiguracaoService
     * @throws ServiceException
     * @throws Exception
     * @author valdoilo.damasceno
     */
    public TipoItemConfiguracaoService getTipoItemConfiguracaoService() throws ServiceException, Exception {
	return (TipoItemConfiguracaoService) ServiceLocator.getInstance().getService(TipoItemConfiguracaoService.class, null);
    }

    /**
	 * Retorna Service de Caracterstica.
	 * 
	 * @return CaracteristicaService
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
    public CaracteristicaService getCaracteristicaService() throws ServiceException, Exception {
	return (CaracteristicaService) ServiceLocator.getInstance().getService(CaracteristicaService.class, null);
    }

    /**
     * Retorna Service de CaracteristicaTipoItemConfiguracao.
     * 
     * @return CaracteristicaTipoItemConfiguracaoService
     * @throws ServiceException
     * @throws Exception
     * @author valdoilo.damasceno
     */
    public CaracteristicaTipoItemConfiguracaoService getCaracteristicaTipoItemConfiguracaoService() throws ServiceException, Exception {
	return (CaracteristicaTipoItemConfiguracaoService) ServiceLocator.getInstance().getService(CaracteristicaTipoItemConfiguracaoService.class,
		null);
    }

    /**
	 * Retorna Tipo Item Configurao.
	 * 
	 * @return TipoItemConfiguracaoDTO
	 * @author valdoilo.damasceno
	 */
    public TipoItemConfiguracaoDTO getTipoItemConfiguracaoBean() {
	return this.tipoItemConfiguracaoBean;
    }

    /**
	 * Configura Tipo Item Configurao.
	 * 
	 * @param tipoItemConfiguracao
	 *            - IDto
	 * @author valdoilo.damasceno
	 */
    public void setTipoItemConfiguracaoBean(IDto tipoItemConfiguracao) {
	this.tipoItemConfiguracaoBean = (TipoItemConfiguracaoDTO) tipoItemConfiguracao;
    }

    /*
     * (non-Javadoc)
     * 
     * @see br.com.centralit.citajax.html.AjaxFormAction#getBeanClass()
     */
    @SuppressWarnings("rawtypes")
    @Override
    public Class getBeanClass() {
	return TipoItemConfiguracaoDTO.class;
    }
    
    public static java.util.List<String> listDirectorioImagens(File dir) {  
	    List<String> lista = new ArrayList<String>();
		if (dir.isDirectory()) {  
	        String[] filhos = dir.list();  
	        for (int i = 0; i < filhos.length; i++) {
	            File nome = new File(dir, filhos[i]);  
	            if (nome.isFile()) {  
	                if (nome.getName().endsWith(".png")) {  
	                    lista.add(nome.getName());  
	                }  
	            }
	        }  
	    } 
	    return lista;  
	}
    
    /**
	 * Verifica se o Tipo Item Configurao est associado a algum Item
	 * Configurao
	 * 
	 * @return
	 * @throws Exception
	 * @throws ServiceException
	 * @author thyen.chang
	 */
    public boolean verificaAssociacaoItemConfiguracao() throws ServiceException, Exception{
    	return this.getTipoItemConfiguracaoService().verificaAssociacaoItemConfiguracao(this.getTipoItemConfiguracaoBean());
    }

}
