package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.bpm.dto.TipoFluxoDTO;
import br.com.centralit.bpm.servico.TipoFluxoService;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.bean.TipoMudancaDTO;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ModeloEmailService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.TipoMudancaService;
import br.com.centralit.citcorpore.util.Enumerados.Processos;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings("unchecked")
public class TipoMudanca extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		document.focusInFirstActivateField(null);

		this.preencherComboTipoFluxo(document, request);
		this.preencherComboEmailCriacao(document, request);
		this.preencherComboEmailFinalizacao(document, request);
		this.preencherComboEmailAcoes(document, request);
		this.preencherComboGrupoExecutor(document, request);
		this.preencherComboCalendario(document, request);
	}

	@Override
	public Class<TipoMudancaDTO> getBeanClass() {
		return TipoMudancaDTO.class;
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TipoMudancaDTO tipoMudancaDTO = (TipoMudancaDTO) document.getBean();
		TipoMudancaService tipoMudancaService = (TipoMudancaService) ServiceLocator.getInstance().getService(TipoMudancaService.class, WebUtil.getUsuarioSistema(request));

		// Se j existir gravado no sistema o tipo selecionado mostrar a mensagem de tipo j cadastrado
		if (tipoMudancaService.verificarTipoMudancaAtivos(tipoMudancaDTO)) {
			document.alert(UtilI18N.internacionaliza(request, "MSE01"));
			return;
		}

		if (tipoMudancaDTO.getIdTipoMudanca() == null || tipoMudancaDTO.getIdTipoMudanca() == 0) {
			tipoMudancaDTO.setDataInicio(UtilDatas.getDataAtual());
			tipoMudancaService.create(tipoMudancaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
		} else {
			tipoMudancaService.update(tipoMudancaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			return;
		}

		HTMLForm form = document.getForm("form");
		form.clear();
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TipoMudancaDTO tipoMudancaDTO = (TipoMudancaDTO) document.getBean();
		TipoMudancaService tipoMudancaService = (TipoMudancaService) ServiceLocator.getInstance().getService(TipoMudancaService.class, null);
		tipoMudancaDTO = (TipoMudancaDTO) tipoMudancaService.restore(tipoMudancaDTO);

		if (tipoMudancaDTO != null) {
			HTMLForm form = document.getForm("form");
			form.clear();
			form.setValues(tipoMudancaDTO);
		}
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		TipoMudancaDTO tipoMudancaDTO = (TipoMudancaDTO) document.getBean();
		TipoMudancaService tipoMudancaService = (TipoMudancaService) ServiceLocator.getInstance().getService(TipoMudancaService.class, WebUtil.getUsuarioSistema(request));
		RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);

		if (tipoMudancaDTO.getIdTipoMudanca().intValue() > 0) {

			if (requisicaoMudancaService.verificarSeRequisicaoMudancaPossuiTipoMudanca(tipoMudancaDTO.getIdTipoMudanca())) {
				document.alert(UtilI18N.internacionaliza(request, "MSG08"));
				return;
			}
			tipoMudancaDTO.setDataFim(UtilDatas.getDataAtual());
			tipoMudancaService.updateNotNull(tipoMudancaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));

		}

		HTMLForm form = document.getForm("form");
		form.clear();
	}

	private void inicializarCombo(HttpServletRequest request, HTMLSelect combo) {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private void preencherComboTipoFluxo(DocumentHTML document, HttpServletRequest request) throws Exception {
		TipoFluxoService tipoFluxoService = (TipoFluxoService) ServiceLocator.getInstance().getService(TipoFluxoService.class, null);
		HTMLSelect comboFluxo = document.getSelectById("idTipoFluxo");
		Collection<TipoFluxoDTO> fluxo = tipoFluxoService.list();

		inicializarCombo(request, comboFluxo);

		for (TipoFluxoDTO tipoFluxoDTO : fluxo) {
			if (tipoFluxoDTO.getIdTipoFluxo() != null && tipoFluxoDTO.getIdTipoFluxo() > 0) {
				comboFluxo.addOption(tipoFluxoDTO.getIdTipoFluxo().toString(), StringEscapeUtils.escapeJavaScript(tipoFluxoDTO.getNomeFluxo().toString()));
			}
		}
	}

	private void preencherComboEmailCriacao(DocumentHTML document, HttpServletRequest request) throws Exception {

		ModeloEmailService modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		HTMLSelect comboEmailCriacao = document.getSelectById("idModeloEmailCriacao");
		Collection<ModeloEmailDTO> emailCriacao = modeloEmailService.getAtivos();

		inicializarCombo(request, comboEmailCriacao);

		if (emailCriacao != null) {
			for (ModeloEmailDTO modeloEmailDTO : emailCriacao) {
				if (modeloEmailDTO.getIdProcesso() != null && modeloEmailDTO.getIdProcesso().equals(Processos.GESTAO_DE_MUDANCAS.getKey())) {
					comboEmailCriacao.addOption(modeloEmailDTO.getIdModeloEmail().toString(), StringEscapeUtils.escapeJavaScript(modeloEmailDTO.getTitulo().toString()));
				}
			}
		}
	}

	private void preencherComboEmailFinalizacao(DocumentHTML document, HttpServletRequest request) throws Exception {
		ModeloEmailService modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		HTMLSelect comboEmailFinalizacao = document.getSelectById("idModeloEmailFinalizacao");
		Collection<ModeloEmailDTO> emailFinalizacao = modeloEmailService.getAtivos();

		inicializarCombo(request, comboEmailFinalizacao);

		if (emailFinalizacao != null) {
			for (ModeloEmailDTO modeloEmailDTO : emailFinalizacao) {
				if (Processos.GESTAO_DE_MUDANCAS.getKey().equals(modeloEmailDTO.getIdProcesso())) {
					comboEmailFinalizacao.addOption(modeloEmailDTO.getIdModeloEmail().toString(), StringEscapeUtils.escapeJavaScript(modeloEmailDTO.getTitulo().toString()));
				}
			}
		}
	}

	private void preencherComboEmailAcoes(DocumentHTML document, HttpServletRequest request) throws Exception {
		ModeloEmailService modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		HTMLSelect comboEmailAcoes = document.getSelectById("idModeloEmailAcoes");

		Collection<ModeloEmailDTO> emailAcoes = modeloEmailService.getAtivos();

		inicializarCombo(request, comboEmailAcoes);

		if (emailAcoes != null) {
			for (ModeloEmailDTO modeloEmailDTO : emailAcoes) {
				if (Processos.GESTAO_DE_MUDANCAS.getKey().equals(modeloEmailDTO.getIdProcesso())) {
					comboEmailAcoes.addOption(modeloEmailDTO.getIdModeloEmail().toString(), StringEscapeUtils.escapeJavaScript(modeloEmailDTO.getTitulo().toString()));
				}
			}
		}
	}

	private void preencherComboGrupoExecutor(DocumentHTML document, HttpServletRequest request) throws Exception {
		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		HTMLSelect comboGrupoExecutor = document.getSelectById("idGrupoExecutor");
		Collection<GrupoDTO> grupoDTO = grupoService.listarGruposAtivos();

		inicializarCombo(request, comboGrupoExecutor);

		if (grupoDTO != null) {
			for (GrupoDTO grupo : grupoDTO) {
				comboGrupoExecutor.addOption(grupo.getIdGrupo().toString(), StringEscapeUtils.escapeJavaScript(grupo.getNome().toString()));
			}
		}
	}

	private void preencherComboCalendario(DocumentHTML document, HttpServletRequest request) throws Exception {
		CalendarioService calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		HTMLSelect comboCalendario = document.getSelectById("idCalendario");
		Collection<CalendarioDTO> calendarioDTO = calendarioService.list();

		inicializarCombo(request, comboCalendario);

		if (calendarioDTO != null) {
			for (CalendarioDTO calendario : calendarioDTO) {
				comboCalendario.addOption(calendario.getIdCalendario().toString(), StringEscapeUtils.escapeJavaScript(calendario.getDescricao().toString()));
			}
		}
	}
}
