package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.TipoAnexoCasoNegocio;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

/**
 * @author ibimon.morais
 *
 * @see 13/10/2015
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class UploadCasoDeNegocio extends AjaxFormAction {
	@Override
	public Class<UploadDTO> getBeanClass() {
		return UploadDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final br.com.centralit.citcorpore.util.Upload upload = new br.com.centralit.citcorpore.util.Upload();
		Collection<Object> colUploadsGED = null;

		HashMap hshRetorno[] = new HashMap[2];
		hshRetorno = upload.doUploadAll(request);

		if (hshRetorno[0] != null) {
			final Collection fileItems = hshRetorno[1].values();
			final HashMap formItems = hshRetorno[0];

			final String versao = (String) formItems.get("VERSAO_UPLOADCASODENEGOCIO");
			final String itemComboValores = (String) formItems.get(CampoUpload.UPLOADCASODENEGOCIO.getNome());

			String nameUploadFile = this.definirNomeArquivoUpload(formItems);
			nameUploadFile = this.montarNomeCorporeUtil(nameUploadFile);
			final String descUploadFile = this.definirDescricaoArquivoUpload(formItems, request, itemComboValores);
			final String notaTecnicaUpload = this.montarNotaTecnicaArquivo(formItems);
			colUploadsGED = this.definirColunasUpload(request);
			this.montandoPastaDeArquivos();
			this.montarItensUploadNaPastaTemp(request, colUploadsGED, fileItems, versao, nameUploadFile, descUploadFile, notaTecnicaUpload,
					itemComboValores);
		}

		request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), colUploadsGED);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#montarItensUploadNaPastaTemp)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private void montarItensUploadNaPastaTemp(final HttpServletRequest request, final Collection<Object> colUploadsGED,
			final Collection fileItems, final String versao, final String nameUploadFile, final String descUploadFile,
			final String notaTecnicaUpload, final String itemCombo) throws Exception {
		FileItem itensUplodCompare;
		if (!fileItems.isEmpty()) {
			final Iterator it = fileItems.iterator();
			while (it.hasNext()) {
				itensUplodCompare = (FileItem) it.next();
				if (itensUplodCompare.getSize() > 0
						&& (itensUplodCompare.getFieldName() != null && itensUplodCompare.getFieldName().equalsIgnoreCase(
								"file_uploadCasoDeNegocio"))) {
					final UploadDTO uploadDTO = new UploadDTO();
					this.montarUploadDTO(request, versao, nameUploadFile, descUploadFile, notaTecnicaUpload, itensUplodCompare, uploadDTO,
							itemCombo);
					colUploadsGED.add(uploadDTO);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#montarUploadDTO)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private void montarUploadDTO(final HttpServletRequest request, final String versao, final String nameUploadFile,
			final String descUploadFile, final String notaTecnicaUpload, final FileItem itensUploda, final UploadDTO uploadDTO,
			final String itemCombo) throws Exception {
		File arquivo;
		uploadDTO.setDescricao(itemCombo);
		uploadDTO.setTipoAnexoParaCombo(descUploadFile);
		uploadDTO.setNameFile(nameUploadFile);
		uploadDTO.setSituacao(UtilI18N.internacionaliza(request, "citcorpore.comum.temporario"));
		uploadDTO.setTemporario("S");
		uploadDTO.setVersao(versao);
		uploadDTO.setNotaTecnicaUpload(notaTecnicaUpload);
		uploadDTO.setPath(CITCorporeUtil.CAMINHO_REAL_APP + "tempUpload/" + uploadDTO.getNameFile());
		arquivo = new File(uploadDTO.getPath());
		itensUploda.write(arquivo);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#montandoPastaDeArquivos)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private void montandoPastaDeArquivos() {
		final File f = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempUpload");
		if (!f.exists()) {
			f.mkdirs();
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#definirColunasUpload)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private Collection<Object> definirColunasUpload(final HttpServletRequest request) {
		Collection<Object> colUploadsGED;
		colUploadsGED = (Collection) request.getSession(true).getAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED());
		if (colUploadsGED == null || colUploadsGED.isEmpty()) {
			colUploadsGED = new ArrayList();
		}
		return colUploadsGED;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#montarNotaTecnicaArquivo)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private String montarNotaTecnicaArquivo(final HashMap formItems) {
		String notaTecnicaUpload = (String) formItems.get("NOTATECNICAUPLOAD");
		if (notaTecnicaUpload == null) {
			notaTecnicaUpload = "N";
		}
		return notaTecnicaUpload;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#montarNomeCorporeUtil)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private String montarNomeCorporeUtil(String nameUploadFile) {
		if (nameUploadFile != null) {
			nameUploadFile = CITCorporeUtil.getNameFile(nameUploadFile);
		}
		return nameUploadFile;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#definirDescricaoArquivoUpload)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private String definirDescricaoArquivoUpload(final HashMap formItems, final HttpServletRequest request, String descUploadFile) {
		descUploadFile = UtilI18N.internacionaliza(request, TipoAnexoCasoNegocio.fromTipo(descUploadFile).getChave());
		if (descUploadFile != null) {
			descUploadFile = UtilStrings.decodeCaracteresEspeciais(descUploadFile);
			descUploadFile = descUploadFile.replaceAll("#10##13#", "\n"); // codificacao do CITFramework
		}
		return descUploadFile;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#definirNomeArquivoUpload)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private String definirNomeArquivoUpload(final HashMap formItems) {
		String nameUploadFile = (String) formItems.get("FILE_UPLOADCASODENEGOCIO");
		nameUploadFile = UtilStrings.nullToVazio(nameUploadFile);
		if (nameUploadFile == null) {
			nameUploadFile = UtilStrings.nullToVazio(nameUploadFile);
		} else if (nameUploadFile.trim().equalsIgnoreCase("arquivo")) {
			nameUploadFile = (String) formItems.get("FILE_UPLOADANEXOS");
			nameUploadFile = UtilStrings.decodeCaracteresEspeciais(nameUploadFile);
		}
		return nameUploadFile;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadCasoDeNegocioSumario.java_(#restaurarAnexosPlanoDeReversao)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	protected void restaurarAnexosPlanoDeReversao(final HttpServletRequest request, final Integer idSelecionado) throws ServiceException,
			Exception {
		final ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(
				ControleGEDService.class, null);
		final Collection colAnexos = controleGedService.listByIdTabelaAndIdLiberacaoAndLigacao(ControleGEDDTO.TABELA_BUSINESS_CASE,
				idSelecionado);
		final Collection<UploadDTO> colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);
		if (colAnexosUploadDTO != null) {
			for (final UploadDTO uploadDTO : colAnexosUploadDTO) {
				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				}
			}
		}
		request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), colAnexosUploadDTO);
	}
}