package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class UploadExcluir extends AjaxFormAction {

	@Override
	public Class getBeanClass() {
		return UploadDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UploadDTO uploadDTO = (UploadDTO) document.getBean();

		String uuid = request.getParameter("uuid");

		String flagGerenciamento = (String) request.getSession(true).getAttribute("flagGerenciamento");
		Collection colUploadsGED = null;

		if (uuid != null && !uuid.isEmpty()) {
			colUploadsGED = (Collection) request.getSession(true).getAttribute("uploadsPortal-" + uuid);
		} else {
			if (flagGerenciamento != null && flagGerenciamento.equalsIgnoreCase("S")) {
				colUploadsGED = (Collection) request.getSession(true).getAttribute("colUploadsGED2");
			} else {
				colUploadsGED = (Collection) request.getSession(true).getAttribute("colUploadsGED");
			}
		}

		if (colUploadsGED == null) {
			colUploadsGED = new ArrayList();
		}

		Collection col2 = new ArrayList();

		for (Iterator it = colUploadsGED.iterator(); it.hasNext();) {
			UploadDTO uploadAux = (UploadDTO) it.next();

			if (uploadDTO.getPath() == null || uploadDTO.getPath().isEmpty()) {
				if (!uploadAux.getPath().equalsIgnoreCase(CITCorporeUtil.CAMINHO_REAL_APP + "tempUpload/" + uploadDTO.getNameFile().replace("\\", "\\\\"))) {
					col2.add(uploadAux);
				}
			} else {
				if (!uploadAux.getPath().equalsIgnoreCase(uploadDTO.getPath().replace("\\", "\\\\"))) {
					col2.add(uploadAux);
				}
			}
		}

		if (uuid != null && !uuid.isEmpty()) {
			request.getSession(true).setAttribute("uploadsPortal-" + uuid, col2);
		} else {
			if (flagGerenciamento != null && flagGerenciamento.equalsIgnoreCase("S")) {
				request.getSession(true).setAttribute("colUploadsGED2", col2);
			} else {
				request.getSession(true).setAttribute("colUploadsGED", col2);
				request.getSession(true).setAttribute("colUploadsGEDExclusaoDefinida", null);

				Collection colunaParaExclusaoDefinida = new ArrayList();
				colunaParaExclusaoDefinida.add(uploadDTO);
				request.getSession(true).setAttribute("colUploadsGEDExclusaoDefinida", colunaParaExclusaoDefinida);
			}
		}

	}
}
