package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CasoNegocioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.negocio.CasoNegocioService;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 * @author ibimon.morais
 * @since 20/10/2015
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class UploadExcluirCasoDeNegocio extends AjaxFormAction {
	private CasoNegocioService service;

	@Override
	public Class getBeanClass() {
		return UploadDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UploadDTO uploadDTO = (UploadDTO) document.getBean();
		Permissoes permisao = new Permissoes(document,request,PagesPortfolio.SERVICO_NEGOCIO_CASOS_NEGOCIO.getCaminho());
		if(!permisao.isGravar()){
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.permissaoFuncionalidade"));
			return;
		}
		Collection colUploadsGED = (Collection) request.getSession(true).getAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED());
		final Collection<String> colCasoNegocioUploadsGED = new ArrayList<String>();
		if (colUploadsGED == null) {
			colUploadsGED = new ArrayList();
		}
		final Collection anexos = new ArrayList();
		UploadDTO anexoRemovido = new UploadDTO();

		for (final Iterator it = colUploadsGED.iterator(); it.hasNext();) {
			final UploadDTO uploadAux = (UploadDTO) it.next();
			if (!uploadAux.getPath().equalsIgnoreCase(uploadDTO.getPath().replace("\\", "\\\\"))) {
				anexos.add(uploadAux);
			} else {
				colCasoNegocioUploadsGED.add(uploadDTO.getPath());
				anexoRemovido = uploadAux;
			}
		}
		this.excluirAnexos(colCasoNegocioUploadsGED, request, document);
		if (anexoRemovido.getIdControleGED() != null) {
			this.salvarOcorrenciaServicoCasoNegocio(anexoRemovido, document, request);
		}
		request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), anexos);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.UploadExcluirCasoDeNegocio.java_(#excluirAnexos)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private void excluirAnexos(final Collection<String> colCasoNegocioUploadsGED, final HttpServletRequest request,
			final DocumentHTML document) {
		try {
			final CasoNegocioDTO casoNegocio = new CasoNegocioDTO();
			casoNegocio.setColsUploadGEDExcluidos(colCasoNegocioUploadsGED);
			this.getService().removerAnexosDiretorioGed(casoNegocio);
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.anexoexcluido"));
		} catch (final PersistenceException e) {
			e.printStackTrace();
		} catch (final ServiceException e) {
			e.printStackTrace();
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#getService)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private CasoNegocioService getService() throws ServiceException {
		if (this.service == null) {
			this.service = (CasoNegocioService) ServiceLocator.getInstance().getService(CasoNegocioService.class, null);
		}
		return this.service;
	}

	/**
	 * @author deborah.ferreira
	 * @since 19.02.2016
	 */
	private void salvarOcorrenciaServicoCasoNegocio(UploadDTO anexoRemovido, DocumentHTML document, HttpServletRequest request) throws Exception {
		CasoNegocioDTO casoNegocioDTO = new CasoNegocioDTO();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		Integer idServico = (Integer) request.getSession(true).getAttribute("idServicoRelacionado");
		casoNegocioDTO.setIdServico(idServico);
		casoNegocioDTO.setIdCasoNegocio(Integer.parseInt(anexoRemovido.getId()));
		casoNegocioDTO.setAcaoCasoNegocioOcorrenciaServico(AuditoriaAcoes.REMOVIDO.getIdentificador());
		casoNegocioDTO.setAnexoRemovidoCasoNegocio(anexoRemovido);
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoCasoNegocio(casoNegocioDTO, document, request);
	}
}
