package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class UploadExcluirContrato extends AjaxFormAction {
	private ContratoService service;

	@Override
	public Class getBeanClass() {
		return UploadDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UploadDTO uploadDTO = (UploadDTO) document.getBean();
		Permissoes permisao = new Permissoes(document,request,PagesPortfolio.SERVICO_NEGOCIO.getCaminho());
		if(!permisao.isGravar()){
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.permissaoFuncionalidade"));
			return;
		}
		Collection colUploadsGED = (Collection) request.getSession(true).getAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED());
		final Collection<String> colContratoUploadsGED = new ArrayList<String>();

		if (colUploadsGED == null) {
			colUploadsGED = new ArrayList();
		}

		final Collection<UploadDTO> anexos = new ArrayList();

		for (final Iterator it = colUploadsGED.iterator(); it.hasNext();) {
			final UploadDTO uploadAux = (UploadDTO) it.next();
			if (!uploadAux.getPath().equalsIgnoreCase(uploadDTO.getPath().replace("\\", "\\\\"))) {
				anexos.add(uploadAux);
			}else{
				colContratoUploadsGED.add(uploadDTO.getPath());
			}
		}
		
		this.excluirAnexos(colContratoUploadsGED, request, document);

		request.getSession(true).setAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED(), anexos);
	}

	private void excluirAnexos(final Collection<String> colContratoUploadsGED, final HttpServletRequest request, final DocumentHTML document){
		try {
			final ContratoDTO contratoDTO = new ContratoDTO();
			contratoDTO.setColsUploadGEDExcluidos(colContratoUploadsGED);
			this.getService().removerAnexosDiretorioGed(document, contratoDTO);
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.anexoexcluido"));
		} catch (final PersistenceException e) {
			e.printStackTrace();
		} catch (final ServiceException e) {
			e.printStackTrace();
		}
	}

	private ContratoService getService() throws ServiceException {
		if (this.service == null) {
			this.service = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return this.service;
	}

}