package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.PagesContinuidade;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 * @author douglas.japiassu
 * @since 21.10.2015
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public class UploadExcluirServicoNegocio extends AjaxFormAction {
	private ServicoService service;

	@Override
	public Class getBeanClass() {
		return UploadDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UploadDTO uploadDTO = (UploadDTO) document.getBean();
		Permissoes permisao = new Permissoes(document,request,PagesPortfolio.SERVICO_NEGOCIO.getCaminho());
		if(!permisao.isGravar()){
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.permissaoFuncionalidade"));
			return;
		}
		Collection colUploadsGED = (Collection) request.getSession(true).getAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED());
		final Collection<String> colServicoNegocioUploadsGED = new ArrayList<String>();

		if (colUploadsGED == null) {
			colUploadsGED = new ArrayList();
		}

		final Collection<UploadDTO> anexos = new ArrayList();
		UploadDTO anexoRemovido = new UploadDTO();

		for (final Iterator it = colUploadsGED.iterator(); it.hasNext();) {
			final UploadDTO uploadAux = (UploadDTO) it.next();
			if (!uploadAux.getPath().equalsIgnoreCase(uploadDTO.getPath().replace("\\", "\\\\"))) {
				anexos.add(uploadAux);
			}else{
				colServicoNegocioUploadsGED.add(uploadDTO.getPath());
				anexoRemovido = uploadAux;
			}
		}
		
		this.excluirAnexos(colServicoNegocioUploadsGED, request, document);
		if (anexoRemovido.getIdControleGED() != null) {
			this.salvarOcorrenciaServicoDetalhes(anexoRemovido, document, request);
		}
		request.getSession(true).setAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED(), anexos);
	}

	private void excluirAnexos(final Collection<String> colServicoNegocioUploadsGED, final HttpServletRequest request, final DocumentHTML document){
		try {
			final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO = new GerenciamentoPortfolioCadastroServicoNegocioDTO();
			servicoNegocioDTO.setColsUploadGEDExcluidos(colServicoNegocioUploadsGED);
			this.getService().removerAnexosDiretorioGed(document, servicoNegocioDTO);
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.anexoexcluido"));
		} catch (final PersistenceException e) {
			e.printStackTrace();
		} catch (final ServiceException e) {
			e.printStackTrace();
		}
	}

	private ServicoService getService() throws ServiceException {
		if (this.service == null) {
			this.service = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return this.service;
	}

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private void salvarOcorrenciaServicoDetalhes(UploadDTO anexoRemovido, DocumentHTML document, HttpServletRequest request) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDTO = new GerenciamentoPortfolioCadastroServicoNegocioDTO();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		Integer idServico = (Integer) request.getSession(true).getAttribute("idServicoRelacionado");
		gerenciamentoPortfolioCadastroServicoNegocioDTO.setIdServico(idServico);
		gerenciamentoPortfolioCadastroServicoNegocioDTO.setAcaoDetalhesOcorrenciaServico(AuditoriaAcoes.REMOVIDO.getIdentificador());
		gerenciamentoPortfolioCadastroServicoNegocioDTO.setAnexoRemovidoServico(anexoRemovido);
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoDetalhes(gerenciamentoPortfolioCadastroServicoNegocioDTO, document, request);
	}
}
