package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({ "rawtypes", "unchecked" })
public abstract class UploadGenerico extends AjaxFormAction {

	private ControleGEDService controleGEDService;

	/**
	 * ======= // COMO USAR
	 * 
	 * 1 - Criar o id/name do form com este padro e criar um input hiden com id/name "ID".
	 * Ex. em "implementacaoPlanosContinuidade.jsp": O form "formImplementacaoPlanosContinuidadeAnexo" contm um input hidden obrigatrio "ID", que ir conter o ID do item em questo. 
	 * Neste exemplo, o id de um plano de continuidade, se fosse na tela de funes vitais, seria o id de uma funo vital.; 
	 * 
	 * 2 - Implementar os mtodos abstratos desta classe, getCampoUpload(), getNomeDoCasoDeUso() e load();
	 * 
	 * 3 - Criar as outras classes e .jsp referentes a upload, ter como exemplo o caso de uso de Funes Vitais e Plano de Continuidade.
	 * 
	 * 4 - FIQUE atento no seu 'upload*.jsp', a funo "excluirImagemUpload" deve apontar pro seu "uploadExcluir*.jsp"
	 * 
	 * ====== // PASSOS PARA CONTINUAR COM  REFATORAO
	 * 
	 * 1 - Refatorar o loadImplementacao da classe UploadGenerico.java; 
	 * 2 - Refatorar o load da classe UploadExcluirGenerico.java;
	 * 3 - Migrar os cdigos do .jsp (upload/refresh/excluir) para seus arquivos .java;
	 * 4 - Gerar tabelas atravs do java;
	 * 5 - Deixar de usar os arquivos .jsp referentes a upload (citados no 3 passo);
	 * */

	/**
	 * Caso de uso: Casos de uso so narrativas em texto, descrevendo a unidade funcional, e so amplamente utilizados para descobrir e registrar requisitos funcionais nos sistemas.
	 * Em poucas palavras,  o nome daquilo com o que voc est trabalhando. Ex.: funcaoVital, planoContinuidade etc.  bem provvel que seja o mesmo nome do seu DTO. 
	 * */
	public abstract String getNomeDoCasoDeUso();

	/**
	 * O citsmart funciona baseado em reflexion. Dentro da estrutura de upload do sistema  esperado o mtodo load na classe 
	 * "UploadNomeDoSeuCasoDeUso". A implementao do seu mtodo load, apenas dever chamar o mtodo  loadImplementacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response).
	 * Ver exemplo na classe UploadPlanoContinuidade.java;
	 * */
	@Override
	public abstract void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception;

	public abstract CampoUpload getCampoUpload();

	private String getNome() {
		return getNomeDoCasoDeUso().toUpperCase();
	}

	@Override
	public Class<UploadDTO> getBeanClass() {
		return UploadDTO.class;
	}

	public void loadImplementacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		final br.com.centralit.citcorpore.util.Upload upload = new br.com.centralit.citcorpore.util.Upload();
		Collection<UploadDTO> colUploadsGED = null;

		HashMap hshRetorno[] = new HashMap[2];
		hshRetorno = upload.doUploadAll(request);

		if (hshRetorno[0] != null) {
			Collection fileItems = hshRetorno[1].values();
			HashMap formItems = hshRetorno[0];

			String itemDetalheAnexo = (String) formItems.get(getCampoUpload().getNome());
			String id = (String) formItems.get("ID"); //ADICIONAR NO FORM DE UPLOAD ex.: formFuncaoVitalAnexo

			String nameUploadFile = definirNomeArquivoUpload(formItems);
			nameUploadFile = montarNomeCorporeUtil(nameUploadFile);
			final String notaTecnicaUpload = montarNotaTecnicaArquivo(formItems);
			colUploadsGED = definirColunasUpload(request);
			this.montandoPastaDeArquivos();
			this.montarItensUploadNaPastaTemp(request, colUploadsGED, fileItems, nameUploadFile, itemDetalheAnexo, notaTecnicaUpload, itemDetalheAnexo);

			if (!Util.isNullOrEmpty(colUploadsGED)) {
				for (UploadDTO upado : colUploadsGED) {
					upado.setId(id);

					try {
						upado = (UploadDTO) getControleGEDService().find(upado);
					} catch (Exception ignore) {

					}
				}
			}
		}

		request.getSession(true).setAttribute(getCampoUpload().getColUploadGED(), colUploadsGED);
	}

	private List<UploadDTO> montarItensUploadNaPastaTemp(HttpServletRequest request, Collection<UploadDTO> colUploadsGED, Collection fileItems, String nameUploadFile, String descUploadFile,
			String notaTecnicaUpload, String itemCombo) throws Exception {
		List<UploadDTO> listaUploadDTO = new ArrayList<>();

		FileItem itensUplodCompare;

		if (!fileItems.isEmpty()) {
			Iterator it = fileItems.iterator();
			while (it.hasNext()) {
				itensUplodCompare = (FileItem) it.next();
				if (itensUplodCompare.getSize() > 0 && itensUplodCompare.getFieldName() != null && ("file_upload" + getNomeDoCasoDeUso()).equalsIgnoreCase(itensUplodCompare.getFieldName().toString())) {
					UploadDTO dto = montarUploadDTO(request, nameUploadFile, descUploadFile, notaTecnicaUpload, itensUplodCompare, itemCombo);
					colUploadsGED.add(dto);
					listaUploadDTO.add(dto);
				}
			}
		}

		return listaUploadDTO;
	}

	private UploadDTO montarUploadDTO(HttpServletRequest request, String nameUploadFile, String descUploadFile, String notaTecnicaUpload, FileItem itensUploda, String itemCombo) throws Exception {
		UploadDTO uploadDTO = new UploadDTO();

		File arquivo;
		uploadDTO.setDescricao(itemCombo);
		uploadDTO.setTipoAnexoParaCombo(descUploadFile);
		uploadDTO.setNameFile(nameUploadFile);
		uploadDTO.setSituacao(UtilI18N.internacionaliza(request, "citcorpore.comum.temporario"));
		uploadDTO.setTemporario("S");
		uploadDTO.setNotaTecnicaUpload(notaTecnicaUpload);
		uploadDTO.setPath(CITCorporeUtil.CAMINHO_REAL_APP + "tempUpload/" + uploadDTO.getNameFile());

		arquivo = new File(uploadDTO.getPath());
		itensUploda.write(arquivo);

		return uploadDTO;
	}

	private void montandoPastaDeArquivos() {
		File f = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempUpload");
		if (!f.exists()) {
			f.mkdirs();
		}
	}

	private Collection<UploadDTO> definirColunasUpload(HttpServletRequest request) {
		Collection<UploadDTO> colUploadsGED;
		colUploadsGED = (Collection) request.getSession(true).getAttribute(getCampoUpload().getColUploadGED());
		if (colUploadsGED == null || colUploadsGED.isEmpty()) {
			colUploadsGED = new ArrayList();
		}
		return colUploadsGED;
	}

	private String montarNotaTecnicaArquivo(HashMap formItems) {
		String notaTecnicaUpload = (String) formItems.get("NOTATECNICAUPLOAD");
		if (notaTecnicaUpload == null) {
			notaTecnicaUpload = "N";
		}
		return notaTecnicaUpload;
	}

	private String montarNomeCorporeUtil(String nameUploadFile) {
		if (nameUploadFile != null) {
			nameUploadFile = CITCorporeUtil.getNameFile(nameUploadFile);
		}
		return nameUploadFile;
	}

	private String definirNomeArquivoUpload(HashMap formItems) {
		String nameUploadFile = (String) formItems.get("FILE_UPLOAD" + getNome());

		nameUploadFile = UtilStrings.nullToVazio(nameUploadFile);

		if (nameUploadFile == null) {
			nameUploadFile = UtilStrings.nullToVazio(nameUploadFile);
		}

		if (nameUploadFile.trim().equalsIgnoreCase("arquivo")) {
			nameUploadFile = (String) formItems.get("FILE_UPLOADANEXOS");
			nameUploadFile = UtilStrings.decodeCaracteresEspeciais(nameUploadFile);
		}

		return nameUploadFile;
	}

	public ControleGEDService getControleGEDService() throws ServiceException {
		return Util.isNullOrEmpty(controleGEDService) ? controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null) : controleGEDService;
	}

	/*
	 * =========================== TABELA ==========================================
	 * private static final String divTabela = "divTabela";
	 * private String getDivTabela() {
	 * return divTabela + getNome();
	 * }
	 * private void atualizarTabela(DocumentHTML document, HttpServletRequest request, List<UploadDTO> lista) throws Exception {
	 * HTMLElement divDinamico = document.getElementById(getDivTabela());
	 * String listaVazia = "<h4><i>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.listavazia")) + "</i></h4>";
	 * divDinamico.setInnerHTML((!Util.isNullOrEmpty(lista) && lista.size() > 0) ? gerarHTML(document, request, lista) : listaVazia);
	 * }
	 * private String gerarHTML(DocumentHTML document, HttpServletRequest request, List<UploadDTO> lista) throws LogicException, ServiceException {
	 * StringBuilder sb = new StringBuilder();
	 * adicionarCabecalhoTabela(sb, request);
	 * adicionarDadosTabela(sb, request, document, lista);
	 * adicionarFimTabela(sb);
	 * return sb.toString();
	 * }
	 * private void adicionarCabecalhoTabela(StringBuilder sb, HttpServletRequest request) {
	 * sb.append("<div class='row-fluid'> ");
	 * sb.append("	<div class=\"table-responsive tabela\">");
	 * sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
	 * sb.append("			<thead> ");
	 * sb.append("				<tr> ");
	 * sb.append("					<th class=\"left\"><fmt:message key=\"citcorpore.comum.arquivo\" /></th> ");
	 * sb.append("					<th class=\"left\"><fmt:message key=\"citcorpore.comum.descricao\" /></th> ");
	 * sb.append("					<th class=\"center\" style=\"width: 120px;\"><fmt:message key=\"citcorpore.comum.situacao\" /></th> ");
	 * sb.append("					<th class=\"center\" style=\"width: 30px;\"><fmt:message key=\"citcorpore.comum.acoes\" /></th> ");
	 * sb.append("				</tr> ");
	 * sb.append("			</thead> ");
	 * }
	 * private void adicionarFimTabela(StringBuilder sb) {
	 * sb.append("</table>");
	 * sb.append("	</div>");
	 * sb.append("</div>");
	 * }
	 * private void adicionarDadosTabela(StringBuilder sb, HttpServletRequest request, DocumentHTML document, List<UploadDTO> lista) throws LogicException, ServiceException {
	 * if (!Util.isNullOrEmpty(lista)) {
	 * for (UploadDTO uploadDTO : lista) {
	 * sb.append("<tbody>");
	 * if (!Util.isNullOrEmpty(uploadDTO)) {
	 * sb.append("	<tr>");
	 * // PRIMEIRA COLUNA - NOME DO ARQUIVO
	 * sb.append(" <td class='left'> ");
	 * sb.append(" <a href='#' ");
	 * sb.append(" onclick='obtemArquivoTemporario(");
	 * sb.append(uploadDTO.getPath());
	 * sb.append(" )' > ");
	 * sb.append(uploadDTO.getNameFile());
	 * sb.append(" </a> ");
	 * sb.append(" </td> ");
	 * // SEGUNDA COLUNA - DESCRIO DO ANEXO
	 * sb.append(" <td class='left'> ");
	 * sb.append(uploadDTO.getDescricao());
	 * sb.append(" </td> ");
	 * // TERCEIRA COLUNA - SITUAO DO ANEXO
	 * sb.append(" <td style='width: 120px;' class='center' ");
	 * sb.append(" title='<fmt:message key='citcorpore.ged.situacao' />'>");
	 * sb.append(uploadDTO.getSituacao());
	 * sb.append("</td>");
	 * // QUARTA COLUNA - BOTO DE EXCLUIR ANEXO
	 * if (request.getSession().getAttribute("disable") == null || request.getSession().getAttribute("disable").equals("false")) {
	 * sb.append(" <td class='center' style='width: 30px; cursor: pointer;'> ");
	 * sb.append(" <a onclick='excluirImagemUpload(");
	 * sb.append(uploadDTO.getPath());
	 * sb.append(")' ");
	 * sb.append(" class='btn-action glyphicons remove_2 btn-default'> ");
	 * sb.append(" <i></i> ");
	 * sb.append(" </a> ");
	 * sb.append(" </td> ");
	 * } else {
	 * sb.append(" <td>&nbsp;</td> ");
	 * }
	 * sb.append("		</tr>");
	 * }
	 * sb.append("</tbody>");
	 * }
	 * }
	 * }
	 * =========================== TABELA ==========================================
	 */
}