package br.com.centralit.citcorpore.batch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Timestamp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import br.com.centralit.citcorpore.bean.ExecucaoBatchDTO;
import br.com.centralit.citcorpore.bean.ProcessamentoBatchDTO;
import br.com.centralit.citcorpore.integracao.ExecucaoBatchDao;
import br.com.centralit.citcorpore.negocio.ProcessamentoBatchService;
import br.com.centralit.citcorpore.util.Enumerados.BatchProcessingType;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.JdbcEngine;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilStrings;

public class JobProcessamentoBatchExecuteSQL implements Job {

	@Override
	public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
		String strNomeJob = jobExecutionContext.getJobDetail().getName();
		System.out.println("----> Iniciando Processamento Batch: " + strNomeJob);
		String numStr = UtilStrings.apenasNumeros(strNomeJob);
		Integer idProcessamentoBatch = new Integer(numStr);

		ProcessamentoBatchDTO procBean = new ProcessamentoBatchDTO();
		procBean.setIdProcessamentoBatch(idProcessamentoBatch);
		ProcessamentoBatchService procService = null;
		try {
			procService = (ProcessamentoBatchService) ServiceLocator.getInstance().getService(ProcessamentoBatchService.class, null);
		} catch (ServiceException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
		ExecucaoBatchDao execucaoBatchDao = new ExecucaoBatchDao();
		if (procService != null) {
			try {
				procBean = (ProcessamentoBatchDTO) procService.restore(procBean);
			} catch (LogicException e) {
				e.printStackTrace();
				procBean = null;
			} catch (ServiceException e) {
				e.printStackTrace();
				procBean = null;
			}
			if (procBean != null) {
				Timestamp tsExecucao = UtilDatas.getDataHoraAtual();
				if (procBean.getSituacao().equalsIgnoreCase("A")) {
					String retorno = "";
					System.out.println("JOB INICIANDO EXECUCAO -> " + procBean.getIdProcessamentoBatch() + " --> " + procBean.getExpressaoCRON() + " (" + procBean.getDescricao() + ")");

					if (BatchProcessingType.SQL.getId().equalsIgnoreCase(procBean.getTipo())) {
						retorno = executaSQL(procBean.getConteudo(), strNomeJob);
					} else if (BatchProcessingType.RHINOSCRIPT.getId().equalsIgnoreCase(procBean.getTipo())) {
						final Context cx = Context.enter();
						final Scriptable scope = cx.initStandardObjects();
						final JdbcEngine jdbcEngine = new JdbcEngine("jdbc/citsmart", null);

						scope.put("jdbcEngine", scope, jdbcEngine);
						scope.put("this", scope, this);
						scope.put("retorno", scope, retorno);
						scope.put("idProcessamentoBatch", scope, idProcessamentoBatch);

						try {
							Object resultEval = cx.evaluateString(scope, procBean.getConteudo(), "JavaScript", 1, null);
							retorno = resultEval.toString();
							System.out.println(strNomeJob + " - Execuo ok! Retorno: " + retorno);
						} catch (Exception e) {
							System.out.println(strNomeJob + " - Problemas na execucao: ");
							e.printStackTrace();
							Writer writer = new StringWriter();
							PrintWriter printWriter = new PrintWriter(writer);
							e.printStackTrace(printWriter);
							retorno = writer.toString();
						}

					} else {
						try {
							retorno = executaClasse(procBean.getConteudo(), strNomeJob, jobExecutionContext);
						} catch (ClassNotFoundException e) {
							e.printStackTrace();
						}
					}
					ExecucaoBatchDTO execDto = new ExecucaoBatchDTO();
					execDto.setIdProcessamentoBatch(idProcessamentoBatch);
					execDto.setDataHora(tsExecucao);
					execDto.setConteudo(retorno);
					try {
						execucaoBatchDao.create(execDto);
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else {
					ExecucaoBatchDTO execDto = new ExecucaoBatchDTO();
					execDto.setIdProcessamentoBatch(idProcessamentoBatch);
					execDto.setDataHora(tsExecucao);
					execDto.setConteudo("PROCESSAMENTO INATIVO! CADASTRO INATIVO!");
					try {
						execucaoBatchDao.create(execDto);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
	}

	private String executaSQL(String sql, String nomeJob) {
		JdbcEngine engineDb = new JdbcEngine(Constantes.getValue("DATABASE_ALIAS"), null);
		int num = 0;
		try {
			num = engineDb.execUpdate(sql, null);
			System.out.println(nomeJob + " - EXECUO OK! Nmero de Linhas atualizadas: " + num);
		} catch (PersistenceException e1) {
			System.out.println(nomeJob + " - Problemas na execucao: ");
			e1.printStackTrace();
			Writer writer = new StringWriter();
			PrintWriter printWriter = new PrintWriter(writer);
			e1.printStackTrace(printWriter);
			return writer.toString();
		}
		return "EXECUO OK! Nmero de Linhas atualizadas: " + num;
	}

	private String executaClasse(String pathClasseParm, String nomeJob, JobExecutionContext jobExecutionContext) throws JobExecutionException, ClassNotFoundException {
		Class<?> classe = Class.forName(pathClasseParm);

		try {
			Object objeto = classe.newInstance();
			Method method = Reflexao.findMethod("execute", objeto);
			if (method != null) {
				method.invoke(objeto, jobExecutionContext);
			} else {
				System.out.println(nomeJob + " - Problemas na execucao: ");
				System.out.println(nomeJob + " PROBLEMA: METODO NAO ENCONTRADAO (execute)!");
				return "PROBLEMA: METODO NAO ENCONTRADAO (execute)!";
			}
		} catch (Exception ex) {
			System.out.println(nomeJob + " - Problemas na execucao: ");
			throw new JobExecutionException(ex.getMessage());
		}

		return "EXECUO OK!";
	}

}
