package br.com.centralit.citcorpore.bean;

import br.com.centralit.citcorpore.negocio.Responsable;

@SuppressWarnings("serial")
public class AcaoPlanoMelhoriaDTO implements Responsable {

	// table 1 no relatrio

	private Integer idAcaoPlanoMelhoria;
	private Integer idPlanoMelhoria;
	private Integer idObjetivoPlanoMelhoria;
	private String tituloAcao;
	private String detalhamentoAcao;
	private java.sql.Date dataInicioAcao;
	private java.sql.Date dataFimAcao;
	private java.sql.Date dataConclusao;
	private String criadoPor;
	private String modificadoPor;
	private java.sql.Date dataCriacao;
	private java.sql.Date ultModificacao;
	private String responsavelAcao;
	private Integer idGrupoRespAcao;
	private Integer idRespAcao;
	private String tituloObjetivoPlanoMelhoria;
	private String resultadoEsperadoPlanoMelhoria;
	private String medicaoPlanoMelhoria;
	private Integer sequencialObjetivo;
	private Integer sequencialAcao;

	@Override
	public boolean isGrupo() {
		return idGrupoRespAcao != null && !isSemResponsavel();
	}

	@Override
	public boolean isResponsavel() {
		return idRespAcao != null && !isSemResponsavel();
	}

	@Override
	public boolean isSemResponsavel() {
		return idRespAcao == null && idGrupoRespAcao == null;
	}

	@Override
	public Integer getValidIdResponsavel() {
		return isSemResponsavel() ? null : (isGrupo() ? idGrupoRespAcao : idRespAcao);
	}

	public Integer getIdAcaoPlanoMelhoria() {
		return this.idAcaoPlanoMelhoria;
	}

	public void setIdAcaoPlanoMelhoria(Integer parm) {
		this.idAcaoPlanoMelhoria = parm;
	}

	public Integer getIdPlanoMelhoria() {
		return this.idPlanoMelhoria;
	}

	public void setIdPlanoMelhoria(Integer parm) {
		this.idPlanoMelhoria = parm;
	}

	public Integer getIdObjetivoPlanoMelhoria() {
		return this.idObjetivoPlanoMelhoria;
	}

	public void setIdObjetivoPlanoMelhoria(Integer parm) {
		this.idObjetivoPlanoMelhoria = parm;
	}

	public String getTituloAcao() {
		return this.tituloAcao;
	}

	public void setTituloAcao(String parm) {
		this.tituloAcao = parm;
	}

	public String getDetalhamentoAcao() {
		return this.detalhamentoAcao;
	}

	public void setDetalhamentoAcao(String parm) {
		this.detalhamentoAcao = parm;
	}

	public java.sql.Date getDataInicioAcao() {
		return dataInicioAcao;
	}

	public void setDataInicioAcao(java.sql.Date dataInicioAcao) {
		this.dataInicioAcao = dataInicioAcao;
	}

	public java.sql.Date getDataFimAcao() {
		return dataFimAcao;
	}

	public void setDataFimAcao(java.sql.Date dataFimAcao) {
		this.dataFimAcao = dataFimAcao;
	}

	public String getResponsavelAcao() {
		return responsavelAcao;
	}

	public void setResponsavelAcao(String responsavelAcao) {
		this.responsavelAcao = responsavelAcao;
	}

	public java.sql.Date getDataConclusao() {
		return this.dataConclusao;
	}

	public void setDataConclusao(java.sql.Date parm) {
		this.dataConclusao = parm;
	}

	public String getCriadoPor() {
		return this.criadoPor;
	}

	public void setCriadoPor(String parm) {
		this.criadoPor = parm;
	}

	public String getModificadoPor() {
		return this.modificadoPor;
	}

	public void setModificadoPor(String parm) {
		this.modificadoPor = parm;
	}

	public java.sql.Date getDataCriacao() {
		return this.dataCriacao;
	}

	public void setDataCriacao(java.sql.Date parm) {
		this.dataCriacao = parm;
	}

	public java.sql.Date getUltModificacao() {
		return this.ultModificacao;
	}

	public void setUltModificacao(java.sql.Date parm) {
		this.ultModificacao = parm;
	}

	/**
	 * @return the tituloObjetivoPlanoMelhoria
	 */
	public String getTituloObjetivoPlanoMelhoria() {
		return tituloObjetivoPlanoMelhoria;
	}

	/**
	 * @param tituloObjetivoPlanoMelhoria
	 *            the tituloObjetivoPlanoMelhoria to set
	 */
	public void setTituloObjetivoPlanoMelhoria(String tituloObjetivoPlanoMelhoria) {
		this.tituloObjetivoPlanoMelhoria = tituloObjetivoPlanoMelhoria;
	}

	/**
	 * @return the sequencialObjetivo
	 */
	public Integer getSequencialObjetivo() {
		return sequencialObjetivo;
	}

	/**
	 * @param sequencialObjetivo
	 *            the sequencialObjetivo to set
	 */
	public void setSequencialObjetivo(Integer sequencialObjetivo) {
		this.sequencialObjetivo = sequencialObjetivo;
	}

	/**
	 * @return the sequencialAcao
	 */
	public Integer getSequencialAcao() {
		return sequencialAcao;
	}

	/**
	 * @param sequencialAcao
	 *            the sequencialAcao to set
	 */
	public void setSequencialAcao(Integer sequencialAcao) {
		this.sequencialAcao = sequencialAcao;
	}

	/**
	 * @return the resultadoEsperadoPlanoMelhoria
	 */
	public String getResultadoEsperadoPlanoMelhoria() {
		return resultadoEsperadoPlanoMelhoria;
	}

	/**
	 * @param resultadoEsperadoPlanoMelhoria
	 *            the resultadoEsperadoPlanoMelhoria to set
	 */
	public void setResultadoEsperadoPlanoMelhoria(String resultadoEsperadoPlanoMelhoria) {
		this.resultadoEsperadoPlanoMelhoria = resultadoEsperadoPlanoMelhoria;
	}

	/**
	 * @return the medicaoPlanoMelhoria
	 */
	public String getMedicaoPlanoMelhoria() {
		return medicaoPlanoMelhoria;
	}

	/**
	 * @param medicaoPlanoMelhoria
	 *            the medicaoPlanoMelhoria to set
	 */
	public void setMedicaoPlanoMelhoria(String medicaoPlanoMelhoria) {
		this.medicaoPlanoMelhoria = medicaoPlanoMelhoria;
	}

	public Integer getIdRespAcao() {
		return idRespAcao;
	}

	public void setIdRespAcao(Integer idRespAcao) {
		this.idRespAcao = idRespAcao;
	}

	public Integer getIdGrupoRespAcao() {
		return idGrupoRespAcao;
	}

	public void setIdGrupoRespAcao(Integer idGrupoRespAcao) {
		this.idGrupoRespAcao = idGrupoRespAcao;
	}

	@Override
	public void addNomeDoResponsavel(String responsavel) {
		setResponsavelAcao(responsavel);
	}

}
