package br.com.centralit.citcorpore.bean;

import java.sql.Timestamp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import br.com.citframework.dto.IDto;
import br.com.citframework.util.DateTimeAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "AprovacaoProposta")
public class AprovacaoPropostaDTO implements IDto {

	private static final long serialVersionUID = 1L;

	private Integer idAprovacaoProposta;
	private Integer idRequisicaoMudanca;
	private Integer idEmpregado;
	private String nomeEmpregado;
	private String voto;
	private String comentario;

	@XmlElement(name = "dataHoraInicio")
	@XmlJavaTypeAdapter(DateTimeAdapter.class)
	private Timestamp dataHoraInicio;

	private Integer quantidadeVotoAprovada;
	private Integer quantidadeVotoRejeitada;
	private Integer quantidadeAprovacaoProposta;
	private String dataHoraVotacao;

	public Integer getIdAprovacaoProposta() {
		return idAprovacaoProposta;
	}

	public void setIdAprovacaoProposta(Integer idAprovacaoProposta) {
		this.idAprovacaoProposta = idAprovacaoProposta;
	}

	public Integer getIdRequisicaoMudanca() {
		return idRequisicaoMudanca;
	}

	public void setIdRequisicaoMudanca(Integer idRequisicaoMudanca) {
		this.idRequisicaoMudanca = idRequisicaoMudanca;
	}

	public Integer getIdEmpregado() {
		return idEmpregado;
	}

	public void setIdEmpregado(Integer idEmpregado) {
		this.idEmpregado = idEmpregado;
	}

	public String getNomeEmpregado() {
		return nomeEmpregado;
	}

	public void setNomeEmpregado(String nomeEmpregado) {
		this.nomeEmpregado = nomeEmpregado;
	}

	public String getVoto() {
		return voto;
	}

	public void setVoto(String voto) {
		this.voto = voto;
	}

	public String getComentario() {
		return comentario;
	}

	public void setComentario(String comentario) {
		this.comentario = comentario;
	}

	public Timestamp getDataHoraInicio() {
		return dataHoraInicio;
	}

	public void setDataHoraInicio(Timestamp dataHoraInicio) {
		this.dataHoraInicio = dataHoraInicio;
	}

	public Integer getQuantidadeVotoAprovada() {
		return quantidadeVotoAprovada;
	}

	public void setQuantidadeVotoAprovada(Integer quantidadeVotoAprovada) {
		this.quantidadeVotoAprovada = quantidadeVotoAprovada;
	}

	public Integer getQuantidadeVotoRejeitada() {
		return quantidadeVotoRejeitada;
	}

	public void setQuantidadeVotoRejeitada(Integer quantidadeVotoRejeitada) {
		this.quantidadeVotoRejeitada = quantidadeVotoRejeitada;
	}

	public Integer getQuantidadeAprovacaoProposta() {
		return quantidadeAprovacaoProposta;
	}

	public void setQuantidadeAprovacaoProposta(Integer quantidadeAprovacaoProposta) {
		this.quantidadeAprovacaoProposta = quantidadeAprovacaoProposta;
	}

	public String getDataHoraVotacao() {
		return dataHoraVotacao;
	}

	public void setDataHoraVotacao(String dataHoraVotacao) {
		this.dataHoraVotacao = dataHoraVotacao;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (idEmpregado == null ? 0 : idEmpregado.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		AprovacaoPropostaDTO other = (AprovacaoPropostaDTO) obj;
		if (idEmpregado == null) {
			if (other.idEmpregado != null) {
				return false;
			}
		} else if (!idEmpregado.equals(other.idEmpregado)) {
			return false;
		}
		return true;
	}

}
