package br.com.centralit.citcorpore.bean;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.HashMap;

import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.citframework.util.Reflexao;

public class ChangeRequestDTO extends RequisicaoMudancaDTO {

	private static final long serialVersionUID = -1281296872210829605L;

	public boolean getVotingProposalApproved() {
		return getVotacaoPropostaAprovada();
	}

	public void setVotingProposalApproved(boolean votingProposalApproved) {
		this.setVotacaoPropostaAprovada(votingProposalApproved);
	}

	public boolean isVotingProposalApproved() {
		return this.votacaoPropostaAprovada();
	}

	public boolean getVotingRequestApproved() {
		return getVotacaoRequisicaoAprovada();
	}

	public void setVotingRequestApproved(boolean votingRequestApproved) {
		this.setVotacaoRequisicaoAprovada(votingRequestApproved);
	}

	public boolean isVotingRequestApproved() {
		return this.votacaoRequisicaoAprovada();
	}

	public boolean isProposal() {
		return ehProposta();
	}

	public Integer getIdChangeRequest() {
		return this.getIdRequisicaoMudanca();
	}

	public void setIdChangeRequest(Integer idChangeRequest) {
		this.setIdRequisicaoMudanca(idChangeRequest);
	}

	public String getCurrentGroupName() {
		return this.getNomeGrupoAtual();
	}

	public void setCurrentGroupName(String currentGroupName) {
		this.setNomeGrupoAtual(currentGroupName);
	}

	public String getChangeStatus() {
		return this.getAlterarSituacao();
	}

	public void setChangeStatus(String changeStatus) {
		if (SimNao.SIM.getValorStrEn().equalsIgnoreCase(changeStatus)) {
			changeStatus = SimNao.SIM.getValorStr().toUpperCase();
		}

		this.setAlterarSituacao(changeStatus);
	}

	public String getEscalate() {
		return this.getEscalar();
	}

	public void setEscalate(String escalate) {
		if (SimNao.SIM.getValorStrEn().equalsIgnoreCase(escalate)) {
			escalate = SimNao.SIM.getValorStr().toUpperCase();
		}

		this.setEscalar(escalate);
	}

	public Integer getDeadlineHH() {
		return this.getPrazoHH();
	}

	public void setDeadlineHH(Integer value) {
		this.setPrazoHH(value);
	}

	public Integer getIdOwner() {
		return this.getIdResponsavel();
	}

	public void setIdOwner(Integer value) {
		this.setIdResponsavel(value);
	}

	public String getSendFinalizationMail() {
		return this.getEnviaEmailFinalizacao();
	}

	public void setSendFinalizationMail(String value) {
		this.setEnviaEmailFinalizacao(value);
	}

	public Integer getIdServiceRequest() {
		return this.getIdSolicitacaoServico();
	}

	public void setIdServiceRequest(Integer value) {
		this.setIdSolicitacaoServico(value);
	}

	public Integer getReopenSequence() {
		return this.getSeqReabertura();
	}

	public void setReopenSequence(Integer value) {
		this.setSeqReabertura(value);
	}

	public Integer getIdLocale() {
		return this.getIdLocalidade();
	}

	public void setIdLocale(Integer value) {
		this.setIdLocalidade(value);
	}

	public String getContactEmail() {
		return this.getEmailContato();
	}

	public void setContactEmail(String value) {
		this.setEmailContato(value);
	}

	public Integer getPastTimeMM() {
		return this.getTempoDecorridoMM();
	}

	public void setPastTimeMM(Integer value) {
		this.setTempoDecorridoMM(value);
	}

	public Integer getTreatmentTimeMM() {
		return this.getTempoAtendimentoMM();
	}

	public void setTreatmentTimeMM(Integer value) {
		this.setTempoAtendimentoMM(value);
	}

	public Integer getIdRequester() {
		return this.getIdSolicitante();
	}

	public void setIdRequester(Integer value) {
		this.setIdSolicitante(value);
	}

	public Integer getIdCurrentGroup() {
		return this.getIdGrupoAtual();
	}

	public void setIdCurrentGroup(Integer value) {
		this.setIdGrupoAtual(value);
	}

	public Integer getIdKnowledgeBase() {
		return this.getIdBaseConhecimento();
	}

	public void setIdKnowledgeBase(Integer value) {
		this.setIdBaseConhecimento(value);
	}

	public Integer getIdDepartment() {
		return this.getIdUnidade();
	}

	public void setIdDepartment(Integer value) {
		this.setIdUnidade(value);
	}

	public Timestamp getCaptureDateTime() {
		return this.getDataHoraCaptura();
	}

	public void setCaptureDateTime(Timestamp value) {
		this.setDataHoraCaptura(value);
	}

	public Integer getDelayTimeHH() {
		return this.getTempoAtrasoHH();
	}

	public void setDelayTimeHH(Integer value) {
		this.setTempoAtrasoHH(value);
	}

	public Timestamp getRequestDateTime() {
		return this.getDataHoraSolicitacao();
	}

	public void setRequestDateTime(Timestamp value) {
		this.setDataHoraSolicitacao(value);
	}

	public String getDescription() {
		return this.getDescricao();
	}

	public void setDescription(String value) {
		this.setDescricao(value);
	}

	public Integer getPastTimeHH() {
		return this.getTempoDecorridoHH();
	}

	public void setPastTimeHH(Integer value) {
		this.setTempoDecorridoHH(value);
	}

	public String getCurrentPhase() {
		return this.getFaseAtual();
	}

	public void setCurrentPhase(String value) {
		this.setFaseAtual(value);
	}

	public Integer getCaptureTimeMM() {
		return this.getTempoCapturaMM();
	}

	public void setCaptureTimeMM(Integer value) {
		this.setTempoCapturaMM(value);
	}

	public String getContactName() {
		return this.getNomeContato();
	}

	public void setContactName(String value) {
		this.setNomeContato(value);
	}

	public Timestamp getStartDateTime() {
		return this.getDataHoraInicio();
	}

	public void setStartDateTime(Timestamp value) {
		this.setDataHoraInicio(value);
	}

	public Integer getIdResponseCaegory() {
		return this.getIdCategoriaSolucao();
	}

	public void setIdResponseCaegory(Integer value) {
		this.setIdCategoriaSolucao(value);
	}

	public String getSendCreationMail() {
		return this.getEnviaEmailCriacao();
	}

	public void setSendCreationMail(String value) {
		this.setEnviaEmailCriacao(value);
	}

	public Integer getIdCalendar() {
		return this.getIdCalendario();
	}

	public void setIdCalendar(Integer value) {
		this.setIdCalendario(value);
	}

	public Integer getDeadlineMM() {
		return this.getPrazoMM();
	}

	public void setDeadlineMM(Integer value) {
		this.setPrazoMM(value);
	}

	public Integer getPriority() {
		return this.getPrioridade();
	}

	public void setPriority(Integer value) {
		this.setPrioridade(value);
	}

	public Integer getIdContract() {
		return this.getIdContrato();
	}

	public void setIdContract(Integer value) {
		this.setIdContrato(value);
	}

	public Timestamp getReactivationDateTime() {
		return this.getDataHoraReativacao();
	}

	public void setReactivationDateTime(Timestamp value) {
		this.setDataHoraReativacao(value);
	}

	public Integer getCaptureTimeHH() {
		return this.getTempoCapturaHH();
	}

	public void setCaptureTimeHH(Integer value) {
		this.setTempoCapturaHH(value);
	}

	public Timestamp getSuspensionDateTime() {
		return this.getDataHoraSuspensao();
	}

	public void setSuspensionDateTime(Timestamp value) {
		this.setDataHoraSuspensao(value);
	}

	public String getContactPhone() {
		return this.getTelefoneContato();
	}

	public void setContactPhone(String value) {
		this.setTelefoneContato(value);
	}

	public Integer getIdGroupLevel1() {
		return this.getIdGrupoNivel1();
	}

	public void setIdGroupLevel1(Integer value) {
		this.setIdGrupoNivel1(value);
	}

	public Integer getDelayTimeMM() {
		return this.getTempoAtrasoMM();
	}

	public void setDelayTimeMM(Integer value) {
		this.setTempoAtrasoMM(value);
	}

	public String getObservation() {
		return this.getObservacao();
	}

	public void setObservation(String value) {
		this.setObservacao(value);
	}

	public Integer getTreatmentTimeHH() {
		return this.getTempoAtendimentoHH();
	}

	public void setTreatmentTimeHH(Integer value) {
		this.setTempoAtendimentoHH(value);
	}

	public String getSendActionMail() {
		return this.getEnviaEmailAcoes();
	}

	public void setSendActionMail(String value) {
		this.setEnviaEmailAcoes(value);
	}

	/**
	 * Method to translate the (most important) attributes of {@link RequisicaoMudancaDTO}.
	 *
	 * @author douglas.japiassu
	 */
	public static void main(String[] args) {
		HashMap<String, String> map = new HashMap<String, String>();

		map.put("IdSolicitacaoServico", "IdServiceRequest");
		map.put("IdBaseConhecimento", "IdKnowledgeBase");
		map.put("IdServicoContrato", "IdServiceContract");
		map.put("IdSolicitante", "IdRequester");
		map.put("IdItemConfiguracao", "IdConfigurationItem");
		map.put("IdItemConfiguracaoFilho", "IdChildConfigurarationItem");
		map.put("IdContatoSolicitacaoServico", "IdContact");
		map.put("IdOrigem", "IdOrigin");
		map.put("IdResponsavel", "IdOwner");
		map.put("IdTipoProblema", "IdProblemType");
		map.put("IdPrioridade", "IdPriority");
		map.put("IdUnidade", "IdDepartment");
		map.put("IdFaseAtual", "IdCurrentPhase");
		map.put("IdGrupoAtual", "IdCurrentGroup");
		map.put("DataHoraSolicitacao", "RequestDateTime");
		map.put("DataHoraLimite", "Deadline");
		map.put("AtendimentoPresencial", "PersonalAssistance");
		map.put("PrazoCapturaHH", "CaptureDeadlineHH");
		map.put("PrazoCapturaMM", "CaptureDeadlineMM");
		map.put("PrazoHH", "DeadlineHH");
		map.put("PrazoMM", "DeadlineMM");
		map.put("Descricao", "Description");
		map.put("Resposta", "Response");
		map.put("DataHoraInicio", "StartDateTime");
		map.put("DataHoraFim", "EndDateTime");
		map.put("IdSolicitacaoPai", "IdOwnerRequest");
		map.put("DetalhamentoCausa", "CauseDetail");
		map.put("IdCausaIncidente", "IdIncidentCause");
		map.put("IdCategoriaSolucao", "IdResponseCaegory");
		map.put("SeqReabertura", "ReopenSequence");
		map.put("EnviaEmailCriacao", "SendCreationMail");
		map.put("EnviaEmailFinalizacao", "SendFinalizationMail");
		map.put("EnviaEmailAcoes", "SendActionMail");
		map.put("IdGrupoNivel1", "IdGroupLevel1");
		map.put("SolucaoTemporaria", "TemporarySolution");
		map.put("HouveMudanca", "HasChange");
		map.put("SlaACombinar", "SLAToAgree");
		map.put("PrazohhAnterior", "PreviousDeadlineHH");
		map.put("PrazommAnterior", "PreviousDeadlineMM");
		map.put("IdCalendario", "IdCalendar");
		map.put("TempoDecorridoHH", "PastTimeHH");
		map.put("TempoDecorridoMM", "PastTimeMM");
		map.put("DataHoraSuspensao", "SuspensionDateTime");
		map.put("DataHoraReativacao", "ReactivationDateTime");
		map.put("Impacto", "Impact");
		map.put("Urgencia", "Urgency");
		map.put("DataHoraCaptura", "CaptureDateTime");
		map.put("TempoCapturaHH", "CaptureTimeHH");
		map.put("TempoCapturaMM", "CaptureTimeMM");
		map.put("TempoAtrasoHH", "DelayTimeHH");
		map.put("TempoAtrasoMM", "DelayTimeMM");
		map.put("TempoAtendimentoHH", "TreatmentTimeHH");
		map.put("TempoAtendimentoMM", "TreatmentTimeMM");
		map.put("IdAcordoNivelServico", "IdServiceLevelAgreement");
		map.put("IdUltimaAprovacao", "IdLastApproval");
		map.put("DataHoraInicioSLA", "DateTimeStartSLA");
		map.put("DataHoraInicioSLA", "DateTimeSuspensionSLA");
		map.put("DataHoraInicioSLA", "DateTimeReactivationSLA");
		map.put("SituacaoSLA", "StatusSLA");
		map.put("IdTarefaEncerramento", "IdClosingTask");
		map.put("JustificativaVencimentoSLA", "ReasonChangeSLA");
		map.put("Aprovacao", "Approval");
		map.put("IdServico", "IdService");
		map.put("Servico", "ServiceName");
		map.put("IdTipoDemandaServico", "IdDemandTypeService");
		map.put("Demanda", "DemandTypeName");
		map.put("IdContrato", "IdContract");
		map.put("Contrato", "ContractName");
		map.put("Solicitante", "RequesterName");
		map.put("NomeUnidadeSolicitante", "RequesterDepartmentName");
		map.put("Responsavel", "OwnerName");
		map.put("NomeUnidadeResponsavel", "OwnerDepartmentName");
		map.put("Origem", "OriginName");
		map.put("Prioridade", "Priority");
		map.put("FaseAtual", "CurrentPhase");
		map.put("GrupoAtual", "CurrentGroup");
		map.put("GrupoNivel1", "GroupLevel1");
		map.put("Nomecontato", "ContactName");
		map.put("Emailcontato", "ContactEmail");
		map.put("Telefonecontato", "ContactPhone");
		map.put("Observacao", "Observation");
		map.put("IdLocalidade", "IdLocale");
		map.put("IdSolicitacaoRelacionada", "IdRelatedRequest");
		map.put("EmailResponsavel", "OwnerEmail");
		map.put("CodigoExterno", "ExternalCode");

		RequisicaoMudancaDTO obj = new RequisicaoMudancaDTO();
		for (String key : map.keySet()) {
			String value = map.get(key);
			Method getMethod = Reflexao.findMethod("get" + key, obj);
			if (getMethod != null) {
				Class<?> clazz = getMethod.getReturnType();
				System.out.println("public " + clazz.getSimpleName() + " get" + value + "() {");
				System.out.println("	return this.get" + key + "();");
				System.out.println("}");
				System.out.println("");
				System.out.println("public void set" + value + "(" + clazz.getSimpleName() + " value) {");
				System.out.println("	this.set" + key + "(value);");
				System.out.println("}");
				System.out.println("");
			}
			;
		}
	}

}
