package br.com.centralit.citcorpore.bean;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

import br.com.citframework.dto.IDto;

/**
 * Contm os dados da tabela "hosts" do Nagios.  
 * @author cristian.guedes
 *
 */

public class EVMHostNagiosDTO implements IDto {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1979425246068230565L;

	private Integer idEVMHostNagios;

    /**
     * Whether passive host checks are accepted (0/1)
     */
    private int accept_passive_checks;
    /**
     * Whether the current host problem has been acknowledged (0/1)
     */
 
    private int acknowledged;
    /**
     * Type of acknowledgement (0: none, 1: normal, 2: stick)
     */

    private int acknowledgement_type;
    /**
     * An optional URL to custom actions or information about this host
     */

    private String action_url = null;
    /**
     * The same as action_url, but with the most important macros expanded
     */

    private String action_url_expanded = null;
    /**
     * Whether active checks are enabled for the host (0/1)
     */

    private int active_checks_enabled;
    /**
     * IP address
     */

    private String address = null;
    /**
     * An alias name for the host
     */

    private String alias = null;
    /**
     * Nagios command for active host check of this host
     */

    private String check_command = null;
    /**
     * Nagios command for active host check of this host with the macros expanded
     */

    private String check_command_expanded = null;
    /**
     * Whether to check to send a recovery notification when flapping stops (0/1)
     */

    private int check_flapping_recovery_notification;
    /**
     * Whether freshness checks are activated (0/1)
     */

    private int check_freshness;
    /**
     * Number of basic interval lengths between two scheduled checks of the host
     */

    private Float check_interval = null;
    /**
     * The current check option, forced, normal, freshness... (0-2)
     */

    private int check_options;
    /**
     * Time period in which this host will be checked. If empty then the host will always be checked.
     */

    private String check_period = null;
    /**
     * Type of check (0: active, 1: passive)
     */

    private int check_type;
    /**
     * Whether checks of the host are enabled (0/1)
     */

    private int checks_enabled;
    /**
     * A list of all direct childs of the host
     */

    private String childs = null;
    /**
     * A list of the ids of all comments of this host
     */

    private String comments = null;
    /**
     * A list of all comments of the host with id, author, comment, entry type and entry time
     */

    private String comments_with_extra_info = null;
    /**
     * A list of all comments of the host with id, author and comment
     */

    private String comments_with_info = null;
    /**
     * A list of all contact groups this host is in
     */

    private String contact_groups = null;
    /**
     * A list of all contacts of this host, either direct or via a contact group
     */

    private String contacts = null;
    /**
     * Number of the current check attempts
     */

    private int current_attempt;
    /**
     * Number of the current notification
     */

    private int current_notification_number;
    /**
     * A list of the names of all custom variables
     */

    private String custom_variable_names = null;
    /**
     * A list of the values of the custom variables
     */

    private String custom_variable_values = null;
    /**
     * A dictionary of the custom variables
     */

    private String custom_variables = null;
    /**
     * Optional display name of the host - not used by Nagios' web interface
     */

    private String display_name = null;
    /**
     * A list of the ids of all scheduled downtimes of this host
     */

    private String downtimes = null;
    /**
     * A list of the all scheduled downtimes of the host with id, author and comment
     */

    private String downtimes_with_info = null;
    /**
     * Nagios command used as event handler
     */

    private String event_handler = null;
    /**
     * Whether event handling is enabled (0/1)
     */

    private int event_handler_enabled;
    /**
     * Time the host check needed for execution
     */

    private Float execution_time = null;
    /**
     * The value of the custom variable FILENAME
     */

    private String filename = null;
    /**
     * Delay before the first notification
     */

    private Float first_notification_delay = null;
    /**
     * Whether flap detection is enabled (0/1)
     */

    private int flap_detection_enabled;
    /**
     * A list of all host groups this host is in
     */

    private String groups = null;
    /**
     * The effective hard state of the host (eliminates a problem in hard_state)
     */

    private int hard_state;
    /**
     * Whether the host has already been checked (0/1)
     */

    private int has_been_checked;
    /**
     * High threshold of flap detection
     */

    private Float high_flap_threshold = null;
    /**
     * The name of an image file to be used in the web pages
     */

    private String icon_image = null;
    /**
     * Alternative text for the icon_image
     */

    private String icon_image_alt = null;
    /**
     * The same as icon_image, but with the most important macros expanded
     */

    private String icon_image_expanded = null;
    /**
     * Whether this host is currently in its check period (0/1)
     */

    private int in_check_period;
    /**
     * Whether this host is currently in its notification period (0/1)
     */

    private int in_notification_period;
    /**
     * Whether this host is currently in its service period (0/1)
     */

    private int in_service_period;
    /**
     * Initial host state
     */

    private int initial_state;
    /**
     * is there a host check currently running... (0/1)
     */

    private int is_executing;
    /**
     * Whether the host state is flapping (0/1)
     */

    private int is_flapping;
    /**
     * Time of the last check (Unix timestamp)
     */

    private Timestamp last_check = null;
    /**
     * Last hard state
     */

    private int last_hard_state;
    /**
     * Time of the last hard state change (Unix timestamp)
     */

    private Timestamp last_hard_state_change = null;
    /**
     * Time of the last notification (Unix timestamp)
     */

    private Timestamp last_notification = null;
    /**
     * State before last state change
     */

    private int last_state;
    /**
     * Time of the last state change - soft or hard (Unix timestamp)
     */

    private Timestamp last_state_change = null;
    /**
     * The last time the host was DOWN (Unix timestamp)
     * <module>modulozabbix</module>
     */

    private Timestamp last_time_down = null;
    /**
     * The last time the host was UNREACHABLE (Unix timestamp)
     */

    private Timestamp last_time_unreachable = null;
    /**
     * The last time the host was UP (Unix timestamp)
     */

    private Timestamp last_time_up = null;
    /**
     * Time difference between scheduled check time and actual check time
     */

    private Float latency = null;
    /**
     * Complete output from check plugin
     */

    private String long_plugin_output = null;
    /**
     * Low threshold of flap detection
     */

    private Float low_flap_threshold = null;
    /**
     * Max check attempts for active host checks
     */

    private int max_check_attempts;
    /**
     * A bitmask specifying which attributes have been modified
     */

    private int modified_attributes;
    /**
     * A list of all modified attributes
     */

    private String modified_attributes_list = null;
    /**
     * Host name
     */

    private String name = null;
    /**
     * Scheduled time for the next check (Unix timestamp)
     */

    private Timestamp next_check = null;
    /**
     * Time of the next notification (Unix timestamp)
     */

    private Timestamp next_notification = null;
    /**
     * Whether to stop sending notifications (0/1)
     */

    private int no_more_notifications;
    /**
     * Optional notes for this host
     */

    private String notes = null;
    /**
     * The same as notes, but with the most important macros expanded
     */

    private String notes_expanded = null;
    /**
     * An optional URL with further information about the host
     */

    private String notes_url = null;
    /**
     * Same es notes_url, but with the most important macros expanded
     */

    private String notes_url_expanded = null;
    /**
     * Interval of periodic notification or 0 if its off
     */

    private Float notification_interval = null;
    /**
     * Time period in which problems of this host will be notified. If empty then notification will be always
     */

    private String notification_period = null;
    /**
     * Whether notifications of the host are enabled (0/1)
     */

    private int notifications_enabled;
    /**
     * The total number of services of the host
     */

    private int num_services;
    /**
     * The number of the host's services with the soft state CRIT
     */

    private int num_services_crit;
    /**
     * The number of the host's services with the hard state CRIT
     */

    private int num_services_hard_crit;
    /**
     * The number of the host's services with the hard state OK
     */

    private int num_services_hard_ok;
    /**
     * The number of the host's services with the hard state UNKNOWN
     */

    private int num_services_hard_unknown;
    /**
     * The number of the host's services with the hard state WARN
     */

    private int num_services_hard_warn;
    /**
     * The number of the host's services with the soft state OK
     */

    private int num_services_ok;
    /**
     * The number of the host's services which have not been checked yet (pending)
     */

    private int num_services_pending;
    /**
     * The number of the host's services with the soft state UNKNOWN
     */

    private int num_services_unknown;
    /**
     * The number of the host's services with the soft state WARN
     */

    private int num_services_warn;
    /**
     * The current obsess_over_host setting... (0/1)
     */

    private int obsess_over_host;
    /**
     * A list of all direct parents of the host
     */

    private String parents = null;
    /**
     * Whether a flex downtime is pending (0/1)
     */

    private int pending_flex_downtime;
    /**
     * Percent state change
     */

    private Float percent_state_change = null;
    /**
     * Optional performance data of the last host check
     */

    private String perf_data = null;
    /**
     * Output of the last host check
     */

    private String plugin_output = null;
    /**
     * Whether there is a PNP4Nagios graph present for this host (0/1)
     */

    private int pnpgraph_present;
    /**
     * Whether processing of performance data is enabled (0/1)
     */

    private int process_performance_data;
    /**
     * Number of basic interval lengths between checks when retrying after a soft error
     */

    private Float retry_interval = null;
    /**
     * The number of downtimes this host is currently in
     */

    private int scheduled_downtime_depth;
    /**
     * The name of the service period of the host
     */

    private String service_period = null;
    /**
     * A list of all services of the host
     */

    private String services = null;
    /**
     * A list of all services including detailed information about each service
     */

    private String services_with_info = null;
    /**
     * A list of all services of the host together with state and has_been_checked
     */

    private String services_with_state = null;
    /**
     * Staleness indicator for this host
     */

    private Float staleness = null;
    /**
     * The current state of the host (0: up, 1: down, 2: unreachable)
     */

    private int state;
    /**
     * Type of the current state (0: soft, 1: hard)
     */

    private int state_type;
    /**
     * The name of in image file for the status map
     */

    private String statusmap_image = null;
    /**
     * The total number of services of the host
     */

    private int total_services;
    /**
     * The worst hard state of all of the host's services (OK <= WARN <= UNKNOWN <= CRIT)
     */

    private int worst_service_hard_state;
    /**
     * The worst soft state of all of the host's services (OK <= WARN <= UNKNOWN <= CRIT)
     */

    private int worst_service_state;
    /**
     * 3D-Coordinates: X
     */

    private Float x_3d = null;
    /**
     * 3D-Coordinates: Y
     */

    private Float y_3d = null;
    /**
     * 3D-Coordinates: Z
     */

    private Float z_3d = null;

    private List<EventDTO> events = new ArrayList<EventDTO>();

    private List<ServicesDTO> listOfServices = new ArrayList<ServicesDTO>();

    private List<ContactsDTO> listOfContacts = new ArrayList<ContactsDTO>();

	public Integer getIdEVMHostNagios() {
		return idEVMHostNagios;
	}

	public void setIdEVMHostNagios(Integer idEVMHostNagios) {
		this.idEVMHostNagios = idEVMHostNagios;
	}

	public int getAccept_passive_checks() {
		return accept_passive_checks;
	}

	public void setAccept_passive_checks(int accept_passive_checks) {
		this.accept_passive_checks = accept_passive_checks;
	}

	public int getAcknowledged() {
		return acknowledged;
	}

	public void setAcknowledged(int acknowledged) {
		this.acknowledged = acknowledged;
	}

	public int getAcknowledgement_type() {
		return acknowledgement_type;
	}

	public void setAcknowledgement_type(int acknowledgement_type) {
		this.acknowledgement_type = acknowledgement_type;
	}

	public String getAction_url() {
		return action_url;
	}

	public void setAction_url(String action_url) {
		this.action_url = action_url;
	}

	public String getAction_url_expanded() {
		return action_url_expanded;
	}

	public void setAction_url_expanded(String action_url_expanded) {
		this.action_url_expanded = action_url_expanded;
	}

	public int getActive_checks_enabled() {
		return active_checks_enabled;
	}

	public void setActive_checks_enabled(int active_checks_enabled) {
		this.active_checks_enabled = active_checks_enabled;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getAlias() {
		return alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public String getCheck_command() {
		return check_command;
	}

	public void setCheck_command(String check_command) {
		this.check_command = check_command;
	}

	public String getCheck_command_expanded() {
		return check_command_expanded;
	}

	public void setCheck_command_expanded(String check_command_expanded) {
		this.check_command_expanded = check_command_expanded;
	}

	public int getCheck_flapping_recovery_notification() {
		return check_flapping_recovery_notification;
	}

	public void setCheck_flapping_recovery_notification(int check_flapping_recovery_notification) {
		this.check_flapping_recovery_notification = check_flapping_recovery_notification;
	}

	public int getCheck_freshness() {
		return check_freshness;
	}

	public void setCheck_freshness(int check_freshness) {
		this.check_freshness = check_freshness;
	}

	public Float getCheck_interval() {
		return check_interval;
	}

	public void setCheck_interval(Float check_interval) {
		this.check_interval = check_interval;
	}

	public int getCheck_options() {
		return check_options;
	}

	public void setCheck_options(int check_options) {
		this.check_options = check_options;
	}

	public String getCheck_period() {
		return check_period;
	}

	public void setCheck_period(String check_period) {
		this.check_period = check_period;
	}

	public int getCheck_type() {
		return check_type;
	}

	public void setCheck_type(int check_type) {
		this.check_type = check_type;
	}

	public int getChecks_enabled() {
		return checks_enabled;
	}

	public void setChecks_enabled(int checks_enabled) {
		this.checks_enabled = checks_enabled;
	}

	public String getChilds() {
		return childs;
	}

	public void setChilds(String childs) {
		this.childs = childs;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getComments_with_extra_info() {
		return comments_with_extra_info;
	}

	public void setComments_with_extra_info(String comments_with_extra_info) {
		this.comments_with_extra_info = comments_with_extra_info;
	}

	public String getComments_with_info() {
		return comments_with_info;
	}

	public void setComments_with_info(String comments_with_info) {
		this.comments_with_info = comments_with_info;
	}

	public String getContact_groups() {
		return contact_groups;
	}

	public void setContact_groups(String contact_groups) {
		this.contact_groups = contact_groups;
	}

	public String getContacts() {
		return contacts;
	}

	public void setContacts(String contacts) {
		this.contacts = contacts;
	}

	public int getCurrent_attempt() {
		return current_attempt;
	}

	public void setCurrent_attempt(int current_attempt) {
		this.current_attempt = current_attempt;
	}

	public int getCurrent_notification_number() {
		return current_notification_number;
	}

	public void setCurrent_notification_number(int current_notification_number) {
		this.current_notification_number = current_notification_number;
	}

	public String getCustom_variable_names() {
		return custom_variable_names;
	}

	public void setCustom_variable_names(String custom_variable_names) {
		this.custom_variable_names = custom_variable_names;
	}

	public String getCustom_variable_values() {
		return custom_variable_values;
	}

	public void setCustom_variable_values(String custom_variable_values) {
		this.custom_variable_values = custom_variable_values;
	}

	public String getCustom_variables() {
		return custom_variables;
	}

	public void setCustom_variables(String custom_variables) {
		this.custom_variables = custom_variables;
	}

	public String getDisplay_name() {
		return display_name;
	}

	public void setDisplay_name(String display_name) {
		this.display_name = display_name;
	}

	public String getDowntimes() {
		return downtimes;
	}

	public void setDowntimes(String downtimes) {
		this.downtimes = downtimes;
	}

	public String getDowntimes_with_info() {
		return downtimes_with_info;
	}

	public void setDowntimes_with_info(String downtimes_with_info) {
		this.downtimes_with_info = downtimes_with_info;
	}

	public String getEvent_handler() {
		return event_handler;
	}

	public void setEvent_handler(String event_handler) {
		this.event_handler = event_handler;
	}

	public int getEvent_handler_enabled() {
		return event_handler_enabled;
	}

	public void setEvent_handler_enabled(int event_handler_enabled) {
		this.event_handler_enabled = event_handler_enabled;
	}

	public Float getExecution_time() {
		return execution_time;
	}

	public void setExecution_time(Float execution_time) {
		this.execution_time = execution_time;
	}

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public Float getFirst_notification_delay() {
		return first_notification_delay;
	}

	public void setFirst_notification_delay(Float first_notification_delay) {
		this.first_notification_delay = first_notification_delay;
	}

	public int getFlap_detection_enabled() {
		return flap_detection_enabled;
	}

	public void setFlap_detection_enabled(int flap_detection_enabled) {
		this.flap_detection_enabled = flap_detection_enabled;
	}

	public String getGroups() {
		return groups;
	}

	public void setGroups(String groups) {
		this.groups = groups;
	}

	public int getHard_state() {
		return hard_state;
	}

	public void setHard_state(int hard_state) {
		this.hard_state = hard_state;
	}

	public int getHas_been_checked() {
		return has_been_checked;
	}

	public void setHas_been_checked(int has_been_checked) {
		this.has_been_checked = has_been_checked;
	}

	public Float getHigh_flap_threshold() {
		return high_flap_threshold;
	}

	public void setHigh_flap_threshold(Float high_flap_threshold) {
		this.high_flap_threshold = high_flap_threshold;
	}

	public String getIcon_image() {
		return icon_image;
	}

	public void setIcon_image(String icon_image) {
		this.icon_image = icon_image;
	}

	public String getIcon_image_alt() {
		return icon_image_alt;
	}

	public void setIcon_image_alt(String icon_image_alt) {
		this.icon_image_alt = icon_image_alt;
	}

	public String getIcon_image_expanded() {
		return icon_image_expanded;
	}

	public void setIcon_image_expanded(String icon_image_expanded) {
		this.icon_image_expanded = icon_image_expanded;
	}

	public int getIn_check_period() {
		return in_check_period;
	}

	public void setIn_check_period(int in_check_period) {
		this.in_check_period = in_check_period;
	}

	public int getIn_notification_period() {
		return in_notification_period;
	}

	public void setIn_notification_period(int in_notification_period) {
		this.in_notification_period = in_notification_period;
	}

	public int getIn_service_period() {
		return in_service_period;
	}

	public void setIn_service_period(int in_service_period) {
		this.in_service_period = in_service_period;
	}

	public int getInitial_state() {
		return initial_state;
	}

	public void setInitial_state(int initial_state) {
		this.initial_state = initial_state;
	}

	public int getIs_executing() {
		return is_executing;
	}

	public void setIs_executing(int is_executing) {
		this.is_executing = is_executing;
	}

	public int getIs_flapping() {
		return is_flapping;
	}

	public void setIs_flapping(int is_flapping) {
		this.is_flapping = is_flapping;
	}

	public Timestamp getLast_check() {
		return last_check;
	}

	public void setLast_check(Timestamp last_check) {
		this.last_check = last_check;
	}

	public int getLast_hard_state() {
		return last_hard_state;
	}

	public void setLast_hard_state(int last_hard_state) {
		this.last_hard_state = last_hard_state;
	}

	public Timestamp getLast_hard_state_change() {
		return last_hard_state_change;
	}

	public void setLast_hard_state_change(Timestamp last_hard_state_change) {
		this.last_hard_state_change = last_hard_state_change;
	}

	public Timestamp getLast_notification() {
		return last_notification;
	}

	public void setLast_notification(Timestamp last_notification) {
		this.last_notification = last_notification;
	}

	public int getLast_state() {
		return last_state;
	}

	public void setLast_state(int last_state) {
		this.last_state = last_state;
	}

	public Timestamp getLast_state_change() {
		return last_state_change;
	}

	public void setLast_state_change(Timestamp last_state_change) {
		this.last_state_change = last_state_change;
	}

	public Timestamp getLast_time_down() {
		return last_time_down;
	}

	public void setLast_time_down(Timestamp last_time_down) {
		this.last_time_down = last_time_down;
	}

	public Timestamp getLast_time_unreachable() {
		return last_time_unreachable;
	}

	public void setLast_time_unreachable(Timestamp last_time_unreachable) {
		this.last_time_unreachable = last_time_unreachable;
	}

	public Timestamp getLast_time_up() {
		return last_time_up;
	}

	public void setLast_time_up(Timestamp last_time_up) {
		this.last_time_up = last_time_up;
	}

	public Float getLatency() {
		return latency;
	}

	public void setLatency(Float latency) {
		this.latency = latency;
	}

	public String getLong_plugin_output() {
		return long_plugin_output;
	}

	public void setLong_plugin_output(String long_plugin_output) {
		this.long_plugin_output = long_plugin_output;
	}

	public Float getLow_flap_threshold() {
		return low_flap_threshold;
	}

	public void setLow_flap_threshold(Float low_flap_threshold) {
		this.low_flap_threshold = low_flap_threshold;
	}

	public int getMax_check_attempts() {
		return max_check_attempts;
	}

	public void setMax_check_attempts(int max_check_attempts) {
		this.max_check_attempts = max_check_attempts;
	}

	public int getModified_attributes() {
		return modified_attributes;
	}

	public void setModified_attributes(int modified_attributes) {
		this.modified_attributes = modified_attributes;
	}

	public String getModified_attributes_list() {
		return modified_attributes_list;
	}

	public void setModified_attributes_list(String modified_attributes_list) {
		this.modified_attributes_list = modified_attributes_list;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Timestamp getNext_check() {
		return next_check;
	}

	public void setNext_check(Timestamp next_check) {
		this.next_check = next_check;
	}

	public Timestamp getNext_notification() {
		return next_notification;
	}

	public void setNext_notification(Timestamp next_notification) {
		this.next_notification = next_notification;
	}

	public int getNo_more_notifications() {
		return no_more_notifications;
	}

	public void setNo_more_notifications(int no_more_notifications) {
		this.no_more_notifications = no_more_notifications;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public String getNotes_expanded() {
		return notes_expanded;
	}

	public void setNotes_expanded(String notes_expanded) {
		this.notes_expanded = notes_expanded;
	}

	public String getNotes_url() {
		return notes_url;
	}

	public void setNotes_url(String notes_url) {
		this.notes_url = notes_url;
	}

	public String getNotes_url_expanded() {
		return notes_url_expanded;
	}

	public void setNotes_url_expanded(String notes_url_expanded) {
		this.notes_url_expanded = notes_url_expanded;
	}

	public Float getNotification_interval() {
		return notification_interval;
	}

	public void setNotification_interval(Float notification_interval) {
		this.notification_interval = notification_interval;
	}

	public String getNotification_period() {
		return notification_period;
	}

	public void setNotification_period(String notification_period) {
		this.notification_period = notification_period;
	}

	public int getNotifications_enabled() {
		return notifications_enabled;
	}

	public void setNotifications_enabled(int notifications_enabled) {
		this.notifications_enabled = notifications_enabled;
	}

	public int getNum_services() {
		return num_services;
	}

	public void setNum_services(int num_services) {
		this.num_services = num_services;
	}

	public int getNum_services_crit() {
		return num_services_crit;
	}

	public void setNum_services_crit(int num_services_crit) {
		this.num_services_crit = num_services_crit;
	}

	public int getNum_services_hard_crit() {
		return num_services_hard_crit;
	}

	public void setNum_services_hard_crit(int num_services_hard_crit) {
		this.num_services_hard_crit = num_services_hard_crit;
	}

	public int getNum_services_hard_ok() {
		return num_services_hard_ok;
	}

	public void setNum_services_hard_ok(int num_services_hard_ok) {
		this.num_services_hard_ok = num_services_hard_ok;
	}

	public int getNum_services_hard_unknown() {
		return num_services_hard_unknown;
	}

	public void setNum_services_hard_unknown(int num_services_hard_unknown) {
		this.num_services_hard_unknown = num_services_hard_unknown;
	}

	public int getNum_services_hard_warn() {
		return num_services_hard_warn;
	}

	public void setNum_services_hard_warn(int num_services_hard_warn) {
		this.num_services_hard_warn = num_services_hard_warn;
	}

	public int getNum_services_ok() {
		return num_services_ok;
	}

	public void setNum_services_ok(int num_services_ok) {
		this.num_services_ok = num_services_ok;
	}

	public int getNum_services_pending() {
		return num_services_pending;
	}

	public void setNum_services_pending(int num_services_pending) {
		this.num_services_pending = num_services_pending;
	}

	public int getNum_services_unknown() {
		return num_services_unknown;
	}

	public void setNum_services_unknown(int num_services_unknown) {
		this.num_services_unknown = num_services_unknown;
	}

	public int getNum_services_warn() {
		return num_services_warn;
	}

	public void setNum_services_warn(int num_services_warn) {
		this.num_services_warn = num_services_warn;
	}

	public int getObsess_over_host() {
		return obsess_over_host;
	}

	public void setObsess_over_host(int obsess_over_host) {
		this.obsess_over_host = obsess_over_host;
	}

	public String getParents() {
		return parents;
	}

	public void setParents(String parents) {
		this.parents = parents;
	}

	public int getPending_flex_downtime() {
		return pending_flex_downtime;
	}

	public void setPending_flex_downtime(int pending_flex_downtime) {
		this.pending_flex_downtime = pending_flex_downtime;
	}

	public Float getPercent_state_change() {
		return percent_state_change;
	}

	public void setPercent_state_change(Float percent_state_change) {
		this.percent_state_change = percent_state_change;
	}

	public String getPerf_data() {
		return perf_data;
	}

	public void setPerf_data(String perf_data) {
		this.perf_data = perf_data;
	}

	public String getPlugin_output() {
		return plugin_output;
	}

	public void setPlugin_output(String plugin_output) {
		this.plugin_output = plugin_output;
	}

	public int getPnpgraph_present() {
		return pnpgraph_present;
	}

	public void setPnpgraph_present(int pnpgraph_present) {
		this.pnpgraph_present = pnpgraph_present;
	}

	public int getProcess_performance_data() {
		return process_performance_data;
	}

	public void setProcess_performance_data(int process_performance_data) {
		this.process_performance_data = process_performance_data;
	}

	public Float getRetry_interval() {
		return retry_interval;
	}

	public void setRetry_interval(Float retry_interval) {
		this.retry_interval = retry_interval;
	}

	public int getScheduled_downtime_depth() {
		return scheduled_downtime_depth;
	}

	public void setScheduled_downtime_depth(int scheduled_downtime_depth) {
		this.scheduled_downtime_depth = scheduled_downtime_depth;
	}

	public String getService_period() {
		return service_period;
	}

	public void setService_period(String service_period) {
		this.service_period = service_period;
	}

	public String getServices() {
		return services;
	}

	public void setServices(String services) {
		this.services = services;
	}

	public String getServices_with_info() {
		return services_with_info;
	}

	public void setServices_with_info(String services_with_info) {
		this.services_with_info = services_with_info;
	}

	public String getServices_with_state() {
		return services_with_state;
	}

	public void setServices_with_state(String services_with_state) {
		this.services_with_state = services_with_state;
	}

	public Float getStaleness() {
		return staleness;
	}

	public void setStaleness(Float staleness) {
		this.staleness = staleness;
	}

	public int getState() {
		return state;
	}

	public void setState(int state) {
		this.state = state;
	}

	public int getState_type() {
		return state_type;
	}

	public void setState_type(int state_type) {
		this.state_type = state_type;
	}

	public String getStatusmap_image() {
		return statusmap_image;
	}

	public void setStatusmap_image(String statusmap_image) {
		this.statusmap_image = statusmap_image;
	}

	public int getTotal_services() {
		return total_services;
	}

	public void setTotal_services(int total_services) {
		this.total_services = total_services;
	}

	public int getWorst_service_hard_state() {
		return worst_service_hard_state;
	}

	public void setWorst_service_hard_state(int worst_service_hard_state) {
		this.worst_service_hard_state = worst_service_hard_state;
	}

	public int getWorst_service_state() {
		return worst_service_state;
	}

	public void setWorst_service_state(int worst_service_state) {
		this.worst_service_state = worst_service_state;
	}

	public Float getX_3d() {
		return x_3d;
	}

	public void setX_3d(Float x_3d) {
		this.x_3d = x_3d;
	}

	public Float getY_3d() {
		return y_3d;
	}

	public void setY_3d(Float y_3d) {
		this.y_3d = y_3d;
	}

	public Float getZ_3d() {
		return z_3d;
	}

	public void setZ_3d(Float z_3d) {
		this.z_3d = z_3d;
	}

	public List<EventDTO> getEvents() {
		return events;
	}

	public void setEvents(List<EventDTO> events) {
		this.events = events;
	}

	public List<ServicesDTO> getListOfServices() {
		return listOfServices;
	}

	public void setListOfServices(List<ServicesDTO> listOfServices) {
		this.listOfServices = listOfServices;
	}

	public List<ContactsDTO> getListOfContacts() {
		return listOfContacts;
	}

	public void setListOfContacts(List<ContactsDTO> listOfContacts) {
		this.listOfContacts = listOfContacts;
	}



 


}