package br.com.centralit.citcorpore.bean;

import java.sql.Timestamp;

import com.fasterxml.jackson.annotation.JsonIgnore;

import br.com.citframework.dto.IDto;

/**
 * DTO utilizado para armazenar as informaes de conexo com ferramentas de monitorao.
 * 
 * @author VALDOILO MARQUES DAMASCENO
 * @version 1.0
 * @created 21-out-2014 16:48:58
 */
public class EvmConexaoDTO implements IDto {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2008079552001097414L;

	private String conexaoEventMonitorIdentificador;

	@JsonIgnore
	private String conexaoEventMonitorSenha;

	@JsonIgnore
	private String conexaoEventMonitorUrl;

	@JsonIgnore
	private String conexaoEventMonitorUsuario;

	/**
	 * Data/hora de excluso lgica do registro.
	 */
	private Timestamp dataHoraFim;

	/**
	 * Data/hora de criao do registro.
	 */
	private Timestamp dataHoraInicio;

	/**
	 * Data/hora da ltima alterao do registro.
	 */
	private Timestamp dataHoraUltimaAlteracao;

	/**
	 * Endereo IP da conexo.
	 */
	private String endereco;

	/**
	 * @author cristian.guedes
	 * @since 02/03/2015
	 */
	private EvmInventoryConfiguracaoDTO evmInventoryConfiguracaoDTO;

	/**
	 * Ferramenta de monitorao: Nagios, Zabbix, Citsmart Monitor, Legado
	 */
	private String ferramenta;

	/**
	 * Identificador nico da conexo com ferramentas de monitorao.
	 */
	private Integer idConexao;

	@JsonIgnore
	private Integer idEvmConexaoEventMonitor;
	/**
	 * Identificador do Usurio que criou o registro.
	 */
	private Integer idUsuarioCriador;
	/**
	 * Identificador do Usurio que modificou o registro.
	 */
	private Integer idUsuarioModificador;

	/**
	 * Nome da conexo
	 */
	private String nome;
	private String nomeHost;
	private String nomeUsuarioCriador;
	private String nomeUsuarioModificador;

	/**
	 * Porta do endereo de conexo.
	 */
	private Integer porta;

	/**
	 * Tipo da conexo: TCP
	 */
	private String protocolo;

	/**
	 * Senha necessria para estabelecer conexo.
	 */
	private String senha;

	/**
	 * Status da conexo
	 */
	private String status;

	/**
	 * Usurio necessrio para estabelecer a conexo.
	 */
	private String usuario;

	public String getConexaoEventMonitorIdentificador() {
		return conexaoEventMonitorIdentificador;
	}

	public String getConexaoEventMonitorSenha() {
		return conexaoEventMonitorSenha;
	}

	public String getConexaoEventMonitorUrl() {
		return conexaoEventMonitorUrl;
	}

	public String getConexaoEventMonitorUsuario() {
		return conexaoEventMonitorUsuario;
	}

	public String getEndereco() {
		return endereco;
	}

	public EvmInventoryConfiguracaoDTO getEvmInventoryConfiguracaoDTO() {
		return evmInventoryConfiguracaoDTO;
	}

	public String getFerramenta() {
		return ferramenta;
	}

	public Integer getIdConexao() {
		return idConexao;
	}

	public Integer getIdEvmConexaoEventMonitor() {
		return idEvmConexaoEventMonitor;
	}

	public Integer getIdUsuarioCriador() {
		return idUsuarioCriador;
	}

	public Integer getIdUsuarioModificador() {
		return idUsuarioModificador;
	}

	public String getNome() {
		return nome;
	}

	public String getNomeHost() {
		return nomeHost;
	}

	public String getNomeUsuarioCriador() {
		return nomeUsuarioCriador;
	}

	public String getNomeUsuarioModificador() {
		return nomeUsuarioModificador;
	}

	public Integer getPorta() {
		return porta;
	}

	public String getProtocolo() {
		return protocolo;
	}

	public String getSenha() {
		return senha;
	}

	public String getStatus() {
		return status;
	}

	public String getUsuario() {
		return usuario;
	}

	public void setConexaoEventMonitorIdentificador(String conexaoEventMonitorIdentificador) {
		this.conexaoEventMonitorIdentificador = conexaoEventMonitorIdentificador;
	}

	public void setConexaoEventMonitorSenha(String conexaoEventMonitorSenha) {
		this.conexaoEventMonitorSenha = conexaoEventMonitorSenha;
	}

	public void setConexaoEventMonitorUrl(String conexaoEventMonitorUrl) {
		this.conexaoEventMonitorUrl = conexaoEventMonitorUrl;
	}

	public void setConexaoEventMonitorUsuario(String conexaoEventMonitorUsuario) {
		this.conexaoEventMonitorUsuario = conexaoEventMonitorUsuario;
	}

	public void setEndereco(String endereco) {
		this.endereco = endereco;
	}

	public void setEvmInventoryConfiguracaoDTO(EvmInventoryConfiguracaoDTO evmInventoryConfiguracaoDTO) {
		this.evmInventoryConfiguracaoDTO = evmInventoryConfiguracaoDTO;
	}

	public void setFerramenta(String ferramenta) {
		this.ferramenta = ferramenta;
	}

	public void setIdConexao(Integer idConexao) {
		this.idConexao = idConexao;
	}

	public void setIdEvmConexaoEventMonitor(Integer idEvmConexaoEventMonitor) {
		this.idEvmConexaoEventMonitor = idEvmConexaoEventMonitor;
	}

	public void setIdUsuarioCriador(Integer idUsuarioCriador) {
		this.idUsuarioCriador = idUsuarioCriador;
	}

	public void setIdUsuarioModificador(Integer idUsuarioModificador) {
		this.idUsuarioModificador = idUsuarioModificador;
	}

	public void setNome(String nome) {
		this.nome = nome;
	}

	public void setNomeHost(String nomeHost) {
		this.nomeHost = nomeHost;
	}

	public void setNomeUsuarioCriador(String nomeUsuarioCriador) {
		this.nomeUsuarioCriador = nomeUsuarioCriador;
	}

	public void setNomeUsuarioModificador(String nomeUsuarioModificador) {
		this.nomeUsuarioModificador = nomeUsuarioModificador;
	}

	public void setPorta(Integer porta) {
		this.porta = porta;
	}

	public void setProtocolo(String protocolo) {
		this.protocolo = protocolo;
	}

	public void setSenha(String senha) {
		this.senha = senha;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public void setUsuario(String usuario) {
		this.usuario = usuario;
	}

	public Timestamp getDataHoraFim() {
		return dataHoraFim;
	}

	public void setDataHoraFim(Timestamp dataHoraFim) {
		this.dataHoraFim = dataHoraFim;
	}

	public Timestamp getDataHoraInicio() {
		return dataHoraInicio;
	}

	public void setDataHoraInicio(Timestamp dataHoraInicio) {
		this.dataHoraInicio = dataHoraInicio;
	}

	public Timestamp getDataHoraUltimaAlteracao() {
		return dataHoraUltimaAlteracao;
	}

	public void setDataHoraUltimaAlteracao(Timestamp dataHoraUltimaAlteracao) {
		this.dataHoraUltimaAlteracao = dataHoraUltimaAlteracao;
	}

}// end EvmConexao