/**
 * CentralIT
 */
package br.com.centralit.citcorpore.bean;

import java.sql.Date;

import br.com.citframework.dto.IDto;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * DTO das expresses cron utilizadas pelo Gerenciamento de Eventos.
 * 
 * @author valdoilo.damasceno
 * @version 1.0
 * @created 28-out-2014 09:06:00
 */
public class EvmCronDTO implements IDto {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5288265090520064800L;

	/**
	 * Identificador nico da expresso.
	 */
	private Integer idCron;

	/**
	 * Nome da expresso.
	 */
	private String nome;

	/**
	 * Expresso cron.
	 */
	private String expressao;

	/**
	 * Identificador do Usurio que criou o registro.
	 */
	private Integer idUsuarioCriador;

	/**
	 * Identificador do Usurio que modificou o registro.
	 */
	private Integer idUsuarioModificador;

	/**
	 * Data/hora de criao do registro.
	 */
	@JsonIgnore
	private Date dataHoraInicio;

	/**
	 * Data/hora de excluso lgica do registro.
	 */
	@JsonIgnore
	private Date dataHoraFim;

	/**
	 * Data/hora da ltima alterao do registro.
	 */
	@JsonIgnore
	private Date dataHoraUltimaAlteracao;

	private String nomeUsuarioModificador;

	private String nomeUsuarioCriador;

	private String ano;

	private String diaDaSemana;

	private String mes;

	private String diaDoMes;

	private String hora;

	private String minuto;

	private String segundo;

	public Integer getIdCron() {
		return idCron;
	}

	public void setIdCron(Integer idCron) {
		this.idCron = idCron;
	}

	public Integer getIdUsuarioCriador() {
		return idUsuarioCriador;
	}

	public void setIdUsuarioCriador(Integer idUsuarioCriador) {
		this.idUsuarioCriador = idUsuarioCriador;
	}

	public Integer getIdUsuarioModificador() {
		return idUsuarioModificador;
	}

	public void setIdUsuarioModificador(Integer idUsuarioModificador) {
		this.idUsuarioModificador = idUsuarioModificador;
	}

	public Date getDataHoraInicio() {
		return dataHoraInicio;
	}

	public void setDataHoraInicio(Date dataHoraInicio) {
		this.dataHoraInicio = dataHoraInicio;
	}

	public Date getDataHoraFim() {
		return dataHoraFim;
	}

	public void setDataHoraFim(Date dataHoraFim) {
		this.dataHoraFim = dataHoraFim;
	}

	public Date getDataHoraUltimaAlteracao() {
		return dataHoraUltimaAlteracao;
	}

	public void setDataHoraUltimaAlteracao(Date dataHoraUltimaAlteracao) {
		this.dataHoraUltimaAlteracao = dataHoraUltimaAlteracao;
	}

	public String getNome() {
		return nome;
	}

	public void setNome(String nome) {
		this.nome = nome;
	}

	public String getExpressao() {
		return expressao;
	}

	public void setExpressao(String expressao) {
		this.expressao = expressao;
	}

	public String getNomeUsuarioModificador() {
		return nomeUsuarioModificador;
	}

	public void setNomeUsuarioModificador(String nomeUsuarioModificador) {
		this.nomeUsuarioModificador = nomeUsuarioModificador;
	}

	public String getNomeUsuarioCriador() {
		return nomeUsuarioCriador;
	}

	public void setNomeUsuarioCriador(String nomeUsuarioCriador) {
		this.nomeUsuarioCriador = nomeUsuarioCriador;
	}

	public String getAno() {
		return ano;
	}

	public void setAno(String ano) {
		this.ano = ano;
	}

	public String getDiaDaSemana() {
		return diaDaSemana;
	}

	public void setDiaDaSemana(String diaDaSemana) {
		this.diaDaSemana = diaDaSemana;
	}

	public String getMes() {
		return mes;
	}

	public void setMes(String mes) {
		this.mes = mes;
	}

	public String getDiaDoMes() {
		return diaDoMes;
	}

	public void setDiaDoMes(String diaDoMes) {
		this.diaDoMes = diaDoMes;
	}

	public String getHora() {
		return hora;
	}

	public void setHora(String hora) {
		this.hora = hora;
	}

	public String getMinuto() {
		return minuto;
	}

	public void setMinuto(String minuto) {
		this.minuto = minuto;
	}

	public String getSegundo() {
		return segundo;
	}

	public void setSegundo(String segundo) {
		this.segundo = segundo;
	}

}
