package br.com.centralit.citcorpore.bean;

import java.util.Collection;

import br.com.centralit.citcorpore.negocio.Responsable;

@SuppressWarnings("serial")
public class ObjetivoPlanoMelhoriaDTO implements Responsable {

	private Integer idObjetivoPlanoMelhoria;
	private Integer idPlanoMelhoria;
	private Integer idPlanoMelhoriaAux1;
	private String tituloObjetivo;
	private String detalhamentoObjetivo;
	private String resultadoEsperado;
	private String medicaoObjetivo;
	private String criadoPor;
	private String modificadoPor;
	private java.sql.Date dataCriacao;
	private java.sql.Date ultModificacao;
	private String responsavelObjetivo;
	private Integer idGrupoRespObj;
	private Integer idRespObj;
	private Integer sequencialObjetivo;

	private Collection<AcaoPlanoMelhoriaDTO> listAcaoPlanoMelhoria;
	private Collection<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoria;
	private Collection<ObjetivoMonitoramentoDTO> listObjetivosMonitoramento;

	@Override
	public boolean isGrupo() {
		return idGrupoRespObj != null && !isSemResponsavel();
	}

	@Override
	public boolean isResponsavel() {
		return idRespObj != null && !isSemResponsavel();
	}

	@Override
	public boolean isSemResponsavel() {
		return idRespObj == null && idGrupoRespObj == null;
	}

	@Override
	public Integer getValidIdResponsavel() {
		return isSemResponsavel() ? null : (isGrupo() ? idGrupoRespObj : idRespObj);
	}

	public Integer getIdGrupoRespObj() {
		return idGrupoRespObj;
	}

	public void setIdGrupoRespObj(Integer idGrupoRespObj) {
		this.idGrupoRespObj = idGrupoRespObj;
	}

	public Integer getIdRespObj() {
		return idRespObj;
	}

	public void setIdRespObj(Integer idRespObj) {
		this.idRespObj = idRespObj;
	}

	public Integer getIdObjetivoPlanoMelhoria() {
		return this.idObjetivoPlanoMelhoria;
	}

	public void setIdObjetivoPlanoMelhoria(Integer parm) {
		this.idObjetivoPlanoMelhoria = parm;
	}

	public Integer getIdPlanoMelhoria() {
		return this.idPlanoMelhoria;
	}

	public void setIdPlanoMelhoria(Integer parm) {
		this.idPlanoMelhoria = parm;
	}

	public String getTituloObjetivo() {
		return this.tituloObjetivo;
	}

	public void setTituloObjetivo(String parm) {
		this.tituloObjetivo = parm;
	}

	public String getResultadoEsperado() {
		return this.resultadoEsperado;
	}

	public void setResultadoEsperado(String parm) {
		this.resultadoEsperado = parm;
	}

	public String getCriadoPor() {
		return this.criadoPor;
	}

	public void setCriadoPor(String parm) {
		this.criadoPor = parm;
	}

	public String getModificadoPor() {
		return this.modificadoPor;
	}

	public void setModificadoPor(String parm) {
		this.modificadoPor = parm;
	}

	public java.sql.Date getDataCriacao() {
		return this.dataCriacao;
	}

	public void setDataCriacao(java.sql.Date parm) {
		this.dataCriacao = parm;
	}

	public java.sql.Date getUltModificacao() {
		return this.ultModificacao;
	}

	public void setUltModificacao(java.sql.Date parm) {
		this.ultModificacao = parm;
	}

	/**
	 * @return the listAcaoPlanoMelhoria
	 */
	public Collection<AcaoPlanoMelhoriaDTO> getListAcaoPlanoMelhoria() {
		return listAcaoPlanoMelhoria;
	}

	/**
	 * @param listAcaoPlanoMelhoria
	 *            the listAcaoPlanoMelhoria to set
	 */
	public void setListAcaoPlanoMelhoria(Collection<AcaoPlanoMelhoriaDTO> listAcaoPlanoMelhoria) {
		this.listAcaoPlanoMelhoria = listAcaoPlanoMelhoria;
	}

	/**
	 * @return the sequencialObjetivo
	 */
	public Integer getSequencialObjetivo() {
		return sequencialObjetivo;
	}

	/**
	 * @param sequencialObjetivo
	 *            the sequencialObjetivo to set
	 */
	public void setSequencialObjetivo(Integer sequencialObjetivo) {
		this.sequencialObjetivo = sequencialObjetivo;
	}

	/**
	 * @return the listObjetivosPlanoMelhoria
	 */
	public Collection<ObjetivoPlanoMelhoriaDTO> getListObjetivosPlanoMelhoria() {
		return listObjetivosPlanoMelhoria;
	}

	/**
	 * @param listObjetivosPlanoMelhoria
	 *            the listObjetivosPlanoMelhoria to set
	 */
	public void setListObjetivosPlanoMelhoria(Collection<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoria) {
		this.listObjetivosPlanoMelhoria = listObjetivosPlanoMelhoria;
	}

	public Integer getIdPlanoMelhoriaAux1() {
		return idPlanoMelhoriaAux1;
	}

	public void setIdPlanoMelhoriaAux1(Integer idPlanoMelhoriaAux1) {
		this.idPlanoMelhoriaAux1 = idPlanoMelhoriaAux1;
	}

	/**
	 * @return the listObjetivosMonitoramento
	 */
	public Collection<ObjetivoMonitoramentoDTO> getListObjetivosMonitoramento() {
		return listObjetivosMonitoramento;
	}

	/**
	 * @param listObjetivosMonitoramento the listObjetivosMonitoramento to set
	 */
	public void setListObjetivosMonitoramento(Collection<ObjetivoMonitoramentoDTO> listObjetivosMonitoramento) {
		this.listObjetivosMonitoramento = listObjetivosMonitoramento;
	}

	public String getDetalhamentoObjetivo() {
		return detalhamentoObjetivo;
	}

	public void setDetalhamentoObjetivo(String detalhamentoObjetivo) {
		this.detalhamentoObjetivo = detalhamentoObjetivo;
	}

	public String getMedicaoObjetivo() {
		return medicaoObjetivo;
	}

	public void setMedicaoObjetivo(String medicaoObjetivo) {
		this.medicaoObjetivo = medicaoObjetivo;
	}

	public String getResponsavelObjetivo() {
		return responsavelObjetivo;
	}

	public void setResponsavelObjetivo(String responsavelObjetivo) {
		this.responsavelObjetivo = responsavelObjetivo;
	}

	@Override
	public void addNomeDoResponsavel(String responsavel) {
		setResponsavelObjetivo(responsavel);
	}

}
