package br.com.centralit.citcorpore.bean;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.HashMap;

import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.citframework.util.Reflexao;

public class ServiceRequestDTO extends SolicitacaoServicoDTO {

	private static final long serialVersionUID = 450686752303710099L;

	public boolean isApproved() {
		return this.aprovada();
	}

	public boolean isSolved() {
		return this.atendida();
	}

	public boolean isInProgress() {
		return this.emAtendimento();
	}

	public boolean isClosed() {
		return this.encerrada();
	}

	public boolean isDirected() {
		return this.escalada();
	}

	public boolean isFinalized() {
		return this.finalizada();
	}

	public boolean isCanceled() {
		return this.cancelada();
	}

	public boolean isDelayed() {
		return this.getAtrasada();
	}

	public String getChangeStatus() {
		return this.getAlterarSituacao();
	}

	public void setChangeStatus(String changeStatus) {
		if (SimNao.SIM.getValorStrEn().equalsIgnoreCase(changeStatus)) {
			changeStatus = SimNao.SIM.getValorStr().toUpperCase();
		}

		this.setAlterarSituacao(changeStatus);
	}

	public String getEscalate() {
		return this.getEscalar();
	}

	public void setEscalate(String escalate) {
		if (SimNao.SIM.getValorStrEn().equalsIgnoreCase(escalate)) {
			escalate = SimNao.SIM.getValorStr().toUpperCase();
		}

		this.setEscalar(escalate);
	}

	public Integer getIdIncidentCause() {
		return this.getIdCausaIncidente();
	}

	public void setIdIncidentCause(Integer value) {
		this.setIdCausaIncidente(value);
	}

	public String getHasChange() {
		return this.getHouveMudanca();
	}

	public void setHasChange(String value) {
		this.setHouveMudanca(value);
	}

	public String getTemporarySolution() {
		return this.getSolucaoTemporaria();
	}

	public void setTemporarySolution(String value) {
		this.setSolucaoTemporaria(value);
	}

	public String getCurrentGroup() {
		return this.getGrupoAtual();
	}

	public void setCurrentGroup(String value) {
		this.setGrupoAtual(value);
	}

	public String getServiceName() {
		return this.getServico();
	}

	public void setServiceName(String value) {
		this.setServico(value);
	}

	public Integer getDeadlineHH() {
		return this.getPrazoHH();
	}

	public void setDeadlineHH(Integer value) {
		this.setPrazoHH(value);
	}

	public Integer getCaptureDeadlineHH() {
		return this.getPrazoCapturaHH();
	}

	public void setCaptureDeadlineHH(Integer value) {
		this.setPrazoCapturaHH(value);
	}

	public Integer getIdCurrentPhase() {
		return this.getIdFaseAtual();
	}

	public void setIdCurrentPhase(Integer value) {
		this.setIdFaseAtual(value);
	}

	public Integer getIdKnowledgeBase() {
		return this.getIdBaseConhecimento();
	}

	public void setIdKnowledgeBase(Integer value) {
		this.setIdBaseConhecimento(value);
	}

	public Timestamp getEndDateTime() {
		return this.getDataHoraFim();
	}

	public void setEndDateTime(Timestamp value) {
		this.setDataHoraFim(value);
	}

	public Integer getIdOwner() {
		return this.getIdResponsavel();
	}

	public void setIdOwner(Integer value) {
		this.setIdResponsavel(value);
	}

	public Integer getIdOwnerRequest() {
		return this.getIdSolicitacaoPai();
	}

	public void setIdOwnerRequest(Integer value) {
		this.setIdSolicitacaoPai(value);
	}

	public String getSendFinalizationMail() {
		return this.getEnviaEmailFinalizacao();
	}

	public void setSendFinalizationMail(String value) {
		this.setEnviaEmailFinalizacao(value);
	}

	public Integer getIdService() {
		return this.getIdServico();
	}

	public void setIdService(Integer value) {
		this.setIdServico(value);
	}

	public String getResponse() {
		return this.getResposta();
	}

	public void setResponse(String value) {
		this.setResposta(value);
	}

	public String getRequesterDepartmentName() {
		return this.getNomeUnidadeSolicitante();
	}

	public void setRequesterDepartmentName(String value) {
		this.setNomeUnidadeSolicitante(value);
	}

	public Integer getIdServiceRequest() {
		return this.getIdSolicitacaoServico();
	}

	public void setIdServiceRequest(Integer value) {
		this.setIdSolicitacaoServico(value);
	}

	public Integer getReopenSequence() {
		return this.getSeqReabertura();
	}

	public void setReopenSequence(Integer value) {
		this.setSeqReabertura(value);
	}

	public Integer getIdLocale() {
		return this.getIdLocalidade();
	}

	public void setIdLocale(Integer value) {
		this.setIdLocalidade(value);
	}

	public String getOriginName() {
		return this.getOrigem();
	}

	public void setOriginName(String value) {
		this.setOrigem(value);
	}

	public String getOwnerEmail() {
		return this.getEmailResponsavel();
	}

	public void setOwnerEmail(String value) {
		this.setEmailResponsavel(value);
	}

	public Timestamp getDateTimeReactivationSLA() {
		return this.getDataHoraInicioSLA();
	}

	public void setDateTimeReactivationSLA(Timestamp value) {
		this.setDataHoraInicioSLA(value);
	}

	public String getContactEmail() {
		return this.getEmailcontato();
	}

	public void setContactEmail(String value) {
		this.setEmailcontato(value);
	}

	public Integer getPastTimeMM() {
		return this.getTempoDecorridoMM();
	}

	public void setPastTimeMM(Integer value) {
		this.setTempoDecorridoMM(value);
	}

	public String getApproval() {
		return this.getAprovacao();
	}

	public void setApproval(String value) {
		this.setAprovacao(value);
	}

	public Integer getTreatmentTimeMM() {
		return this.getTempoAtendimentoMM();
	}

	public void setTreatmentTimeMM(Integer value) {
		this.setTempoAtendimentoMM(value);
	}

	public Integer getPreviousDeadlineHH() {
		return this.getPrazohhAnterior();
	}

	public void setPreviousDeadlineHH(Integer value) {
		this.setPrazohhAnterior(value);
	}

	public String getDemandTypeName() {
		return this.getDemanda();
	}

	public void setDemandTypeName(String value) {
		this.setDemanda(value);
	}

	public Integer getIdRequester() {
		return this.getIdSolicitante();
	}

	public void setIdRequester(Integer value) {
		this.setIdSolicitante(value);
	}

	public Integer getIdCurrentGroup() {
		return this.getIdGrupoAtual();
	}

	public void setIdCurrentGroup(Integer value) {
		this.setIdGrupoAtual(value);
	}

	public Integer getIdDemandTypeService() {
		return this.getIdTipoDemandaServico();
	}

	public void setIdDemandTypeService(Integer value) {
		this.setIdTipoDemandaServico(value);
	}

	public String getUrgency() {
		return this.getUrgencia();
	}

	public void setUrgency(String value) {
		this.setUrgencia(value);
	}

	public Timestamp getDeadline() {
		return this.getDataHoraLimite();
	}

	public void setDeadline(Timestamp value) {
		this.setDataHoraLimite(value);
	}

	public String getPersonalAssistance() {
		return this.getAtendimentoPresencial();
	}

	public void setPersonalAssistance(String value) {
		this.setAtendimentoPresencial(value);
	}

	public String getSLAToAgree() {
		return this.getSlaACombinar();
	}

	public void setSLAToAgree(String value) {
		this.setSlaACombinar(value);
	}

	public String getCauseDetail() {
		return this.getDetalhamentoCausa();
	}

	public void setCauseDetail(String value) {
		this.setDetalhamentoCausa(value);
	}

	public Integer getIdDepartment() {
		return this.getIdUnidade();
	}

	public void setIdDepartment(Integer value) {
		this.setIdUnidade(value);
	}

	public String getGroupLevel1() {
		return this.getGrupoNivel1();
	}

	public void setGroupLevel1(String value) {
		this.setGrupoNivel1(value);
	}

	public Timestamp getCaptureDateTime() {
		return this.getDataHoraCaptura();
	}

	public void setCaptureDateTime(Timestamp value) {
		this.setDataHoraCaptura(value);
	}

	public Integer getIdRelatedRequest() {
		return this.getIdSolicitacaoRelacionada();
	}

	public void setIdRelatedRequest(Integer value) {
		this.setIdSolicitacaoRelacionada(value);
	}

	public Integer getDelayTimeHH() {
		return this.getTempoAtrasoHH();
	}

	public void setDelayTimeHH(Integer value) {
		this.setTempoAtrasoHH(value);
	}

	public Timestamp getRequestDateTime() {
		return this.getDataHoraSolicitacao();
	}

	public void setRequestDateTime(Timestamp value) {
		this.setDataHoraSolicitacao(value);
	}

	public String getContractName() {
		return this.getContrato();
	}

	public void setContractName(String value) {
		this.setContrato(value);
	}

	public String getDescription() {
		return this.getDescricao();
	}

	public void setDescription(String value) {
		this.setDescricao(value);
	}

	public Integer getPastTimeHH() {
		return this.getTempoDecorridoHH();
	}

	public void setPastTimeHH(Integer value) {
		this.setTempoDecorridoHH(value);
	}

	public String getCurrentPhase() {
		return this.getFaseAtual();
	}

	public void setCurrentPhase(String value) {
		this.setFaseAtual(value);
	}

	public Integer getCaptureTimeMM() {
		return this.getTempoCapturaMM();
	}

	public void setCaptureTimeMM(Integer value) {
		this.setTempoCapturaMM(value);
	}

	public String getContactName() {
		return this.getNomecontato();
	}

	public void setContactName(String value) {
		this.setNomecontato(value);
	}

	public String getReasonChangeSLA() {
		return this.getJustificativaVencimentoSLA();
	}

	public void setReasonChangeSLA(String value) {
		this.setJustificativaVencimentoSLA(value);
	}

	public Timestamp getStartDateTime() {
		return this.getDataHoraInicio();
	}

	public void setStartDateTime(Timestamp value) {
		this.setDataHoraInicio(value);
	}

	public Integer getIdResponseCaegory() {
		return this.getIdCategoriaSolucao();
	}

	public void setIdResponseCaegory(Integer value) {
		this.setIdCategoriaSolucao(value);
	}

	public String getSendCreationMail() {
		return this.getEnviaEmailCriacao();
	}

	public void setSendCreationMail(String value) {
		this.setEnviaEmailCriacao(value);
	}

	public String getStatusSLA() {
		return this.getSituacaoSLA();
	}

	public void setStatusSLA(String value) {
		this.setSituacaoSLA(value);
	}

	public Integer getPreviousDeadlineMM() {
		return this.getPrazommAnterior();
	}

	public void setPreviousDeadlineMM(Integer value) {
		this.setPrazommAnterior(value);
	}

	public Integer getIdCalendar() {
		return this.getIdCalendario();
	}

	public void setIdCalendar(Integer value) {
		this.setIdCalendario(value);
	}

	public String getImpact() {
		return this.getImpacto();
	}

	public void setImpact(String value) {
		this.setImpacto(value);
	}

	public String getExternalCode() {
		return this.getCodigoExterno();
	}

	public void setExternalCode(String value) {
		this.setCodigoExterno(value);
	}

	public Integer getIdLastApproval() {
		return this.getIdUltimaAprovacao();
	}

	public void setIdLastApproval(Integer value) {
		this.setIdUltimaAprovacao(value);
	}

	public Integer getDeadlineMM() {
		return this.getPrazoMM();
	}

	public void setDeadlineMM(Integer value) {
		this.setPrazoMM(value);
	}

	public Integer getIdChildConfigurarationItem() {
		return this.getIdItemConfiguracaoFilho();
	}

	public void setIdChildConfigurarationItem(Integer value) {
		this.setIdItemConfiguracaoFilho(value);
	}

	public Integer getIdOrigin() {
		return this.getIdOrigem();
	}

	public void setIdOrigin(Integer value) {
		this.setIdOrigem(value);
	}

	public String getPriority() {
		return this.getPrioridade();
	}

	public void setPriority(String value) {
		this.setPrioridade(value);
	}

	public Integer getIdServiceLevelAgreement() {
		return this.getIdAcordoNivelServico();
	}

	public void setIdServiceLevelAgreement(Integer value) {
		this.setIdAcordoNivelServico(value);
	}

	public Integer getIdContract() {
		return this.getIdContrato();
	}

	public void setIdContract(Integer value) {
		this.setIdContrato(value);
	}

	public Integer getIdPriority() {
		return this.getIdPrioridade();
	}

	public void setIdPriority(Integer value) {
		this.setIdPrioridade(value);
	}

	public Timestamp getReactivationDateTime() {
		return this.getDataHoraReativacao();
	}

	public void setReactivationDateTime(Timestamp value) {
		this.setDataHoraReativacao(value);
	}

	public Integer getCaptureTimeHH() {
		return this.getTempoCapturaHH();
	}

	public void setCaptureTimeHH(Integer value) {
		this.setTempoCapturaHH(value);
	}

	public Integer getCaptureDeadlineMM() {
		return this.getPrazoCapturaMM();
	}

	public void setCaptureDeadlineMM(Integer value) {
		this.setPrazoCapturaMM(value);
	}

	public Timestamp getSuspensionDateTime() {
		return this.getDataHoraSuspensao();
	}

	public void setSuspensionDateTime(Timestamp value) {
		this.setDataHoraSuspensao(value);
	}

	public String getContactPhone() {
		return this.getTelefonecontato();
	}

	public void setContactPhone(String value) {
		this.setTelefonecontato(value);
	}

	public Integer getIdServiceContract() {
		return this.getIdServicoContrato();
	}

	public void setIdServiceContract(Integer value) {
		this.setIdServicoContrato(value);
	}

	public Integer getIdGroupLevel1() {
		return this.getIdGrupoNivel1();
	}

	public void setIdGroupLevel1(Integer value) {
		this.setIdGrupoNivel1(value);
	}

	public Long getIdClosingTask() {
		return this.getIdTarefaEncerramento();
	}

	public void setIdClosingTask(Long value) {
		this.setIdTarefaEncerramento(value);
	}

	public Integer getDelayTimeMM() {
		return this.getTempoAtrasoMM();
	}

	public void setDelayTimeMM(Integer value) {
		this.setTempoAtrasoMM(value);
	}

	public String getOwnerName() {
		return this.getResponsavel();
	}

	public void setOwnerName(String value) {
		this.setResponsavel(value);
	}

	public String getRequesterName() {
		return this.getSolicitante();
	}

	public void setRequesterName(String value) {
		this.setSolicitante(value);
	}

	public Integer getIdContact() {
		return this.getIdContatoSolicitacaoServico();
	}

	public void setIdContact(Integer value) {
		this.setIdContatoSolicitacaoServico(value);
	}

	public String getOwnerDepartmentName() {
		return this.getNomeUnidadeResponsavel();
	}

	public void setOwnerDepartmentName(String value) {
		this.setNomeUnidadeResponsavel(value);
	}

	public String getObservation() {
		return this.getObservacao();
	}

	public void setObservation(String value) {
		this.setObservacao(value);
	}

	public Integer getTreatmentTimeHH() {
		return this.getTempoAtendimentoHH();
	}

	public void setTreatmentTimeHH(Integer value) {
		this.setTempoAtendimentoHH(value);
	}

	public Integer getIdProblemType() {
		return this.getIdTipoProblema();
	}

	public void setIdProblemType(Integer value) {
		this.setIdTipoProblema(value);
	}

	public String getSendActionMail() {
		return this.getEnviaEmailAcoes();
	}

	public void setSendActionMail(String value) {
		this.setEnviaEmailAcoes(value);
	}

	public Integer getIdConfigurationItem() {
		return this.getIdItemConfiguracao();
	}

	public void setIdConfigurationItem(Integer value) {
		this.setIdItemConfiguracao(value);
	}

	/**
	 * Method to translate the (most important) attributes of SolicitacaoServicoDTO.
	 *
	 * @author carlos.alberto
	 * @author douglas.japiassu
	 */
	public static void main(String[] args) {
		HashMap<String, String> map = new HashMap<String, String>();

		map.put("IdSolicitacaoServico", "IdServiceRequest");
		map.put("IdBaseConhecimento", "IdKnowledgeBase");
		map.put("IdServicoContrato", "IdServiceContract");
		map.put("IdSolicitante", "IdRequester");
		map.put("IdItemConfiguracao", "IdConfigurationItem");
		map.put("IdItemConfiguracaoFilho", "IdChildConfigurarationItem");
		map.put("IdContatoSolicitacaoServico", "IdContact");
		map.put("IdOrigem", "IdOrigin");
		map.put("IdResponsavel", "IdOwner");
		map.put("IdTipoProblema", "IdProblemType");
		map.put("IdPrioridade", "IdPriority");
		map.put("IdUnidade", "IdDepartment");
		map.put("IdFaseAtual", "IdCurrentPhase");
		map.put("IdGrupoAtual", "IdCurrentGroup");
		map.put("DataHoraSolicitacao", "RequestDateTime");
		map.put("DataHoraLimite", "Deadline");
		map.put("AtendimentoPresencial", "PersonalAssistance");
		map.put("PrazoCapturaHH", "CaptureDeadlineHH");
		map.put("PrazoCapturaMM", "CaptureDeadlineMM");
		map.put("PrazoHH", "DeadlineHH");
		map.put("PrazoMM", "DeadlineMM");
		map.put("Descricao", "Description");
		map.put("Resposta", "Response");
		map.put("DataHoraInicio", "StartDateTime");
		map.put("DataHoraFim", "EndDateTime");
		map.put("IdSolicitacaoPai", "IdOwnerRequest");
		map.put("DetalhamentoCausa", "CauseDetail");
		map.put("IdCausaIncidente", "IdIncidentCause");
		map.put("IdCategoriaSolucao", "IdResponseCaegory");
		map.put("SeqReabertura", "ReopenSequence");
		map.put("EnviaEmailCriacao", "SendCreationMail");
		map.put("EnviaEmailFinalizacao", "SendFinalizationMail");
		map.put("EnviaEmailAcoes", "SendActionMail");
		map.put("IdGrupoNivel1", "IdGroupLevel1");
		map.put("SolucaoTemporaria", "TemporarySolution");
		map.put("HouveMudanca", "HasChange");
		map.put("SlaACombinar", "SLAToAgree");
		map.put("PrazohhAnterior", "PreviousDeadlineHH");
		map.put("PrazommAnterior", "PreviousDeadlineMM");
		map.put("IdCalendario", "IdCalendar");
		map.put("TempoDecorridoHH", "PastTimeHH");
		map.put("TempoDecorridoMM", "PastTimeMM");
		map.put("DataHoraSuspensao", "SuspensionDateTime");
		map.put("DataHoraReativacao", "ReactivationDateTime");
		map.put("Impacto", "Impact");
		map.put("Urgencia", "Urgency");
		map.put("DataHoraCaptura", "CaptureDateTime");
		map.put("TempoCapturaHH", "CaptureTimeHH");
		map.put("TempoCapturaMM", "CaptureTimeMM");
		map.put("TempoAtrasoHH", "DelayTimeHH");
		map.put("TempoAtrasoMM", "DelayTimeMM");
		map.put("TempoAtendimentoHH", "TreatmentTimeHH");
		map.put("TempoAtendimentoMM", "TreatmentTimeMM");
		map.put("IdAcordoNivelServico", "IdServiceLevelAgreement");
		map.put("IdUltimaAprovacao", "IdLastApproval");
		map.put("DataHoraInicioSLA", "DateTimeStartSLA");
		map.put("DataHoraInicioSLA", "DateTimeSuspensionSLA");
		map.put("DataHoraInicioSLA", "DateTimeReactivationSLA");
		map.put("SituacaoSLA", "StatusSLA");
		map.put("IdTarefaEncerramento", "IdClosingTask");
		map.put("JustificativaVencimentoSLA", "ReasonChangeSLA");
		map.put("Aprovacao", "Approval");
		map.put("IdServico", "IdService");
		map.put("Servico", "ServiceName");
		map.put("IdTipoDemandaServico", "IdDemandTypeService");
		map.put("Demanda", "DemandTypeName");
		map.put("IdContrato", "IdContract");
		map.put("Contrato", "ContractName");
		map.put("Solicitante", "RequesterName");
		map.put("NomeUnidadeSolicitante", "RequesterDepartmentName");
		map.put("Responsavel", "OwnerName");
		map.put("NomeUnidadeResponsavel", "OwnerDepartmentName");
		map.put("Origem", "OriginName");
		map.put("Prioridade", "Priority");
		map.put("FaseAtual", "CurrentPhase");
		map.put("GrupoAtual", "CurrentGroup");
		map.put("GrupoNivel1", "GroupLevel1");
		map.put("Nomecontato", "ContactName");
		map.put("Emailcontato", "ContactEmail");
		map.put("Telefonecontato", "ContactPhone");
		map.put("Observacao", "Observation");
		map.put("IdLocalidade", "IdLocale");
		map.put("IdSolicitacaoRelacionada", "IdRelatedRequest");
		map.put("EmailResponsavel", "OwnerEmail");
		map.put("CodigoExterno", "ExternalCode");

		SolicitacaoServicoDTO obj = new SolicitacaoServicoDTO();
		for (String key : map.keySet()) {
			String value = map.get(key);
			Method getMethod = Reflexao.findMethod("get" + key, obj);
			if (getMethod != null) {
				Class<?> clazz = getMethod.getReturnType();
				System.out.println("public " + clazz.getSimpleName() + " get" + value + "() {");
				System.out.println("	return this.get" + key + "();");
				System.out.println("}");
				System.out.println("");
				System.out.println("public void set" + value + "(" + clazz.getSimpleName() + " value) {");
				System.out.println("	this.set" + key + "(value);");
				System.out.println("}");
				System.out.println("");
			}
			;
		}
	}

}
