package br.com.centralit.citcorpore.bean;

import java.sql.Timestamp;

import br.com.citframework.dto.IDto;


/**
 * Este DTO faz parte da tabela EVMHostNagiosDTO do Nagios
 * @author cristian.guedes
 *
 */
public class ServicesDTO  implements IDto {
	
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5080220759650433248L;
	/**
	*	Whether the service accepts passive checks (0/1)
	*/
	
	private Integer idServices;
	
	private Integer idEVMHostNagios;
	

	private int accept_passive_checks;
	/**
	*	Whether the current service problem has been acknowledged (0/1)
	*/

	private int acknowledged;
	/**
	*	The type of the acknownledgement (0: none, 1: normal, 2: sticky)
	*/

	private int acknowledgement_type;
	/**
	*	An optional URL for actions or custom information about the service
	*/

	private String action_url;
	/**
	*	The action_url with (the most important) macros expanded
	*/

	private String action_url_expanded;
	/**
	*	Whether active checks are enabled for the service (0/1)
	*/

	private int active_checks_enabled;
	/**
	*	Nagios command used for active checks
	*/

	private String check_command;
	/**
	*	Nagios command used for active checks with the macros expanded
	*/

	private String check_command_expanded;
	/**
	*	Whether freshness checks are activated (0/1)
	*/

	private int check_freshness;
	/**
	*	Number of basic interval lengths between two scheduled checks of the service
	*/

	private Float check_interval;
	/**
	*	The current check option, forced, normal, freshness... (0/1)
	*/

	private int check_options;
	/**
	*	The name of the check period of the service. It this is empty, the service is always checked.
	*/

	private String check_period;
	/**
	*	The type of the last check (0: active, 1: passive)
	*/

	private int check_type;
	/**
	*	Whether active checks are enabled for the service (0/1)
	*/

	private int checks_enabled;
	/**
	*	A list of all comment ids of the service
	*/

	private String comments;
	/**
	*	A list of all comments of the service with id, author, comment, entry type and entry time
	*/

	private String comments_with_extra_info;
	/**
	*	A list of all comments of the service with id, author and comment
	*/

	private String comments_with_info;
	/**
	*	A list of all contact groups this service is in
	*/

	private String contact_groups;
	/**
	*	A list of all contacts of the service, either direct or via a contact group
	*/

	private String contacts;
	/**
	*	The number of the current check attempt
	*/

	private int current_attempt;
	/**
	*	The number of the current notification
	*/

	private int current_notification_number;
	/**
	*	A list of the names of all custom variables of the service
	*/

	private String custom_variable_names;
	/**
	*	A list of the values of all custom variable of the service
	*/

	private String custom_variable_values;
	/**
	*	A dictionary of the custom variables
	*/

	private String custom_variables;
	/**
	*	Description of the service (also used as key)
	*/

	private String description;
	/**
	*	An optional display name (not used by Nagios standard web pages)
	*/

	private String display_name;
	/**
	*	A list of all downtime ids of the service
	*/

	private String downtimes;
	/**
	*	A list of all downtimes of the service with id, author and comment
	*/

	private String downtimes_with_info;
	/**
	*	Nagios command used as event handler
	*/

	private String event_handler;
	/**
	*	Whether and event handler is activated for the service (0/1)
	*/

	private int event_handler_enabled;
	/**
	*	Time the service check needed for execution
	*/

	private Float execution_time;
	/**
	*	Delay before the first notification
	*/

	private Float first_notification_delay;
	/**
	*	Whether flap detection is enabled for the service (0/1)
	*/

	private int flap_detection_enabled;
	/**
	*	A list of all service groups the service is in
	*/

	private String groups;
	/**
	*	Whether the service already has been checked (0/1)
	*/

	private int has_been_checked;
	/**
	*	High threshold of flap detection
	*/

	private Float high_flap_threshold;
	/**
	*	Whether passive host checks are accepted (0/1)
	*/

	private int host_accept_passive_checks;
	/**
	*	Whether the current host problem has been acknowledged (0/1)
	*/

	private int host_acknowledged;
	/**
	*	Type of acknowledgement (0: none, 1: normal, 2: stick)
	*/

	private int host_acknowledgement_type;
	/**
	*	An optional URL to custom actions or information about this host
	*/

	private String host_action_url;
	/**
	*	The same as action_url, but with the most important macros expanded
	*/

	private String host_action_url_expanded;
	/**
	*	Whether active checks are enabled for the host (0/1)
	*/

	private int host_active_checks_enabled;
	/**
	*	IP address
	*/

	private String host_address;
	/**
	*	An alias name for the host
	*/

	private String host_alias;
	/**
	*	Nagios command for active host check of this host
	*/

	private String host_check_command;
	/**
	*	Nagios command for active host check of this host with the macros expanded
	*/

	private String host_check_command_expanded;
	/**
	*	Whether to check to send a recovery notification when flapping stops (0/1)
	*/

	private int host_check_flapping_recovery_notification;
	/**
	*	Whether freshness checks are activated (0/1)
	*/

	private int host_check_freshness;
	/**
	*	Number of basic interval lengths between two scheduled checks of the host
	*/

	private Float host_check_interval;
	/**
	*	The current check option, forced, normal, freshness... (0-2)
	*/

	private int host_check_options;
	/**
	*	Time period in which this host will be checked. If empty then the host will always be checked.
	*/

	private String host_check_period;
	/**
	*	Type of check (0: active, 1: passive)
	*/

	private int host_check_type;
	/**
	*	Whether checks of the host are enabled (0/1)
	*/

	private int host_checks_enabled;
	/**
	*	A list of all direct childs of the host
	*/

	private String host_childs;
	/**
	*	A list of the ids of all comments of this host
	*/

	private String host_comments;
	/**
	*	A list of all comments of the host with id, author, comment, entry type and entry time
	*/

	private String host_comments_with_extra_info;
	/**
	*	A list of all comments of the host with id, author and comment
	*/

	private String host_comments_with_info;
	/**
	*	A list of all contact groups this host is in
	*/

	private String host_contact_groups;
	/**
	*	A list of all contacts of this host, either direct or via a contact group
	*/

	private String host_contacts;
	/**
	*	Number of the current check attempts
	*/

	private int host_current_attempt;
	/**
	*	Number of the current notification
	*/

	private int host_current_notification_number;
	/**
	*	A list of the names of all custom variables
	*/

	private String host_custom_variable_names;
	/**
	*	A list of the values of the custom variables
	*/

	private String host_custom_variable_values;
	/**
	*	A dictionary of the custom variables
	*/

	private String host_custom_variables;
	/**
	*	Optional display name of the host - not used by Nagios' web interface
	*/

	private String host_display_name;
	/**
	*	A list of the ids of all scheduled downtimes of this host
	*/

	private String host_downtimes;
	/**
	*	A list of the all scheduled downtimes of the host with id, author and comment
	*/

	private String host_downtimes_with_info;
	/**
	*	Nagios command used as event handler
	*/

	private String host_event_handler;
	/**
	*	Whether event handling is enabled (0/1)
	*/

	private int host_event_handler_enabled;
	/**
	*	Time the host check needed for execution
	*/

	private Float host_execution_time;
	/**
	*	The value of the custom variable FILENAME
	*/

	private String host_filename;
	/**
	*	Delay before the first notification
	*/

	private Float host_first_notification_delay;
	/**
	*	Whether flap detection is enabled (0/1)
	*/

	private int host_flap_detection_enabled;
	/**
	*	A list of all host groups this host is in
	*/

	private String host_groups;
	/**
	*	The effective hard state of the host (eliminates a problem in hard_state)
	*/

	private int host_hard_state;
	/**
	*	Whether the host has already been checked (0/1)
	*/

	private int host_has_been_checked;
	/**
	*	High threshold of flap detection
	*/

	private Float host_high_flap_threshold;
	/**
	*	The name of an image file to be used in the web pages
	*/

	private String host_icon_image;
	/**
	*	Alternative text for the icon_image
	*/

	private String host_icon_image_alt;
	/**
	*	The same as icon_image, but with the most important macros expanded
	*/

	private String host_icon_image_expanded;
	/**
	*	Whether this host is currently in its check period (0/1)
	*/

	private int host_in_check_period;
	/**
	*	Whether this host is currently in its notification period (0/1)
	*/

	private int host_in_notification_period;
	/**
	*	Whether this host is currently in its service period (0/1)
	*/

	private int host_in_service_period;
	/**
	*	Initial host state
	*/

	private int host_initial_state;
	/**
	*	is there a host check currently running... (0/1)
	*/

	private int host_is_executing;
	/**
	*	Whether the host state is flapping (0/1)
	*/

	private int host_is_flapping;
	/**
	*	Time of the last check (Unix timestamp)
	*/

	private Timestamp host_last_check;
	/**
	*	Last hard state
	*/

	private int host_last_hard_state;
	/**
	*	Time of the last hard state change (Unix timestamp)
	*/

	private Timestamp host_last_hard_state_change;
	/**
	*	Time of the last notification (Unix timestamp)
	*/

	private Timestamp host_last_notification;
	/**
	*	State before last state change
	*/

	private int host_last_state;
	/**
	*	Time of the last state change - soft or hard (Unix timestamp)
	*/

	private Timestamp host_last_state_change;
	/**
	*	The last time the host was DOWN (Unix timestamp)
	*/

	private Timestamp host_last_time_down;
	/**
	*	The last time the host was UNREACHABLE (Unix timestamp)
	*/

	private Timestamp host_last_time_unreachable;
	/**
	*	The last time the host was UP (Unix timestamp)
	*/

	private Timestamp host_last_time_up;
	/**
	*	Time difference between scheduled check time and actual check time
	*/

	private Float host_latency;
	/**
	*	Complete output from check plugin
	*/

	private String host_long_plugin_output;
	/**
	*	Low threshold of flap detection
	*/

	private Float host_low_flap_threshold;
	/**
	*	Max check attempts for active host checks
	*/

	private int host_max_check_attempts;
	/**
	*	A bitmask specifying which attributes have been modified
	*/

	private int host_modified_attributes;
	/**
	*	A list of all modified attributes
	*/

	private String host_modified_attributes_list;
	/**
	*	Host name
	*/

	private String host_name;
	/**
	*	Scheduled time for the next check (Unix timestamp)
	*/

	private Timestamp host_next_check;
	/**
	*	Time of the next notification (Unix timestamp)
	*/

	private Timestamp host_next_notification;
	/**
	*	Whether to stop sending notifications (0/1)
	*/

	private int host_no_more_notifications;
	/**
	*	Optional notes for this host
	*/

	private String host_notes;
	/**
	*	The same as notes, but with the most important macros expanded
	*/

	private String host_notes_expanded;
	/**
	*	An optional URL with further information about the host
	*/

	private String host_notes_url;
	/**
	*	Same es notes_url, but with the most important macros expanded
	*/

	private String host_notes_url_expanded;
	/**
	*	Interval of periodic notification or 0 if its off
	*/

	private Float host_notification_interval;
	/**
	*	Time period in which problems of this host will be notified. If empty then notification will be always
	*/

	private String host_notification_period;
	/**
	*	Whether notifications of the host are enabled (0/1)
	*/

	private int host_notifications_enabled;
	/**
	*	The total number of services of the host
	*/

	private int host_num_services;
	/**
	*	The number of the host's services with the soft state CRIT
	*/

	private int host_num_services_crit;
	/**
	*	The number of the host's services with the hard state CRIT
	*/

	private int host_num_services_hard_crit;
	/**
	*	The number of the host's services with the hard state OK
	*/

	private int host_num_services_hard_ok;
	/**
	*	The number of the host's services with the hard state UNKNOWN
	*/

	private int host_num_services_hard_unknown;
	/**
	*	The number of the host's services with the hard state WARN
	*/

	private int host_num_services_hard_warn;
	/**
	*	The number of the host's services with the soft state OK
	*/

	private int host_num_services_ok;
	/**
	*	The number of the host's services which have not been checked yet (pending)
	*/

	private int host_num_services_pending;
	/**
	*	The number of the host's services with the soft state UNKNOWN
	*/

	private int host_num_services_unknown;
	/**
	*	The number of the host's services with the soft state WARN
	*/

	private int host_num_services_warn;
	/**
	*	The current obsess_over_host setting... (0/1)
	*/

	private int host_obsess_over_host;
	/**
	*	A list of all direct parents of the host
	*/

	private String host_parents;
	/**
	*	Whether a flex downtime is pending (0/1)
	*/

	private int host_pending_flex_downtime;
	/**
	*	Percent state change
	*/

	private Float host_percent_state_change;
	/**
	*	Optional performance data of the last host check
	*/

	private String host_perf_data;
	/**
	*	Output of the last host check
	*/

	private String host_plugin_output;
	/**
	*	Whether there is a PNP4Nagios graph present for this host (0/1)
	*/

	private int host_pnpgraph_present;
	/**
	*	Whether processing of performance data is enabled (0/1)
	*/

	private int host_process_performance_data;
	/**
	*	Number of basic interval lengths between checks when retrying after a soft error
	*/

	private Float host_retry_interval;
	/**
	*	The number of downtimes this host is currently in
	*/

	private int host_scheduled_downtime_depth;
	/**
	*	The name of the service period of the host
	*/

	private String host_service_period;
	/**
	*	A list of all services of the host
	*/

	private String host_services;
	/**
	*	A list of all services including detailed information about each service
	*/

	private String host_services_with_info;
	/**
	*	A list of all services of the host together with state and has_been_checked
	*/

	private String host_services_with_state;
	/**
	*	Staleness indicator for this host
	*/

	private Float host_staleness;
	/**
	*	The current state of the host (0: up, 1: down, 2: unreachable)
	*/

	private int host_state;
	/**
	*	Type of the current state (0: soft, 1: hard)
	*/

	private int host_state_type;
	/**
	*	The name of in image file for the status map
	*/

	private String host_statusmap_image;
	/**
	*	The total number of services of the host
	*/

	private int host_total_services;
	/**
	*	The worst hard state of all of the host's services (OK <= WARN <= UNKNOWN <= CRIT)
	*/

	private int host_worst_service_hard_state;
	/**
	*	The worst soft state of all of the host's services (OK <= WARN <= UNKNOWN <= CRIT)
	*/

	private int host_worst_service_state;
	/**
	*	3D-Coordinates: X
	*/

	private Float host_x_3d;
	/**
	*	3D-Coordinates: Y
	*/

	private Float host_y_3d;
	/**
	*	3D-Coordinates: Z
	*/

	private Float host_z_3d;
	/**
	*	The name of an image to be used as icon in the web interface
	*/

	private String icon_image;
	/**
	*	An alternative text for the icon_image for browsers not displaying icons
	*/

	private String icon_image_alt;
	/**
	*	The icon_image with (the most important) macros expanded
	*/

	private String icon_image_expanded;
	/**
	*	Whether the service is currently in its check period (0/1)
	*/

	private int in_check_period;
	/**
	*	Whether the service is currently in its notification period (0/1)
	*/

	private int in_notification_period;
	/**
	*	Whether this service is currently in its service period (0/1)
	*/

	private int in_service_period;
	/**
	*	The initial state of the service
	*/

	private int initial_state;
	/**
	*	is there a service check currently running... (0/1)
	*/

	private int is_executing;
	/**
	*	Whether the service is flapping (0/1)
	*/

	private int is_flapping;
	/**
	*	The time of the last check (Unix timestamp)
	*/

	private Timestamp last_check;
	/**
	*	The last hard state of the service
	*/

	private int last_hard_state;
	/**
	*	The time of the last hard state change (Unix timestamp)
	*/

	private Timestamp last_hard_state_change;
	/**
	*	The time of the last notification (Unix timestamp)
	*/

	private Timestamp last_notification;
	/**
	*	The last state of the service
	*/

	private int last_state;
	/**
	*	The time of the last state change (Unix timestamp)
	*/

	private Timestamp last_state_change;
	/**
	*	The last time the service was CRITICAL (Unix timestamp)
	*/

	private Timestamp last_time_critical;
	/**
	*	The last time the service was OK (Unix timestamp)
	*/

	private Timestamp last_time_ok;
	/**
	*	The last time the service was UNKNOWN (Unix timestamp)
	*/

	private Timestamp last_time_unknown;
	/**
	*	The last time the service was in WARNING state (Unix timestamp)
	*/

	private Timestamp last_time_warning;
	/**
	*	Time difference between scheduled check time and actual check time
	*/

	private Float latency;
	/**
	*	Unabbreviated output of the last check plugin
	*/

	private String long_plugin_output;
	/**
	*	Low threshold of flap detection
	*/

	private Float low_flap_threshold;
	/**
	*	The maximum number of check attempts
	*/

	private int max_check_attempts;
	/**
	*	A bitmask specifying which attributes have been modified
	*/

	private int modified_attributes;
	/**
	*	A list of all modified attributes
	*/

	private String modified_attributes_list;
	/**
	*	The scheduled time of the next check (Unix timestamp)
	*/

	private Timestamp next_check;
	/**
	*	The time of the next notification (Unix timestamp)
	*/

	private Timestamp next_notification;
	/**
	*	Whether to stop sending notifications (0/1)
	*/

	private int no_more_notifications;
	/**
	*	Optional notes about the service
	*/

	private String notes;
	/**
	*	The notes with (the most important) macros expanded
	*/

	private String notes_expanded;
	/**
	*	An optional URL for additional notes about the service
	*/

	private String notes_url;
	/**
	*	The notes_url with (the most important) macros expanded
	*/

	private String notes_url_expanded;
	/**
	*	Interval of periodic notification or 0 if its off
	*/

	private Float notification_interval;
	/**
	*	The name of the notification period of the service. It this is empty, service problems are always notified.
	*/

	private String notification_period;
	/**
	*	Whether notifications are enabled for the service (0/1)
	*/

	private int notifications_enabled;
	/**
	*	Whether 'obsess_over_service' is enabled for the service (0/1)
	*/

	private int obsess_over_service;
	/**
	*	Percent state change
	*/

	private Float percent_state_change;
	/**
	*	Performance data of the last check plugin
	*/

	private String perf_data;
	/**
	*	Output of the last check plugin
	*/

	private String plugin_output;
	/**
	*	Whether there is a PNP4Nagios graph present for this service (0/1)
	*/

	private int pnpgraph_present;
	/**
	*	Whether processing of performance data is enabled for the service (0/1)
	*/

	private int process_performance_data;
	/**
	*	Number of basic interval lengths between checks when retrying after a soft error
	*/

	private Float retry_interval;
	/**
	*	The number of scheduled downtimes the service is currently in
	*/

	private int scheduled_downtime_depth;
	/**
	*	The name of the service period of the service
	*/

	private String service_period;
	/**
	*	The staleness indicator for this service
	*/

	private Float staleness;
	/**
	*	The current state of the service (0: OK, 1: WARN, 2: CRITICAL, 3: UNKNOWN)
	*/

	private int state;
	/**
	*	The type of the current state (0: soft, 1: hard)
	*/

	private int state_type;
	
	
	
	public Integer getIdServices() {
		return idServices;
	}



	public void setIdServices(Integer idServices) {
		this.idServices = idServices;
	}



	public Integer getIdEVMHostNagios() {
		return idEVMHostNagios;
	}



	public void setIdEVMHostNagios(Integer idEVMHostNagios) {
		this.idEVMHostNagios = idEVMHostNagios;
	}



	public int getAccept_passive_checks() {
		return accept_passive_checks;
	}



	public void setAccept_passive_checks(int accept_passive_checks) {
		this.accept_passive_checks = accept_passive_checks;
	}



	public int getAcknowledged() {
		return acknowledged;
	}



	public void setAcknowledged(int acknowledged) {
		this.acknowledged = acknowledged;
	}



	public int getAcknowledgement_type() {
		return acknowledgement_type;
	}



	public void setAcknowledgement_type(int acknowledgement_type) {
		this.acknowledgement_type = acknowledgement_type;
	}



	public String getAction_url() {
		return action_url;
	}



	public void setAction_url(String action_url) {
		this.action_url = action_url;
	}



	public String getAction_url_expanded() {
		return action_url_expanded;
	}



	public void setAction_url_expanded(String action_url_expanded) {
		this.action_url_expanded = action_url_expanded;
	}



	public int getActive_checks_enabled() {
		return active_checks_enabled;
	}



	public void setActive_checks_enabled(int active_checks_enabled) {
		this.active_checks_enabled = active_checks_enabled;
	}



	public String getCheck_command() {
		return check_command;
	}



	public void setCheck_command(String check_command) {
		this.check_command = check_command;
	}



	public String getCheck_command_expanded() {
		return check_command_expanded;
	}



	public void setCheck_command_expanded(String check_command_expanded) {
		this.check_command_expanded = check_command_expanded;
	}



	public int getCheck_freshness() {
		return check_freshness;
	}



	public void setCheck_freshness(int check_freshness) {
		this.check_freshness = check_freshness;
	}



	public Float getCheck_interval() {
		return check_interval;
	}



	public void setCheck_interval(Float check_interval) {
		this.check_interval = check_interval;
	}



	public int getCheck_options() {
		return check_options;
	}



	public void setCheck_options(int check_options) {
		this.check_options = check_options;
	}



	public String getCheck_period() {
		return check_period;
	}



	public void setCheck_period(String check_period) {
		this.check_period = check_period;
	}



	public int getCheck_type() {
		return check_type;
	}



	public void setCheck_type(int check_type) {
		this.check_type = check_type;
	}



	public int getChecks_enabled() {
		return checks_enabled;
	}



	public void setChecks_enabled(int checks_enabled) {
		this.checks_enabled = checks_enabled;
	}



	public String getComments() {
		return comments;
	}



	public void setComments(String comments) {
		this.comments = comments;
	}



	public String getComments_with_extra_info() {
		return comments_with_extra_info;
	}



	public void setComments_with_extra_info(String comments_with_extra_info) {
		this.comments_with_extra_info = comments_with_extra_info;
	}



	public String getComments_with_info() {
		return comments_with_info;
	}



	public void setComments_with_info(String comments_with_info) {
		this.comments_with_info = comments_with_info;
	}



	public String getContact_groups() {
		return contact_groups;
	}



	public void setContact_groups(String contact_groups) {
		this.contact_groups = contact_groups;
	}



	public String getContacts() {
		return contacts;
	}



	public void setContacts(String contacts) {
		this.contacts = contacts;
	}



	public int getCurrent_attempt() {
		return current_attempt;
	}



	public void setCurrent_attempt(int current_attempt) {
		this.current_attempt = current_attempt;
	}



	public int getCurrent_notification_number() {
		return current_notification_number;
	}



	public void setCurrent_notification_number(int current_notification_number) {
		this.current_notification_number = current_notification_number;
	}



	public String getCustom_variable_names() {
		return custom_variable_names;
	}



	public void setCustom_variable_names(String custom_variable_names) {
		this.custom_variable_names = custom_variable_names;
	}



	public String getCustom_variable_values() {
		return custom_variable_values;
	}



	public void setCustom_variable_values(String custom_variable_values) {
		this.custom_variable_values = custom_variable_values;
	}



	public String getCustom_variables() {
		return custom_variables;
	}



	public void setCustom_variables(String custom_variables) {
		this.custom_variables = custom_variables;
	}



	public String getDescription() {
		return description;
	}



	public void setDescription(String description) {
		this.description = description;
	}



	public String getDisplay_name() {
		return display_name;
	}



	public void setDisplay_name(String display_name) {
		this.display_name = display_name;
	}



	public String getDowntimes() {
		return downtimes;
	}



	public void setDowntimes(String downtimes) {
		this.downtimes = downtimes;
	}



	public String getDowntimes_with_info() {
		return downtimes_with_info;
	}



	public void setDowntimes_with_info(String downtimes_with_info) {
		this.downtimes_with_info = downtimes_with_info;
	}



	public String getEvent_handler() {
		return event_handler;
	}



	public void setEvent_handler(String event_handler) {
		this.event_handler = event_handler;
	}



	public int getEvent_handler_enabled() {
		return event_handler_enabled;
	}



	public void setEvent_handler_enabled(int event_handler_enabled) {
		this.event_handler_enabled = event_handler_enabled;
	}



	public Float getExecution_time() {
		return execution_time;
	}



	public void setExecution_time(Float execution_time) {
		this.execution_time = execution_time;
	}



	public Float getFirst_notification_delay() {
		return first_notification_delay;
	}



	public void setFirst_notification_delay(Float first_notification_delay) {
		this.first_notification_delay = first_notification_delay;
	}



	public int getFlap_detection_enabled() {
		return flap_detection_enabled;
	}



	public void setFlap_detection_enabled(int flap_detection_enabled) {
		this.flap_detection_enabled = flap_detection_enabled;
	}



	public String getGroups() {
		return groups;
	}



	public void setGroups(String groups) {
		this.groups = groups;
	}



	public int getHas_been_checked() {
		return has_been_checked;
	}



	public void setHas_been_checked(int has_been_checked) {
		this.has_been_checked = has_been_checked;
	}



	public Float getHigh_flap_threshold() {
		return high_flap_threshold;
	}



	public void setHigh_flap_threshold(Float high_flap_threshold) {
		this.high_flap_threshold = high_flap_threshold;
	}



	public int getHost_accept_passive_checks() {
		return host_accept_passive_checks;
	}



	public void setHost_accept_passive_checks(int host_accept_passive_checks) {
		this.host_accept_passive_checks = host_accept_passive_checks;
	}



	public int getHost_acknowledged() {
		return host_acknowledged;
	}



	public void setHost_acknowledged(int host_acknowledged) {
		this.host_acknowledged = host_acknowledged;
	}



	public int getHost_acknowledgement_type() {
		return host_acknowledgement_type;
	}



	public void setHost_acknowledgement_type(int host_acknowledgement_type) {
		this.host_acknowledgement_type = host_acknowledgement_type;
	}



	public String getHost_action_url() {
		return host_action_url;
	}



	public void setHost_action_url(String host_action_url) {
		this.host_action_url = host_action_url;
	}



	public String getHost_action_url_expanded() {
		return host_action_url_expanded;
	}



	public void setHost_action_url_expanded(String host_action_url_expanded) {
		this.host_action_url_expanded = host_action_url_expanded;
	}



	public int getHost_active_checks_enabled() {
		return host_active_checks_enabled;
	}



	public void setHost_active_checks_enabled(int host_active_checks_enabled) {
		this.host_active_checks_enabled = host_active_checks_enabled;
	}



	public String getHost_address() {
		return host_address;
	}



	public void setHost_address(String host_address) {
		this.host_address = host_address;
	}



	public String getHost_alias() {
		return host_alias;
	}



	public void setHost_alias(String host_alias) {
		this.host_alias = host_alias;
	}



	public String getHost_check_command() {
		return host_check_command;
	}



	public void setHost_check_command(String host_check_command) {
		this.host_check_command = host_check_command;
	}



	public String getHost_check_command_expanded() {
		return host_check_command_expanded;
	}



	public void setHost_check_command_expanded(String host_check_command_expanded) {
		this.host_check_command_expanded = host_check_command_expanded;
	}



	public int getHost_check_flapping_recovery_notification() {
		return host_check_flapping_recovery_notification;
	}



	public void setHost_check_flapping_recovery_notification(int host_check_flapping_recovery_notification) {
		this.host_check_flapping_recovery_notification = host_check_flapping_recovery_notification;
	}



	public int getHost_check_freshness() {
		return host_check_freshness;
	}



	public void setHost_check_freshness(int host_check_freshness) {
		this.host_check_freshness = host_check_freshness;
	}



	public Float getHost_check_interval() {
		return host_check_interval;
	}



	public void setHost_check_interval(Float host_check_interval) {
		this.host_check_interval = host_check_interval;
	}



	public int getHost_check_options() {
		return host_check_options;
	}



	public void setHost_check_options(int host_check_options) {
		this.host_check_options = host_check_options;
	}



	public String getHost_check_period() {
		return host_check_period;
	}



	public void setHost_check_period(String host_check_period) {
		this.host_check_period = host_check_period;
	}



	public int getHost_check_type() {
		return host_check_type;
	}



	public void setHost_check_type(int host_check_type) {
		this.host_check_type = host_check_type;
	}



	public int getHost_checks_enabled() {
		return host_checks_enabled;
	}



	public void setHost_checks_enabled(int host_checks_enabled) {
		this.host_checks_enabled = host_checks_enabled;
	}



	public String getHost_childs() {
		return host_childs;
	}



	public void setHost_childs(String host_childs) {
		this.host_childs = host_childs;
	}



	public String getHost_comments() {
		return host_comments;
	}



	public void setHost_comments(String host_comments) {
		this.host_comments = host_comments;
	}



	public String getHost_comments_with_extra_info() {
		return host_comments_with_extra_info;
	}



	public void setHost_comments_with_extra_info(String host_comments_with_extra_info) {
		this.host_comments_with_extra_info = host_comments_with_extra_info;
	}



	public String getHost_comments_with_info() {
		return host_comments_with_info;
	}



	public void setHost_comments_with_info(String host_comments_with_info) {
		this.host_comments_with_info = host_comments_with_info;
	}



	public String getHost_contact_groups() {
		return host_contact_groups;
	}



	public void setHost_contact_groups(String host_contact_groups) {
		this.host_contact_groups = host_contact_groups;
	}



	public String getHost_contacts() {
		return host_contacts;
	}



	public void setHost_contacts(String host_contacts) {
		this.host_contacts = host_contacts;
	}



	public int getHost_current_attempt() {
		return host_current_attempt;
	}



	public void setHost_current_attempt(int host_current_attempt) {
		this.host_current_attempt = host_current_attempt;
	}



	public int getHost_current_notification_number() {
		return host_current_notification_number;
	}



	public void setHost_current_notification_number(int host_current_notification_number) {
		this.host_current_notification_number = host_current_notification_number;
	}



	public String getHost_custom_variable_names() {
		return host_custom_variable_names;
	}



	public void setHost_custom_variable_names(String host_custom_variable_names) {
		this.host_custom_variable_names = host_custom_variable_names;
	}



	public String getHost_custom_variable_values() {
		return host_custom_variable_values;
	}



	public void setHost_custom_variable_values(String host_custom_variable_values) {
		this.host_custom_variable_values = host_custom_variable_values;
	}



	public String getHost_custom_variables() {
		return host_custom_variables;
	}



	public void setHost_custom_variables(String host_custom_variables) {
		this.host_custom_variables = host_custom_variables;
	}



	public String getHost_display_name() {
		return host_display_name;
	}



	public void setHost_display_name(String host_display_name) {
		this.host_display_name = host_display_name;
	}



	public String getHost_downtimes() {
		return host_downtimes;
	}



	public void setHost_downtimes(String host_downtimes) {
		this.host_downtimes = host_downtimes;
	}



	public String getHost_downtimes_with_info() {
		return host_downtimes_with_info;
	}



	public void setHost_downtimes_with_info(String host_downtimes_with_info) {
		this.host_downtimes_with_info = host_downtimes_with_info;
	}



	public String getHost_event_handler() {
		return host_event_handler;
	}



	public void setHost_event_handler(String host_event_handler) {
		this.host_event_handler = host_event_handler;
	}



	public int getHost_event_handler_enabled() {
		return host_event_handler_enabled;
	}



	public void setHost_event_handler_enabled(int host_event_handler_enabled) {
		this.host_event_handler_enabled = host_event_handler_enabled;
	}



	public Float getHost_execution_time() {
		return host_execution_time;
	}



	public void setHost_execution_time(Float host_execution_time) {
		this.host_execution_time = host_execution_time;
	}



	public String getHost_filename() {
		return host_filename;
	}



	public void setHost_filename(String host_filename) {
		this.host_filename = host_filename;
	}



	public Float getHost_first_notification_delay() {
		return host_first_notification_delay;
	}



	public void setHost_first_notification_delay(Float host_first_notification_delay) {
		this.host_first_notification_delay = host_first_notification_delay;
	}



	public int getHost_flap_detection_enabled() {
		return host_flap_detection_enabled;
	}



	public void setHost_flap_detection_enabled(int host_flap_detection_enabled) {
		this.host_flap_detection_enabled = host_flap_detection_enabled;
	}



	public String getHost_groups() {
		return host_groups;
	}



	public void setHost_groups(String host_groups) {
		this.host_groups = host_groups;
	}



	public int getHost_hard_state() {
		return host_hard_state;
	}



	public void setHost_hard_state(int host_hard_state) {
		this.host_hard_state = host_hard_state;
	}



	public int getHost_has_been_checked() {
		return host_has_been_checked;
	}



	public void setHost_has_been_checked(int host_has_been_checked) {
		this.host_has_been_checked = host_has_been_checked;
	}



	public Float getHost_high_flap_threshold() {
		return host_high_flap_threshold;
	}



	public void setHost_high_flap_threshold(Float host_high_flap_threshold) {
		this.host_high_flap_threshold = host_high_flap_threshold;
	}



	public String getHost_icon_image() {
		return host_icon_image;
	}



	public void setHost_icon_image(String host_icon_image) {
		this.host_icon_image = host_icon_image;
	}



	public String getHost_icon_image_alt() {
		return host_icon_image_alt;
	}



	public void setHost_icon_image_alt(String host_icon_image_alt) {
		this.host_icon_image_alt = host_icon_image_alt;
	}



	public String getHost_icon_image_expanded() {
		return host_icon_image_expanded;
	}



	public void setHost_icon_image_expanded(String host_icon_image_expanded) {
		this.host_icon_image_expanded = host_icon_image_expanded;
	}



	public int getHost_in_check_period() {
		return host_in_check_period;
	}



	public void setHost_in_check_period(int host_in_check_period) {
		this.host_in_check_period = host_in_check_period;
	}



	public int getHost_in_notification_period() {
		return host_in_notification_period;
	}



	public void setHost_in_notification_period(int host_in_notification_period) {
		this.host_in_notification_period = host_in_notification_period;
	}



	public int getHost_in_service_period() {
		return host_in_service_period;
	}



	public void setHost_in_service_period(int host_in_service_period) {
		this.host_in_service_period = host_in_service_period;
	}



	public int getHost_initial_state() {
		return host_initial_state;
	}



	public void setHost_initial_state(int host_initial_state) {
		this.host_initial_state = host_initial_state;
	}



	public int getHost_is_executing() {
		return host_is_executing;
	}



	public void setHost_is_executing(int host_is_executing) {
		this.host_is_executing = host_is_executing;
	}



	public int getHost_is_flapping() {
		return host_is_flapping;
	}



	public void setHost_is_flapping(int host_is_flapping) {
		this.host_is_flapping = host_is_flapping;
	}



	public Timestamp getHost_last_check() {
		return host_last_check;
	}



	public void setHost_last_check(Timestamp host_last_check) {
		this.host_last_check = host_last_check;
	}



	public int getHost_last_hard_state() {
		return host_last_hard_state;
	}



	public void setHost_last_hard_state(int host_last_hard_state) {
		this.host_last_hard_state = host_last_hard_state;
	}



	public Timestamp getHost_last_hard_state_change() {
		return host_last_hard_state_change;
	}



	public void setHost_last_hard_state_change(Timestamp host_last_hard_state_change) {
		this.host_last_hard_state_change = host_last_hard_state_change;
	}



	public Timestamp getHost_last_notification() {
		return host_last_notification;
	}



	public void setHost_last_notification(Timestamp host_last_notification) {
		this.host_last_notification = host_last_notification;
	}



	public int getHost_last_state() {
		return host_last_state;
	}



	public void setHost_last_state(int host_last_state) {
		this.host_last_state = host_last_state;
	}



	public Timestamp getHost_last_state_change() {
		return host_last_state_change;
	}



	public void setHost_last_state_change(Timestamp host_last_state_change) {
		this.host_last_state_change = host_last_state_change;
	}



	public Timestamp getHost_last_time_down() {
		return host_last_time_down;
	}



	public void setHost_last_time_down(Timestamp host_last_time_down) {
		this.host_last_time_down = host_last_time_down;
	}



	public Timestamp getHost_last_time_unreachable() {
		return host_last_time_unreachable;
	}



	public void setHost_last_time_unreachable(Timestamp host_last_time_unreachable) {
		this.host_last_time_unreachable = host_last_time_unreachable;
	}



	public Timestamp getHost_last_time_up() {
		return host_last_time_up;
	}



	public void setHost_last_time_up(Timestamp host_last_time_up) {
		this.host_last_time_up = host_last_time_up;
	}



	public Float getHost_latency() {
		return host_latency;
	}



	public void setHost_latency(Float host_latency) {
		this.host_latency = host_latency;
	}



	public String getHost_long_plugin_output() {
		return host_long_plugin_output;
	}



	public void setHost_long_plugin_output(String host_long_plugin_output) {
		this.host_long_plugin_output = host_long_plugin_output;
	}



	public Float getHost_low_flap_threshold() {
		return host_low_flap_threshold;
	}



	public void setHost_low_flap_threshold(Float host_low_flap_threshold) {
		this.host_low_flap_threshold = host_low_flap_threshold;
	}



	public int getHost_max_check_attempts() {
		return host_max_check_attempts;
	}



	public void setHost_max_check_attempts(int host_max_check_attempts) {
		this.host_max_check_attempts = host_max_check_attempts;
	}



	public int getHost_modified_attributes() {
		return host_modified_attributes;
	}



	public void setHost_modified_attributes(int host_modified_attributes) {
		this.host_modified_attributes = host_modified_attributes;
	}



	public String getHost_modified_attributes_list() {
		return host_modified_attributes_list;
	}



	public void setHost_modified_attributes_list(String host_modified_attributes_list) {
		this.host_modified_attributes_list = host_modified_attributes_list;
	}



	public String getHost_name() {
		return host_name;
	}



	public void setHost_name(String host_name) {
		this.host_name = host_name;
	}



	public Timestamp getHost_next_check() {
		return host_next_check;
	}



	public void setHost_next_check(Timestamp host_next_check) {
		this.host_next_check = host_next_check;
	}



	public Timestamp getHost_next_notification() {
		return host_next_notification;
	}



	public void setHost_next_notification(Timestamp host_next_notification) {
		this.host_next_notification = host_next_notification;
	}



	public int getHost_no_more_notifications() {
		return host_no_more_notifications;
	}



	public void setHost_no_more_notifications(int host_no_more_notifications) {
		this.host_no_more_notifications = host_no_more_notifications;
	}



	public String getHost_notes() {
		return host_notes;
	}



	public void setHost_notes(String host_notes) {
		this.host_notes = host_notes;
	}



	public String getHost_notes_expanded() {
		return host_notes_expanded;
	}



	public void setHost_notes_expanded(String host_notes_expanded) {
		this.host_notes_expanded = host_notes_expanded;
	}



	public String getHost_notes_url() {
		return host_notes_url;
	}



	public void setHost_notes_url(String host_notes_url) {
		this.host_notes_url = host_notes_url;
	}



	public String getHost_notes_url_expanded() {
		return host_notes_url_expanded;
	}



	public void setHost_notes_url_expanded(String host_notes_url_expanded) {
		this.host_notes_url_expanded = host_notes_url_expanded;
	}



	public Float getHost_notification_interval() {
		return host_notification_interval;
	}



	public void setHost_notification_interval(Float host_notification_interval) {
		this.host_notification_interval = host_notification_interval;
	}



	public String getHost_notification_period() {
		return host_notification_period;
	}



	public void setHost_notification_period(String host_notification_period) {
		this.host_notification_period = host_notification_period;
	}



	public int getHost_notifications_enabled() {
		return host_notifications_enabled;
	}



	public void setHost_notifications_enabled(int host_notifications_enabled) {
		this.host_notifications_enabled = host_notifications_enabled;
	}



	public int getHost_num_services() {
		return host_num_services;
	}



	public void setHost_num_services(int host_num_services) {
		this.host_num_services = host_num_services;
	}



	public int getHost_num_services_crit() {
		return host_num_services_crit;
	}



	public void setHost_num_services_crit(int host_num_services_crit) {
		this.host_num_services_crit = host_num_services_crit;
	}



	public int getHost_num_services_hard_crit() {
		return host_num_services_hard_crit;
	}



	public void setHost_num_services_hard_crit(int host_num_services_hard_crit) {
		this.host_num_services_hard_crit = host_num_services_hard_crit;
	}



	public int getHost_num_services_hard_ok() {
		return host_num_services_hard_ok;
	}



	public void setHost_num_services_hard_ok(int host_num_services_hard_ok) {
		this.host_num_services_hard_ok = host_num_services_hard_ok;
	}



	public int getHost_num_services_hard_unknown() {
		return host_num_services_hard_unknown;
	}



	public void setHost_num_services_hard_unknown(int host_num_services_hard_unknown) {
		this.host_num_services_hard_unknown = host_num_services_hard_unknown;
	}



	public int getHost_num_services_hard_warn() {
		return host_num_services_hard_warn;
	}



	public void setHost_num_services_hard_warn(int host_num_services_hard_warn) {
		this.host_num_services_hard_warn = host_num_services_hard_warn;
	}



	public int getHost_num_services_ok() {
		return host_num_services_ok;
	}



	public void setHost_num_services_ok(int host_num_services_ok) {
		this.host_num_services_ok = host_num_services_ok;
	}



	public int getHost_num_services_pending() {
		return host_num_services_pending;
	}



	public void setHost_num_services_pending(int host_num_services_pending) {
		this.host_num_services_pending = host_num_services_pending;
	}



	public int getHost_num_services_unknown() {
		return host_num_services_unknown;
	}



	public void setHost_num_services_unknown(int host_num_services_unknown) {
		this.host_num_services_unknown = host_num_services_unknown;
	}



	public int getHost_num_services_warn() {
		return host_num_services_warn;
	}



	public void setHost_num_services_warn(int host_num_services_warn) {
		this.host_num_services_warn = host_num_services_warn;
	}



	public int getHost_obsess_over_host() {
		return host_obsess_over_host;
	}



	public void setHost_obsess_over_host(int host_obsess_over_host) {
		this.host_obsess_over_host = host_obsess_over_host;
	}



	public String getHost_parents() {
		return host_parents;
	}



	public void setHost_parents(String host_parents) {
		this.host_parents = host_parents;
	}



	public int getHost_pending_flex_downtime() {
		return host_pending_flex_downtime;
	}



	public void setHost_pending_flex_downtime(int host_pending_flex_downtime) {
		this.host_pending_flex_downtime = host_pending_flex_downtime;
	}



	public Float getHost_percent_state_change() {
		return host_percent_state_change;
	}



	public void setHost_percent_state_change(Float host_percent_state_change) {
		this.host_percent_state_change = host_percent_state_change;
	}



	public String getHost_perf_data() {
		return host_perf_data;
	}



	public void setHost_perf_data(String host_perf_data) {
		this.host_perf_data = host_perf_data;
	}



	public String getHost_plugin_output() {
		return host_plugin_output;
	}



	public void setHost_plugin_output(String host_plugin_output) {
		this.host_plugin_output = host_plugin_output;
	}



	public int getHost_pnpgraph_present() {
		return host_pnpgraph_present;
	}



	public void setHost_pnpgraph_present(int host_pnpgraph_present) {
		this.host_pnpgraph_present = host_pnpgraph_present;
	}



	public int getHost_process_performance_data() {
		return host_process_performance_data;
	}



	public void setHost_process_performance_data(int host_process_performance_data) {
		this.host_process_performance_data = host_process_performance_data;
	}



	public Float getHost_retry_interval() {
		return host_retry_interval;
	}



	public void setHost_retry_interval(Float host_retry_interval) {
		this.host_retry_interval = host_retry_interval;
	}



	public int getHost_scheduled_downtime_depth() {
		return host_scheduled_downtime_depth;
	}



	public void setHost_scheduled_downtime_depth(int host_scheduled_downtime_depth) {
		this.host_scheduled_downtime_depth = host_scheduled_downtime_depth;
	}



	public String getHost_service_period() {
		return host_service_period;
	}



	public void setHost_service_period(String host_service_period) {
		this.host_service_period = host_service_period;
	}



	public String getHost_services() {
		return host_services;
	}



	public void setHost_services(String host_services) {
		this.host_services = host_services;
	}



	public String getHost_services_with_info() {
		return host_services_with_info;
	}



	public void setHost_services_with_info(String host_services_with_info) {
		this.host_services_with_info = host_services_with_info;
	}



	public String getHost_services_with_state() {
		return host_services_with_state;
	}



	public void setHost_services_with_state(String host_services_with_state) {
		this.host_services_with_state = host_services_with_state;
	}



	public Float getHost_staleness() {
		return host_staleness;
	}



	public void setHost_staleness(Float host_staleness) {
		this.host_staleness = host_staleness;
	}



	public int getHost_state() {
		return host_state;
	}



	public void setHost_state(int host_state) {
		this.host_state = host_state;
	}



	public int getHost_state_type() {
		return host_state_type;
	}



	public void setHost_state_type(int host_state_type) {
		this.host_state_type = host_state_type;
	}



	public String getHost_statusmap_image() {
		return host_statusmap_image;
	}



	public void setHost_statusmap_image(String host_statusmap_image) {
		this.host_statusmap_image = host_statusmap_image;
	}



	public int getHost_total_services() {
		return host_total_services;
	}



	public void setHost_total_services(int host_total_services) {
		this.host_total_services = host_total_services;
	}



	public int getHost_worst_service_hard_state() {
		return host_worst_service_hard_state;
	}



	public void setHost_worst_service_hard_state(int host_worst_service_hard_state) {
		this.host_worst_service_hard_state = host_worst_service_hard_state;
	}



	public int getHost_worst_service_state() {
		return host_worst_service_state;
	}



	public void setHost_worst_service_state(int host_worst_service_state) {
		this.host_worst_service_state = host_worst_service_state;
	}



	public Float getHost_x_3d() {
		return host_x_3d;
	}



	public void setHost_x_3d(Float host_x_3d) {
		this.host_x_3d = host_x_3d;
	}



	public Float getHost_y_3d() {
		return host_y_3d;
	}



	public void setHost_y_3d(Float host_y_3d) {
		this.host_y_3d = host_y_3d;
	}



	public Float getHost_z_3d() {
		return host_z_3d;
	}



	public void setHost_z_3d(Float host_z_3d) {
		this.host_z_3d = host_z_3d;
	}



	public String getIcon_image() {
		return icon_image;
	}



	public void setIcon_image(String icon_image) {
		this.icon_image = icon_image;
	}



	public String getIcon_image_alt() {
		return icon_image_alt;
	}



	public void setIcon_image_alt(String icon_image_alt) {
		this.icon_image_alt = icon_image_alt;
	}



	public String getIcon_image_expanded() {
		return icon_image_expanded;
	}



	public void setIcon_image_expanded(String icon_image_expanded) {
		this.icon_image_expanded = icon_image_expanded;
	}



	public int getIn_check_period() {
		return in_check_period;
	}



	public void setIn_check_period(int in_check_period) {
		this.in_check_period = in_check_period;
	}



	public int getIn_notification_period() {
		return in_notification_period;
	}



	public void setIn_notification_period(int in_notification_period) {
		this.in_notification_period = in_notification_period;
	}



	public int getIn_service_period() {
		return in_service_period;
	}



	public void setIn_service_period(int in_service_period) {
		this.in_service_period = in_service_period;
	}



	public int getInitial_state() {
		return initial_state;
	}



	public void setInitial_state(int initial_state) {
		this.initial_state = initial_state;
	}



	public int getIs_executing() {
		return is_executing;
	}



	public void setIs_executing(int is_executing) {
		this.is_executing = is_executing;
	}



	public int getIs_flapping() {
		return is_flapping;
	}



	public void setIs_flapping(int is_flapping) {
		this.is_flapping = is_flapping;
	}



	public Timestamp getLast_check() {
		return last_check;
	}



	public void setLast_check(Timestamp last_check) {
		this.last_check = last_check;
	}



	public int getLast_hard_state() {
		return last_hard_state;
	}



	public void setLast_hard_state(int last_hard_state) {
		this.last_hard_state = last_hard_state;
	}



	public Timestamp getLast_hard_state_change() {
		return last_hard_state_change;
	}



	public void setLast_hard_state_change(Timestamp last_hard_state_change) {
		this.last_hard_state_change = last_hard_state_change;
	}



	public Timestamp getLast_notification() {
		return last_notification;
	}



	public void setLast_notification(Timestamp last_notification) {
		this.last_notification = last_notification;
	}



	public int getLast_state() {
		return last_state;
	}



	public void setLast_state(int last_state) {
		this.last_state = last_state;
	}



	public Timestamp getLast_state_change() {
		return last_state_change;
	}



	public void setLast_state_change(Timestamp last_state_change) {
		this.last_state_change = last_state_change;
	}



	public Timestamp getLast_time_critical() {
		return last_time_critical;
	}



	public void setLast_time_critical(Timestamp last_time_critical) {
		this.last_time_critical = last_time_critical;
	}



	public Timestamp getLast_time_ok() {
		return last_time_ok;
	}



	public void setLast_time_ok(Timestamp last_time_ok) {
		this.last_time_ok = last_time_ok;
	}



	public Timestamp getLast_time_unknown() {
		return last_time_unknown;
	}



	public void setLast_time_unknown(Timestamp last_time_unknown) {
		this.last_time_unknown = last_time_unknown;
	}



	public Timestamp getLast_time_warning() {
		return last_time_warning;
	}



	public void setLast_time_warning(Timestamp last_time_warning) {
		this.last_time_warning = last_time_warning;
	}



	public Float getLatency() {
		return latency;
	}



	public void setLatency(Float latency) {
		this.latency = latency;
	}



	public String getLong_plugin_output() {
		return long_plugin_output;
	}



	public void setLong_plugin_output(String long_plugin_output) {
		this.long_plugin_output = long_plugin_output;
	}



	public Float getLow_flap_threshold() {
		return low_flap_threshold;
	}



	public void setLow_flap_threshold(Float low_flap_threshold) {
		this.low_flap_threshold = low_flap_threshold;
	}



	public int getMax_check_attempts() {
		return max_check_attempts;
	}



	public void setMax_check_attempts(int max_check_attempts) {
		this.max_check_attempts = max_check_attempts;
	}



	public int getModified_attributes() {
		return modified_attributes;
	}



	public void setModified_attributes(int modified_attributes) {
		this.modified_attributes = modified_attributes;
	}



	public String getModified_attributes_list() {
		return modified_attributes_list;
	}



	public void setModified_attributes_list(String modified_attributes_list) {
		this.modified_attributes_list = modified_attributes_list;
	}



	public Timestamp getNext_check() {
		return next_check;
	}



	public void setNext_check(Timestamp next_check) {
		this.next_check = next_check;
	}



	public Timestamp getNext_notification() {
		return next_notification;
	}



	public void setNext_notification(Timestamp next_notification) {
		this.next_notification = next_notification;
	}



	public int getNo_more_notifications() {
		return no_more_notifications;
	}



	public void setNo_more_notifications(int no_more_notifications) {
		this.no_more_notifications = no_more_notifications;
	}



	public String getNotes() {
		return notes;
	}



	public void setNotes(String notes) {
		this.notes = notes;
	}



	public String getNotes_expanded() {
		return notes_expanded;
	}



	public void setNotes_expanded(String notes_expanded) {
		this.notes_expanded = notes_expanded;
	}



	public String getNotes_url() {
		return notes_url;
	}



	public void setNotes_url(String notes_url) {
		this.notes_url = notes_url;
	}



	public String getNotes_url_expanded() {
		return notes_url_expanded;
	}



	public void setNotes_url_expanded(String notes_url_expanded) {
		this.notes_url_expanded = notes_url_expanded;
	}



	public Float getNotification_interval() {
		return notification_interval;
	}



	public void setNotification_interval(Float notification_interval) {
		this.notification_interval = notification_interval;
	}



	public String getNotification_period() {
		return notification_period;
	}



	public void setNotification_period(String notification_period) {
		this.notification_period = notification_period;
	}



	public int getNotifications_enabled() {
		return notifications_enabled;
	}



	public void setNotifications_enabled(int notifications_enabled) {
		this.notifications_enabled = notifications_enabled;
	}



	public int getObsess_over_service() {
		return obsess_over_service;
	}



	public void setObsess_over_service(int obsess_over_service) {
		this.obsess_over_service = obsess_over_service;
	}



	public Float getPercent_state_change() {
		return percent_state_change;
	}



	public void setPercent_state_change(Float percent_state_change) {
		this.percent_state_change = percent_state_change;
	}



	public String getPerf_data() {
		return perf_data;
	}



	public void setPerf_data(String perf_data) {
		this.perf_data = perf_data;
	}



	public String getPlugin_output() {
		return plugin_output;
	}



	public void setPlugin_output(String plugin_output) {
		this.plugin_output = plugin_output;
	}



	public int getPnpgraph_present() {
		return pnpgraph_present;
	}



	public void setPnpgraph_present(int pnpgraph_present) {
		this.pnpgraph_present = pnpgraph_present;
	}



	public int getProcess_performance_data() {
		return process_performance_data;
	}



	public void setProcess_performance_data(int process_performance_data) {
		this.process_performance_data = process_performance_data;
	}



	public Float getRetry_interval() {
		return retry_interval;
	}



	public void setRetry_interval(Float retry_interval) {
		this.retry_interval = retry_interval;
	}



	public int getScheduled_downtime_depth() {
		return scheduled_downtime_depth;
	}



	public void setScheduled_downtime_depth(int scheduled_downtime_depth) {
		this.scheduled_downtime_depth = scheduled_downtime_depth;
	}



	public String getService_period() {
		return service_period;
	}



	public void setService_period(String service_period) {
		this.service_period = service_period;
	}



	public Float getStaleness() {
		return staleness;
	}



	public void setStaleness(Float staleness) {
		this.staleness = staleness;
	}



	public int getState() {
		return state;
	}



	public void setState(int state) {
		this.state = state;
	}



	public int getState_type() {
		return state_type;
	}



	public void setState_type(int state_type) {
		this.state_type = state_type;
	}



	@Override
	public String toString() {
		return "Services [perf_data=" + perf_data + ", plugin_output=" + plugin_output + "]";
	}
	

	
	
	
}