/**
 *
 * ************************************************************************************************************
 *
 * Dependentes: BI Citsmart
 *
 * Obs:
 * Qualquer alterao nesta tabela dever ser informada aos responsveis pelo desenvolvimento do BI Citsmart.
 * O database do BI Citsmart precisa ter suas tabelas atualizadas de acordo com as mudanas nesta tabela.
 *
 * ************************************************************************************************************
 *
 */

package br.com.centralit.citcorpore.bean;

import java.sql.Date;
import java.sql.Timestamp;

import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.citframework.dto.IDto;

public class ServicoDTO implements IDto {
	private static final long serialVersionUID = 1L;

	private String conteudodados;
	private Date dataFim;
	private Date dataInicio;
	private String deleted;
	private String descricaoProcesso;
	private String detalheServico;
	private String dispPortal;
	private Integer idBaseconhecimento;
	private Integer idCategoriaServico;
	private Integer idEmpresa;
	private Integer idImportanciaNegocio;
	private Integer idLocalExecucaoServico;
	private Integer idServico;
	private Integer idContrato;
	private Integer idSituacaoServico;
	private Integer idTemplateAcompanhamento;
	private Integer idTemplateSolicitacao;
	private Integer idTipoDemandaServico;
	private Integer idTipoEventoServico;
	private Integer idTipoServico;
	private String linkProcesso;
	private Timestamp modificadoEm;
	private String modificadoPor;
	private String nomeCategoriaServico;
	private String nomeServico;
	private String nomeTipoServico;
	private String objetivo;
	private String passosServico;
	private String quadroOrientPortal;
	private String siglaAbrev;
	private String tipoDescProcess;
	private Integer idSolicitacao;
	private String complexidade;
	private String nomeTipoDemandaServico;
	private String custoAtividade;
	private String slaAtendido;
	private String nomeSolucionador;
	private String tempoDecorrido;
	private Integer idStatus;
	private String descrSituacao;
	private Integer tempoAtendimentoHH;
	private Integer tempoAtendimentoMM;
	private Double valorServico;
	private Double valorTotalServico;
	private Integer topList;
	private String tipoServico;
	private Integer idPortfolioServico;
	private Boolean baseReports;
	private String faseServico;
	private String statusServico;
	private String processoDeIniciacao;
	private String tipoDeInvestimento;
	private String valoresDoServico;
	private Integer idTemplateServico;
	private String informacoesComplementares_serialize;
	private IDto informacoesComplementares;
	private ServicoQuestionarioDTO servicoQuestionarioDTO;
	private Integer criticidadeServico;
	private Integer demandaServico;
	private Integer retornoFinanceiroServico;
	private String incidenteCritico;

	private Integer idServicoRelacionado;
	private String nomeServicoRelacionado;
	private String tipoServicoRelacionado;

	private String nomePortal;
	private String descricaoPortal;
	private String imagemPortal;

	public String getConteudodados() {
		return conteudodados;
	}

	public void setConteudodados(String conteudodados) {
		this.conteudodados = conteudodados;
	}

	public Date getDataFim() {
		return dataFim;
	}

	public void setDataFim(Date dataFim) {
		this.dataFim = dataFim;
	}

	public Date getDataInicio() {
		return dataInicio;
	}

	public void setDataInicio(Date dataInicio) {
		this.dataInicio = dataInicio;
	}

	public String getDeleted() {
		return deleted;
	}

	public void setDeleted(String deleted) {
		this.deleted = deleted;
	}

	public String getDescricaoProcesso() {
		return descricaoProcesso;
	}

	public void setDescricaoProcesso(String descricaoProcesso) {
		this.descricaoProcesso = descricaoProcesso;
	}

	public String getDetalheServico() {
		return detalheServico;
	}

	public void setDetalheServico(String detalheServico) {
		this.detalheServico = detalheServico;
	}

	public String getDispPortal() {
		return dispPortal;
	}

	public void setDispPortal(String dispPortal) {
		this.dispPortal = dispPortal;
	}

	public Integer getIdBaseconhecimento() {
		return idBaseconhecimento;
	}

	public void setIdBaseconhecimento(Integer idBaseconhecimento) {
		this.idBaseconhecimento = idBaseconhecimento;
	}

	public Integer getIdCategoriaServico() {
		return idCategoriaServico;
	}

	public void setIdCategoriaServico(Integer idCategoriaServico) {
		this.idCategoriaServico = idCategoriaServico;
	}

	public Integer getIdEmpresa() {
		return idEmpresa;
	}

	public void setIdEmpresa(Integer idEmpresa) {
		this.idEmpresa = idEmpresa;
	}

	public Integer getIdImportanciaNegocio() {
		return idImportanciaNegocio;
	}

	public void setIdImportanciaNegocio(Integer idImportanciaNegocio) {
		this.idImportanciaNegocio = idImportanciaNegocio;
	}

	public Integer getIdLocalExecucaoServico() {
		return idLocalExecucaoServico;
	}

	public void setIdLocalExecucaoServico(Integer idLocalExecucaoServico) {
		this.idLocalExecucaoServico = idLocalExecucaoServico;
	}

	public Integer getIdServico() {
		return idServico;
	}

	public void setIdServico(Integer idServico) {
		this.idServico = idServico;
	}

	public Integer getIdContrato() {
		return idContrato;
	}

	public void setIdContrato(Integer idContrato) {
		this.idContrato = idContrato;
	}

	public Integer getIdSituacaoServico() {
		return idSituacaoServico;
	}

	public void setIdSituacaoServico(Integer idSituacaoServico) {
		this.idSituacaoServico = idSituacaoServico;
	}

	public Integer getIdTemplateAcompanhamento() {
		return idTemplateAcompanhamento;
	}

	public void setIdTemplateAcompanhamento(Integer idTemplateAcompanhamento) {
		this.idTemplateAcompanhamento = idTemplateAcompanhamento;
	}

	public Integer getIdTemplateSolicitacao() {
		return idTemplateSolicitacao;
	}

	public void setIdTemplateSolicitacao(Integer idTemplateSolicitacao) {
		this.idTemplateSolicitacao = idTemplateSolicitacao;
	}

	public Integer getIdTipoDemandaServico() {
		return idTipoDemandaServico;
	}

	public void setIdTipoDemandaServico(Integer idTipoDemandaServico) {
		this.idTipoDemandaServico = idTipoDemandaServico;
	}

	public Integer getIdTipoEventoServico() {
		return idTipoEventoServico;
	}

	public void setIdTipoEventoServico(Integer idTipoEventoServico) {
		this.idTipoEventoServico = idTipoEventoServico;
	}

	public Integer getIdTipoServico() {
		return idTipoServico;
	}

	public void setIdTipoServico(Integer idTipoServico) {
		this.idTipoServico = idTipoServico;
	}

	public String getLinkProcesso() {
		return linkProcesso;
	}

	public void setLinkProcesso(String linkProcesso) {
		this.linkProcesso = linkProcesso;
	}

	public Timestamp getModificadoEm() {
		return modificadoEm;
	}

	public void setModificadoEm(Timestamp modificadoEm) {
		this.modificadoEm = modificadoEm;
	}

	public String getModificadoPor() {
		return modificadoPor;
	}

	public void setModificadoPor(String modificadoPor) {
		this.modificadoPor = modificadoPor;
	}

	public String getNomeCategoriaServico() {
		return nomeCategoriaServico;
	}

	public void setNomeCategoriaServico(String nomeCategoriaServico) {
		this.nomeCategoriaServico = nomeCategoriaServico;
	}

	public String getNomeServico() {
		return nomeServico;
	}

	public void setNomeServico(String nomeServico) {
		this.nomeServico = nomeServico;
	}

	public String getNomeTipoServico() {
		return nomeTipoServico;
	}

	public void setNomeTipoServico(String nomeTipoServico) {
		this.nomeTipoServico = nomeTipoServico;
	}

	public String getObjetivo() {
		return objetivo;
	}

	public void setObjetivo(String objetivo) {
		this.objetivo = objetivo;
	}

	public String getPassosServico() {
		return passosServico;
	}

	public void setPassosServico(String passosServico) {
		this.passosServico = passosServico;
	}

	public String getQuadroOrientPortal() {
		return quadroOrientPortal;
	}

	public void setQuadroOrientPortal(String quadroOrientPortal) {
		this.quadroOrientPortal = quadroOrientPortal;
	}

	public String getSiglaAbrev() {
		return siglaAbrev;
	}

	public void setSiglaAbrev(String siglaAbrev) {
		this.siglaAbrev = siglaAbrev;
	}

	public String getTipoDescProcess() {
		return tipoDescProcess;
	}

	public void setTipoDescProcess(String tipoDescProcess) {
		this.tipoDescProcess = tipoDescProcess;
	}

	public Integer getIdSolicitacao() {
		return idSolicitacao;
	}

	public void setIdSolicitacao(Integer idSolicitacao) {
		this.idSolicitacao = idSolicitacao;
	}

	public String getComplexidade() {
		return complexidade;
	}

	public void setComplexidade(String complexidade) {
		this.complexidade = complexidade;
	}

	public String getNomeTipoDemandaServico() {
		return nomeTipoDemandaServico;
	}

	public void setNomeTipoDemandaServico(String nomeTipoDemandaServico) {
		this.nomeTipoDemandaServico = nomeTipoDemandaServico;
	}

	public String getCustoAtividade() {
		return custoAtividade;
	}

	public void setCustoAtividade(String custoAtividade) {
		this.custoAtividade = custoAtividade;
	}

	public String getSlaAtendido() {
		return slaAtendido;
	}

	public void setSlaAtendido(String slaAtendido) {
		this.slaAtendido = slaAtendido;
	}

	public String getNomeSolucionador() {
		return nomeSolucionador;
	}

	public void setNomeSolucionador(String nomeSolucionador) {
		this.nomeSolucionador = nomeSolucionador;
	}

	public String getTempoDecorrido() {
		return tempoDecorrido;
	}

	public void setTempoDecorrido(String tempoDecorrido) {
		this.tempoDecorrido = tempoDecorrido;
	}

	public Integer getIdStatus() {
		return idStatus;
	}

	public void setIdStatus(Integer idStatus) {
		try {
			if (idStatus != null) {
				this.descrSituacao = ServiceRequestStatus.fromId(idStatus).getI18NKey();
			}
		} catch (Exception e) {
		}
		this.idStatus = idStatus;
	}

	public String getDescrSituacao() {
		return descrSituacao;
	}

	public void setDescrSituacao(String descrSituacao) {
		this.descrSituacao = descrSituacao;
	}

	public Integer getTempoAtendimentoHH() {
		return tempoAtendimentoHH;
	}

	public void setTempoAtendimentoHH(Integer tempoAtendimentoHH) {
		this.tempoAtendimentoHH = tempoAtendimentoHH;
	}

	public Integer getTempoAtendimentoMM() {
		return tempoAtendimentoMM;
	}

	public void setTempoAtendimentoMM(Integer tempoAtendimentoMM) {
		this.tempoAtendimentoMM = tempoAtendimentoMM;
	}

	public Double getValorServico() {
		return valorServico;
	}

	public void setValorServico(Double valorServico) {
		this.valorServico = valorServico;
	}

	public Double getValorTotalServico() {
		return valorTotalServico;
	}

	public void setValorTotalServico(Double valorTotalServico) {
		this.valorTotalServico = valorTotalServico;
	}

	public Integer getTopList() {
		return topList;
	}

	public void setTopList(Integer topList) {
		this.topList = topList;
	}

	public String getTipoServico() {
		return tipoServico;
	}

	public void setTipoServico(String tipoServico) {
		this.tipoServico = tipoServico;
	}

	public Integer getIdPortfolioServico() {
		return idPortfolioServico;
	}

	public void setIdPortfolioServico(Integer idPortfolioServico) {
		this.idPortfolioServico = idPortfolioServico;
	}

	public Integer getCriticidadeServico() {
		return criticidadeServico;
	}

	public void setCriticidadeServico(Integer criticidadeServico) {
		this.criticidadeServico = criticidadeServico;
	}

	public Integer getDemandaServico() {
		return demandaServico;
	}

	public void setDemandaServico(Integer demandaServico) {
		this.demandaServico = demandaServico;
	}

	public Integer getRetornoFinanceiroServico() {
		return retornoFinanceiroServico;
	}

	public void setRetornoFinanceiroServico(Integer retornoFinanceiroServico) {
		this.retornoFinanceiroServico = retornoFinanceiroServico;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (idServico == null ? 0 : idServico.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		ServicoDTO other = (ServicoDTO) obj;
		if (idServico == null) {
			if (other.idServico != null) {
				return false;
			}
		} else if (!idServico.equals(other.idServico)) {
			return false;
		}
		return true;
	}

	public Boolean getBaseReports() {
		if (baseReports == null) {
			baseReports = Boolean.FALSE;
		}

		return baseReports;
	}

	public void setBaseReports(Boolean baseReports) {
		this.baseReports = baseReports;
	}

	public String getFaseServico() {
		return faseServico;
	}

	public void setFaseServico(String faseServico) {
		this.faseServico = faseServico;
	}

	public String getStatusServico() {
		return statusServico;
	}

	public void setStatusServico(String statusServico) {
		this.statusServico = statusServico;
	}

	public String getProcessoDeIniciacao() {
		return processoDeIniciacao;
	}

	public void setProcessoDeIniciacao(String processoDeIniciacao) {
		this.processoDeIniciacao = processoDeIniciacao;
	}

	public String getTipoDeInvestimento() {
		return tipoDeInvestimento;
	}

	public void setTipoDeInvestimento(String tipoDeInvestimento) {
		this.tipoDeInvestimento = tipoDeInvestimento;
	}

	public Integer getIdServicoRelacionado() {
		return idServicoRelacionado;
	}

	public void setIdServicoRelacionado(Integer idServicoRelacionado) {
		this.idServicoRelacionado = idServicoRelacionado;
	}

	public String getValoresDoServico() {
		return valoresDoServico;
	}

	public void setValoresDoServico(String valoresDoServico) {
		this.valoresDoServico = valoresDoServico;
	}

	public Integer getIdTemplateServico() {
		return idTemplateServico;
	}

	public void setIdTemplateServico(Integer idTemplateServico) {
		this.idTemplateServico = idTemplateServico;
	}

	public String getInformacoesComplementares_serialize() {
		return informacoesComplementares_serialize;
	}

	public void setInformacoesComplementares_serialize(String informacoesComplementares_serialize) {
		this.informacoesComplementares_serialize = informacoesComplementares_serialize;
	}

	public IDto getInformacoesComplementares() {
		return informacoesComplementares;
	}

	public void setInformacoesComplementares(IDto informacoesComplementares) {
		this.informacoesComplementares = informacoesComplementares;
	}

	public ServicoQuestionarioDTO getServicoQuestionarioDTO() {
		return servicoQuestionarioDTO;
	}

	public void setServicoQuestionarioDTO(ServicoQuestionarioDTO servicoQuestionarioDTO) {
		this.servicoQuestionarioDTO = servicoQuestionarioDTO;
	}

	public String getIncidenteCritico() {
		return incidenteCritico;
	}

	public void setIncidenteCritico(String incidenteCritico) {
		this.incidenteCritico = incidenteCritico;
	}

	public String getNomeServicoRelacionado() {
		return nomeServicoRelacionado;
	}

	public void setNomeServicoRelacionado(String nomeServicoRelacionado) {
		this.nomeServicoRelacionado = nomeServicoRelacionado;
	}

	public String getTipoServicoRelacionado() {
		return tipoServicoRelacionado;
	}

	public void setTipoServicoRelacionado(String tipoServicoRelacionado) {
		this.tipoServicoRelacionado = tipoServicoRelacionado;
	}

	public String getNomePortal() {
		return nomePortal;
	}

	public void setNomePortal(String nomePortal) {
		this.nomePortal = nomePortal;
	}

	public String getDescricaoPortal() {
		return descricaoPortal;
	}

	public void setDescricaoPortal(String descricaoPortal) {
		this.descricaoPortal = descricaoPortal;
	}

	public String getImagemPortal() {
		return imagemPortal;
	}

	public void setImagemPortal(String imagemPortal) {
		this.imagemPortal = imagemPortal;
	}

}
