package br.com.centralit.citcorpore.bpm.negocio;

import java.util.Map;

import br.com.centralit.citcorpore.bean.ChangeRequestDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.negocio.ProblemaServiceEjb;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaServiceEjb;
import br.com.citframework.util.Reflexao;

public class ChangeRequestExecution extends ExecucaoMudanca {

	@Override
	public void mapObjetoNegocio(Map<String, Object> map) throws Exception {
		final RequisicaoMudancaDTO requisicaoMudancaDto = (RequisicaoMudancaDTO) objetoNegocioDto;
		final RequisicaoMudancaDTO requisicaoMudancaAuxDto = new RequisicaoMudancaServiceEjb().restoreAll(requisicaoMudancaDto.getIdRequisicaoMudanca(), getTransacao());
		requisicaoMudancaDto.setIdGrupoAtual(requisicaoMudancaAuxDto.getIdGrupoAtual());
		requisicaoMudancaDto.setIdGrupoNivel1(requisicaoMudancaAuxDto.getIdGrupoNivel1());
		requisicaoMudancaDto.setNomeGrupoAtual(requisicaoMudancaAuxDto.getNomeGrupoAtual());

		ChangeRequestDTO changeRequestDto = new ChangeRequestDTO();
		Reflexao.copyPropertyValues(requisicaoMudancaDto, changeRequestDto);

		adicionaObjeto("changeRequest", changeRequestDto, map);
		if (usuarioDto != null) {
			adicionaObjeto("user", usuarioDto, map);
		} else if (requisicaoMudancaDto.getUsuarioDto() != null) {
			adicionaObjeto("user", requisicaoMudancaDto.getUsuarioDto(), map);
		}

		adicionaObjeto("flowExecution", this, map);
		adicionaObjeto("changeRequestService", new ProblemaServiceEjb(), map);
	}

	public void close() throws Exception {
		super.encerra();
	}

}
