package br.com.centralit.citcorpore.bpm.negocio;

import java.util.Map;

import br.com.centralit.citcorpore.bean.ProblemRequestDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.negocio.ProblemaServiceEjb;
import br.com.citframework.util.Reflexao;

public class ProblemRequestExecution extends ExecucaoProblema {

	@Override
	public void mapObjetoNegocio(Map<String, Object> map) throws Exception {
		final ProblemaDTO problemaDto = (ProblemaDTO) objetoNegocioDto;
		final ProblemaDTO problemaAuxDto = new ProblemaServiceEjb().restoreAll(problemaDto.getIdProblema(), getTransacao());
		problemaDto.setIdGrupoAtual(problemaAuxDto.getIdGrupoAtual());
		problemaDto.setIdGrupoNivel1(problemaAuxDto.getIdGrupoNivel1());
		problemaDto.setNomeGrupoAtual(problemaAuxDto.getNomeGrupoAtual());

		ProblemRequestDTO problemRequestDto = new ProblemRequestDTO();
		Reflexao.copyPropertyValues(problemaDto, problemRequestDto);

		adicionaObjeto("problemRequest", problemRequestDto, map);
		if (usuarioDto != null) {
			adicionaObjeto("user", usuarioDto, map);
		} else if (problemaDto.getUsuarioDto() != null) {
			adicionaObjeto("user", problemaDto.getUsuarioDto(), map);
		}

		adicionaObjeto("flowExecution", this, map);
		adicionaObjeto("problemService", new ProblemaServiceEjb(), map);
	}


	public String recoverApproverGroup() throws Exception {
		return super.recuperaGrupoAprovador();
	}

	public void close() throws Exception {
		super.encerra();
	}

}
