package br.com.centralit.citcorpore.bpm.negocio;

import java.util.Map;

import br.com.centralit.citcorpore.bean.ReleaseRequestDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoServiceEjb;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.util.Reflexao;

public class ReleaseRequestExecution extends ExecucaoLiberacao {

	@Override
	public void mapObjetoNegocio(Map<String, Object> map) throws Exception {
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) objetoNegocioDto;
		RequisicaoLiberacaoDTO requisicaoAuxDto = new RequisicaoLiberacaoServiceEjb().restoreAll(requisicaoLiberacaoDto.getIdRequisicaoLiberacao(), getTransacao());
		requisicaoLiberacaoDto.setIdGrupoAtual(requisicaoAuxDto.getIdGrupoAtual());
		requisicaoLiberacaoDto.setIdGrupoNivel1(requisicaoAuxDto.getIdGrupoNivel1());
		requisicaoLiberacaoDto.setNomeGrupoAtual(requisicaoAuxDto.getNomeGrupoAtual());
		requisicaoLiberacaoDto.setNomeGrupoNivel1(requisicaoAuxDto.getNomeGrupoNivel1());
		UsuarioDTO usuario = usuarioSolicitante(requisicaoAuxDto);
		if (usuario != null) {
			requisicaoLiberacaoDto.setUsuarioSolicitante(usuario.getLogin());
		}

		ReleaseRequestDTO releaseRequestDto = new ReleaseRequestDTO();
		Reflexao.copyPropertyValues(requisicaoLiberacaoDto, releaseRequestDto);

		adicionaObjeto("releaseRequest", releaseRequestDto, map);
		if (usuarioDto != null) {
			adicionaObjeto("user", usuarioDto, map);
		} else if (requisicaoLiberacaoDto.getUsuarioDto() != null) {
			adicionaObjeto("user", requisicaoLiberacaoDto.getUsuarioDto(), map);
		}

		adicionaObjeto("flowExecution", this, map);
		adicionaObjeto("releaseRequestService", new RequisicaoLiberacaoServiceEjb(), map);
	}

	public void endIC(RequisicaoLiberacaoDTO liberacao) throws ServiceException, Exception {
		super.finalizaIC(liberacao);
	}


}