package br.com.centralit.citcorpore.bpm.negocio;

import java.util.Map;

import br.com.centralit.citcorpore.bean.ServiceRequestDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoServiceEjb;
import br.com.citframework.util.Reflexao;

public class ServiceRequestExecution extends ExecucaoSolicitacao {

	@Override
	public void mapObjetoNegocio(Map<String, Object> map) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoDTO = (SolicitacaoServicoDTO) objetoNegocioDto;
		SolicitacaoServicoDTO solicitacaoServicoAuxDTO = new SolicitacaoServicoServiceEjb().restoreAll(solicitacaoServicoDTO.getIdSolicitacaoServico(), getTransacao());
		if (solicitacaoServicoAuxDTO != null) {
			solicitacaoServicoDTO.setGrupoAtual(solicitacaoServicoAuxDTO.getGrupoAtual());
			solicitacaoServicoDTO.setGrupoNivel1(solicitacaoServicoAuxDTO.getGrupoNivel1());
		}

		ServiceRequestDTO serviceRequestDTO = new ServiceRequestDTO();

		Reflexao.copyPropertyValues(solicitacaoServicoDTO, serviceRequestDTO);

		adicionaObjeto("serviceRequest", serviceRequestDTO, map);
		if (usuarioDTO != null) {
			adicionaObjeto("user", usuarioDTO, map);
		} else if (solicitacaoServicoDTO.getUsuarioDto() != null) {
			adicionaObjeto("user", solicitacaoServicoDTO.getUsuarioDto(), map);
		}

		adicionaObjeto("flowExecution", this, map);
		adicionaObjeto("serviceRequestService", new SolicitacaoServicoServiceEjb(), map);
	}

	public String recoverApproverGroup() throws Exception {
		return super.recuperaGrupoAprovador();
	}

}
