package br.com.centralit.citcorpore.comm.server;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.TipoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ValorDTO;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citsmart.rest.schema.HostItem;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;

/**
 * Esta classe recebe um conjunto de objetos do tipo HostItem (Set<HostItem>) e processa a propriedade HostItem.getProperties() de cada objeto inventariado,
 * que nada mais  do que um map (HashMap). Anteriormente, a funo desta classe era processar um arquivo XML. Da maneira atual no  mais necessrio
 * ficar fazendo "parse" ou anlise dos dados antes de persistir na base do Citsmart.
 * @since 20/02/2015
 * @author cristian.guedes
 * 
 */
public class ProcessarHashmapInventarioAgente {

	private static final String VALUE = "HARDWARE";

	Set<HostItem> objetosInventario = null;
	private List<ItemConfiguracaoDTO> listElementos = new ArrayList<ItemConfiguracaoDTO>();

	public ProcessarHashmapInventarioAgente() {
	}

	/**
	 * @return ItemConfiguracaoDTO
	 * @throws Exception
	 * @throws ServiceException
	 */
	private ItemConfiguracaoDTO gravaDados() throws ServiceException, Exception, LogicException {
		ItemConfiguracaoDTO beanItem = new ItemConfiguracaoDTO();
		List<TipoItemConfiguracaoDTO> lstTipoItemConfi = new ArrayList<TipoItemConfiguracaoDTO>();

		String atributo = "";
		String noPesquisa = "";

		noPesquisa = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.NoPesquisa, null);

		if (!VALUE.equalsIgnoreCase((noPesquisa == null ? "" : noPesquisa.trim())))
			noPesquisa = "HARDWARE";

		atributo = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.Atributo, null);

		if (atributo == null || atributo.trim().equalsIgnoreCase("")) {
			atributo = "NAME";
		}

		atributo = atributo.trim();
		noPesquisa = noPesquisa.trim();

		try {

			HostItem objetoInventarioHardware = encontrarObjetoInventario(noPesquisa);

			beanItem.setIdentificacao(objetoInventarioHardware.getProperties().get("NAME"));

			if (objetoInventarioHardware.getProperties().get("IPADDR") != null && !objetoInventarioHardware.getProperties().get("IPADDR").isEmpty()) {
				beanItem.setIpaddr(objetoInventarioHardware.getProperties().get("IPADDR"));
			}

			for (HostItem objetoInventarioNaoHardware : objetosInventario) {
				lstTipoItemConfi.add(percorreListaMap(objetoInventarioNaoHardware));
			}

			beanItem.setTipoItemConfiguracao(lstTipoItemConfi);

			return beanItem;
		} catch (Exception e) {
			System.out.println("Erro ao fazer a leitura do objeto de inventrio: " + e.getMessage());
			throw new LogicException("Parmetros de Configurao Atributo Pesquisa/No Pesquisa invlidos");
		}
	}

	/**
	 * Percorre Atributos do Node
	 * 
	 * OBS: String Identifica atributo atraves desse parametro (Caso queira percorre o node por completo deixar vazio)
	 * 
	 * @param noAtual
	 *            Node
	 * @param campoIdentificacao
	 *            String
	 * @return TipoItemConfiguracaoDTO
	 * 
	 */
	private TipoItemConfiguracaoDTO percorreListaMap(HostItem noAtual) {
		TipoItemConfiguracaoDTO tpItemConfigbean = new TipoItemConfiguracaoDTO();
		ValorDTO valorbean = null;
		CaracteristicaDTO caracteristicabean = null;

		tpItemConfigbean.setTag(noAtual.getName());
		tpItemConfigbean.setNome(noAtual.getName());

		List<CaracteristicaDTO> lstCaracteristica = new ArrayList<CaracteristicaDTO>();

		Iterator it = noAtual.getProperties().entrySet().iterator();
		while (it.hasNext()) {
			Map.Entry pair = (Map.Entry) it.next();

			caracteristicabean = new CaracteristicaDTO();
			valorbean = new ValorDTO();

			if (pair == null || pair.getKey() == null || pair.getValue() == null) {
				continue;
			}

			caracteristicabean.setNome(pair.getKey().toString());
			caracteristicabean.setTipo("A");
			caracteristicabean.setTag(pair.getKey().toString());
			valorbean.setValorStr(pair.getValue().toString());
			caracteristicabean.setValor(valorbean);
			lstCaracteristica.add(caracteristicabean);
		}

		if (lstCaracteristica != null && !lstCaracteristica.isEmpty()) {
			tpItemConfigbean.setCaracteristicas(lstCaracteristica);
			return tpItemConfigbean;
		} else {
			return null;
		}
	}

	/**
	 * Retorna Lista Preenchida pelos Node do xml
	 * 
	 * @return Lista Item Configuracao
	 */
	public List<ItemConfiguracaoDTO> getRetornaListaItemConfiguracao() {
		return listElementos;
	}

	public List<ItemConfiguracaoDTO> processarHashmapInventario(final Set<HostItem> objetosInventario) throws ServiceException, Exception, LogicException {
		this.objetosInventario = objetosInventario;
		listElementos.add(gravaDados());
		return listElementos;
	}

	private HostItem encontrarObjetoInventario(String nameTipoItemConfiguracao) {

		for (HostItem objetoInventario : objetosInventario) {
			if (objetoInventario.getName().equalsIgnoreCase(nameTipoItemConfiguracao)) {
				return objetoInventario;
			}

		}

		return null;
	}

}
