package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AcaoPlanoMelhoriaDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class AcaoPlanoMelhoriaDao extends CrudDaoDefaultImpl {

	public AcaoPlanoMelhoriaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAcaoPlanoMelhoria", "idAcaoPlanoMelhoria", true, true, false, false));
		listFields.add(new Field("idPlanoMelhoria", "idPlanoMelhoria", false, false, false, false));
		listFields.add(new Field("idObjetivoPlanoMelhoria", "idObjetivoPlanoMelhoria", false, false, false, false));
		listFields.add(new Field("tituloAcao", "tituloAcao", false, false, false, false));
		listFields.add(new Field("detalhamentoAcao", "detalhamentoAcao", false, false, false, false));
		listFields.add(new Field("datainicioacao", "dataInicioAcao", false, false, false, false));
		listFields.add(new Field("datafimacao", "dataFimAcao", false, false, false, false));
		listFields.add(new Field("responsavel", "responsavelAcao", false, false, false, false));
		listFields.add(new Field("dataConclusao", "dataConclusao", false, false, false, false));
		listFields.add(new Field("criadoPor", "criadoPor", false, false, false, false));
		listFields.add(new Field("modificadoPor", "modificadoPor", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("ultModificacao", "ultModificacao", false, false, false, false));
		listFields.add(new Field("idrespacao", "idRespAcao", false, false, false, false));
		listFields.add(new Field("idgruporespacao", "idGrupoRespAcao", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "AcaoPlanoMelhoria";
	}

	@Override
	public Collection<AcaoPlanoMelhoriaDTO> list() throws PersistenceException {
		return null;
	}

	@Override
	public Class<AcaoPlanoMelhoriaDTO> getBean() {
		return AcaoPlanoMelhoriaDTO.class;
	}

	@Override
	public Collection<AcaoPlanoMelhoriaDTO> find(IDto arg0) throws PersistenceException {
		return null;
	}

	public Collection findByIdPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idPlanoMelhoria", "=", parm));
		ordenacao.add(new Order("tituloAcao"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idPlanoMelhoria", "=", parm));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdObjetivoPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idObjetivoPlanoMelhoria", "=", parm));
		ordenacao.add(new Order("tituloAcao"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdObjetivoPlanoMelhoria(Integer parm) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idObjetivoPlanoMelhoria", "=", parm));
		super.deleteByCondition(condicao);
	}

	/**
	 * Retorna uma lista de acao plano melhoria de acordo com o plano melhoria passado
	 *
	 * @param acaoPlanoMelhoriaDto
	 * @return Collection
	 * @throws Exception
	 * @author thays.araujo
	 */
	public List<AcaoPlanoMelhoriaDTO> listAcaoPlanoMelhoria(Integer idObjetivoPlanoMelhoria) throws PersistenceException {
		StringBuilder sql = new StringBuilder();

		List parametro = new ArrayList();

		List list = new ArrayList();

		sql.append("select * from " + getTableName() + " where idobjetivoplanomelhoria = ? ");

		parametro.add(idObjetivoPlanoMelhoria);

		list = this.execSQL(sql.toString(), parametro.toArray());
		List listaRetorno = new ArrayList();
		listaRetorno.add("idAcaoPlanoMelhoria");
		listaRetorno.add("idPlanoMelhoria");
		listaRetorno.add("idObjetivoPlanoMelhoria");
		listaRetorno.add("tituloAcao");
		listaRetorno.add("detalhamentoAcao");
		listaRetorno.add("dataInicioAcao");
		listaRetorno.add("dataFimAcao");
		listaRetorno.add("responsavelAcao");
		listaRetorno.add("dataConclusao");
		listaRetorno.add("criadoPor");
		listaRetorno.add("modificadoPor");
		listaRetorno.add("dataCriacao");
		listaRetorno.add("ultModificacao");
		listaRetorno.add("idGrupoRespAcao");
		listaRetorno.add("idRespAcao");

		if (list != null && !list.isEmpty()) {
			return this.listConvertion(AcaoPlanoMelhoriaDTO.class, list, listaRetorno);
		}

		return null;
	}

	@Override
	public IDto create(IDto obj) throws PersistenceException {
		return super.create(obj);
	}

	@Override
	public void update(IDto obj) throws PersistenceException {
		AcaoPlanoMelhoriaDTO acaoPlanoMelhoriaDTO = (AcaoPlanoMelhoriaDTO) restore(obj);
		if (acaoPlanoMelhoriaDTO != null) {
			((AcaoPlanoMelhoriaDTO) obj).setCriadoPor(acaoPlanoMelhoriaDTO.getCriadoPor());
			((AcaoPlanoMelhoriaDTO) obj).setDataCriacao(acaoPlanoMelhoriaDTO.getDataCriacao());
		}
		super.update(obj);
	}

	public List<IDto> listAcaoPlanoMelhoriaAsIDto(Integer idObjetivoPlanoMelhoria) throws PersistenceException {
		Collection<AcaoPlanoMelhoriaDTO> lista = listAcaoPlanoMelhoria(idObjetivoPlanoMelhoria);
		List<IDto> listaIDto = new ArrayList<>();
		if (lista != null && lista.size() > 0)
			listaIDto.addAll(lista);
		return listaIDto;
	}
}
