package br.com.centralit.citcorpore.integracao;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;

public class AcordoNivelServicoDao extends CrudDaoDefaultImpl {

	public AcordoNivelServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}


	/**
	 * Desenvolvedor: Fabio Amorim - Data: 17/08/2015 - Horrio: 16:48 - ID Citsmart: 176361 -
	 * Motivo/Comentrio: Possibilitara gerao dos relatrios do Citsmart atravs do dataSsource passado por parmetro para o DAO, citsmart_reports, por exemplo.
	 * @param databaseAlias
	 * @return dao com o databaseAlias especificado, caso esteja preenchido, seno dao com o datasource principal
	 */
	public AcordoNivelServicoDao(String databaseAlias) {
		super(databaseAlias, null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAcordoNivelServico", "idAcordoNivelServico", true, true, false, false));
		listFields.add(new Field("idServicoContrato", "idServicoContrato", false, false, false, false));
		listFields.add(new Field("idPrioridadePadrao", "idPrioridadePadrao", false, false, false, false));
		listFields.add(new Field("situacao", "situacao", false, false, false, false));
		listFields.add(new Field("tituloSLA", "tituloSLA", false, false, false, false));
		listFields.add(new Field("disponibilidade", "disponibilidade", false, false, false, false));
		listFields.add(new Field("descricaoSLA", "descricaoSLA", false, false, false, false));
		listFields.add(new Field("escopoSLA", "escopoSLA", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		listFields.add(new Field("avaliarEm", "avaliarEm", false, false, false, false));
		listFields.add(new Field("tipo", "tipo", false, false, false, false));
		listFields.add(new Field("valorLimite", "valorLimite", false, false, false, false));
		listFields.add(new Field("detalheGlosa", "detalheGlosa", false, false, false, false));
		listFields.add(new Field("detalheLimiteGlosa", "detalheLimiteGlosa", false, false, false, false));
		listFields.add(new Field("unidadeValorLimite", "unidadeValorLimite", false, false, false, false));
		listFields.add(new Field("impacto", "impacto", false, false, false, false));
		listFields.add(new Field("urgencia", "urgencia", false, false, false, false));
		listFields.add(new Field("permiteMudarImpUrg", "permiteMudarImpUrg", false, false, false, false));
		listFields.add(new Field("contatos", "contatos", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));
		listFields.add(new Field("tempoAuto", "tempoAuto", false, false, false, false));
		listFields.add(new Field("idPrioridadeAuto1", "idPrioridadeAuto1", false, false, false, false));
		listFields.add(new Field("idGrupo1", "idGrupo1", false, false, false, false));
		listFields.add(new Field("criadoEm", "criadoEm", false, false, false, false));
		listFields.add(new Field("criadoPor", "criadoPor", false, false, false, false));
		listFields.add(new Field("modificadoEm", "modificadoEm", false, false, false, false));
		listFields.add(new Field("modificadoPor", "modificadoPor", false, false, false, false));
		listFields.add(new Field("idEmail", "idEmail", false, false, false, false));
		listFields.add(new Field("idcontrato", "idContrato", false, false, false, false));
		listFields.add(new Field("sazonalidade", "sazonalidade", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "AcordoNivelServico";
	}

	@Override
	public Class<AcordoNivelServicoDTO> getBean() {
		return AcordoNivelServicoDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<AcordoNivelServicoDTO> findByIdServicoContrato(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idServicoContrato", parm));
		ordenacao.add(new Order("dataInicio"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdServicoContrato(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServicoContrato", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public Collection<AcordoNivelServicoDTO> findByIdPrioridadePadrao(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idPrioridadePadrao", parm));
		ordenacao.add(new Order("dataInicio"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdPrioridadePadrao(Integer parm) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idPrioridadePadrao", "=", parm));
		super.deleteByCondition(condicao);
	}

	@SuppressWarnings("unchecked")
	public AcordoNivelServicoDTO findAtivoByIdServicoContrato(Integer idServicoContrato, String tipo) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idServicoContrato", idServicoContrato));
		condicao.add(new Condition("tipo", tipo));
		condicao.add(new Condition("situacao", "A"));

		Collection<AcordoNivelServicoDTO> col = super.findByCondition(condicao, null);
		if (col == null || col.size() == 0) {
			return null;
		}
		AcordoNivelServicoDTO result = null;
		for (AcordoNivelServicoDTO acordoNivelServicoDto : col) {
			if ((acordoNivelServicoDto.getDataFim() == null || UtilDatas.getDataAtual().before(acordoNivelServicoDto.getDataFim()))
					&& (acordoNivelServicoDto.getDeleted() == null || acordoNivelServicoDto.getDeleted().equalsIgnoreCase("N"))) {
				result = acordoNivelServicoDto;
			}
		}
		return result;
	}
	
	@SuppressWarnings("unchecked")
	public AcordoNivelServicoDTO findTempoAtendimentoByIdServicoContratoAndIdEmpregado(Integer idServicoContrato, Integer idEmpregado) throws PersistenceException {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		acordoNivelServico.idAcordoNivelServico, ");
		sqlBuilder.append("		acordoNivelServico.idServicoContrato, ");
		sqlBuilder.append("		acordoNivelServico.impacto, ");
		sqlBuilder.append("		acordoNivelServico.urgencia, ");
		sqlBuilder.append("		acordoNivelServico.permiteMudarImpUrg, ");
		sqlBuilder.append("		acordoNivelServico.dataFim ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		acordoNivelServico acordoNivelServico ");
		sqlBuilder.append("		INNER JOIN tempoAtendimentoEmpregado tempoAtendimentoEmpregado ");
		sqlBuilder.append("			ON acordoNivelServico.idAcordoNivelServico = tempoAtendimentoEmpregado.idAcordoNivelServico ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		acordoNivelServico.idServicoContrato = ? ");
		sqlBuilder.append("		AND tempoAtendimentoEmpregado.idEmpregado = ? ");
		sqlBuilder.append("		AND acordoNivelServico.tipo = 'T' ");
		sqlBuilder.append("		AND (acordoNivelServico.deleted IS NULL OR UPPER(acordoNivelServico.deleted) <> UPPER('Y')) ");
		sqlBuilder.append("		AND acordoNivelServico.situacao =  'A' ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idServicoContrato);
		listParametro.add(idEmpregado);

		listResultado = this.execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAcordoNivelServico");
		listRetorno.add("idServicoContrato");
		listRetorno.add("impacto");
		listRetorno.add("urgencia");
		listRetorno.add("permiteMudarImpUrg");
		listRetorno.add("dataFim");

		List<AcordoNivelServicoDTO> listAcordoNivelServico = this.engine.listConvertion(AcordoNivelServicoDTO.class, listResultado, listRetorno);
		
		if(listAcordoNivelServico == null || listAcordoNivelServico.isEmpty()) {
			return null;
		}
		
		AcordoNivelServicoDTO result = null;
		for (AcordoNivelServicoDTO acordoNivelServicoDto : listAcordoNivelServico) {
			if (acordoNivelServicoDto.getDataFim() == null || UtilDatas.getDataAtual().before(acordoNivelServicoDto.getDataFim())) {
				result = acordoNivelServicoDto;
			}
		}
		return result;
	}

	/**
	 * Mtodo para retornar os servios que possuem o SLA selecionado j copiado, para ser tratado evitando duplicao de SLA.
	 *
	 * @param titulo
	 *            do SLA selecionado
	 * @return retorna os servios que possuem o SLA selecionado
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
	@SuppressWarnings("unchecked")
	public List<ServicoContratoDTO> buscaServicosComContrato(String tituloSla) throws PersistenceException {

		List<String> parametro = new ArrayList<String>();
		List<?> resp = new ArrayList<>();

		String sql = "SELECT DISTINCT idServicoContrato FROM " + getTableName() + " WHERE titulosla LIKE ? AND idservicocontrato IS NOT NULL ORDER BY idservicocontrato ";

		parametro.add(tituloSla);

		resp = this.execSQL(sql, parametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idServicoContrato");

		List<ServicoContratoDTO> listconvertion = this.engine.listConvertion(ServicoContratoDTO.class, resp, listRetorno);

		return listconvertion;
	}

	/**
	 * Mtodo para verificar se existe cadastrado um cadastro o mesmo nome.
	 *
	 * @param String
	 *            tituloSLA
	 * @return true se o nome exisite e false se no existir
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
	public boolean verificaSeNomeExiste(String tituloSLA) throws PersistenceException {
		List<String> parametro = new ArrayList<String>();
		List<?> list = new ArrayList<>();
		String sql = "SELECT idacordonivelservico FROM " + getTableName() + " WHERE titulosla = ? ";

		parametro.add(tituloSLA);

		list = this.execSQL(sql, parametro.toArray());

		if (list != null && !list.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Retorna os SLAs que no possuem vinculao direta com ServicoContrato
	 */
	@SuppressWarnings("unchecked")
	public List<AcordoNivelServicoDTO> findAcordosSemVinculacaoDireta() throws PersistenceException {
		List<?> resp = new ArrayList<>();

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append(getNamesFieldsStr()).append(" ");
		sb.append("FROM ");
		sb.append(getTableName()).append(" ");
		sb.append("WHERE ");
		sb.append("	idServicoContrato is null ");
		sb.append("	and (deleted is null or upper(deleted) = upper('n')) ");
		sb.append("	and (dataFim is null or dataFim > {DATAATUAL}) ");
		sb.append("ORDER BY ");
		sb.append("	tituloSLA");

		resp = this.execSQL(sb.toString(), null);

		return this.listConvertion(AcordoNivelServicoDTO.class, resp, getListNamesFieldClass());
	}

	/**
	 * Encontra o SLAs pelo ID
	 * @author euler.ramos
	 */
	@SuppressWarnings("unchecked")
	public List<AcordoNivelServicoDTO> findByIdAcordoSemVinculacaoDireta(Integer idAcordoNivelServico) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		List<?> resp = new ArrayList<>();

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append(getNamesFieldsStr()).append(" ");
		sb.append("FROM ");
		sb.append(getTableName()).append(" ");
		sb.append("WHERE ");
		sb.append("	idAcordoNivelServico = ? ");
		sb.append("	and idServicoContrato is null ");
		sb.append("	and (deleted is null or upper(deleted) = upper('n')) ");
		sb.append("	and (dataFim is null or dataFim > {DATAATUAL}) ");
		sb.append("ORDER BY ");
		sb.append("	tituloSLA");

		parametro.add(idAcordoNivelServico);

		resp = this.execSQL(sb.toString(), parametro.toArray());

		List<AcordoNivelServicoDTO> result = this.engine.listConvertion(getBean(), resp, getListNamesFieldClass());
		return result == null ? new ArrayList<AcordoNivelServicoDTO>() : result;
	}

	/**
	 * Encontra o SLAs pelo Titulo
	 * @author euler.ramos
	 */
	@SuppressWarnings("unchecked")
	public List<AcordoNivelServicoDTO> findByTituloSLA(String titulo) throws PersistenceException {
		List<String> parametro = new ArrayList<String>();
		List<?> resp = new ArrayList<>();

		StringBuilder sb = new StringBuilder();
		sb.append("SELECT ");
		sb.append(getNamesFieldsStr()).append(" ");
		sb.append("FROM ");
		sb.append(getTableName()).append(" ");
		sb.append("WHERE ");
		sb.append("	tituloSLA = ? ");
		sb.append("	and idServicoContrato is null ");
		sb.append("	and (deleted is null or upper(deleted) = upper('n')) ");
		sb.append("	and (dataFim is null or dataFim > {DATAATUAL}) ");
		sb.append("ORDER BY ");
		sb.append("	tituloSLA");

		parametro.add(titulo);

		resp = this.execSQL(sb.toString(), parametro.toArray());

		List<AcordoNivelServicoDTO> result = this.engine.listConvertion(getBean(), resp, getListNamesFieldClass());
		return result == null ? new ArrayList<AcordoNivelServicoDTO>() : result;
	}

	public void updateTemposAcoes(AcordoNivelServicoDTO acordoNivelServicoDTO) throws PersistenceException {
		AcordoNivelServicoDTO acordoNivelServicoAux = new AcordoNivelServicoDTO();
		acordoNivelServicoAux.setIdGrupo1(acordoNivelServicoDTO.getIdGrupo1());
		acordoNivelServicoAux.setIdPrioridadeAuto1(acordoNivelServicoDTO.getIdPrioridadeAuto1());
		acordoNivelServicoAux.setTempoAuto(acordoNivelServicoDTO.getTempoAuto());
		acordoNivelServicoAux.setIdAcordoNivelServico(acordoNivelServicoDTO.getIdAcordoNivelServico());
		acordoNivelServicoAux.setDeleted(acordoNivelServicoDTO.getDeleted());
		super.updateNotNull(acordoNivelServicoAux);
	}

	/**
	 * @param idServicoContrato
	 * @param data
	 * @throws PersistenceException
	 * @author cledson.junior
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void updateAcordoNivelServico(Integer idServicoContrato, Date data) throws PersistenceException {
		List parametros = new ArrayList<>();

		if (data != null) {
			parametros.add(data);
		} else {
			parametros.add(null);
		}

		parametros.add("y");
		parametros.add(idServicoContrato);
		String sql = "UPDATE " + getTableName() + " SET datafim = ?, deleted = ? WHERE idServicoContrato = ?";
		execUpdate(sql, parametros.toArray());
	}

	public void updateNotNull(AcordoNivelServicoDTO acordoNivelServicoDTO) throws PersistenceException {
		super.updateNotNull(acordoNivelServicoDTO);
	}

	@SuppressWarnings("unchecked")
	public List<AcordoNivelServicoDTO> findIdEmailByIdSolicitacaoServico(Integer idSolicitacaoServico) throws PersistenceException {

		List<Integer> parametro = new ArrayList<Integer>();
		List<?> resp = new ArrayList<>();

		String sql = "SELECT DISTINCT idEmail FROM " + getTableName() + " inner join  solicitacaoservico on solicitacaoservico.idservicocontrato = acordonivelservico.idservicocontrato"
				+ " AND solicitacaoservico.idsolicitacaoservico = " + idSolicitacaoServico;

		resp = this.execSQL(sql, parametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idEmail");

		List<AcordoNivelServicoDTO> listconvertion = this.engine.listConvertion(ServicoContratoDTO.class, resp, listRetorno);

		return listconvertion;
	}

	public AcordoNivelServicoDTO findByIdAcordoNivelServicoEServicoContrato(Integer idAcordoNivelServico, Integer idServicoContrato) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		List<String> fields = new ArrayList<String>();
		List<?> list = new ArrayList<>();
		String sql = "select idacordonivelservico, idservicocontrato from acordonivelservico where idacordonivelservico = ? and idservicocontrato = ?";
		parametro.add(idAcordoNivelServico);
		parametro.add(idServicoContrato);
		list = this.execSQL(sql, parametro.toArray());
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");

		if (list != null && !list.isEmpty()) {
			return (AcordoNivelServicoDTO) this.listConvertion(getBean(), list, fields).get(0);
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public AcordoNivelServicoDTO findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws Exception {
		Collection<AcordoNivelServicoDTO> listAcordoNivelServicoDTO = new ArrayList<>();

		final List<Condition> condicao = new ArrayList<>();

		condicao.add(new Condition("idAcordoNivelServico", idAcordoNivelServico));

		listAcordoNivelServicoDTO = this.findByCondition(condicao, null);

		if (listAcordoNivelServicoDTO != null && listAcordoNivelServicoDTO.iterator().hasNext()) {
			return listAcordoNivelServicoDTO.iterator().next();
		}

		return null;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public void deleteByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException{
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList<>();

		sql.append("UPDATE ").append(getTableName()).append(" SET deleted = ? WHERE idacordonivelservico = ?");
		parametros.add("y");
		parametros.add(idAcordoNivelServico);

		this.execSQL(sql.toString(), parametros.toArray());
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public AcordoNivelServicoDTO findANSIncReqProcByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();
		List result = new ArrayList();
		List fields = new ArrayList();

		sql.append(" SELECT ").append(getNamesFieldsStr("ans"));
		sql.append(" FROM ").append(getTableName()).append(" ans ");
		sql.append(" LEFT JOIN 	tempoatendimentounidade tau ON tau.idacordonivelservico = ans.idacordonivelservico ");
		sql.append(" LEFT JOIN	tempoatendimentoempregado tae ON tae.idacordonivelservico = ans.idacordonivelservico ");
		sql.append(" WHERE	ans.idservicocontrato = ? ");

		if (idServicoContrato != null) {
			parametros.add(idServicoContrato);
		} else {
			parametros.add(0);
		}

		sql.append(" ORDER BY tau.prioridade, tae.prioridade ASC ");

		result = this.execSQL(sql.toString(), parametros.toArray());

		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("idPrioridadePadrao");
		fields.add("situacao");
		fields.add("tituloSLA");
		fields.add("disponibilidade");
		fields.add("descricaoSLA");
		fields.add("escopoSLA");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("avaliarEm");
		fields.add("tipo");
		fields.add("valorLimite");
		fields.add("detalheGlosa");
		fields.add("detalheLimiteGlosa");
		fields.add("unidadeValorLimite");
		fields.add("impacto");
		fields.add("urgencia");
		fields.add("permiteMudarImpUrg");
		fields.add("contatos");
		fields.add("deleted");
		fields.add("tempoAuto");
		fields.add("idPrioridadeAuto1");
		fields.add("idGrupo1");
		fields.add("criadoEm");
		fields.add("criadoPor");
		fields.add("modificadoEm");
		fields.add("modificadoPor");
		fields.add("idEmail");
		fields.add("idcontrato");
		fields.add("sazonalidade");

		AcordoNivelServicoDTO ans = new AcordoNivelServicoDTO();
		if (result != null && !result.isEmpty()) {
			ans = (AcordoNivelServicoDTO) this.listConvertion(getBean(), result, fields).get(0);
		}

		return ans;
	}
}
