package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class AcordoServicoContratoDao extends CrudDaoDefaultImpl {

	public AcordoServicoContratoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	public AcordoServicoContratoDao(String databaseAlias) {
		super(databaseAlias, null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAcordoServicoContrato", "idAcordoServicoContrato", true, true, false, false));
		listFields.add(new Field("idAcordoNivelServico", "idAcordoNivelServico", false, false, false, false));
		listFields.add(new Field("idServicoContrato", "idServicoContrato", false, false, false, false));
		listFields.add(new Field("dataCriacao", "dataCriacao", false, false, false, false));
		listFields.add(new Field("dataInicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("dataFim", "dataFim", false, false, false, false));
		listFields.add(new Field("dataUltAtualiz", "dataUltAtualiz", false, false, false, false));
		listFields.add(new Field("idRecurso", "idRecurso", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));
		listFields.add(new Field("habilitado", "habilitado", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "AcordoServicoContrato";
	}

	@Override
	public Collection list() throws PersistenceException {
		return null;
	}

	@Override
	public Class getBean() {
		return AcordoServicoContratoDTO.class;
	}

	@Override
	public Collection find(IDto arg0) throws PersistenceException {
		return null;
	}

	public Collection findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException {
		List condicao = new ArrayList();
		List ordenacao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		ordenacao.add(new Order("idServicoContrato"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdAcordoServicoContrato(Integer idAcordoServicoContrato) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idAcordoServicoContrato", "=", idAcordoServicoContrato));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		List parametros = new ArrayList();
		parametros.add(idServicoContrato);

		StringBuilder sql = new StringBuilder();

		sql.append("SELECT ");
		sql.append("	ascont.idAcordoServicoContrato, ");
		sql.append("	ascont.idAcordoNivelServico, ");
		sql.append("	ascont.idServicoContrato, ");
		sql.append("	ascont.dataCriacao, ");
		sql.append("	ascont.dataInicio, ");
		sql.append("	ascont.dataFim, ");
		sql.append("	ascont.dataUltAtualiz, ");
		sql.append("	ascont.deleted, ");
		sql.append("	ans.tituloSla, ");
		sql.append("	ascont.habilitado ");
		sql.append("FROM ");
		sql.append("	acordoservicocontrato ascont ");
		sql.append("	INNER JOIN acordonivelservico ans on ascont.idAcordoNivelServico = ans.idAcordoNivelServico ");
		sql.append("WHERE ");
		sql.append("	ascont.idServicoContrato = ? ");
		sql.append("ORDER BY ");
		sql.append("	ascont.idAcordoNivelServico");

		List fields = new ArrayList();
		fields.add("idAcordoServicoContrato");
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("dataCriacao");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("dataUltAtualiz");
		fields.add("deleted");
		fields.add("descAcordoNivelServico");
		fields.add("habilitado");

		List colDados = this.execSQL(sql.toString(), parametros.toArray());
		Collection<AcordoServicoContratoDTO> col = this.listConvertion(AcordoServicoContratoDTO.class, colDados, fields);

		return col;
	}

	public AcordoServicoContratoDTO findAtivoByIdServicoContrato(Integer idServicoContrato, String tipo) throws PersistenceException {
		List parametros = new ArrayList();
		parametros.add(idServicoContrato);
		parametros.add(tipo);

		List fields = new ArrayList();
		fields.add("idAcordoServicoContrato");
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("dataCriacao");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("dataUltAtualiz");
		fields.add("deleted");

		String sql = "SELECT A.idacordoservicocontrato, A.idacordonivelservico, A.idservicocontrato, A.dataCriacao, A.dataInicio, A.dataFim, A.dataUltAtualiz, A.deleted FROM " + this.getTableName()
				+ " A INNER JOIN acordonivelservico B ON A.idacordonivelservico = B.idacordonivelservico AND B.idservicocontrato IS NULL "
				+ "WHERE A.idservicocontrato = ? AND B.tipo = ? AND (A.deleted IS NULL or UPPER(A.deleted) = 'N') AND (B.deleted IS NULL or UPPER(B.deleted) = 'N') AND A.habilitado = 'S' ";
		List colDados = this.execSQL(sql, parametros.toArray());
		Collection<AcordoServicoContratoDTO> col = this.listConvertion(AcordoServicoContratoDTO.class, colDados, fields);
		if (col == null || col.size() == 0) {
			return null;
		}
		AcordoServicoContratoDTO result = null;
		for (AcordoServicoContratoDTO acordoNivelServicoDto : col) {
			if ((acordoNivelServicoDto.getDataFim() == null || UtilDatas.getDataAtual().before(acordoNivelServicoDto.getDataFim())) && (acordoNivelServicoDto.getDeleted() == null || acordoNivelServicoDto.getDeleted().equalsIgnoreCase("N"))) {
				result = acordoNivelServicoDto;
			}
		}
		return result;
	}

	public AcordoServicoContratoDTO getANSGlobalClienteHierarquicoByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		List parametros = new ArrayList();
		List result = new ArrayList();

		AcordoServicoContratoDTO acordoServicoContratoDTO = new AcordoServicoContratoDTO();

		StringBuilder sql = new StringBuilder();

		sql.append(" SELECT ").append(getNamesFieldsStr("acsc"));
		sql.append(" FROM ").append(getTableName()).append(" acsc ");
		sql.append(" INNER JOIN acordonivelservico ans ON ans.idacordonivelservico = acsc.idacordonivelservico ");
		sql.append(" WHERE acsc.idservicocontrato = ? ");
		if (idServicoContrato != null) {
			parametros.add(idServicoContrato);
		} else {
			parametros.add(0);
		}

		sql.append(" ORDER BY acsc.idservicocontrato, ans.idcontrato ASC ");
		result = execSQL(sql.toString(), parametros.toArray());

		List fields = new ArrayList();
		fields.add("idAcordoServicoContrato");
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("dataCriacao");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("dataUltAtualiz");
		fields.add("idRecurso");
		fields.add("deleted");
		fields.add("habilitado");

		if (result != null && !result.isEmpty()) {
			acordoServicoContratoDTO = (AcordoServicoContratoDTO) this.listConvertion(AcordoServicoContratoDTO.class, result, fields).get(0);
		}

		return acordoServicoContratoDTO;
	}

	public void deleteByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idServicoContrato", "=", idServicoContrato));
		super.deleteByCondition(condicao);
	}

	/**
	 * Verifica se existe relacionamento na base de dados entre a ANS e o Contrato
	 * @author flavio.santana
	 * @param idAcordoNivelServico
	 * @param idContrato
	 * @return
	 * @throws Exception
	 */
	public boolean existeAcordoServicoContrato(Integer idAcordoNivelServico, Integer idContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List fields = new ArrayList();
		List parametros = new ArrayList();
		sql.append("select ascn.idAcordoNivelServico from acordoServicoContrato ascn ");
		sql.append("inner join servicocontrato sc on sc.idservicocontrato = ascn.idservicocontrato ");
		sql.append("inner join contratos c on c.idcontrato =  sc.idcontrato ");
		sql.append("where ascn.idAcordoNivelServico = ? and c.idcontrato = ? ");

		fields.add("idAcordoNivelServico");
		parametros.add(idAcordoNivelServico);
		parametros.add(idContrato);

		 Collection<AcordoServicoContratoDTO> obj = this.execSQL(sql.toString(), parametros.toArray());
		return obj != null && !obj.isEmpty() ? true : false;
	}

	public Collection<AcordoServicoContratoDTO> findByIdAcordoNivelServicoIdServicoContrato(Integer idAcordoNivelServico, Integer idServicoContrato) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		condicao.add(new Condition("idServicoContrato", "=", idServicoContrato));
		return super.findByCondition(condicao, ordenacao);
	}

	@Override
	public void updateNotNull(IDto obj) throws PersistenceException {
		super.updateNotNull(obj);
	}

	public List<AcordoServicoContratoDTO> listAtivoByIdServicoContrato(Integer idAcordoServicoContrato, Integer idServicoContrato, String tipo) throws PersistenceException {
		List parametros = new ArrayList();
		parametros.add(idAcordoServicoContrato);
		parametros.add(idServicoContrato);
		parametros.add(tipo);

		List fields = new ArrayList();
		fields.add("idAcordoServicoContrato");
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("dataCriacao");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("dataUltAtualiz");
		fields.add("deleted");

		String sql = "SELECT A.idacordoservicocontrato, A.idacordonivelservico, A.idservicocontrato, A.dataCriacao, A.dataInicio, A.dataFim, A.dataUltAtualiz, A.deleted FROM " + this.getTableName()
				+ " A INNER JOIN acordonivelservico B ON A.idacordonivelservico = B.idacordonivelservico AND B.idservicocontrato IS NULL "
				+ "WHERE A.idAcordoServicoContrato <> ? and A.idservicocontrato = ? AND B.tipo = ? AND (A.deleted IS NULL or UPPER(A.deleted) = 'N') AND (B.deleted IS NULL or UPPER(B.deleted) = 'N') ";
		List colDados = this.execSQL(sql, parametros.toArray());
		List<AcordoServicoContratoDTO> col = this.listConvertion(AcordoServicoContratoDTO.class, colDados, fields);
		if (col == null || col.size() == 0) {
			return null;
		}
		return col;
	}

	public List<AcordoServicoContratoDTO> listAtivoByIdServicoContrato(Integer idServicoContrato, String tipo) throws PersistenceException {
		List parametros = new ArrayList();
		parametros.add(idServicoContrato);
		parametros.add(tipo);

		List fields = new ArrayList();
		fields.add("idAcordoServicoContrato");
		fields.add("idAcordoNivelServico");
		fields.add("idServicoContrato");
		fields.add("dataCriacao");
		fields.add("dataInicio");
		fields.add("dataFim");
		fields.add("dataUltAtualiz");
		fields.add("deleted");

		String sql = "SELECT A.idacordoservicocontrato, A.idacordonivelservico, A.idservicocontrato, A.dataCriacao, A.dataInicio, A.dataFim, A.dataUltAtualiz, A.deleted FROM " + this.getTableName()
				+ " A INNER JOIN acordonivelservico B ON A.idacordonivelservico = B.idacordonivelservico AND B.idservicocontrato IS NULL "
				+ "WHERE A.idservicocontrato = ? AND B.tipo = ? AND (A.deleted IS NULL or UPPER(A.deleted) = 'N') AND (B.deleted IS NULL or UPPER(B.deleted) = 'N')";
		List colDados = this.execSQL(sql, parametros.toArray());
		List<AcordoServicoContratoDTO> col = this.listConvertion(AcordoServicoContratoDTO.class, colDados, fields);
		if (col == null || col.size() == 0) {
			return null;
		}
		return col;
	}
	
	public AcordoServicoContratoDTO getAcordoServicoContratoAtualByIdServicoContrato(Integer idServicoContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();
		List listResultado = new ArrayList();

		sql.append("SELECT ");
		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
			sql.append(" TOP 1 ");
		}
		sql.append(getNamesFieldsStr());
		sql.append(" FROM ").append(getTableName());
		sql.append(" WHERE idservicocontrato = ? ");

		if (idServicoContrato != null) {
			parametros.add(idServicoContrato);
		} else {
			parametros.add("0");
		}

		sql.append(" ORDER BY datacriacao DESC");
		
		if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
            String sqlTudo = sql.toString();
            sql.setLength(0);
            sql.append("SELECT * FROM (" + sqlTudo + ") WHERE ROWNUM <= 1");
		} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.MYSQL)) {
            sql.append(" LIMIT 1 ");
        }

		listResultado = this.execSQL(sql.toString(), parametros.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAcordoServicoContrato");
		listRetorno.add("idAcordoNivelServico");
		listRetorno.add("idServicoContrato");
		listRetorno.add("dataCriacao");
		listRetorno.add("dataInicio");
		listRetorno.add("dataFim");
		listRetorno.add("dataUltAtualiz");
		listRetorno.add("idRecurso");
		listRetorno.add("deleted");
		listRetorno.add("habilitado");

		List<AcordoServicoContratoDTO> listaAcordoServicoContratoDTO = this.engine.listConvertion(getBean(), listResultado, listRetorno);

		if (listaAcordoServicoContratoDTO != null && !listaAcordoServicoContratoDTO.isEmpty()) {
			return listaAcordoServicoContratoDTO.get(0);
		}

		return null;
	}

	public AcordoServicoContratoDTO getAcordoServicoContratoByIdServicoContrato(Integer idServicoContrato, String tipo) throws PersistenceException {
		StringBuilder sqlBuilder = new StringBuilder();
		List listResultado = new ArrayList();
		List parametros = new ArrayList();

		sqlBuilder.append("SELECT ");
		sqlBuilder.append("		acordoServicoContrato.idacordoservicocontrato, ");
		sqlBuilder.append("		acordoServicoContrato.idacordonivelservico, ");
		sqlBuilder.append("		acordoServicoContrato.idservicocontrato, ");
		sqlBuilder.append("		acordoServicoContrato.dataCriacao, ");
		sqlBuilder.append("		acordoServicoContrato.dataInicio, ");
		sqlBuilder.append("		acordoServicoContrato.dataFim, ");
		sqlBuilder.append("		acordoServicoContrato.dataUltAtualiz, ");
		sqlBuilder.append("		acordoServicoContrato.deleted ");
		sqlBuilder.append("FROM ");
		sqlBuilder.append("		acordoServicoContrato acordoServicoContrato ");
		sqlBuilder.append("		INNER JOIN ");
		sqlBuilder.append(" 		acordoNivelServico acordoNivelServico ");
		sqlBuilder.append(" 			ON acordoServicoContrato.idacordonivelservico = acordoNivelServico.idacordonivelservico ");
		sqlBuilder.append(" 				AND acordoNivelServico.idservicocontrato IS NULL ");
		sqlBuilder.append("WHERE ");
		sqlBuilder.append("		acordoServicoContrato.idservicocontrato = ? ");
		sqlBuilder.append("		AND acordoNivelServico.tipo = ? ");
		sqlBuilder.append("		AND (acordoServicoContrato.deleted IS NULL OR UPPER(acordoServicoContrato.deleted) = 'N') ");
		sqlBuilder.append("		AND (acordoNivelServico.deleted IS NULL OR UPPER(acordoNivelServico.deleted) = 'N') ");
		sqlBuilder.append("ORDER BY ");
		sqlBuilder.append("		acordoServicoContrato.idacordoservicocontrato");

		parametros.add(idServicoContrato);
		parametros.add(tipo);

		listResultado = this.execSQL(sqlBuilder.toString(), parametros.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idAcordoServicoContrato");
		listRetorno.add("idAcordoNivelServico");
		listRetorno.add("idServicoContrato");
		listRetorno.add("dataCriacao");
		listRetorno.add("dataInicio");
		listRetorno.add("dataFim");
		listRetorno.add("dataUltAtualiz");
		listRetorno.add("deleted");

		List<AcordoServicoContratoDTO> listaAcordoServicoContratoDTO = this.engine.listConvertion(getBean(), listResultado, listRetorno);

		if (listaAcordoServicoContratoDTO != null && !listaAcordoServicoContratoDTO.isEmpty()) {
			return listaAcordoServicoContratoDTO.iterator().next();
		}

		return null;
	}

	/**
	 * Retorna o ANS do Contrato
	 * @author flavio.santana
	 * @param idAcordoNivelServico
	 * @param idContrato
	 * @return
	 * @throws Exception
	 */
	public List<AcordoServicoContratoDTO> findBylistByIdAcordoNivelServicoAndContrato(Integer idAcordoNivelServico, Integer idContrato) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List fields = new ArrayList();
		List parametros = new ArrayList();
		sql.append("select ascn.idAcordoServicoContrato from "+this.getTableName()+" ascn ");
		sql.append("inner join servicocontrato sc on sc.idservicocontrato = ascn.idservicocontrato ");
		sql.append("inner join contratos c on c.idcontrato =  sc.idcontrato ");
		sql.append("where ascn.idAcordoNivelServico = ? and c.idcontrato = ? ");

		fields.add("idAcordoServicoContrato");
		parametros.add(idAcordoNivelServico);
		parametros.add(idContrato);

		List colDados = this.execSQL(sql.toString(), parametros.toArray());
		return  this.listConvertion(AcordoServicoContratoDTO.class, colDados, fields);
	}

	public void deleteByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException{
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append("UPDATE ").append(getTableName()).append(" SET deleted = ? WHERE idacordonivelservico = ?");
		parametros.add("y");
		parametros.add(idAcordoNivelServico);

		this.execSQL(sql.toString(), parametros.toArray());
	}
}
