package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AmeacaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class AmeacaDao extends CrudDaoDefaultImpl {

	public AmeacaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<Field>();

		listFields.add(new Field("IDAMEACA", "idAmeaca", true, true, false, false));
		listFields.add(new Field("IDCATEGORIAAMEACA", "idCategoriaAmeaca", false, false, false, false));
		listFields.add(new Field("NOMEAMEACA", "nomeAmeaca", false, false, false, false));
		listFields.add(new Field("TIPO", "tipo", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "AMEACA";
	}

	@Override
	public Class<AmeacaDTO> getBean() {
		return AmeacaDTO.class;
	}

	public void updateNotNull(AmeacaDTO ameacaDTO) throws PersistenceException {
		super.updateNotNull(ameacaDTO);
	}

	@SuppressWarnings("unchecked")
	public Collection<AmeacaDTO> getListAmeacasByNome(String nome) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("nomeAmeaca", nome));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();

		return this.findByCondition(condicao, ordenacao);
	}
	
	public boolean verificarVinculoCategoriaAmeaca(Integer idCategoriaAmeaca) throws PersistenceException {
		final List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idCategoriaAmeaca", idCategoriaAmeaca));
		condicao.add(new Condition("dataFim", Condition.IS, null));

		final List<Order> ordenacao = new ArrayList<Order>();

		Collection result = this.findByCondition(condicao, ordenacao);
		
		if(result!=null && result.size()>0) return true;
		return false;
	}
}
