package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AmeacaRiscoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class AmeacaRiscoDAO extends CrudDaoDefaultImpl {

	public AmeacaRiscoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return "AMEACARISCO";
	}

	@Override
	public Collection<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDAMEACARISCOCONT", "idAmeacaRiscoCont", true, true, false, false));
		listFields.add(new Field("IDRISCO", "idRisco", false, false, false, false));
		listFields.add(new Field("IDAMEACA", "idAmeaca", false, false, false, false));

		return listFields;
	}

	public void excluiAmeacasRisco(Integer idRisco) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametros = new ArrayList();

		sql.append("DELETE ");
		sql.append("FROM AmeacaRisco ");
		sql.append("WHERE idRisco = ?");
		parametros.add(idRisco);

		this.execUpdate(sql.toString(), parametros.toArray());
	}

	public List buscaAmeacasByRisco(Integer idRisco) throws PersistenceException {
		List listResultado = new ArrayList();
		StringBuilder sqlBuilder = new StringBuilder();
		List parametros = new ArrayList();
		parametros.add(idRisco);

		sqlBuilder.append("SELECT idAmeaca ");
		sqlBuilder.append("FROM AmeacaRisco ");
		sqlBuilder.append("WHERE idRisco = ? ");

		listResultado = this.execSQL(sqlBuilder.toString(), parametros.toArray());

		return listResultado;
	}
	
	public boolean verificarVinculoAmeaca(Integer idAmeaca) throws PersistenceException {
		List listResultado = new ArrayList();
		StringBuilder sqlBuilder = new StringBuilder();
		List parametros = new ArrayList();
	
		sqlBuilder.append("SELECT idAmeaca ");
		sqlBuilder.append("FROM AmeacaRisco ");
		sqlBuilder.append("WHERE idAmeaca = ? ");
		parametros.add(idAmeaca);
		
		listResultado = this.execSQL(sqlBuilder.toString(), parametros.toArray());
		
		if(listResultado!=null && listResultado.size()>0) return true;
		return false;
	
	}
	
	@Override
	public Class getBean() {
		return AmeacaRiscoDTO.class;
	}
	

}
