package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AplicacaoClienteDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class AplicacaoClienteDao extends CrudDaoDefaultImpl {

	public AplicacaoClienteDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	public Class getBean() {
		return AplicacaoClienteDTO.class;
	}

	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idaplicacaocliente", "idAplicacaoCliente", true, true, false, false));
		listFields.add(new Field("idcliente", "idCliente", false, false, false, false));
		listFields.add(new Field("idaplicacao", "idAplicacao", false, false, false, false));

		return listFields;
	}

	public String getTableName() {
		return "aplicacaocliente";
	}

	public Collection<AplicacaoClienteDTO> findByIdAplicacao(final Integer idAplicacao) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT aplicacaocliente.idaplicacaocliente, ");
		sql.append("        aplicacaocliente.idcliente, ");
		sql.append("        aplicacaocliente.idaplicacao, ");
		sql.append("        clientes.nomerazaosocial ");
		sql.append(" FROM   aplicacaocliente aplicacaocliente ");
		sql.append("        INNER JOIN clientes clientes ");
		sql.append("                ON clientes.idcliente = aplicacaocliente.idcliente ");
		sql.append(" WHERE  aplicacaocliente.idaplicacao = ? ");
		sql.append(" ORDER  BY aplicacaocliente.idaplicacaocliente ");

		parametro.add(idAplicacao);

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("idAplicacaoCliente");
		listFields.add("idCliente");
		listFields.add("idAplicacao");
		listFields.add("nomeCliente");

		Collection<AplicacaoClienteDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<AplicacaoClienteDTO>();
		}

		return listaRetorno;
	}

	public void deleteByIdAplicacao(final Integer idAplicacao) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idAplicacao", "=", idAplicacao));
		super.deleteByCondition(condicao);
	}

}
