package br.com.centralit.citcorpore.integracao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AplicacaoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class AplicacaoDao extends CrudDaoDefaultImpl {

	public AplicacaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		List ordem = new ArrayList();
		ordem.add(new Order("nome"));
		return super.find(obj, ordem);
	}

	@Override
	public Class getBean() {
		return AplicacaoDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDAPLICACAO", "idAplicacao", true, true, false, false));
		listFields.add(new Field("NOME", "nome", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));
		listFields.add(new Field("ULTIMAVERSAODISPONIVEL", "ultimaVersaoDisponivel", false, false, false, false));
		listFields.add(new Field("IDRESPONSAVEL", "idResponsavel", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "APLICACAO";
	}

	@Override
	public Collection list() throws PersistenceException {
		List list = new ArrayList();
		list.add(new Order("nome"));
		return super.list(list);
	}

	public Collection listaAtivas() throws PersistenceException {
		List ordenacao = new ArrayList();
		List condicao = new ArrayList();

		ordenacao.add(new Order("nome"));
		condicao.add(new Condition("dataFim", "is", null));

		return super.findByCondition(condicao, ordenacao);
	}

	public Collection<AplicacaoDTO> listAtivosByIdServicoAndFiltro(Integer idServico, String filtro) throws Exception {
		final StringBuilder sql = new StringBuilder();
		final List parametro = new ArrayList();
		List list = new ArrayList();

		sql.append(" SELECT " + this.getNamesFieldsStr("a") + ", e.nome as nomeResponsavel ");
		sql.append(" FROM aplicacao a INNER JOIN aplicacaoservico aps ON aps.idaplicacao=a.idaplicacao ");
		sql.append(" LEFT JOIN empregados e on a.idresponsavel = e.idempregado ");
		sql.append(" WHERE aps.idservico = ? ");

		parametro.add(idServico);

		if (filtro != null && !filtro.isEmpty()) {
			sql.append(" AND a.nome like '%" + filtro + "%'");
		}

		list = this.execSQL(sql.toString(), parametro.toArray());

		List<Field> fields = this.getFields();
		fields.add(new Field("nomeResponsavel", "nomeResponsavel", false, false, false, false));

		final List<AplicacaoDTO> listServicoAplicacaoDto = this.listConvertion(this.getBean(), list, fields);

		if (listServicoAplicacaoDto != null && !listServicoAplicacaoDto.isEmpty()) {
			return listServicoAplicacaoDto;
		} else {
			return null;
		}
	}
	
	/**
     * Verifica se existe cliente vinculado  algum contrato.
     * @param idCliente
     * @return
     * @throws Exception
     * @author joao.morais
     */
    public boolean aplicacaoVinculadoServico (Integer idAplicacao) throws PersistenceException {
        List parametro = new ArrayList();
        StringBuilder sql = new StringBuilder();

        sql.append(" select count(*) from aplicacaoservico apps ");
        sql.append(" where apps.idaplicacao = ?");

        parametro.add(idAplicacao);

        List lista = new ArrayList();
        lista = this.execSQL(sql.toString(), parametro.toArray());

        Long total = 0l;
        BigDecimal totalLinhaBigDecimal;
        Integer totalLinhaInteger;
        if(lista != null){
            Object[] totalLinha = (Object[]) lista.get(0);
            if(totalLinha != null && totalLinha.length > 0){
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.POSTGRESQL) || CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.MYSQL)) {
                    total = (Long) totalLinha[0];
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
                    totalLinhaBigDecimal = (BigDecimal) totalLinha[0];
                    total = totalLinhaBigDecimal.longValue();
                }
                if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
                    totalLinhaInteger = (Integer) totalLinha[0];
                    total = Long.valueOf(totalLinhaInteger);
                }
            }
        }

        if (total > 0) {
            return true;
        } else{
            return false;
        }
    }

}