package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AplicacaoRequisitoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;
/**
 * @author murilo.rodrigues
 * @date 06/10/2015
 */
public class AplicacaoRequisitoDao extends CrudDaoDefaultImpl {

    public AplicacaoRequisitoDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<AplicacaoRequisitoDTO> find(final IDto arg0) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Field> getFields() {
    	final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idrequisitoaplicacao", "idRequisitoAplicacao", true, true, false, false));
		listFields.add(new Field("idaplicacao", "idAplicacao", false, false, false, false));
		listFields.add(new Field("detalhesrequisito", "detalhesRequisito", false, false, false, false));
		listFields.add(new Field("nomerequisito", "nomeRequisito", false, false, false, false));
		listFields.add(new Field("statusrequisito", "statusRequisito", false, false, false, false));
		listFields.add(new Field("deleted", "deleted", false, false, false, false));

        return listFields;
    }

    @Override
    public String getTableName() {
    	return "aplicacaorequisito";
    }

    @Override
    public Collection<AplicacaoRequisitoDTO> list() throws PersistenceException {
        return null;
    }

    @Override
    public Class<AplicacaoRequisitoDTO> getBean() {
        return AplicacaoRequisitoDTO.class;
    }

    @SuppressWarnings("unchecked")
	public Collection<AplicacaoRequisitoDTO> findByIdAplicacao(final Integer idAplicacao) throws Exception {
    	List<Condition> condicao = new ArrayList<Condition>();
		List<Order> ordenacao = new ArrayList<Order>();
		condicao.add(new Condition("idAplicacao", "=", idAplicacao));
		ordenacao.add(new Order("idRequisitoAplicacao"));
		return super.findByCondition(condicao, ordenacao);
	}

	public void deleteByIdAplicacao(final Integer idAplicacao) throws PersistenceException {
		List<Condition> condicao = new ArrayList<Condition>();
		condicao.add(new Condition("idAplicacao", "=", idAplicacao));
		super.deleteByCondition(condicao);
	}
}
