package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AplicacaoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "unchecked", "rawtypes"})
public class AplicacaoServicoDao extends CrudDaoDefaultImpl {
		
	  public AplicacaoServicoDao() {
	        super(Constantes.getValue("DATABASE_ALIAS"), null);
	  }
	  
	  public static String strSGBDPrincipal = null;
	  
	  @Override
	  public String getTableName() {
	        return "aplicacaoservico";
	  }
	  
	  @Override
	  public List<Field> getFields() {
		  final List<Field> listFields = new ArrayList<>();

	        listFields.add(new Field("idaplicacaoservico", "idAplicacaoServico", true, true, false, false));
	        listFields.add(new Field("idservico", "idServico", false, false, false, false));
	        listFields.add(new Field("idaplicacao", "idAplicacao", false, false, false, false));
	        

	        return listFields;
	  }

	 @Override
	 public Class getBean() {
		 return AplicacaoServicoDTO.class;
	 }
	 
	 @Override
	 public Collection list() throws PersistenceException {
	        return null;
	 }
	 
	 @Override
	 public Collection find(final IDto arg0) throws PersistenceException {
	        return null;
	 }
	 
	 public AplicacaoServicoDTO findByIdServicoAndIdAplicacao(Integer idServico, Integer idAplicacao) throws Exception{
		 
		 final StringBuilder sql = new StringBuilder();
	     final List parametro = new ArrayList();
	     List list = new ArrayList();
	     sql.append(" SELECT * ");
	     sql.append(" FROM aplicacaoservico ");
	     sql.append(" WHERE idservico = ? AND idaplicacao = ?");

	     parametro.add(idServico);
	     parametro.add(idAplicacao);
	     
	     list = this.execSQL(sql.toString(), parametro.toArray());
	     	     
	     final List<AplicacaoServicoDTO> listServicoAplicacaoDto = this.listConvertion(this.getBean(), list,
	                this.getFields());
	        
	        if (listServicoAplicacaoDto != null && !listServicoAplicacaoDto.isEmpty()) {
	            return listServicoAplicacaoDto.get(0);
	        } else {
	            return null;
	        }
	 }

	 

}
