package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AprovacaoMudancaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

public class AprovacaoMudancaDao extends CrudDaoDefaultImpl {

	public AprovacaoMudancaDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	private static final String SQL_DELETE_BY_ID_MUDANCA = "delete from  APROVACAOMUDANCA where idRequisicaoMudanca = ? and idhistoricomudanca is null ";

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAprovacaoMudanca", "idAprovacaoMudanca", true, true, false, false));
		listFields.add(new Field("idRequisicaoMudanca", "idRequisicaoMudanca", false, false, false, false));
		listFields.add(new Field("idEmpregado", "idEmpregado", false, false, false, false));
		listFields.add(new Field("nomeEmpregado", "nomeEmpregado", false, false, false, false));
		listFields.add(new Field("voto", "voto", false, false, false, false));
		listFields.add(new Field("comentario", "comentario", false, false, false, false));
		listFields.add(new Field("datahorainicio", "dataHoraInicio", false, false, false, false));
		listFields.add(new Field("datahoravotacao", "datahoravotacao", false, false, false, false));
		listFields.add(new Field("idhistoricomudanca", "idHistoricoMudanca", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "APROVACAOMUDANCA";
	}

	@Override
	public Class<AprovacaoMudancaDTO> getBean() {
		return AprovacaoMudancaDTO.class;
	}

	@SuppressWarnings("unchecked")
	public Collection<AprovacaoMudancaDTO> listaAprovacaoMudancaPorIdRequisicaoMudanca(Integer idRequisicaoMudanca) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT distinct (aprovacaomudanca.idempregado), aprovacaomudanca.comentario, aprovacaomudanca.voto, aprovacaomudanca.idrequisicaomudanca,aprovacaomudanca.idaprovacaomudanca,empregados.nome,aprovacaomudanca.datahorainicio, aprovacaomudanca.datahoravotacao  ");
		sql.append("FROM " + getTableName() + " ");
		sql.append("inner join empregados on empregados.idempregado = aprovacaomudanca.idempregado ");
		sql.append("WHERE  aprovacaomudanca.idrequisicaomudanca = ? and idhistoricomudanca is null ");
		parametro.add(idRequisicaoMudanca);

		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idEmpregado");
		listRetorno.add("comentario");
		listRetorno.add("voto");
		listRetorno.add("idRequisicaoMudanca");
		listRetorno.add("idAprovacaoMudanca");
		listRetorno.add("nomeEmpregado");
		listRetorno.add("dataHoraInicio");
		listRetorno.add("dataHoraVotacao");

		if (lista != null && !lista.isEmpty()) {
			return this.engine.listConvertion(getBean(), lista, listRetorno);
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<AprovacaoMudancaDTO> listByIdHistoricoMudanca(Integer idHistoricoMudanca) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT distinct (aprovacaomudanca.idempregado), aprovacaomudanca.comentario, aprovacaomudanca.voto, aprovacaomudanca.idrequisicaomudanca,aprovacaomudanca.idaprovacaomudanca,empregados.nome,aprovacaomudanca.datahorainicio, aprovacaomudanca.datahoravotacao  ");
		sql.append("FROM " + getTableName() + " ");
		sql.append("inner join empregados on empregados.idempregado = aprovacaomudanca.idempregado ");
		sql.append("WHERE  aprovacaomudanca.idhistoricomudanca = ? ");
		parametro.add(idHistoricoMudanca);

		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idEmpregado");
		listRetorno.add("comentario");
		listRetorno.add("voto");
		listRetorno.add("idRequisicaoMudanca");
		listRetorno.add("idAprovacaoMudanca");
		listRetorno.add("nomeEmpregado");
		listRetorno.add("dataHoraInicio");
		listRetorno.add("dataHoraVotacao");
		if (lista != null && !lista.isEmpty()) {
			return this.engine.listConvertion(getBean(), lista, listRetorno);
		} else {
			return null;
		}
	}

	@SuppressWarnings("unchecked")
	public Collection<AprovacaoMudancaDTO> listaAprovacaoMudancaPorIdRequisicaoMudancaEHistorico(Integer idRequisicaoMudanca) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT distinct (aprovacaomudanca.idempregado), aprovacaomudanca.comentario, aprovacaomudanca.voto, aprovacaomudanca.idrequisicaomudanca,aprovacaomudanca.idaprovacaomudanca,empregados.nome,aprovacaomudanca.datahorainicio, aprovacaomudanca.datahoravotacao  ");
		sql.append("FROM " + getTableName() + " ");
		sql.append("inner join empregados on empregados.idempregado = aprovacaomudanca.idempregado ");
		sql.append("WHERE  aprovacaomudanca.idrequisicaomudanca = ? and idhistoricomudanca is null ");
		parametro.add(idRequisicaoMudanca);

		List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idEmpregado");
		listRetorno.add("comentario");
		listRetorno.add("voto");
		listRetorno.add("idRequisicaoMudanca");
		listRetorno.add("idAprovacaoMudanca");
		listRetorno.add("nomeEmpregado");
		listRetorno.add("dataHoraInicio");
		listRetorno.add("dataHoraVotacao");
		if (lista != null && !lista.isEmpty()) {
			return this.engine.listConvertion(getBean(), lista, listRetorno);
		} else {
			return null;
		}
	}

	public void deleteByIdRequisicaoMudanca(Integer idRequisicaoMudanca) throws PersistenceException {
		super.execUpdate(SQL_DELETE_BY_ID_MUDANCA, new Object[]{idRequisicaoMudanca});
	}

	public void updateByIdRequisicaoMudanca(AprovacaoMudancaDTO aprovacaoMudancaDto) throws PersistenceException {
		super.updateNotNull(aprovacaoMudancaDto);
	}


	public void deleteLinha(Integer idRequisicaoMudanca, Integer idEmpregado) throws PersistenceException {
		List<Condition> lstCondicao = new ArrayList<Condition>();
		lstCondicao.add(new Condition("idRequisicaoMudanca", idRequisicaoMudanca));
		lstCondicao.add(new Condition("idEmpregado", idEmpregado));
		lstCondicao.add(new Condition("idHistoricoMudanca", Condition.IS, null));
		super.deleteByCondition(lstCondicao);
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Integer quantidadeAprovacaoMudancaPorVoto(AprovacaoMudancaDTO aprovacao) throws PersistenceException {
		List<String> listRetorno = new ArrayList<String>();
		List parametro = new ArrayList<>();
		StringBuilder sql = new StringBuilder();

		sql.append("select count(voto) from  aprovacaomudanca ");
		sql.append("where idrequisicaomudanca = ?  and voto = ? and idhistoricomudanca is null ");
		parametro.add(aprovacao.getIdRequisicaoMudanca());
		parametro.add(aprovacao.getVoto());

		List<?> list = this.execSQL(sql.toString(), parametro.toArray());

		listRetorno.add("quantidadeVotoRejeitada");

		if (list != null && !list.isEmpty()) {
			AprovacaoMudancaDTO aprovacaoMudancaDto = (AprovacaoMudancaDTO) this.engine.listConvertion(AprovacaoMudancaDTO.class, list, listRetorno).get(0);
			return aprovacaoMudancaDto.getQuantidadeVotoRejeitada();
		} else {
			return new Integer(0);
		}
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public Integer quantidadeAprovacaoMudanca(AprovacaoMudancaDTO aprovacao) throws PersistenceException {
		List<String> listRetorno = new ArrayList<String>();
		List parametro = new ArrayList<>();
		StringBuilder sql = new StringBuilder();

		sql.append("select count(aprovacaomudanca.idempregado) from  aprovacaomudanca ");
		sql.append("where idrequisicaomudanca = ? and idhistoricomudanca is null ");
		parametro.add(aprovacao.getIdRequisicaoMudanca());

		List<?> list = this.execSQL(sql.toString(), parametro.toArray());

		listRetorno.add("quantidadeAprovacaoMudanca");

		if (list != null && !list.isEmpty()) {
			AprovacaoMudancaDTO aprovacaoMudancaDto = (AprovacaoMudancaDTO) this.engine.listConvertion(AprovacaoMudancaDTO.class, list, listRetorno).get(0);
			return aprovacaoMudancaDto.getQuantidadeAprovacaoMudanca();
		} else {
			return new Integer(0);
		}
	}

	public Boolean validacaoAprovacaoMudanca(Integer idRequisicaoMudanca) throws PersistenceException {
		List<Integer> parametro = new ArrayList<Integer>();
		StringBuilder sql = new StringBuilder();

		sql.append("select idrequisicaomudanca from aprovacaomudanca where idrequisicaomudanca = ?");

		parametro.add(idRequisicaoMudanca);

		List<?> list = this.execSQL(sql.toString(), parametro.toArray());

		if (list != null && !list.isEmpty()) {
			return true;
		} else {
			return false;
		}
	}
}
