package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import br.com.centralit.citcorpore.bean.AssinaturaAprovacaoProjetoDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class AssinaturaAprovacaoProjetoDao extends CrudDaoDefaultImpl {

    public AssinaturaAprovacaoProjetoDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        final Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idAssinaturaAprovacaoProjeto", "idAssinaturaAprovacaoProjeto", true, true, false, false));
        listFields.add(new Field("idProjeto", "idProjeto", true, false, false, false));
        listFields.add(new Field("idEmpregado", "idEmpregadoAssinatura", true, false, false, false));
        listFields.add(new Field("papel", "papel", false, false, false, false));
        listFields.add(new Field("ordem", "ordem", false, false, false, false));
        return listFields;
    }

    @Override
    public String getTableName() {
        return this.getOwner() + "AssinaturaAprovacaoProjeto";
    }

    @Override
    public Class<AssinaturaAprovacaoProjetoDTO> getBean() {
        return AssinaturaAprovacaoProjetoDTO.class;
    }

    public Collection<AssinaturaAprovacaoProjetoDTO> findByIdProjeto(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idProjeto", "=", parm));
        ordenacao.add(new Order("idEmpregadoAssinatura"));
        return super.findByCondition(condicao, ordenacao);
    }

    public void deleteByIdProjeto(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        condicao.add(new Condition("idProjeto", "=", parm));
        super.deleteByCondition(condicao);
    }

    public Collection<AssinaturaAprovacaoProjetoDTO> findByIdEmpregado(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        final List<Order> ordenacao = new ArrayList<>();
        condicao.add(new Condition("idEmpregadoAssinatura", "=", parm));
        ordenacao.add(new Order("idProjeto"));
        return super.findByCondition(condicao, ordenacao);
    }

    public void deleteByIdEmpregado(final Integer parm) throws PersistenceException {
        final List<Condition> condicao = new ArrayList<>();
        condicao.add(new Condition("idEmpregadoAssinatura", "=", parm));
        super.deleteByCondition(condicao);
    }

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 * @param idProjeto
	 * @return Collection<AssinaturaAprovacaoProjetoDTO>
	 * @throws PersistenceException
	 */
	@SuppressWarnings("unchecked")
	public List<AssinaturaAprovacaoProjetoDTO> findAssinaturaAprovacaoComEmpregadoByIdProjeto(Integer idProjeto) throws Exception {
		List<Object> listResultado = new ArrayList<Object>();
		StringBuilder sqlBuilder = new StringBuilder();

		sqlBuilder.append("	SELECT ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto.idProjeto, ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto.idEmpregado, ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto.papel, ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto.ordem, ");
		sqlBuilder.append("		empregados.nome ");
		sqlBuilder.append("	FROM ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto assinaturaAprovacaoProjeto ");
		sqlBuilder.append("		INNER JOIN empregados empregados ");
		sqlBuilder.append("			ON assinaturaAprovacaoProjeto.idEmpregado = empregados.idEmpregado ");
		sqlBuilder.append("	WHERE ");
		sqlBuilder.append("		assinaturaAprovacaoProjeto.idProjeto = ? ");
		sqlBuilder.append("	ORDER  BY empregados.nome ");

		List<Object> listParametro = new ArrayList<Object>();
		listParametro.add(idProjeto);

		listResultado = execSQL(sqlBuilder.toString(), listParametro.toArray());

		List<String> listRetorno = new ArrayList<String>();
		listRetorno.add("idProjeto");
		listRetorno.add("idEmpregadoAssinatura");
		listRetorno.add("papel");
		listRetorno.add("ordem");
		listRetorno.add("nomeEmpregado");

		List<AssinaturaAprovacaoProjetoDTO> listaAssinaturaAprovacaoProjeto = engine.listConvertion(AssinaturaAprovacaoProjetoDTO.class, listResultado, listRetorno);
		

		if (listaAssinaturaAprovacaoProjeto != null && !listaAssinaturaAprovacaoProjeto.isEmpty()) {
			return listaAssinaturaAprovacaoProjeto;
		}
				
		return Collections.emptyList();
	}
}
