package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributoDemandaDTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

@SuppressWarnings("rawtypes")
public class AtributoDemandaDao extends CrudDaoDefaultImpl {
    public AtributoDemandaDao() {
        super(Constantes.getValue("DATABASE_ALIAS"), null);
    }

    @Override
    public Collection<Field> getFields() {
        Collection<Field> listFields = new ArrayList<>();
        listFields.add(new Field("idAtributoDemanda" ,"idAtributoDemanda", true, true, false, false));
        listFields.add(new Field("nome" ,"nome", false, false, false, false));
        listFields.add(new Field("valor" ,"valor", false, false, false, false));
        listFields.add(new Field("dataHoraFim" ,"dataHoraFim", false, false, false, false));
        return listFields;
    }
    @Override
    public String getTableName() {
        return "ATRIBUTODEMANDA";
    }

	@Override
	public Class<AtributoDemandaDTO> getBean() {
		return AtributoDemandaDTO.class;
	}
	
	@Override
	public Collection list() throws PersistenceException {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("dataHoraFim", Condition.IS, null));
		List<Order> ordenacao = new ArrayList<>();
		ordenacao.add(new Order("nome"));
		return findByCondition(condicao, ordenacao);
	}
        
}
