package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributoDemandaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

@SuppressWarnings({"rawtypes","unchecked"})
public class AtributoDemandaItemConfiguracaoDao extends CrudDaoDefaultImpl {
	public AtributoDemandaItemConfiguracaoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAtributoDemandaIc", "idAtributoDemandaIc", true, true, false, false));
		listFields.add(new Field("idAtributoDemanda", "idAtributoDemanda", false, false, false, false));
		listFields.add(new Field("idItemConfiguracao", "idItemConfiguracao", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "ATRIBUTODEMANDAIC";
	}

	@Override
	public Class<AtributoDemandaItemConfiguracaoDTO> getBean() {
		return AtributoDemandaItemConfiguracaoDTO.class;
	}
	
	public List<AtributoDemandaItemConfiguracaoDTO> listByIdItemConfiguracao(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, Integer pageNo, Integer pageSize) throws Exception {
		
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao(), parametros);
		
		Pageable pageable = new PageRequest(pageNo, pageSize);
		
		query = PagingQueryUtil.concatPagingPieceOnQuery(pageable, query, DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL));
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
	
	public Integer getTotalItensByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception{
		List<Object> parametros = new ArrayList<>();
		
		List retorno = this.execSQL(getQueryListByIdItemConfiguracao(idItemConfiguracao, parametros), parametros.toArray());
		
		return retorno.size();
	}

	private String getQueryListByIdItemConfiguracao(Integer idItemConfiguracao, List<Object> parametros) throws Exception{
		StringBuilder sb = new StringBuilder();
		
		sb.append("SELECT ").append(getNamesFieldsStr("atrdemic"));
		sb.append(" ,atrdem.nome ");
		sb.append(" ,atrdem.valor ");
		sb.append("FROM ").append(getTableName()).append(" atrdemic ");
		sb.append(" INNER JOIN ATRIBUTODEMANDA atrdem ON atrdem.idatributodemanda = atrdemic.idatributodemanda AND atrdem.datahorafim IS NULL ");
		sb.append(" AND atrdemic.iditemconfiguracao = ? ");
		sb.append("ORDER BY atrdem.nome ");
		parametros.add(idItemConfiguracao);
		
		return sb.toString();
	}
	
	public void deleteByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		List<Condition> condition = new ArrayList<>();
		condition.add(new Condition("idItemConfiguracao", Condition.EQUALS, idItemConfiguracao));
		super.deleteByCondition(condition);
	}
	
	public List<AtributoDemandaItemConfiguracaoDTO> listAllByIdItemConfiguracao(Integer idItemConfiguracao) throws Exception {
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdItemConfiguracao(idItemConfiguracao, parametros);
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
}
