package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributoDemandaServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioAtributoDemandaDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioIndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

@SuppressWarnings({"rawtypes","unchecked"})
public class AtributoDemandaServicoDao extends CrudDaoDefaultImpl {
	public AtributoDemandaServicoDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idAtributoDemandaServico", "idAtributoDemandaServico", true, true, false, false));
		listFields.add(new Field("idAtributoDemanda", "idAtributoDemanda", false, false, false, false));
		listFields.add(new Field("idServico", "idServico", false, false, false, false));
		return listFields;
	}

	@Override
	public String getTableName() {
		return "ATRIBUTODEMANDASERVICO";
	}

	@Override
	public Class<AtributoDemandaServicoDTO> getBean() {
		return AtributoDemandaServicoDTO.class;
	}
	
	public List<AtributoDemandaServicoDTO> listByIdServico(ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO, Integer pageNo, Integer pageSize) throws Exception {
		
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdServico(servicoNegocioAtributoDemandaDTO.getIdServico(), parametros);
		
		Pageable pageable = new PageRequest(pageNo, pageSize);
		
		query = PagingQueryUtil.concatPagingPieceOnQuery(pageable, query, DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL));
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
	
	public Integer getTotalItensByIdServico(Integer idServico) throws Exception{
		List<Object> parametros = new ArrayList<>();
		
		List retorno = this.execSQL(getQueryListByIdServico(idServico, parametros), parametros.toArray());
		
		return retorno.size();
	}

	private String getQueryListByIdServico(Integer idServico, List<Object> parametros) throws Exception{
		StringBuilder sb = new StringBuilder();
		
		sb.append("SELECT ").append(getNamesFieldsStr("atrdemser"));
		sb.append(" ,atrdem.nome ");
		sb.append(" ,atrdem.valor ");
		sb.append("FROM ").append(getTableName()).append(" atrdemser ");
		sb.append(" INNER JOIN ATRIBUTODEMANDA atrdem ON atrdem.idatributodemanda = atrdemser.idatributodemanda AND atrdem.datahorafim IS NULL ");
		sb.append(" AND atrdemser.idservico = ? ");
		sb.append("ORDER BY atrdem.nome ");
		parametros.add(idServico);
		
		return sb.toString();
	}
	
	public void deleteByIdServico(Integer idServico) throws Exception {
		List<Condition> condition = new ArrayList<>();
		condition.add(new Condition("idServico", Condition.EQUALS, idServico));
		super.deleteByCondition(condition);
	}
	
	public List<AtributoDemandaServicoDTO> listAllByIdServico(Integer idServico) throws Exception {
		List<Object> parametros = new ArrayList<>();
		
		String query = getQueryListByIdServico(idServico, parametros);
		
		List retorno = this.execSQL(query, parametros.toArray());
		
		List fields = new ArrayList<>();
		fields.addAll(getFields());
		fields.add("nome");
		fields.add("valor");
		
		if(retorno != null)
			return this.listConvertion(getBean(), retorno, fields);
		return null;
	}
}
