package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class AtributosFinanceirosDao extends CrudDaoDefaultImpl {

	public AtributosFinanceirosDao() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection find(IDto obj) throws PersistenceException {
		List ordem = new ArrayList();
		ordem.add(new Order("nome"));
		return super.find(obj, ordem);
	}

	@Override
	public Class getBean() {
		return AtributosFinanceirosDTO.class;
	}

	@Override
	public List<Field> getFields() {
		List<Field> listFields = new ArrayList<>();

		listFields.add(new Field("IDFINANCEIROSERVICO", "idFinanceiroServico", true, true, false, false));
		listFields.add(new Field("IDSERVICO", "idServico", false, false, false, false));
		listFields.add(new Field("IDTIPO", "idTipo", false, false, false, false));
		listFields.add(new Field("VALOR", "valor", false, false, false, false));
		listFields.add(new Field("DATAFIM", "dataFim", false, false, false, false));
		listFields.add(new Field("classificacao", "idClassificacao", false, false, false, false));

		return listFields;
	}

	@Override
	public String getTableName() {
		return "FINANCEIROSERVICO";
	}
	
	public Collection<AtributosFinanceirosDTO> listaTiposPorPerfil(final String perfil) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT tipofinan.nometipo,");
		sql.append("        tipofinan.idtipo");
		sql.append(" FROM   tipofinanceiroservico tipofinan ");
		sql.append(" WHERE  tipofinan.perfil = ? ");
		sql.append(" AND    tipofinan.datafim is null ");
		sql.append(" ORDER  BY tipofinan.nometipo ");

		parametro.add(perfil);

		list = this.execSQL(sql.toString(), parametro.toArray());

		listFields.add("nomeTipo");
		listFields.add("idTipo");

		Collection<AtributosFinanceirosDTO> listaRetorno = null;

		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<AtributosFinanceirosDTO>();
		}

		return listaRetorno;
	}
	
	public List<AtributosFinanceirosDTO> findByIdServico(final Integer idServico, final int pageNo, final int pageSize) throws PersistenceException {
		final StringBuilder sql = new StringBuilder();
		final List<Object> listFields = new ArrayList<>();

		List list = new ArrayList<>();

		final List parametro = new ArrayList<>();

		sql.append(" SELECT financeiro.idfinanceiroservico, ");
		sql.append("        financeiro.idservico, ");
		sql.append("        tipofinan.nometipo, ");
		sql.append("        financeiro.valor, ");
		sql.append("        financeiro.idtipo, ");
		sql.append("        tipofinan.perfil, ");
		sql.append("        financeiro.classificacao ");
		sql.append(" FROM   financeiroservico financeiro ");
		sql.append("        INNER JOIN tipofinanceiroservico tipofinan ");
		sql.append("                ON tipofinan.idtipo = financeiro.idtipo ");
		sql.append(" WHERE  financeiro.idservico = ? ");
		sql.append(" AND    tipofinan.datafim is null ");
		sql.append(" AND    financeiro.datafim is null ");
		sql.append(" ORDER  BY tipofinan.nometipo ");

		parametro.add(idServico);
		
		Pageable pageable = new PageRequest(pageNo, pageSize);

		String sqlPaginada = PagingQueryUtil.concatPagingPieceOnQuery(pageable, sql.toString(), DataBase.fromStringId(CITCorporeUtil.SGBD_PRINCIPAL));
		
		list = this.execSQL(sqlPaginada, parametro.toArray());

		listFields.add("idFinanceiroServico");
		listFields.add("idServico");
		listFields.add("nomeTipo");
		listFields.add("valor");
		listFields.add("idTipo");
		listFields.add("perfil");
		listFields.add("idClassificacao");

		List<AtributosFinanceirosDTO> listaRetorno = null;

		
		if (list != null && !list.isEmpty()) {
			listaRetorno = this.listConvertion(this.getBean(), list, listFields);
		} else {
			listaRetorno = new ArrayList<AtributosFinanceirosDTO>();
		}
		
		return listaRetorno;
	}
	
	public Integer getTotalAtributosFinanceiros(Integer idServico) throws Exception {
		List<Condition> condicao = new ArrayList<>();
		condicao.add(new Condition("dataFim", Condition.IS, null));
		condicao.add(new Condition("idServico", Condition.EQUALS, idServico));
		return this.findByCondition(condicao, new ArrayList<>()).size();
	}

}