package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.AvaliacaoServicoDTO;
import br.com.citframework.dto.IDto;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.integracao.Order;
import br.com.citframework.util.Constantes;

public class AvaliacaoServicoDAO extends CrudDaoDefaultImpl {

	private static final long serialVersionUID = -7124296406684704992L;

	public AvaliacaoServicoDAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public Collection<AvaliacaoServicoDTO> find(final IDto obj) {
		return null;
	}

	@Override
	public Collection<Field> getFields() {
		final Collection<Field> listFields = new ArrayList<>();
		listFields.add(new Field("idavaliacaoservico", "idAvaliacaoServico", true, true, false, false));
		listFields.add(new Field("idusuario", "idUsuario", false, false, false, false));
		listFields.add(new Field("idservico", "idServico", false, false, false, false));
		listFields.add(new Field("nota", "nota", false, false, false, false));
		listFields.add(new Field("comentario", "comentario", false, false, false, false));
		listFields.add(new Field("datainicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}

	public Collection<AvaliacaoServicoDTO> findByIdServico(Integer idServico) throws Exception {
		final List<Condition> condicao = new ArrayList<>();
		final List<Order> ordenacao = new ArrayList<>();

		condicao.add(new Condition("idServico", Condition.EQUALS, idServico));

		return this.findByCondition(condicao, ordenacao);
	}

	@Override
	public String getTableName() {
		return "avaliacaoservico";
	}

	@Override
	public Class<AvaliacaoServicoDTO> getBean() {
		return AvaliacaoServicoDTO.class;
	}

}
