package br.com.centralit.citcorpore.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.bean.BaseConhecimentoSLADTO;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.Condition;
import br.com.citframework.integracao.CrudDaoDefaultImpl;
import br.com.citframework.integracao.Field;
import br.com.citframework.util.Constantes;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class BaseConhecimentoSLADAO extends CrudDaoDefaultImpl {
	public BaseConhecimentoSLADAO() {
		super(Constantes.getValue("DATABASE_ALIAS"), null);
	}

	@Override
	public String getTableName() {
		return this.getOwner() + "baseconhecimentosla";
	}

	@Override
	public Collection<Field> getFields() {
		Collection<Field> listFields = new ArrayList<>();

		listFields.add(new Field("idbaseconhecimentosla", "idBaseConhecimentoSLA", true, true, false, false));
		listFields.add(new Field("idbaseconhecimento", "idBaseConhecimento", false, false, false, false));
		listFields.add(new Field("idacordonivelservico", "idAcordoNivelServico", false, false, false, false));
		listFields.add(new Field("datainicio", "dataInicio", false, false, false, false));
		listFields.add(new Field("datafim", "dataFim", false, false, false, false));

		return listFields;
	}

	@Override
	public Class<BaseConhecimentoSLADTO> getBean() {
		return BaseConhecimentoSLADTO.class;
	}

	public Collection findById(Integer idBaseConhecimentoSLA) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametro = new ArrayList();

		List list = new ArrayList();
		List listRetorno = new ArrayList();
		listRetorno.addAll(this.getFields());

		sql.append(" SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(getTableName());
		sql.append(" WHERE idbaseconhecimentosla = ?");
		sql.append(" AND (datafim is null)");

		if (idBaseConhecimentoSLA != null) {
			parametro.add(idBaseConhecimentoSLA);
		} else {
			parametro.add(0);
		}

		list = execSQL(sql.toString(), parametro.toArray());

		List result = this.engine.listConvertion(this.getBean(), list, listRetorno);
		return result;
	}

	public void deleteByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException {
		List condicao = new ArrayList();
		condicao.add(new Condition("idAcordoNivelServico", "=", idAcordoNivelServico));
		super.deleteByCondition(condicao);
	}

	public Collection findByIdAcordoNivelServico(Integer idAcordoNivelServico) throws PersistenceException {
		StringBuilder sql = new StringBuilder();
		List parametro = new ArrayList();

		List list = new ArrayList();
		List listRetorno = new ArrayList();
		listRetorno.addAll(this.getFields());

		sql.append(" SELECT ").append(this.getNamesFieldsStr());
		sql.append(" FROM ").append(getTableName());
		sql.append(" WHERE idacordonivelservico = ?");
		sql.append(" AND (datafim is null)");

		if (idAcordoNivelServico != null) {
			parametro.add(idAcordoNivelServico);
		} else {
			parametro.add(0);
		}

		list = execSQL(sql.toString(), parametro.toArray());

		List result = this.engine.listConvertion(this.getBean(), list, listRetorno);
		return result;
	}
}
